/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.sg.ui;

import com.sas.graphics.sg.interfaces.LineInterface;
import com.sas.graphics.sg.interfaces.MarkerInterface;
import com.sas.graphics.sg.interfaces.RB;
import com.sas.graphics.sg.ui.SGColorChooser;
import com.sas.graphics.sg.ui.SwatchComboBox;
import java.awt.Color;
import javax.swing.BorderFactory;
import javax.swing.JColorChooser;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;

public class UIUtil {
    public static final int NUM_COLOR_ROWS = 4;
    public static final int NUM_COLOR_COLS = 8;
    private static Color[] colors = new Color[]{Color.BLACK, Color.WHITE, new Color(0, 0, 255), new Color(0, 255, 0), new Color(0, 255, 255), new Color(255, 0, 0), new Color(255, 0, 255), new Color(255, 255, 0), new Color(232, 230, 232), new Color(198, 195, 198), new Color(164, 165, 164), new Color(132, 130, 132), new Color(96, 98, 96), new Color(74, 77, 74), new Color(66, 65, 66), new Color(24, 24, 24), new Color(165, 40, 41), new Color(255, 130, 115), new Color(57, 130, 140), new Color(222, 182, 140), new Color(239, 130, 139), new Color(99, 113, 173), new Color(140, 166, 66), new Color(156, 52, 24), new Color(255, 203, 99), new Color(140, 166, 206), new Color(107, 117, 0), new Color(189, 125, 49), new Color(214, 199, 107), new Color(90, 81, 140), new Color(99, 154, 33), new Color(206, 85, 57)};
    private static Color[] recentColors = new Color[]{null, null, null, null, null, null, null, null};
    private static String[] lines = new String[]{LineInterface.stipNames[1], LineInterface.stipNames[2], LineInterface.stipNames[4], LineInterface.stipNames[5], LineInterface.stipNames[8], LineInterface.stipNames[14], LineInterface.stipNames[15], LineInterface.stipNames[20], LineInterface.stipNames[26], LineInterface.stipNames[34], LineInterface.stipNames[35], LineInterface.stipNames[41], LineInterface.stipNames[42]};
    private static String[] markers = new String[]{MarkerInterface.PretyNames[2], MarkerInterface.PretyNames[3], MarkerInterface.PretyNames[4], MarkerInterface.PretyNames[5], MarkerInterface.PretyNames[6], MarkerInterface.PretyNames[7], MarkerInterface.PretyNames[8], MarkerInterface.PretyNames[9], MarkerInterface.PretyNames[10], MarkerInterface.PretyNames[11], MarkerInterface.PretyNames[12], MarkerInterface.PretyNames[13], MarkerInterface.PretyNames[14], MarkerInterface.PretyNames[15], MarkerInterface.PretyNames[16], MarkerInterface.PretyNames[17], MarkerInterface.PretyNames[18], MarkerInterface.PretyNames[19], MarkerInterface.PretyNames[20], MarkerInterface.PretyNames[21], MarkerInterface.PretyNames[22], MarkerInterface.PretyNames[23], MarkerInterface.PretyNames[24], MarkerInterface.PretyNames[25]};
    private static String[] markerSizes = new String[]{Integer.toString(0), Integer.toString(1), Integer.toString(3), Integer.toString(5), Integer.toString(7), Integer.toString(9), Integer.toString(10), Integer.toString(11), Integer.toString(13), Integer.toString(15), Integer.toString(17), Integer.toString(19), Integer.toString(20), Integer.toString(25), Integer.toString(30), Integer.toString(35), Integer.toString(40), Integer.toString(45), Integer.toString(50), Integer.toString(55), Integer.toString(60), Integer.toString(65), Integer.toString(75), Integer.toString(100)};
    private static String[] lineThickness = new String[]{Integer.toString(1), Integer.toString(2), Integer.toString(3), Integer.toString(4), Integer.toString(5), Integer.toString(6), Integer.toString(7), Integer.toString(8), Integer.toString(9), Integer.toString(10)};
    public static final int POSITION_TOP = 0;
    public static final int POSITION_BOTTOM = 1;
    public static final int POSITION_LEFT = 2;
    public static final int POSITION_RIGHT = 3;
    public static final int POSITION_CENTER = 4;
    public static final int POSITION_TOP_LEFT = 5;
    public static final int POSITION_TOP_RIGHT = 6;
    public static final int POSITION_BOTTOM_LEFT = 7;
    public static final int POSITION_BOTTOM_RIGHT = 8;
    public static JColorChooser colorChooser = new SGColorChooser();
    public static final int DLU = Math.max(1, UIManager.getFont("ComboBox.font").getSize() / 8);
    public static int DEFAULT_WIDGET_WIDTH = 144 * DLU;
    public static int DEFAULT_WIDGET_HEIGHT = 14 * DLU;
    public static int DEFAULT_LABEL_WIDTH = 20 * DLU;
    public static int DEFAULT_LABEL_HEIGHT = 14 * DLU;
    public static final int MARGIN = DLU * 7;
    public static final int MESSAGE_MARGIN_HORZ = DLU * 10;
    public static final int MESSAGE_MARGIN_VERT = DLU * 9;
    public static final int MESSAGE_INDENT = DLU * 7;
    public static final int COMP_GAP = DLU * 4;
    public static final int RELATED_COMP_GAP = DLU * 2;
    public static final int COMP_GROUP_GAP = DLU * 8;
    public static final int LABEL_GAP_HORZ = DLU * 3;
    public static final int LABEL_GAP_VERT = DLU;
    public static final int BUTTON_GAP = DLU * 4;
    public static final int RELATED_BUTTON_GAP = DLU;
    public static final int BUTTON_GROUP_GAP = DLU * 8;
    public static final int BUTTON_WIDTH = DLU * 50;
    public static final int BUTTON_HEIGHT = DLU * 14;
    public static final Border emptyBorder = BorderFactory.createEmptyBorder(DLU * 7, DLU * 7, DLU * 7, DLU * 7);
    public static final Border lineBorder = BorderFactory.createLineBorder(new Color(0, 0, 132), 1);
    public static final Border line2Border = BorderFactory.createMatteBorder(2, 2, 0, 0, Color.white);
    public static final Border emptyItemBorder = BorderFactory.createEmptyBorder(4 * DLU, 3 * DLU, 4 * DLU, 2 * DLU);
    public static final Border tabbedBorder = BorderFactory.createEmptyBorder(COMP_GAP + MARGIN, MARGIN, MARGIN, MARGIN);
    public static final Border tabBorder = BorderFactory.createEmptyBorder(0, MARGIN, 0, MARGIN);
    public static final Border tabBorder2 = BorderFactory.createEmptyBorder(0, 2 * MARGIN, 0, 2 * MARGIN);
    public static final Border tabBorder3 = BorderFactory.createEmptyBorder(0, 3 * MARGIN, 0, 3 * MARGIN);
    public static final Border compBorder = BorderFactory.createEmptyBorder(COMP_GAP, COMP_GAP, COMP_GAP, COMP_GAP);
    public static final Border textBorder = BorderFactory.createCompoundBorder(UIManager.getBorder("TextField.border"), new EmptyBorder(0, COMP_GAP, 0, COMP_GAP));

    public static void setColors(Color[] colorlist) {
        colors = colorlist;
    }

    public static Color[] getColors() {
        return colors;
    }

    public static Color[] getRecentColors() {
        return recentColors;
    }

    public static void setLines(String[] linelist) {
        lines = linelist;
    }

    public static String[] getLines() {
        return lines;
    }

    public static void setLineThickness(String[] list) {
        lineThickness = list;
    }

    public static String[] getLineThickness() {
        return lineThickness;
    }

    public static void setMarkers(String[] markerlist) {
        markers = markerlist;
    }

    public static String[] getMarkerSizes() {
        return markerSizes;
    }

    public static void setMarkerSizes(String[] list) {
        markerSizes = list;
    }

    public static String[] getGLMarkers() {
        return MarkerInterface.Names;
    }

    public static String getLocalizedMarker(String name) {
        String rbname;
        try {
            rbname = RB.getStringResource("MarkerInterface.", name.toLowerCase() + ".txt");
        }
        catch (Exception e) {
            rbname = name;
        }
        return rbname;
    }

    public static String[] getMarkers() {
        return markers;
    }

    public static void selectColor(SwatchComboBox cb, Color newColor) {
        int i;
        int insert = -1;
        for (i = 0; i < colors.length; ++i) {
            if (!newColor.equals(colors[i])) continue;
            cb.setSelectedIndex(i);
            insert = i;
            break;
        }
        if (insert == -1) {
            for (i = colors.length - 2; i >= 0; --i) {
                UIUtil.colors[i + 1] = colors[i];
            }
            UIUtil.colors[0] = newColor;
            cb.setModel(colors);
            cb.setSelectedIndex(0);
        }
    }

    public static int swingToList(int swingConstant) {
        int li = 0;
        switch (swingConstant) {
            case 1: {
                li = 0;
                break;
            }
            case 5: {
                li = 1;
                break;
            }
            case 7: {
                li = 2;
                break;
            }
            case 3: {
                li = 3;
                break;
            }
            case 8: {
                li = 5;
                break;
            }
            case 2: {
                li = 6;
                break;
            }
            case 6: {
                li = 7;
                break;
            }
            case 4: {
                li = 8;
                break;
            }
            case 0: {
                li = 4;
            }
        }
        return li;
    }

    public static int listToSwing(int listIndex) {
        int li = 0;
        switch (listIndex) {
            case 0: {
                li = 1;
                break;
            }
            case 1: {
                li = 5;
                break;
            }
            case 2: {
                li = 7;
                break;
            }
            case 3: {
                li = 3;
                break;
            }
            case 5: {
                li = 8;
                break;
            }
            case 6: {
                li = 2;
                break;
            }
            case 7: {
                li = 6;
                break;
            }
            case 8: {
                li = 4;
                break;
            }
            case 4: {
                li = 0;
            }
        }
        return li;
    }

    public static void insertMarkerSize(int value) {
        int mlen;
        int index = mlen = markerSizes.length;
        for (int i = 0; i < mlen; ++i) {
            int avalue = Integer.parseInt(markerSizes[i]);
            if (value == avalue) {
                return;
            }
            if (value >= avalue) continue;
            index = i;
            break;
        }
        String[] temp = new String[mlen + 1];
        System.arraycopy(markerSizes, 0, temp, 0, index);
        temp[index] = Integer.toString(value);
        if (index < mlen) {
            System.arraycopy(markerSizes, index, temp, index + 1, mlen - index);
        }
        markerSizes = temp;
    }

    public static void insertLineThickness(int value) {
        int llen;
        int index = llen = lineThickness.length;
        for (int i = 0; i < llen; ++i) {
            int avalue = Integer.parseInt(lineThickness[i]);
            if (value == avalue) {
                return;
            }
            if (value >= avalue) continue;
            index = i;
            break;
        }
        String[] temp = new String[llen + 1];
        System.arraycopy(lineThickness, 0, temp, 0, index);
        temp[index] = Integer.toString(value);
        if (index < llen) {
            System.arraycopy(lineThickness, index, temp, index + 1, llen - index);
        }
        lineThickness = temp;
    }

    public static String[] addLineToList(String curPattern) {
        int cursize = lines.length;
        String[] newList = new String[cursize + 1];
        System.arraycopy(lines, 0, newList, 0, cursize);
        newList[cursize] = curPattern;
        lines = newList;
        return lines;
    }
}

