/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.sg.ui;

import com.sas.graphics.sg.interfaces.TransparencyInterface;
import com.sas.graphics.sg.ui.NumberRangeListener;
import com.sas.graphics.sg.ui.RB;
import com.sas.graphics.sg.ui.SGCustomizerPanel;
import com.sas.graphics.sg.ui.UIUtil;
import java.awt.Dimension;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.JSpinner;
import javax.swing.SpinnerNumberModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class TransparencyCustomizerPanel
extends SGCustomizerPanel
implements ChangeListener {
    JSpinner transparencyspinner;
    JSlider transparency;
    TransparencyInterface overlay;

    public TransparencyCustomizerPanel(TransparencyInterface overlay) {
        this.overlay = overlay;
        this.init();
    }

    private void init() {
        this.setLayout(new BoxLayout(this, 1));
        JPanel transperacyPanel = new JPanel();
        transperacyPanel.setLayout(new BoxLayout(transperacyPanel, 0));
        transperacyPanel.setBorder(BorderFactory.createEmptyBorder(0, 2 * UIUtil.DLU, 0, 0));
        JLabel tlabel = new JLabel(RB.getStringResource("transparency.txt"));
        transperacyPanel.add(tlabel);
        transperacyPanel.add(Box.createHorizontalGlue());
        this.add(transperacyPanel);
        transperacyPanel = new JPanel();
        transperacyPanel.setLayout(new BoxLayout(transperacyPanel, 0));
        transperacyPanel.setBorder(BorderFactory.createEmptyBorder(0, 9 * UIUtil.DLU, 0, 0));
        this.transparency = new JSlider(0, 0, 100, this.overlay.getTransparency());
        this.transparency.addChangeListener(this);
        this.transparency.setMajorTickSpacing(25);
        this.transparency.setMinorTickSpacing(5);
        this.transparency.setPaintTicks(true);
        transperacyPanel.add(this.transparency);
        transperacyPanel.add(Box.createRigidArea(new Dimension(4 * UIUtil.DLU, 0)));
        SpinnerNumberModel model = new SpinnerNumberModel(this.overlay.getTransparency(), 0, 100, 5);
        this.transparencyspinner = new JSpinner(model);
        NumberRangeListener.addRangeListener(this.transparencyspinner, 0.0, 100.0);
        this.transparencyspinner.addChangeListener(this);
        this.transparencyspinner.setAlignmentY(0.5f);
        transperacyPanel.add(this.transparencyspinner);
        transperacyPanel.add(Box.createHorizontalGlue());
        this.add(transperacyPanel);
        Dimension ps = this.transparency.getPreferredSize();
        ps.width = 120;
        this.transparency.setPreferredSize(ps);
        this.transparency.setMaximumSize(ps);
        Dimension ps2 = new Dimension(this.transparencyspinner.getPreferredSize().width, ps.height);
        this.transparencyspinner.setPreferredSize(ps2);
        this.transparencyspinner.setMaximumSize(ps2);
    }

    @Override
    public void stateChanged(ChangeEvent e) {
        Number value2;
        int value1 = this.transparency.getModel().getValue();
        if (value1 != (value2 = (Number)this.transparencyspinner.getModel().getValue()).intValue()) {
            Object src = e.getSource();
            if (src == this.transparency) {
                this.transparencyspinner.setValue(new Integer(value1));
            } else {
                this.transparency.setValue(value2.intValue());
            }
        } else {
            this.overlay.setTransparency(value1);
        }
    }

    @Override
    public void setValue(Object obj) {
        if (!(obj instanceof TransparencyInterface)) {
            return;
        }
        this.overlay = (TransparencyInterface)obj;
        this.transparency.removeChangeListener(this);
        this.transparencyspinner.removeChangeListener(this);
        this.transparency.setValue(this.overlay.getTransparency());
        this.transparencyspinner.setValue(new Integer(this.overlay.getTransparency()));
        this.transparency.addChangeListener(this);
        this.transparencyspinner.addChangeListener(this);
    }
}

