/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.sg.ui;

import com.sas.graphics.sg.ui.RB;
import com.sas.graphics.sg.ui.UIUtil;
import com.sas.graphics.util.Markers;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.UIManager;
import javax.swing.border.Border;

public class SwatchLabel
extends JLabel {
    private static Border spaceBorder = BorderFactory.createEmptyBorder(0, UIUtil.DLU * 2, 0, 0);
    static final Color backColor = UIManager.getColor("TextPane.background");
    static final Color foreground = UIManager.getColor("TextPane.foreground");
    static final Color hiliteBackground = UIManager.getColor("TextPane.selectionBackground");
    static final Color hiliteForeground = UIManager.getColor("TextPane.selectionForeground");
    static final Border hiliteBorder = BorderFactory.createLineBorder(hiliteForeground);
    static final Border lineBorder = BorderFactory.createLineBorder(backColor, 2);
    static final Border textHiliteBorder = BorderFactory.createCompoundBorder(hiliteBorder, spaceBorder);
    static final Border textLineBorder = BorderFactory.createCompoundBorder(lineBorder, spaceBorder);
    static final int PREFERRED_WIDTH = UIUtil.DLU * 20;
    static final int PREFERRED_HEIGHT = UIUtil.DLU * 20;
    protected Object value = UIManager.getColor("ComboBox.foreground");
    protected boolean hilite = false;
    protected int index = -1;

    public SwatchLabel(Object obj) {
        int id;
        this.setVerticalAlignment(0);
        this.setHorizontalAlignment(2);
        this.setHorizontalTextPosition(2);
        this.setIconTextGap(8);
        this.setValue(obj);
        if (obj instanceof String && (id = Markers.getShape((String)((String)obj))) == -1) {
            this.setText((String)obj);
            this.value = null;
        }
        this.setOpaque(true);
    }

    @Override
    public void paint(Graphics g) {
        Color fg;
        String text = this.getText();
        boolean hasText = text != null && text.length() > 0;
        ((Graphics2D)g).setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        ((Graphics2D)g).setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_OFF);
        if (this.hilite) {
            this.setBackground(hiliteBackground);
            this.setForeground(hiliteForeground);
            if (hasText) {
                this.setBorder(textHiliteBorder);
            } else {
                this.setBorder(hiliteBorder);
            }
            fg = hiliteForeground;
        } else {
            this.setBackground(backColor);
            this.setForeground(foreground);
            if (hasText) {
                this.setBorder(textLineBorder);
            } else {
                this.setBorder(lineBorder);
            }
            fg = foreground;
        }
        super.paint(g);
        if (this.value instanceof Color) {
            Insets i = this.getInsets();
            Rectangle r = this.getBounds();
            if (hasText) {
                int dx = g.getFontMetrics().stringWidth(text) + this.getIconTextGap();
                g.setColor((Color)this.value);
                g.fillRect(i.left + dx, i.top + 2 * UIUtil.DLU, r.width - i.left - i.right - dx - 2 * UIUtil.DLU, r.height - i.top - i.bottom - 5 * UIUtil.DLU);
                g.setColor(Color.LIGHT_GRAY);
                g.drawRect(i.left + dx, i.top + 2 * UIUtil.DLU, r.width - i.left - i.right - dx - 2 * UIUtil.DLU, r.height - i.top - i.bottom - 5 * UIUtil.DLU);
            } else {
                g.setColor((Color)this.value);
                g.fillRect(i.left + 2, i.top + 2 * UIUtil.DLU, r.width - i.left - i.right - 5 * UIUtil.DLU, r.height - i.top - i.bottom - 5 * UIUtil.DLU);
                g.setColor(Color.LIGHT_GRAY);
                g.drawRect(i.left + 2, i.top + 2 * UIUtil.DLU, r.width - i.left - i.right - 5 * UIUtil.DLU, r.height - i.top - i.bottom - 5 * UIUtil.DLU);
            }
        } else {
            Rectangle r = this.getBounds();
            int cy = r.height / 2;
            int cx = r.width / 2;
            int size = Math.min(13, Math.min(r.width, r.height) - 4 * UIUtil.DLU);
            if (hasText) {
                cx = g.getFontMetrics().stringWidth(text) + this.getIconTextGap() + size / 2;
            }
            if (this.value instanceof Integer) {
                Markers.drawStroke((Graphics)g, (Color)fg, null, (int)((Integer)this.value), (int)size, (int)cx, (int)cy, (boolean)true);
            } else if (this.value instanceof String) {
                Markers.drawStroke((Graphics)g, (Color)fg, null, (int)Markers.getShape((String)((String)this.value)), (int)size, (int)cx, (int)cy, (boolean)false);
            }
        }
    }

    public boolean isHilite() {
        return this.hilite;
    }

    public void setHilite(boolean hilite) {
        this.hilite = hilite;
    }

    public Object getValue() {
        if (this.value != null) {
            return this.value;
        }
        return this.getText();
    }

    public void setValue(Object obj) {
        this.value = obj;
        if (obj instanceof Icon) {
            Icon im = (Icon)obj;
            this.setIcon(im);
            this.setPreferredSize(new Dimension(im.getIconWidth() + 12, im.getIconHeight() + 12));
        } else if (obj instanceof Image) {
            ImageIcon im = new ImageIcon((Image)obj);
            this.setIcon(im);
            this.setPreferredSize(new Dimension(im.getIconWidth() + 12, im.getIconHeight() + 12));
        } else {
            this.setPreferredSize(new Dimension(PREFERRED_WIDTH, PREFERRED_HEIGHT));
            if (this.value != null && this.value.equals(RB.getStringResource("morecolorsdots.txt"))) {
                this.setText((String)this.value);
                this.value = null;
            } else {
                this.setText(null);
            }
        }
    }

    public int getIndex() {
        return this.index;
    }

    public void setIndex(int index) {
        this.index = index;
    }
}

