/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.sg.ui;

import com.sas.graphics.sg.interfaces.DefaultTextInterface;
import com.sas.graphics.sg.interfaces.TextInterface;
import com.sas.graphics.sg.interfaces.TextStyleElementInterface;
import com.sas.graphics.sg.ui.ColorComboBoxEditor;
import com.sas.graphics.sg.ui.ColorGrabber;
import com.sas.graphics.sg.ui.RB;
import com.sas.graphics.sg.ui.SGCustomizerPanel;
import com.sas.graphics.sg.ui.SGDialog;
import com.sas.graphics.sg.ui.SwatchActionEvent;
import com.sas.graphics.sg.ui.SwatchComboBox;
import com.sas.graphics.sg.ui.SwatchRenderer;
import com.sas.graphics.sg.ui.UIUtil;
import com.sas.text.Message;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GraphicsEnvironment;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JColorChooser;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.Border;

public class SimpleTextCustomizerPanel
extends SGCustomizerPanel
implements ActionListener {
    protected static final int[] SIZE_VALUES = new int[]{8, 10, 12, 14, 16, 18, 24};
    protected static final int[] FONT_STYLES_VALUES = new int[]{-1, 0, 1, 2, 3};
    protected static final String[] FONT_STYLES = new String[]{RB.getStringResource("regular.txt"), RB.getStringResource("bold.txt"), RB.getStringResource("italic.txt"), RB.getStringResource("bolditalic.txt")};
    static final Border tabBorder = BorderFactory.createEmptyBorder(0, UIUtil.DLU * 3, 0, 0);
    protected TextInterface textStyle;
    protected JComboBox fontName;
    protected JComboBox fontSize;
    protected JComboBox fontStyle;
    protected JComboBox style = null;
    protected SwatchComboBox color;
    protected String defaultString = RB.getStringResource("automatic.txt");
    ColorGrabber colorGrabber = null;
    boolean needtoRemoveBlankSize = false;
    boolean needtoRemoveBlankFamily = false;
    boolean needtoRemoveBlankStyle = false;
    private JDialog dialog = null;

    public SimpleTextCustomizerPanel(TextInterface textStyle) {
        this(textStyle, null);
    }

    public SimpleTextCustomizerPanel(TextInterface textStyle, ColorGrabber cg) {
        this.textStyle = textStyle;
        this.colorGrabber = cg;
        this.init();
    }

    protected void init() {
        boolean italic;
        String defaultFamily;
        Dimension ps;
        this.setBorder(UIUtil.emptyBorder);
        this.setLayout(new BoxLayout(this, 1));
        if (this.textStyle instanceof TextStyleElementInterface) {
            TextStyleElementInterface styleInterface = (TextStyleElementInterface)((Object)this.textStyle);
            JPanel stylePanel = new JPanel();
            stylePanel.setLayout(new BoxLayout(stylePanel, 0));
            JLabel styleLabel = new JLabel(RB.getStringResource("element.txt"));
            ps = styleLabel.getPreferredSize();
            this.labelSize.setSize(Math.max(this.labelSize.width, ps.width), Math.max(this.labelSize.height, ps.height));
            this.labels.add(styleLabel);
            stylePanel.add(styleLabel);
            stylePanel.add(Box.createRigidArea(new Dimension(3 * UIUtil.DLU, 0)));
            this.style = new JComboBox<String>(styleInterface.getAllTextStyleElements());
            this.style.setSelectedItem(styleInterface.getTextStyleElement());
            this.style.setActionCommand("style");
            this.style.addActionListener(this);
            ps = this.style.getPreferredSize();
            this.widgetSize.setSize(Math.max(this.widgetSize.width, ps.width), Math.max(this.widgetSize.height, ps.height));
            this.widgets.add(this.style);
            stylePanel.add(this.style);
            stylePanel.add(Box.createHorizontalGlue());
            this.add(stylePanel);
            this.add(Box.createRigidArea(new Dimension(0, 4 * UIUtil.DLU)));
        }
        JPanel textPanel1 = new JPanel();
        textPanel1.setLayout(new BoxLayout(textPanel1, 0));
        JLabel fontNameLabel = new JLabel(RB.getStringResource("family.txt"));
        textPanel1.add(fontNameLabel);
        textPanel1.add(Box.createRigidArea(new Dimension(3 * UIUtil.DLU, 0)));
        ps = fontNameLabel.getPreferredSize();
        this.labelSize.setSize(Math.max(this.labelSize.width, ps.width), Math.max(this.labelSize.height, ps.height));
        this.labels.add(fontNameLabel);
        Vector<String> fontNames = new Vector<String>(Arrays.asList(GraphicsEnvironment.getLocalGraphicsEnvironment().getAvailableFontFamilyNames()));
        String family = this.textStyle.getFontFamily();
        if (this.textStyle instanceof DefaultTextInterface) {
            defaultFamily = ((DefaultTextInterface)((Object)this.textStyle)).getDefaultFontFamily();
            String auto = Message.format((String)RB.getStringResource("automatic.fmt.txt"), (Object)defaultFamily);
            fontNames.add(0, auto);
        } else {
            defaultFamily = family;
        }
        if (!(family != null && family.length() != 0 || defaultFamily != null && defaultFamily.length() != 0)) {
            fontNames.add("");
            this.needtoRemoveBlankFamily = true;
        }
        this.fontName = new JComboBox<String>(fontNames);
        Border border = this.fontName.getBorder();
        border = border == null ? tabBorder : BorderFactory.createCompoundBorder(border, tabBorder);
        this.fontName.setBorder(border);
        if (family != null && family.length() > 0) {
            this.fontName.setSelectedItem(family);
        } else if (defaultFamily != null && defaultFamily.length() > 0) {
            this.fontName.setSelectedIndex(0);
        } else {
            this.fontName.setSelectedItem(family);
        }
        this.fontName.addActionListener(this);
        textPanel1.add(this.fontName);
        textPanel1.add(Box.createHorizontalGlue());
        ps = this.fontName.getPreferredSize();
        this.widgetSize.setSize(Math.max(this.widgetSize.width, ps.width), Math.max(this.widgetSize.height, ps.height));
        this.widgets.add(this.fontName);
        JPanel textPanel2 = new JPanel();
        textPanel2.setLayout(new BoxLayout(textPanel2, 0));
        JLabel fontSizeLabel = new JLabel(RB.getStringResource("size.txt"));
        textPanel2.add(fontSizeLabel);
        textPanel2.add(Box.createRigidArea(new Dimension(3 * UIUtil.DLU, 0)));
        ps = fontSizeLabel.getPreferredSize();
        this.labelSize.setSize(Math.max(this.labelSize.width, ps.width), Math.max(this.labelSize.height, ps.height));
        this.labels.add(fontSizeLabel);
        int cursize = this.textStyle.getFontSize();
        ArrayList<String> sizes = new ArrayList<String>();
        boolean addCurSize = cursize != -1;
        for (int i = 0; i < SIZE_VALUES.length; ++i) {
            if (addCurSize && cursize < SIZE_VALUES[i]) {
                sizes.add(Integer.toString(cursize));
                addCurSize = false;
            }
            sizes.add(Integer.toString(SIZE_VALUES[i]));
            if (SIZE_VALUES[i] != cursize) continue;
            addCurSize = false;
        }
        if (addCurSize) {
            sizes.add(Integer.toString(cursize));
        }
        int defsize = cursize;
        if (this.textStyle instanceof DefaultTextInterface) {
            defsize = ((DefaultTextInterface)((Object)this.textStyle)).getDefaultFontSize();
            String auto = Message.format((String)RB.getStringResource("automatic.fmt.txt"), (Object)Integer.toString(defsize));
            sizes.add(0, auto);
        }
        if (cursize == -1 && defsize == -1) {
            sizes.add("");
            this.needtoRemoveBlankSize = true;
        }
        this.fontSize = new JComboBox<Object>(sizes.toArray());
        this.fontSize.setBorder(border);
        if (cursize != -1) {
            this.fontSize.setSelectedItem(Integer.toString(cursize));
        } else if (defsize > 0) {
            this.fontSize.setSelectedIndex(0);
        } else {
            this.fontSize.setSelectedItem("");
        }
        this.fontSize.addActionListener(this);
        textPanel2.add(this.fontSize);
        textPanel2.add(Box.createHorizontalGlue());
        ps = this.fontSize.getPreferredSize();
        this.widgetSize.setSize(Math.max(this.widgetSize.width, ps.width), Math.max(this.widgetSize.height, ps.height));
        this.widgets.add(this.fontSize);
        JPanel textPanel3 = new JPanel();
        textPanel3.setLayout(new BoxLayout(textPanel3, 0));
        JLabel fontStyleLabel = new JLabel(RB.getStringResource("style.txt"));
        textPanel3.add(fontStyleLabel);
        textPanel3.add(Box.createRigidArea(new Dimension(3 * UIUtil.DLU, 0)));
        ps = fontStyleLabel.getPreferredSize();
        this.labelSize.setSize(Math.max(this.labelSize.width, ps.width), Math.max(this.labelSize.height, ps.height));
        this.labels.add(fontStyleLabel);
        int fstyle = this.textStyle.getFontStyle();
        boolean bold = (fstyle & 1) != 0;
        boolean bl = italic = (fstyle & 2) != 0;
        String value = bold && italic ? FONT_STYLES[3] : (bold ? FONT_STYLES[1] : (italic ? FONT_STYLES[2] : FONT_STYLES[0]));
        Vector<String> fontStyles = new Vector<String>(Arrays.asList(FONT_STYLES));
        if (fstyle == -1 && !(this.textStyle instanceof DefaultTextInterface)) {
            fontStyles.add("");
            this.needtoRemoveBlankStyle = true;
        }
        this.fontStyle = new JComboBox<Object>(fontStyles.toArray());
        if (this.textStyle instanceof DefaultTextInterface) {
            DefaultTextInterface dti = (DefaultTextInterface)((Object)this.textStyle);
            int ds = dti.getDefaultFontStyle();
            bold = (ds & 1) != 0;
            boolean bl2 = italic = (ds & 2) != 0;
            String defstyle = bold && italic ? FONT_STYLES[3] : (bold ? FONT_STYLES[1] : (italic ? FONT_STYLES[2] : FONT_STYLES[0]));
            String auto = Message.format((String)RB.getStringResource("automatic.fmt.txt"), (Object)defstyle);
            this.fontStyle.insertItemAt(auto, 0);
        } else {
            String defstyle = value;
        }
        this.fontStyle.setBorder(border);
        if (fstyle == -1) {
            if (this.textStyle instanceof DefaultTextInterface) {
                this.fontStyle.setSelectedIndex(0);
            } else {
                this.fontStyle.setSelectedItem("");
            }
        } else {
            this.fontStyle.setSelectedItem(value);
        }
        this.fontStyle.addActionListener(this);
        textPanel3.add(this.fontStyle);
        textPanel3.add(Box.createHorizontalGlue());
        ps = this.fontStyle.getPreferredSize();
        this.widgetSize.setSize(Math.max(this.widgetSize.width, ps.width), Math.max(this.widgetSize.height, ps.height));
        this.widgets.add(this.fontStyle);
        JPanel textPanel4 = new JPanel();
        textPanel4.setLayout(new BoxLayout(textPanel4, 0));
        JLabel textColorLabel = new JLabel(RB.getStringResource("colorcolon.txt"));
        textPanel4.add(textColorLabel);
        textPanel4.add(Box.createRigidArea(new Dimension(3 * UIUtil.DLU, 0)));
        ps = textColorLabel.getPreferredSize();
        this.labelSize.setSize(Math.max(this.labelSize.width, ps.width), Math.max(this.labelSize.height, ps.height));
        this.labels.add(textColorLabel);
        Color defaultColor = null;
        if (this.textStyle instanceof DefaultTextInterface) {
            DefaultTextInterface dti = (DefaultTextInterface)((Object)this.textStyle);
            defaultColor = dti.getDefaultFontColor();
        } else {
            this.defaultString = "";
        }
        this.color = new SwatchComboBox(UIUtil.getColors(), 8, 4, this.colorGrabber, this.defaultString, defaultColor, RB.getStringResource("morecolorsdots.txt"));
        Color c = this.textStyle.getFontColor();
        this.color.setEditable(true);
        ColorComboBoxEditor editor = new ColorComboBoxEditor(this.defaultString, defaultColor);
        this.color.setEditor(editor);
        editor.addMouseListener(this.color);
        if (c != null) {
            this.color.setSelectedItem(c);
        } else {
            this.color.setSelectedItem(this.defaultString);
        }
        this.color.setRenderer(new SwatchRenderer());
        this.color.setActionCommand("color");
        this.color.addActionListener(this);
        ps = this.color.getPreferredSize();
        this.widgetSize.setSize(Math.max(this.widgetSize.width, ps.width), Math.max(this.widgetSize.height, ps.height));
        this.widgets.add(this.fontStyle);
        this.widgets.add(this.color);
        textPanel4.add(this.color);
        textPanel4.add(Box.createHorizontalGlue());
        this.add(textPanel4);
        this.add(Box.createRigidArea(new Dimension(0, 4 * UIUtil.DLU)));
        this.add(textPanel1);
        this.add(Box.createRigidArea(new Dimension(0, 4 * UIUtil.DLU)));
        this.add(textPanel2);
        this.add(Box.createRigidArea(new Dimension(0, 4 * UIUtil.DLU)));
        this.add(textPanel3);
        this.add(Box.createRigidArea(new Dimension(0, 4 * UIUtil.DLU)));
        this.setLabelPreferredSize(null);
        this.setWidgetPreferredSize(null);
    }

    @Override
    public void setValue(Object newValue) {
        boolean italic;
        String family;
        if (!(newValue instanceof TextInterface)) {
            return;
        }
        this.textStyle = (TextInterface)newValue;
        if (this.style != null) {
            this.style.removeActionListener(this);
            this.style.setSelectedItem(((TextStyleElementInterface)((Object)this.textStyle)).getTextStyleElement());
            this.style.addActionListener(this);
        }
        this.fontName.removeActionListener(this);
        this.fontSize.removeActionListener(this);
        this.fontStyle.removeActionListener(this);
        this.color.removeActionListener(this);
        if (this.textStyle instanceof DefaultTextInterface) {
            boolean italic2;
            DefaultTextInterface dti = (DefaultTextInterface)((Object)this.textStyle);
            String defaultFamily = dti.getDefaultFontFamily();
            String auto = Message.format((String)RB.getStringResource("automatic.fmt.txt"), (Object)defaultFamily);
            String item = (String)this.fontName.getItemAt(0);
            this.fontName.removeItemAt(0);
            if (!item.startsWith(RB.getStringResource("automatic.txt"))) {
                this.fontName.removeItemAt(0);
            }
            this.fontName.insertItemAt(auto, 0);
            int defsize = dti.getDefaultFontSize();
            auto = Message.format((String)RB.getStringResource("automatic.fmt.txt"), (Object)Integer.toString(defsize));
            item = (String)this.fontSize.getItemAt(0);
            this.fontSize.removeItemAt(0);
            if (!item.startsWith(RB.getStringResource("automatic.txt"))) {
                this.fontSize.removeItemAt(0);
            }
            this.fontSize.insertItemAt(auto, 0);
            int ds = dti.getDefaultFontStyle();
            boolean bold = (ds & 1) != 0;
            boolean bl = italic2 = (ds & 2) != 0;
            String defstyle = bold && italic2 ? FONT_STYLES[3] : (bold ? FONT_STYLES[1] : (italic2 ? FONT_STYLES[2] : FONT_STYLES[0]));
            auto = Message.format((String)RB.getStringResource("automatic.fmt.txt"), (Object)defstyle);
            this.fontStyle.removeItemAt(0);
            this.fontStyle.insertItemAt(auto, 0);
            Color defaultColor = dti.getDefaultFontColor();
            this.color.setAutomatic(this.defaultString, defaultColor);
            this.color.setSelectedItem(this.defaultString);
        }
        if ((family = this.textStyle.getFontFamily()) != null && family.length() > 0) {
            this.fontName.setSelectedItem(family);
        } else {
            this.fontName.setSelectedIndex(0);
        }
        int cursize = this.textStyle.getFontSize();
        if (cursize != -1) {
            int i;
            boolean found = false;
            int count = this.fontSize.getItemCount();
            int n = i = this.textStyle instanceof DefaultTextInterface ? 1 : 0;
            while (i < count) {
                int value = Integer.parseInt((String)this.fontSize.getItemAt(i));
                if (value > cursize) {
                    this.fontSize.insertItemAt(Integer.toString(cursize), i);
                    this.fontSize.setSelectedIndex(i);
                    found = true;
                    break;
                }
                if (value == cursize) {
                    this.fontSize.setSelectedIndex(i);
                    found = true;
                    break;
                }
                ++i;
            }
            if (!found) {
                this.fontSize.insertItemAt(Integer.toString(cursize), count);
                this.fontSize.setSelectedIndex(count);
            }
        } else {
            this.fontSize.setSelectedIndex(0);
        }
        int style = this.textStyle.getFontStyle();
        boolean bold = (style & 1) != 0;
        boolean bl = italic = (style & 2) != 0;
        String value = bold && italic ? FONT_STYLES[3] : (bold ? FONT_STYLES[1] : (italic ? FONT_STYLES[2] : FONT_STYLES[0]));
        if (style == -1) {
            this.fontStyle.setSelectedIndex(0);
        } else {
            this.fontStyle.setSelectedItem(value);
        }
        Color c = this.textStyle.getFontColor();
        if (c != null) {
            this.color.setSelectedItem(c);
        }
        this.fontName.addActionListener(this);
        this.fontSize.addActionListener(this);
        this.fontStyle.addActionListener(this);
        this.color.addActionListener(this);
    }

    public TextInterface getStyle() {
        return this.textStyle;
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public void actionPerformed(ActionEvent e) {
        Container parent;
        JPanel panel;
        JColorChooser cc;
        Color save;
        block44: {
            block43: {
                if (e.getSource() != this.color) break block43;
                Object item = this.color.getSelectedItem();
                if (item == null) return;
                save = this.textStyle.getFontColor();
                if (!(item instanceof String)) {
                    if (!(item instanceof Color)) return;
                    this.textStyle.setFontColor((Color)item);
                    return;
                }
                if (((String)item).equals(RB.getStringResource("morecolorsdots.txt"))) {
                    cc = UIUtil.colorChooser;
                    if (save == null) {
                        if (this.textStyle instanceof DefaultTextInterface) {
                            cc.setColor(((DefaultTextInterface)((Object)this.textStyle)).getDefaultFontColor());
                        }
                    } else {
                        cc.setColor(save);
                    }
                    cc.setPreviewPanel(new JPanel());
                    panel = new JPanel();
                    panel.setLayout(new BorderLayout());
                    panel.add(cc);
                    break block44;
                } else {
                    if (((String)item).equals(this.defaultString)) {
                        this.textStyle.setFontColor(null);
                        return;
                    }
                    Container c = this.getTopLevelAncestor();
                    if (c instanceof SGDialog) {
                        SGDialog sgd = (SGDialog)c;
                        sgd.value = -1;
                        this.dialog = sgd.makeDisabledCopy(this.colorGrabber);
                        c.setVisible(false);
                        this.dialog.setVisible(true);
                    }
                    c = this.colorGrabber.grabComponent.getTopLevelAncestor();
                    c.requestFocus();
                    if (this.dialog != null) {
                        this.dialog.toFront();
                    }
                    this.colorGrabber.setMouseEventListener();
                    this.colorGrabber.addActionListener(this);
                    if (save == null) {
                        this.colorGrabber.setStartColor(this.defaultString);
                        return;
                    }
                    this.colorGrabber.setStartColor(save);
                    return;
                }
            }
            if (e.getActionCommand().equals("colorpicker:done")) {
                Object c = ((SwatchActionEvent)e).getValue();
                this.color.setSelectedItem(c);
                this.color.setEnabled(true);
                this.colorGrabber.removeMouseEventListener();
                this.colorGrabber.removeActionListener(this);
                if (this.dialog == null) return;
                this.dialog.dispose();
                return;
            }
            if (e.getActionCommand().equals("colorpicker:updating")) {
                int i;
                Color c = (Color)((SwatchActionEvent)e).getValue();
                if (this.color == null) return;
                ActionListener[] listener = this.color.getActionListeners();
                for (i = 0; i < listener.length; ++i) {
                    this.color.removeActionListener(listener[i]);
                }
                this.color.setSelectedItem(c);
                this.color.setEnabled(true);
                i = 0;
                while (i < listener.length) {
                    this.color.addActionListener(listener[i]);
                    ++i;
                }
                return;
            }
            if (e.getSource() == this.style) {
                boolean italic;
                ((TextStyleElementInterface)((Object)this.textStyle)).setTextStyleElement((String)this.style.getSelectedItem());
                Color c = this.textStyle.getFontColor();
                this.color.removeActionListener(this);
                if (c != null) {
                    this.color.setSelectedItem(c);
                } else {
                    this.color.setSelectedItem(this.defaultString);
                }
                String family = this.textStyle.getFontFamily();
                this.fontName.removeActionListener(this);
                if (family != null && family.length() > 0) {
                    this.fontName.setSelectedItem(family);
                } else {
                    this.fontName.setSelectedIndex(0);
                }
                this.fontName.addActionListener(this);
                int cursize = this.textStyle.getFontSize();
                this.fontSize.removeActionListener(this);
                if (cursize != -1) {
                    this.fontSize.setSelectedItem(Integer.toString(cursize));
                } else {
                    this.fontSize.setSelectedIndex(0);
                }
                this.fontSize.addActionListener(this);
                int fstyle = this.textStyle.getFontStyle();
                boolean bold = (fstyle & 1) != 0;
                boolean bl = italic = (fstyle & 2) != 0;
                String value = bold && italic ? FONT_STYLES[3] : (bold ? FONT_STYLES[1] : (italic ? FONT_STYLES[2] : FONT_STYLES[0]));
                this.fontStyle.removeActionListener(this);
                if (fstyle == -1) {
                    this.fontStyle.setSelectedIndex(0);
                } else {
                    this.fontStyle.setSelectedItem(value);
                }
                this.fontStyle.addActionListener(this);
                return;
            }
            if (e.getSource() == this.fontName) {
                String str = (String)this.fontName.getSelectedItem();
                if (str.length() > 0 && this.needtoRemoveBlankFamily) {
                    this.fontName.removeActionListener(this);
                    int count = this.fontName.getItemCount() - 1;
                    Object[] list = new Object[count];
                    for (int i = 0; i < count; ++i) {
                        list[i] = this.fontName.getItemAt(i);
                    }
                    this.fontName.setModel(new DefaultComboBoxModel<Object>(list));
                    this.fontName.setSelectedItem(str);
                    this.fontName.addActionListener(this);
                    this.needtoRemoveBlankFamily = false;
                }
                if (this.textStyle instanceof DefaultTextInterface && this.fontName.getSelectedIndex() == 0) {
                    this.textStyle.setFontFamily("");
                    return;
                }
                if (str.length() <= 0) return;
                this.textStyle.setFontFamily(str);
                return;
            }
            if (e.getSource() == this.fontSize) {
                String fSize = (String)this.fontSize.getSelectedItem();
                if (fSize.length() > 0 && this.needtoRemoveBlankSize) {
                    this.fontSize.removeActionListener(this);
                    int count = this.fontSize.getItemCount() - 1;
                    Object[] list = new Object[count];
                    for (int i = 0; i < count; ++i) {
                        list[i] = this.fontSize.getItemAt(i);
                    }
                    this.fontSize.setModel(new DefaultComboBoxModel<Object>(list));
                    this.fontSize.setSelectedItem(fSize);
                    this.fontSize.addActionListener(this);
                    this.needtoRemoveBlankSize = false;
                }
                if (this.textStyle instanceof DefaultTextInterface && this.fontSize.getSelectedIndex() == 0) {
                    this.textStyle.setFontSize(-1);
                    return;
                }
                if (fSize.length() <= 0) return;
                this.textStyle.setFontSize(Integer.parseInt(fSize));
                return;
            }
            if (e.getSource() != this.fontStyle) return;
            String value = (String)this.fontStyle.getSelectedItem();
            if (value.length() > 0 && this.needtoRemoveBlankStyle) {
                this.fontStyle.removeActionListener(this);
                int count = this.fontStyle.getItemCount() - 1;
                Object[] list = new Object[count];
                for (int i = 0; i < count; ++i) {
                    list[i] = this.fontStyle.getItemAt(i);
                }
                this.fontStyle.setModel(new DefaultComboBoxModel<Object>(list));
                this.fontStyle.setSelectedItem(value);
                this.fontStyle.addActionListener(this);
                this.needtoRemoveBlankStyle = false;
            }
            if (value.equals(FONT_STYLES[0])) {
                this.textStyle.setFontStyle(0);
                return;
            }
            if (value.equals(FONT_STYLES[1])) {
                this.textStyle.setFontStyle(1);
                return;
            }
            if (value.equals(FONT_STYLES[2])) {
                this.textStyle.setFontStyle(2);
                return;
            }
            if (value.equals(FONT_STYLES[3])) {
                this.textStyle.setFontStyle(3);
                return;
            }
            if (value.length() <= 0) return;
            this.textStyle.setFontStyle(-1);
            return;
        }
        for (parent = this.getParent(); parent != null && !(parent instanceof JFrame); parent = parent.getParent()) {
        }
        int result = SGDialog.showInputDialog((JFrame)parent, RB.getStringResource("morecolors.txt"), panel);
        if (result == 0) {
            Color newColor = cc.getColor();
            if (newColor == null) {
                if (save == null) {
                    this.color.setSelectedItem(this.defaultString);
                    return;
                }
                this.color.setSelectedItem(save);
                return;
            }
            if (save != null) {
                if (save.getRGB() == newColor.getRGB()) return;
            }
            this.textStyle.setFontColor(newColor);
            this.color.setSelectedItem(newColor);
            return;
        }
        if (save == null) {
            this.color.setSelectedItem(this.defaultString);
            return;
        }
        this.color.setSelectedItem(save);
    }

    public void setEnabledAll(boolean enable) {
        this.color.setEnabled(enable);
        this.fontName.setEnabled(enable);
        this.fontSize.setEnabled(enable);
        this.fontStyle.setEnabled(enable);
        if (this.style != null) {
            this.style.setEnabled(enable);
        }
    }
}

