/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.sg.ui;

import com.sas.graphics.sg.interfaces.AxisInterface;
import com.sas.graphics.sg.ui.ColorGrabber;
import com.sas.graphics.sg.ui.CompTitledBorder;
import com.sas.graphics.sg.ui.LabelCellRenderer;
import com.sas.graphics.sg.ui.LineCustomizerPanel;
import com.sas.graphics.sg.ui.RB;
import com.sas.graphics.sg.ui.UIUtil;
import com.sas.graphics.sg.util.Util;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ImageIcon;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.Border;
import javax.swing.border.CompoundBorder;
import javax.swing.border.LineBorder;

public class SimpleAxisCustomizerPanel
extends JPanel
implements ActionListener {
    private static final String RB_KEY = "AxisCustomizerPanel.";
    private static final int dlu2 = UIUtil.DLU * 2;
    private static final int dlu3 = UIUtil.DLU * 3;
    private static final int dlu4 = UIUtil.DLU * 4;
    private static final int dlu7 = UIUtil.DLU * 7;
    private static final int dlu11 = UIUtil.DLU * 11;
    private static final Border left = BorderFactory.createEmptyBorder(0, dlu7, 0, dlu7);
    private JComboBox axisId;
    private AxisInterface[] axes;
    private AxisInterface curaxis;
    private int curIndex = 0;
    private CompTitledBorder lineBorder1;
    private CompTitledBorder lineBorder2;
    private JPanel titlePanel;
    private JPanel axisPanel;
    JCheckBox grid;
    JCheckBox label;
    private LineCustomizerPanel gridPanel;
    private ColorGrabber colorGrabber;

    public SimpleAxisCustomizerPanel(AxisInterface axis, ColorGrabber cg) {
        this.axes = null;
        this.curIndex = -1;
        this.curaxis = axis;
        this.setLayout(new BoxLayout(this, 1));
        this.colorGrabber = cg;
        this.axisPanel = this.createAxisPanel();
        this.axisPanel.setBorder(UIUtil.emptyBorder);
        this.add(this.axisPanel);
        this.add(Box.createVerticalGlue());
    }

    public SimpleAxisCustomizerPanel(AxisInterface[] axes, int curIndex, ColorGrabber cg) {
        this.axes = axes;
        this.curIndex = curIndex;
        this.curaxis = axes[curIndex];
        this.colorGrabber = cg;
        if (axes != null && axes.length > 0) {
            this.init();
        }
    }

    private void init() {
        this.titlePanel = new JPanel();
        this.titlePanel.setBorder(BorderFactory.createEmptyBorder(dlu4, dlu3, dlu4, dlu2));
        this.titlePanel.setLayout(new BoxLayout(this.titlePanel, 0));
        JLabel title = new JLabel(RB.getStringResource(RB_KEY, "axis.txt"));
        this.titlePanel.add(title);
        this.titlePanel.add(Box.createRigidArea(new Dimension(3, 0)));
        JLabel[] list = new JLabel[this.axes.length];
        ImageIcon[] icons = new ImageIcon[7];
        for (int i = 0; i < this.axes.length; ++i) {
            list[i] = new JLabel((String)this.axes[i].getElementID());
            int type = this.axes[i].getAxisType();
            if (icons[type] == null) {
                switch (type) {
                    default: {
                        icons[type] = new ImageIcon(Util.getImage(null, "xaxis.gif"));
                        break;
                    }
                    case 1: {
                        icons[type] = new ImageIcon(Util.getImage(null, "x2axis.gif"));
                        break;
                    }
                    case 2: {
                        icons[type] = new ImageIcon(Util.getImage(null, "yaxis.gif"));
                        break;
                    }
                    case 3: {
                        icons[type] = new ImageIcon(Util.getImage(null, "y2axis.gif"));
                        break;
                    }
                    case 4: {
                        icons[type] = new ImageIcon(Util.getImage(null, "xaxis_3d.gif"));
                        break;
                    }
                    case 5: {
                        icons[type] = new ImageIcon(Util.getImage(null, "yaxis_3d.gif"));
                        break;
                    }
                    case 6: {
                        icons[type] = new ImageIcon(Util.getImage(null, "zaxis_3d.gif"));
                    }
                }
            }
            list[i].setIcon(icons[type]);
        }
        this.axisId = new JComboBox<JLabel>(list);
        this.axisId.setSelectedIndex(this.curIndex);
        this.axisId.setRenderer(new LabelCellRenderer());
        this.axisId.addActionListener(this);
        this.axisId.setActionCommand("axisid");
        Dimension pref = this.axisId.getPreferredSize();
        this.axisId.setPreferredSize(new Dimension(pref.width + 15, 6 + pref.height));
        this.titlePanel.add(this.axisId);
        CompoundBorder border = BorderFactory.createCompoundBorder(BorderFactory.createEmptyBorder(dlu11, dlu7, dlu7, dlu7), new LineBorder(Color.GRAY));
        this.lineBorder1 = new CompTitledBorder((Border)border, this.titlePanel);
        this.setBorder(this.lineBorder1);
        this.setLayout(null);
        this.add(this.titlePanel);
        this.axisPanel = this.createAxisPanel();
        this.add(this.axisPanel);
        this.add(Box.createVerticalGlue());
    }

    private JPanel createAxisPanel() {
        JPanel panel = new JPanel();
        panel.setLayout(new BoxLayout(panel, 1));
        JPanel displayPanel = new JPanel();
        displayPanel.setLayout(new BoxLayout(displayPanel, 0));
        displayPanel.add(Box.createRigidArea(new Dimension(7 * UIUtil.DLU, 0)));
        this.label = new JCheckBox(RB.getStringResource(RB_KEY, "label.txt"));
        this.label.setActionCommand("dlabel");
        boolean labelOn = this.curaxis.isLabelOn();
        this.label.setSelected(labelOn);
        this.label.addActionListener(this);
        displayPanel.add(this.label);
        displayPanel.add(Box.createHorizontalGlue());
        panel.add(displayPanel);
        panel.add(Box.createRigidArea(new Dimension(0, 7 * UIUtil.DLU)));
        boolean gridOn = this.curaxis.isGridOn();
        this.grid = new JCheckBox(RB.getStringResource(RB_KEY, "grid.txt"));
        this.grid.setActionCommand("dgrid");
        this.grid.setSelected(gridOn);
        this.grid.setBorder(BorderFactory.createEmptyBorder(0, dlu2, 0, dlu2));
        this.grid.addActionListener(this);
        this.gridPanel = new LineCustomizerPanel(this.curaxis.getGridStyle(), this.colorGrabber);
        this.gridPanel.setBorder(left);
        this.gridPanel.setEnabledAll(gridOn);
        JPanel linePanel = new JPanel(){

            @Override
            public void doLayout() {
                Insets insets = this.getInsets();
                Rectangle rect = this.getBounds();
                rect.x = 0;
                rect.y = 0;
                if (SimpleAxisCustomizerPanel.this.lineBorder2 == null) {
                    return;
                }
                Rectangle compR = SimpleAxisCustomizerPanel.this.lineBorder2.getComponentRect(rect, insets);
                SimpleAxisCustomizerPanel.this.grid.setBounds(compR);
                rect.x += insets.left;
                rect.y += insets.top;
                rect.width -= insets.left + insets.right;
                rect.height -= insets.top + insets.bottom;
                SimpleAxisCustomizerPanel.this.gridPanel.setBounds(rect);
            }

            @Override
            public Dimension getPreferredSize() {
                Dimension ps1 = SimpleAxisCustomizerPanel.this.grid.getPreferredSize();
                Dimension ps2 = SimpleAxisCustomizerPanel.this.gridPanel.getPreferredSize();
                Insets insets = super.getInsets();
                return new Dimension(ps2.width + 16 * UIUtil.DLU + insets.left + insets.right, ps1.height + ps2.height + insets.top + insets.bottom);
            }
        };
        linePanel.add(this.grid);
        linePanel.add(this.gridPanel);
        CompoundBorder border = BorderFactory.createCompoundBorder(BorderFactory.createEmptyBorder(dlu11, dlu7, dlu7, dlu7), new LineBorder(Color.GRAY));
        this.lineBorder2 = new CompTitledBorder((Border)border, this.grid);
        linePanel.setBorder(this.lineBorder2);
        linePanel.setLayout(null);
        panel.add(linePanel);
        return panel;
    }

    private void setValues() {
        boolean gridOn = this.curaxis.isGridOn();
        if (this.grid != null) {
            this.grid.removeActionListener(this);
            this.grid.setSelected(gridOn);
            this.grid.addActionListener(this);
        }
        if (this.gridPanel != null) {
            this.gridPanel.setValue(this.curaxis.getGridStyle());
            this.gridPanel.setEnabledAll(gridOn);
        }
        boolean labelOn = this.curaxis.isLabelOn();
        this.label.removeActionListener(this);
        this.label.setSelected(labelOn);
        this.label.addActionListener(this);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        String cmd = e.getActionCommand();
        Object src = e.getSource();
        if (cmd.startsWith("axisid")) {
            int oldIndex = this.curIndex;
            this.curIndex = ((JComboBox)src).getSelectedIndex();
            if (this.curIndex != oldIndex) {
                this.curaxis = this.axes[this.curIndex];
                this.setValues();
            }
        } else if (cmd.equals("dgrid")) {
            boolean gridOn = this.grid.isSelected();
            this.curaxis.setGridOn(gridOn);
            this.gridPanel.setEnabledAll(gridOn);
        } else if (cmd.equals("dlabel")) {
            boolean labelOn = this.label.isSelected();
            this.curaxis.setLabelOn(labelOn);
            if (this.curaxis.isLabelOn() != labelOn) {
                this.label.removeActionListener(this);
                this.label.setSelected(!labelOn);
                this.label.addActionListener(this);
            }
        }
    }

    @Override
    public void doLayout() {
        Insets insets = this.getInsets();
        Rectangle rect = this.getBounds();
        rect.x = 0;
        rect.y = 0;
        if (this.lineBorder1 == null) {
            super.doLayout();
            return;
        }
        Rectangle compR = this.lineBorder1.getComponentRect(rect, insets);
        this.titlePanel.setBounds(compR);
        rect.x += insets.left;
        rect.y += insets.top;
        rect.width -= insets.left + insets.right;
        rect.height -= insets.top + insets.bottom;
        this.axisPanel.setBounds(rect);
    }

    @Override
    public Dimension getPreferredSize() {
        if (this.titlePanel != null && this.axisPanel != null) {
            Dimension ps1 = this.titlePanel.getPreferredSize();
            Dimension ps2 = this.axisPanel.getPreferredSize();
            return new Dimension(ps1.width + 16 * UIUtil.DLU, ps1.height + ps2.height);
        }
        return super.getPreferredSize();
    }
}

