/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.sg.ui;

import com.sas.graphics.sg.interfaces.AreaInterface;
import com.sas.graphics.sg.interfaces.BandInterface;
import com.sas.graphics.sg.interfaces.BiVarHistogramInterface;
import com.sas.graphics.sg.interfaces.BoxInterface;
import com.sas.graphics.sg.interfaces.BubbleInterface;
import com.sas.graphics.sg.interfaces.ContourInterface;
import com.sas.graphics.sg.interfaces.DecisionTreeInterface;
import com.sas.graphics.sg.interfaces.DendrogramInterface;
import com.sas.graphics.sg.interfaces.FringeInterface;
import com.sas.graphics.sg.interfaces.HeatMapInterface;
import com.sas.graphics.sg.interfaces.HighLowInterface;
import com.sas.graphics.sg.interfaces.HistogramInterface;
import com.sas.graphics.sg.interfaces.LineChartInterface;
import com.sas.graphics.sg.interfaces.LineInterface;
import com.sas.graphics.sg.interfaces.LineParmInterface;
import com.sas.graphics.sg.interfaces.OverlayInterface;
import com.sas.graphics.sg.interfaces.PathDiagramInterface;
import com.sas.graphics.sg.interfaces.PolygonInterface;
import com.sas.graphics.sg.interfaces.ScatterInterface;
import com.sas.graphics.sg.interfaces.SeriesInterface;
import com.sas.graphics.sg.interfaces.SurfaceInterface;
import com.sas.graphics.sg.interfaces.TextPlotInterface;
import com.sas.graphics.sg.interfaces.VectorInterface;
import com.sas.graphics.sg.ui.AreaCustomizerPanel;
import com.sas.graphics.sg.ui.BoxCustomizerPanel;
import com.sas.graphics.sg.ui.BubbleCustomizerPanel;
import com.sas.graphics.sg.ui.ColorGrabber;
import com.sas.graphics.sg.ui.CompTitledBorder;
import com.sas.graphics.sg.ui.ContourCustomizerPanel;
import com.sas.graphics.sg.ui.DecisionTreeCustomizerPanel;
import com.sas.graphics.sg.ui.DendrogramCustomizerPanel;
import com.sas.graphics.sg.ui.HeatMapCustomizerPanel;
import com.sas.graphics.sg.ui.HighLowCustomizerPanel;
import com.sas.graphics.sg.ui.LabelCellRenderer;
import com.sas.graphics.sg.ui.LineChartCustomizerPanel;
import com.sas.graphics.sg.ui.LineCustomizerPanel;
import com.sas.graphics.sg.ui.MarkerCustomizerPanel;
import com.sas.graphics.sg.ui.MyCheckBox;
import com.sas.graphics.sg.ui.NumberRangeListener;
import com.sas.graphics.sg.ui.PathDiagramCustomizerPanel;
import com.sas.graphics.sg.ui.PolygonCustomizerPanel;
import com.sas.graphics.sg.ui.RB;
import com.sas.graphics.sg.ui.SGCustomizerPanel;
import com.sas.graphics.sg.ui.SimpleBoxCustomizerPanel;
import com.sas.graphics.sg.ui.SurfaceCustomizerPanel;
import com.sas.graphics.sg.ui.TextPlotCustomizerPanel;
import com.sas.graphics.sg.ui.UIUtil;
import com.sas.graphics.sg.util.Util;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ImageIcon;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.JTabbedPane;
import javax.swing.RepaintManager;
import javax.swing.SpinnerNumberModel;
import javax.swing.border.Border;
import javax.swing.border.CompoundBorder;
import javax.swing.border.LineBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class PlotCustomizerPanel
extends JPanel {
    public static final String RB_KEY = "PlotCustomizerPanel.";
    protected static final int dlu7 = UIUtil.DLU * 7;
    static final Border tabBorder = BorderFactory.createEmptyBorder(4 * UIUtil.DLU, 2 * dlu7, 4 * UIUtil.DLU, 4 * UIUtil.DLU);
    static final int GROUPED = 41;
    static final int MAX_FRINGE_HEIGHT = 1000;
    protected OverlayInterface[] overlays;
    protected int curIndex = 0;
    protected JPanel[] overlayPanels = new JPanel[42];
    protected JComboBox cb;
    protected JPanel titlePanel;
    protected JCheckBox markers;
    protected JCheckBox arrow;
    protected JCheckBox edge;
    protected MarkerCustomizerPanel mcp = null;
    protected LineCustomizerPanel lcp = null;
    protected JSpinner heightspinner;
    protected CompTitledBorder plotBorder;
    protected boolean building = false;
    protected ColorGrabber colorGrabber = null;

    public PlotCustomizerPanel(OverlayInterface[] overlays, int curIndex) {
        this(overlays, curIndex, null);
    }

    public PlotCustomizerPanel(OverlayInterface[] overlays, int curIndex, ColorGrabber cg) {
        this.overlays = overlays;
        this.curIndex = curIndex;
        this.colorGrabber = cg;
        if (overlays != null && overlays.length > 0) {
            this.init();
        }
    }

    protected PlotCustomizerPanel getThis() {
        return this;
    }

    protected void init() {
        JLabel[] list = new JLabel[this.overlays.length];
        ImageIcon[] icons = new ImageIcon[41];
        for (int i = 0; i < this.overlays.length; ++i) {
            list[i] = new JLabel((String)this.overlays[i].getElementID());
            int type = this.overlays[i].getOverlayType();
            if (icons[type] == null) {
                switch (type) {
                    default: {
                        icons[type] = new ImageIcon(Util.getImage(null, "bubble.gif"));
                        break;
                    }
                    case 33: {
                        icons[type] = new ImageIcon(Util.getImage(null, "heatmap.gif"));
                        break;
                    }
                    case 35: {
                        icons[type] = new ImageIcon(Util.getImage(null, "dendrogram.gif"));
                        break;
                    }
                    case 5: {
                        icons[type] = new ImageIcon(Util.getImage(null, "band.gif"));
                        break;
                    }
                    case 10: {
                        icons[type] = new ImageIcon(Util.getImage(null, "bar.gif"));
                        break;
                    }
                    case 6: 
                    case 25: {
                        icons[type] = new ImageIcon(Util.getImage(null, "box.gif"));
                        break;
                    }
                    case 9: {
                        icons[type] = new ImageIcon(Util.getImage(null, "contour.gif"));
                        break;
                    }
                    case 8: 
                    case 26: {
                        icons[type] = new ImageIcon(Util.getImage(null, "ellipseoverlay.gif"));
                        break;
                    }
                    case 11: {
                        icons[type] = new ImageIcon(Util.getImage(null, "fringe.gif"));
                        break;
                    }
                    case 7: 
                    case 24: {
                        icons[type] = new ImageIcon(Util.getImage(null, "histogram.gif"));
                        break;
                    }
                    case 3: {
                        icons[type] = new ImageIcon(Util.getImage(null, "needle.gif"));
                        break;
                    }
                    case 34: {
                        icons[type] = new ImageIcon(Util.getImage(null, "highlow.gif"));
                        break;
                    }
                    case 1: 
                    case 20: 
                    case 21: 
                    case 22: 
                    case 36: {
                        icons[type] = new ImageIcon(Util.getImage(null, "series.gif"));
                        break;
                    }
                    case 2: {
                        icons[type] = new ImageIcon(Util.getImage(null, "step.gif"));
                        break;
                    }
                    case 12: {
                        icons[type] = new ImageIcon(Util.getImage(null, "surface.gif"));
                        break;
                    }
                    case 4: {
                        icons[type] = new ImageIcon(Util.getImage(null, "vector.gif"));
                        break;
                    }
                    case 13: {
                        icons[type] = new ImageIcon(Util.getImage(null, "lineoverlay.gif"));
                        break;
                    }
                    case 14: {
                        icons[type] = new ImageIcon(Util.getImage(null, "histogram.gif"));
                        break;
                    }
                    case 15: {
                        icons[type] = new ImageIcon(Util.getImage(null, "hrefline.gif"));
                        break;
                    }
                    case 16: {
                        icons[type] = new ImageIcon(Util.getImage(null, "vrefline.gif"));
                        break;
                    }
                    case 17: {
                        icons[type] = new ImageIcon(Util.getImage(null, "dropline.gif"));
                        break;
                    }
                    case 19: {
                        icons[type] = new ImageIcon(Util.getImage(null, "density.gif"));
                        break;
                    }
                    case 18: {
                        icons[type] = new ImageIcon(Util.getImage(null, "pie.gif"));
                        break;
                    }
                    case 28: {
                        icons[type] = new ImageIcon(Util.getImage(null, "hbar.gif"));
                        break;
                    }
                    case 29: {
                        icons[type] = new ImageIcon(Util.getImage(null, "hbox.gif"));
                        break;
                    }
                    case 37: {
                        icons[type] = new ImageIcon(Util.getImage(null, "DiagramView.gif"));
                        break;
                    }
                    case 38: {
                        icons[type] = new ImageIcon(Util.getImage(null, "DiagramView.gif"));
                        break;
                    }
                    case 39: {
                        icons[type] = new ImageIcon(Util.getImage(null, "TextPlot.gif"));
                        break;
                    }
                    case 40: {
                        icons[type] = new ImageIcon(Util.getImage(null, "PolygonPlot.gif"));
                    }
                }
            }
            list[i].setIcon(icons[type]);
        }
        this.titlePanel = new JPanel();
        this.titlePanel.setBorder(BorderFactory.createEmptyBorder(4 * UIUtil.DLU, 3 * UIUtil.DLU, 4 * UIUtil.DLU, 2 * UIUtil.DLU));
        this.titlePanel.setLayout(new BoxLayout(this.titlePanel, 0));
        JLabel titleLabel = new JLabel(RB.getStringResource(RB_KEY, "plot.txt"));
        this.titlePanel.add(titleLabel);
        this.titlePanel.add(Box.createRigidArea(new Dimension(3 * UIUtil.DLU, 0)));
        this.cb = new JComboBox<JLabel>(list);
        this.cb.setRenderer(new LabelCellRenderer());
        this.cb.setSelectedIndex(this.curIndex);
        this.cb.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                int newIndex = PlotCustomizerPanel.this.cb.getSelectedIndex();
                int type = PlotCustomizerPanel.this.overlays[newIndex].getOverlayType();
                if (PlotCustomizerPanel.this.curIndex != newIndex) {
                    PlotCustomizerPanel.this.remove(PlotCustomizerPanel.this.overlayPanels[PlotCustomizerPanel.this.overlays[PlotCustomizerPanel.this.curIndex].getOverlayType()]);
                    PlotCustomizerPanel.this.curIndex = newIndex;
                    PlotCustomizerPanel.this.setValues();
                    PlotCustomizerPanel.this.add(PlotCustomizerPanel.this.overlayPanels[type]);
                }
                PlotCustomizerPanel.this.invalidate();
                PlotCustomizerPanel.this.validate();
                PlotCustomizerPanel pcp = PlotCustomizerPanel.this.getThis();
                RepaintManager.currentManager(pcp).markCompletelyDirty(pcp);
                PlotCustomizerPanel.this.repaint();
                RepaintManager.currentManager(pcp).markCompletelyDirty(PlotCustomizerPanel.this.overlayPanels[type]);
                PlotCustomizerPanel.this.overlayPanels[type].repaint();
            }
        });
        this.cb.setActionCommand("overlayid");
        Dimension pref = this.cb.getPreferredSize();
        this.cb.setPreferredSize(new Dimension(pref.width + 20, pref.height));
        this.titlePanel.add(this.cb);
        CompoundBorder border = BorderFactory.createCompoundBorder(BorderFactory.createEmptyBorder(11 * UIUtil.DLU, dlu7, dlu7, dlu7), new LineBorder(Color.GRAY));
        this.plotBorder = new CompTitledBorder((Border)border, this.titlePanel);
        this.setBorder(this.plotBorder);
        this.setLayout(null);
        this.add(this.titlePanel);
        Dimension ps1 = this.getPreferredSize();
        Dimension ps2 = this.createPlotPanel();
        this.setValues();
        int type = this.overlays[this.curIndex].getOverlayType();
        this.add(this.overlayPanels[type]);
        this.add(Box.createVerticalGlue());
        this.setPreferredSize(new Dimension(ps2.width + 28 * UIUtil.DLU, ps1.height + ps2.height + 56 * UIUtil.DLU));
    }

    protected Dimension createPlotPanel() {
        this.building = true;
        Dimension pps = new Dimension(0, 0);
        for (int i = 0; i < this.overlays.length; ++i) {
            Dimension ps;
            int type = this.overlays[i].getOverlayType();
            if (this.overlayPanels[type] != null) continue;
            JPanel panel = new JPanel();
            panel.setLayout(new BoxLayout(panel, 1));
            panel.setBorder(BorderFactory.createEmptyBorder(0, dlu7, 0, dlu7));
            SGCustomizerPanel panel1 = null;
            switch (type) {
                default: {
                    break;
                }
                case 0: {
                    panel1 = new MarkerCustomizerPanel((ScatterInterface)this.overlays[i], this.colorGrabber);
                    panel1.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), RB.getStringResource("smarkers.txt")), BorderFactory.createEmptyBorder(0, dlu7, 4 * UIUtil.DLU, 4 * UIUtil.DLU)));
                    panel.add(panel1);
                    break;
                }
                case 5: {
                    panel.add(new AreaCustomizerPanel((BandInterface)this.overlays[i], this.colorGrabber));
                    break;
                }
                case 10: 
                case 28: {
                    panel.add(new AreaCustomizerPanel((AreaInterface)((Object)this.overlays[i]), this.colorGrabber));
                    break;
                }
                case 32: {
                    panel.add(new BubbleCustomizerPanel((BubbleInterface)this.overlays[i], this.colorGrabber));
                    break;
                }
                case 34: {
                    panel.add((Component)new HighLowCustomizerPanel((HighLowInterface)this.overlays[i]), this.colorGrabber);
                    break;
                }
                case 6: 
                case 29: {
                    panel.add(new SimpleBoxCustomizerPanel((BoxInterface)this.overlays[i], this.colorGrabber));
                    break;
                }
                case 9: {
                    panel.add(new ContourCustomizerPanel((ContourInterface)this.overlays[i], this.colorGrabber));
                    break;
                }
                case 35: {
                    panel.add(new DendrogramCustomizerPanel((DendrogramInterface)this.overlays[i], this.colorGrabber));
                    break;
                }
                case 8: {
                    panel.add(new AreaCustomizerPanel((AreaInterface)((Object)this.overlays[i]), this.colorGrabber));
                    break;
                }
                case 11: {
                    panel1 = new LineCustomizerPanel((FringeInterface)this.overlays[i], this.colorGrabber);
                    panel1.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), RB.getStringResource("sline.txt")), BorderFactory.createEmptyBorder(0, dlu7, 4 * UIUtil.DLU, 4 * UIUtil.DLU)));
                    panel.add(panel1);
                    panel.add(Box.createRigidArea(new Dimension(0, 7 * UIUtil.DLU)));
                    JPanel heightp = new JPanel();
                    heightp.setLayout(new BoxLayout(heightp, 0));
                    JLabel hlabel = new JLabel(RB.getStringResource("height.txt"));
                    heightp.add(hlabel);
                    Dimension ps1 = panel1.getLabelPreferredSize();
                    Dimension ps2 = hlabel.getPreferredSize();
                    ps = new Dimension(Math.max(ps1.width, ps2.width), Math.max(ps1.height, ps2.height));
                    hlabel.setPreferredSize(ps);
                    hlabel.setMaximumSize(ps);
                    panel1.setLabelPreferredSize(ps);
                    heightp.add(Box.createRigidArea(new Dimension(3 * UIUtil.DLU, 0)));
                    int fheight = ((FringeInterface)this.overlays[i]).getFringeHeight();
                    int hmax = Math.max(fheight, 1000);
                    SpinnerNumberModel model = new SpinnerNumberModel(fheight, 0, hmax, 1);
                    this.heightspinner = new JSpinner(model);
                    NumberRangeListener.addRangeListener(this.heightspinner, 0.0, hmax + 1);
                    this.heightspinner.addChangeListener(new ChangeListener(){

                        @Override
                        public void stateChanged(ChangeEvent e) {
                            if (PlotCustomizerPanel.this.building) {
                                return;
                            }
                            ((FringeInterface)PlotCustomizerPanel.this.overlays[PlotCustomizerPanel.this.curIndex]).setFringeHeight(((Number)((JSpinner)e.getSource()).getValue()).intValue());
                        }
                    });
                    heightp.add(this.heightspinner);
                    ps1 = panel1.getWidgetPreferredSize();
                    ps2 = this.heightspinner.getPreferredSize();
                    ps = new Dimension(Math.max(ps1.width, ps2.width), Math.max(ps1.height, ps2.height));
                    this.heightspinner.setPreferredSize(ps);
                    this.heightspinner.setMaximumSize(ps);
                    panel1.setWidgetPreferredSize(ps);
                    heightp.add(Box.createHorizontalGlue());
                    panel.add(heightp);
                    panel.add(Box.createVerticalGlue());
                    break;
                }
                case 7: {
                    panel.add(new AreaCustomizerPanel((HistogramInterface)this.overlays[i], this.colorGrabber));
                    break;
                }
                case 14: {
                    panel.add(new AreaCustomizerPanel((BiVarHistogramInterface)this.overlays[i], this.colorGrabber));
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    JTabbedPane tabbedPane = new JTabbedPane(1, 0);
                    panel1 = new LineCustomizerPanel((SeriesInterface)this.overlays[i], this.colorGrabber);
                    panel1.setBorder(UIUtil.emptyBorder);
                    tabbedPane.addTab(RB.getStringResource("sline.txt"), panel1);
                    tabbedPane.setMnemonicAt(0, 49);
                    JPanel markerPanel = new JPanel();
                    markerPanel.setBorder(UIUtil.emptyBorder);
                    markerPanel.setLayout(new BoxLayout(markerPanel, 1));
                    JPanel title = new JPanel();
                    title.setLayout(new BoxLayout(title, 0));
                    this.markers = new MyCheckBox(RB.getStringResource("smarkers.txt"));
                    boolean isMarkerOn = ((SeriesInterface)this.overlays[i]).isMarkerOn();
                    this.markers.setSelected(isMarkerOn);
                    this.markers.addActionListener(new ActionListener(){

                        @Override
                        public void actionPerformed(ActionEvent e) {
                            if (PlotCustomizerPanel.this.building) {
                                return;
                            }
                            JCheckBox jcb = (JCheckBox)e.getSource();
                            ((SeriesInterface)PlotCustomizerPanel.this.overlays[PlotCustomizerPanel.this.curIndex]).setMarkerOn(jcb.isSelected());
                            PlotCustomizerPanel.this.mcp.setValue(PlotCustomizerPanel.this.overlays[PlotCustomizerPanel.this.curIndex]);
                            PlotCustomizerPanel.this.mcp.setEnabledAll(jcb.isSelected());
                        }
                    });
                    title.add(this.markers);
                    title.add(Box.createHorizontalGlue());
                    markerPanel.add(title);
                    this.mcp = new MarkerCustomizerPanel((SeriesInterface)this.overlays[i], this.colorGrabber);
                    this.mcp.setBorder(tabBorder);
                    markerPanel.add(this.mcp);
                    this.mcp.setEnabledAll(isMarkerOn);
                    this.mcp.add(Box.createVerticalGlue());
                    tabbedPane.addTab(RB.getStringResource("smarkers.txt"), markerPanel);
                    tabbedPane.setMnemonicAt(1, 50);
                    panel.add(tabbedPane);
                    if (type != 2) break;
                    break;
                }
                case 19: 
                case 20: 
                case 21: 
                case 22: {
                    panel1 = new LineCustomizerPanel((SeriesInterface)this.overlays[i], this.colorGrabber);
                    panel1.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), RB.getStringResource("sline.txt")), BorderFactory.createEmptyBorder(0, dlu7, 4 * UIUtil.DLU, 4 * UIUtil.DLU)));
                    panel.add(panel1);
                    break;
                }
                case 13: {
                    panel1 = new LineCustomizerPanel((LineParmInterface)this.overlays[i], this.colorGrabber);
                    panel1.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), RB.getStringResource("sline.txt")), BorderFactory.createEmptyBorder(0, dlu7, 4 * UIUtil.DLU, 4 * UIUtil.DLU)));
                    panel.add(panel1);
                    break;
                }
                case 36: {
                    panel.add(new LineChartCustomizerPanel((LineChartInterface)this.overlays[i], this.colorGrabber));
                    break;
                }
                case 12: {
                    panel.add(new SurfaceCustomizerPanel((SurfaceInterface)this.overlays[i], this.colorGrabber));
                    break;
                }
                case 4: {
                    panel1 = new LineCustomizerPanel((SeriesInterface)this.overlays[i], this.colorGrabber);
                    panel1.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), RB.getStringResource("sline.txt")), BorderFactory.createEmptyBorder(0, dlu7, 4 * UIUtil.DLU, 4 * UIUtil.DLU)));
                    panel.add(panel1);
                    panel.add(Box.createRigidArea(new Dimension(0, 7 * UIUtil.DLU)));
                    JPanel mpanel = new JPanel();
                    mpanel.setLayout(new BoxLayout(mpanel, 0));
                    this.arrow = new MyCheckBox(RB.getStringResource("sarrow.txt"));
                    boolean isArrowOn = ((VectorInterface)this.overlays[i]).isArrowOn();
                    this.arrow.setSelected(isArrowOn);
                    this.arrow.addActionListener(new ActionListener(){

                        @Override
                        public void actionPerformed(ActionEvent e) {
                            if (PlotCustomizerPanel.this.building) {
                                return;
                            }
                            JCheckBox jcb = (JCheckBox)e.getSource();
                            ((VectorInterface)PlotCustomizerPanel.this.overlays[PlotCustomizerPanel.this.curIndex]).setArrowOn(jcb.isSelected());
                        }
                    });
                    mpanel.add(this.arrow);
                    mpanel.add(Box.createHorizontalGlue());
                    panel.add(mpanel);
                    panel.add(Box.createVerticalGlue());
                    break;
                }
                case 15: 
                case 16: 
                case 17: {
                    panel1 = new LineCustomizerPanel((LineInterface)((Object)this.overlays[i]), this.colorGrabber);
                    panel1.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), RB.getStringResource("sline.txt")), BorderFactory.createEmptyBorder(0, dlu7, 4 * UIUtil.DLU, 4 * UIUtil.DLU)));
                    panel.add(panel1);
                    break;
                }
                case 33: {
                    panel.add(new HeatMapCustomizerPanel((HeatMapInterface)this.overlays[i], this.colorGrabber));
                    break;
                }
                case 37: {
                    panel.add(new PathDiagramCustomizerPanel((PathDiagramInterface)this.overlays[i], this.colorGrabber));
                    break;
                }
                case 38: {
                    panel.add(new DecisionTreeCustomizerPanel((DecisionTreeInterface)this.overlays[i], this.colorGrabber));
                    break;
                }
                case 39: {
                    panel.add(new TextPlotCustomizerPanel((TextPlotInterface)this.overlays[i], this.colorGrabber));
                    break;
                }
                case 40: {
                    panel.add(new PolygonCustomizerPanel((PolygonInterface)this.overlays[i], this.colorGrabber));
                }
            }
            panel.setBorder(UIUtil.emptyBorder);
            this.overlayPanels[type] = panel;
            ps = panel.getPreferredSize();
            pps.setSize(Math.max(pps.width, ps.width), Math.max(pps.height, ps.height));
        }
        this.building = false;
        return pps;
    }

    protected void setValues() {
        if (this.overlays == null || this.overlays.length == 0) {
            return;
        }
        this.building = true;
        int type = this.overlays[this.curIndex].getOverlayType();
        Component[] clist = this.overlayPanels[type].getComponents();
        block0 : switch (type) {
            default: {
                for (int i = 0; i < clist.length; ++i) {
                    if (!(clist[i] instanceof MarkerCustomizerPanel)) continue;
                    ((MarkerCustomizerPanel)clist[i]).setValue(this.overlays[this.curIndex]);
                }
                break;
            }
            case 5: {
                for (int i = 0; i < clist.length; ++i) {
                    if (!(clist[i] instanceof AreaCustomizerPanel)) continue;
                    ((AreaCustomizerPanel)clist[i]).setValue(this.overlays[this.curIndex]);
                }
                break;
            }
            case 10: 
            case 28: {
                for (int i = 0; i < clist.length; ++i) {
                    if (clist[i] instanceof SGCustomizerPanel) {
                        ((SGCustomizerPanel)clist[i]).setValue(this.overlays[this.curIndex]);
                        continue;
                    }
                    if (!(clist[i] instanceof JTabbedPane)) continue;
                    Component[] c = ((JTabbedPane)clist[i]).getComponents();
                    for (int j = 0; j < c.length; ++j) {
                        if (c[j] instanceof AreaCustomizerPanel) {
                            ((AreaCustomizerPanel)c[j]).setValue(this.overlays[this.curIndex]);
                            continue;
                        }
                        if (!(c[j] instanceof SGCustomizerPanel)) continue;
                        ((SGCustomizerPanel)c[j]).setValue(this.overlays[this.curIndex]);
                    }
                }
                break;
            }
            case 9: {
                for (int i = 0; i < clist.length; ++i) {
                    if (!(clist[i] instanceof ContourCustomizerPanel)) continue;
                    ((ContourCustomizerPanel)clist[i]).setValue(this.overlays[this.curIndex]);
                }
                break;
            }
            case 8: {
                for (int i = 0; i < clist.length; ++i) {
                    if (!(clist[i] instanceof AreaCustomizerPanel)) continue;
                    ((AreaCustomizerPanel)clist[i]).setValue(this.overlays[this.curIndex]);
                }
                break;
            }
            case 11: {
                for (int i = 0; i < clist.length; ++i) {
                    if (!(clist[i] instanceof LineCustomizerPanel)) continue;
                    ((LineCustomizerPanel)clist[i]).setValue(this.overlays[this.curIndex]);
                }
                this.heightspinner.setValue(new Integer(((FringeInterface)this.overlays[this.curIndex]).getFringeHeight()));
                break;
            }
            case 13: 
            case 15: 
            case 16: 
            case 17: 
            case 19: 
            case 20: 
            case 21: 
            case 22: {
                for (int i = 0; i < clist.length; ++i) {
                    if (!(clist[i] instanceof LineCustomizerPanel)) continue;
                    ((LineCustomizerPanel)clist[i]).setValue(this.overlays[this.curIndex]);
                }
                break;
            }
            case 7: {
                for (int i = 0; i < clist.length; ++i) {
                    if (!(clist[i] instanceof AreaCustomizerPanel)) continue;
                    ((AreaCustomizerPanel)clist[i]).setValue(this.overlays[this.curIndex]);
                }
                break;
            }
            case 14: {
                for (int i = 0; i < clist.length; ++i) {
                    if (!(clist[i] instanceof AreaCustomizerPanel)) continue;
                    ((AreaCustomizerPanel)clist[i]).setValue(this.overlays[this.curIndex]);
                }
                break;
            }
            case 6: 
            case 29: {
                for (int i = 0; i < clist.length; ++i) {
                    if (clist[i] instanceof BoxCustomizerPanel) {
                        ((BoxCustomizerPanel)clist[i]).setValue((BoxInterface)this.overlays[this.curIndex]);
                        break block0;
                    }
                    if (!(clist[i] instanceof SimpleBoxCustomizerPanel)) continue;
                    ((SimpleBoxCustomizerPanel)clist[i]).setValue(this.overlays[this.curIndex]);
                    break block0;
                }
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                boolean isMarkerOn = ((SeriesInterface)this.overlays[this.curIndex]).isMarkerOn();
                this.markers.setSelected(isMarkerOn);
                for (int i = 0; i < clist.length; ++i) {
                    if (!(clist[i] instanceof JTabbedPane)) continue;
                    Component[] c = ((JTabbedPane)clist[i]).getComponents();
                    block35: for (int j = 0; j < c.length; ++j) {
                        if (c[j] instanceof LineCustomizerPanel) {
                            ((LineCustomizerPanel)c[j]).setValue(this.overlays[this.curIndex]);
                            continue;
                        }
                        if (!(c[j] instanceof JPanel)) continue;
                        Component[] cj = ((JPanel)c[j]).getComponents();
                        for (int k = 0; k < cj.length; ++k) {
                            if (!(cj[k] instanceof MarkerCustomizerPanel)) continue;
                            this.mcp = (MarkerCustomizerPanel)cj[k];
                            this.mcp.setValue(this.overlays[this.curIndex]);
                            this.mcp.setEnabledAll(isMarkerOn);
                            continue block35;
                        }
                    }
                }
                if (type != 2) break;
                break;
            }
            case 12: {
                for (int i = 0; i < clist.length; ++i) {
                    if (!(clist[i] instanceof SurfaceCustomizerPanel)) continue;
                    ((SurfaceCustomizerPanel)clist[i]).setValue(this.overlays[this.curIndex]);
                }
                break;
            }
            case 4: {
                for (int i = 0; i < clist.length; ++i) {
                    if (!(clist[i] instanceof LineCustomizerPanel)) continue;
                    ((LineCustomizerPanel)clist[i]).setValue(this.overlays[this.curIndex]);
                }
                this.arrow.setSelected(((VectorInterface)this.overlays[this.curIndex]).isArrowOn());
                break;
            }
            case 35: {
                for (int i = 0; i < clist.length; ++i) {
                    if (!(clist[i] instanceof DendrogramCustomizerPanel)) continue;
                    ((DendrogramCustomizerPanel)clist[i]).setValue(this.overlays[this.curIndex]);
                    break block0;
                }
                break;
            }
            case 34: {
                for (int i = 0; i < clist.length; ++i) {
                    if (!(clist[i] instanceof HighLowCustomizerPanel)) continue;
                    ((HighLowCustomizerPanel)clist[i]).setValue(this.overlays[this.curIndex]);
                    break block0;
                }
                break;
            }
            case 33: {
                for (int i = 0; i < clist.length; ++i) {
                    if (!(clist[i] instanceof HeatMapCustomizerPanel)) continue;
                    ((HeatMapCustomizerPanel)clist[i]).setValue(this.overlays[this.curIndex]);
                    break block0;
                }
                break;
            }
            case 32: {
                for (int i = 0; i < clist.length; ++i) {
                    if (!(clist[i] instanceof BubbleCustomizerPanel)) continue;
                    ((BubbleCustomizerPanel)clist[i]).setValue(this.overlays[this.curIndex]);
                    break block0;
                }
                break;
            }
            case 36: {
                for (int i = 0; i < clist.length; ++i) {
                    if (!(clist[i] instanceof LineChartCustomizerPanel)) continue;
                    ((LineChartCustomizerPanel)clist[i]).setValue(this.overlays[this.curIndex]);
                }
                break;
            }
            case 37: {
                for (int i = 0; i < clist.length; ++i) {
                    if (!(clist[i] instanceof PathDiagramCustomizerPanel)) continue;
                    ((PathDiagramCustomizerPanel)clist[i]).setValue(this.overlays[this.curIndex]);
                }
                break;
            }
            case 38: {
                for (int i = 0; i < clist.length; ++i) {
                    if (!(clist[i] instanceof DecisionTreeCustomizerPanel)) continue;
                    ((DecisionTreeCustomizerPanel)clist[i]).setValue(this.overlays[this.curIndex]);
                }
                break;
            }
            case 39: {
                for (int i = 0; i < clist.length; ++i) {
                    if (!(clist[i] instanceof TextPlotCustomizerPanel)) continue;
                    ((TextPlotCustomizerPanel)clist[i]).setValue(this.overlays[this.curIndex]);
                }
                break;
            }
            case 40: {
                for (int i = 0; i < clist.length; ++i) {
                    if (!(clist[i] instanceof PolygonCustomizerPanel)) continue;
                    ((PolygonCustomizerPanel)clist[i]).setValue(this.overlays[this.curIndex]);
                    break block0;
                }
            }
        }
        this.building = false;
    }

    @Override
    public void doLayout() {
        Insets insets = this.getInsets();
        Rectangle rect = this.getBounds();
        rect.x = 0;
        rect.y = 0;
        if (this.plotBorder == null) {
            return;
        }
        Rectangle compR = this.plotBorder.getComponentRect(rect, insets);
        this.titlePanel.setBounds(compR);
        rect.x += insets.left;
        rect.y += insets.top;
        rect.width -= insets.left + insets.right;
        rect.height -= insets.top + insets.bottom;
        this.overlayPanels[this.overlays[this.curIndex].getOverlayType()].setBounds(rect);
    }

    public void updateCurrentValues() {
        this.setValues();
    }
}

