/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.sg.ui;

import com.sas.graphics.sg.interfaces.SaveInterface;
import com.sas.graphics.sg.ui.RB;
import com.sas.graphics.sg.ui.WarningPanel;
import com.sas.text.Message;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.text.ParseException;
import javax.swing.InputVerifier;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JFormattedTextField;
import javax.swing.JOptionPane;
import javax.swing.JSpinner;

public class NumberRangeListener
extends InputVerifier
implements FocusListener,
KeyListener {
    public static final String RB_KEY = "NumberRangeListener.";
    double min = Double.MIN_VALUE;
    double max = Double.MAX_VALUE;
    boolean processingKey = false;
    String value = "";
    double doubleValue = 0.0;
    JFormattedTextField textField;
    JSpinner spinner;
    boolean errorMessage;
    Component nextComponent = null;
    private double step = 1.0;

    public static NumberRangeListener addRangeListener(JSpinner spinner, double min, double max) {
        JFormattedTextField textField = ((JSpinner.DefaultEditor)spinner.getEditor()).getTextField();
        NumberRangeListener nrl = new NumberRangeListener(textField, min, max);
        nrl.spinner = spinner;
        textField.addFocusListener(nrl);
        textField.setInputVerifier(nrl);
        textField.addKeyListener(nrl);
        double cvalue = ((Number)spinner.getModel().getValue()).doubleValue();
        Number value = (Number)spinner.getModel().getNextValue();
        if (value != null) {
            nrl.step = value.doubleValue() - cvalue;
        } else {
            value = (Number)spinner.getModel().getPreviousValue();
            nrl.step = value.doubleValue() - cvalue;
        }
        if (nrl.step < 1.0) {
            JFormattedTextField.AbstractFormatter formatter = textField.getFormatter();
            try {
                String vv = formatter.valueToString(new Double(nrl.step));
                nrl.step = ((Number)formatter.stringToValue(vv)).doubleValue();
                vv = formatter.valueToString(new Double(min));
                nrl.min = ((Number)formatter.stringToValue(vv)).doubleValue();
                vv = formatter.valueToString(new Double(nrl.max));
                nrl.max = ((Number)formatter.stringToValue(vv)).doubleValue();
            }
            catch (ParseException parseException) {
                // empty catch block
            }
        }
        return nrl;
    }

    public NumberRangeListener(JFormattedTextField textField, double min, double max) {
        this.textField = textField;
        this.min = min;
        this.max = max;
        this.value = textField.getText();
        try {
            JFormattedTextField.AbstractFormatter formatter = textField.getFormatter();
            this.doubleValue = ((Number)formatter.stringToValue(this.value)).doubleValue();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public boolean verify(JComponent input) {
        return this.verify();
    }

    @Override
    public boolean shouldYieldFocus(JComponent input) {
        double dvalue = -1.0;
        if (this.errorMessage) {
            return false;
        }
        boolean validValue = true;
        String cvalue = null;
        JFormattedTextField.AbstractFormatter formatter = this.textField.getFormatter();
        try {
            cvalue = formatter.stringToValue(this.textField.getText()).toString();
            dvalue = Double.parseDouble(cvalue);
            validValue = dvalue >= this.min && dvalue < this.max;
        }
        catch (Exception nfe) {
            validValue = false;
        }
        if (validValue) {
            Double nv = new Double(dvalue);
            if (!nv.toString().equalsIgnoreCase(cvalue)) {
                this.value = nv.toString();
                this.doubleValue = dvalue;
                this.textField.setValue(nv);
            }
            return true;
        }
        if (!this.errorMessage) {
            String message;
            this.errorMessage = true;
            if (this.step < 1.0) {
                String maxvalue;
                String minvalue;
                try {
                    minvalue = formatter.valueToString(new Double(this.min));
                }
                catch (ParseException pe) {
                    minvalue = Double.toString(this.min);
                }
                try {
                    maxvalue = formatter.valueToString(new Double(this.max));
                }
                catch (ParseException pe) {
                    maxvalue = Double.toString(this.max);
                }
                message = Message.format((String)RB.getStringResource(RB_KEY, "invalidNumber.fmt.txt"), (Object)minvalue, (Object)maxvalue);
            } else {
                message = Message.format((String)RB.getStringResource(RB_KEY, "invalidValue.fmt.txt"), (Object)new Double(this.min), (Object)new Double(this.max));
            }
            JOptionPane.showMessageDialog(this.textField, message, RB.getStringResource("inaneError.txt"), 0);
            this.textField.setValue(new Double(this.value));
            try {
                dvalue = Double.parseDouble(this.textField.getFormatter().stringToValue(this.value).toString());
                this.spinner.setValue(new Double(dvalue));
                this.doubleValue = dvalue;
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.errorMessage = false;
        }
        return false;
    }

    public boolean verify() {
        if (this.processingKey) {
            return true;
        }
        if (this.errorMessage) {
            return false;
        }
        this.processingKey = true;
        String cvalue = this.textField.getText();
        double dvalue = -1.0;
        boolean rc = true;
        try {
            dvalue = Double.parseDouble(this.textField.getFormatter().stringToValue(cvalue).toString());
        }
        catch (Exception nfe) {
            String message;
            rc = false;
            this.errorMessage = true;
            if (this.step < 1.0) {
                String maxvalue;
                String minvalue;
                JFormattedTextField.AbstractFormatter formatter = this.textField.getFormatter();
                try {
                    minvalue = formatter.valueToString(new Double(this.min));
                }
                catch (ParseException pe) {
                    minvalue = Double.toString(this.min);
                }
                try {
                    maxvalue = formatter.valueToString(new Double(this.max));
                }
                catch (ParseException pe) {
                    maxvalue = Double.toString(this.max);
                }
                message = Message.format((String)RB.getStringResource(RB_KEY, "invalidNumber.fmt.txt"), (Object)minvalue, (Object)maxvalue);
            } else {
                message = Message.format((String)RB.getStringResource(RB_KEY, "invalidValue.fmt.txt"), (Object)new Double(this.min), (Object)new Double(this.max));
            }
            JOptionPane.showMessageDialog(this.textField, message, RB.getStringResource("inaneError.txt"), 0);
        }
        if (rc) {
            dvalue = ((Number)this.spinner.getValue()).doubleValue();
        }
        if (rc && (dvalue < this.min || dvalue >= this.max)) {
            String message;
            this.errorMessage = true;
            if (this.step < 1.0) {
                String maxvalue;
                String minvalue;
                JFormattedTextField.AbstractFormatter formatter = this.textField.getFormatter();
                try {
                    minvalue = formatter.valueToString(new Double(this.min));
                }
                catch (ParseException pe) {
                    minvalue = Double.toString(this.min);
                }
                try {
                    maxvalue = formatter.valueToString(new Double(this.max));
                }
                catch (ParseException pe) {
                    maxvalue = Double.toString(this.max);
                }
                message = Message.format((String)RB.getStringResource(RB_KEY, "invalidNumber.fmt.txt"), (Object)minvalue, (Object)maxvalue);
            } else {
                message = Message.format((String)RB.getStringResource(RB_KEY, "invalidValue.fmt.txt"), (Object)new Double(this.min), (Object)new Double(this.max));
            }
            JOptionPane.showMessageDialog(this.textField, message, RB.getStringResource("inaneError.txt"), 0);
            rc = false;
        }
        if (rc) {
            this.doubleValue = dvalue;
            this.textField.setValue(new Double(this.doubleValue));
            this.value = this.textField.getText();
        } else {
            this.textField.setValue(new Double(this.value));
            try {
                dvalue = Double.parseDouble(this.textField.getFormatter().stringToValue(this.value).toString());
                this.spinner.setValue(new Double(dvalue));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.errorMessage = false;
        this.processingKey = false;
        return rc;
    }

    public boolean apply() {
        if (this.processingKey) {
            return true;
        }
        if (this.errorMessage) {
            return false;
        }
        this.processingKey = true;
        String cvalue = this.textField.getText();
        double dvalue = -1.0;
        boolean rc = true;
        try {
            dvalue = Double.parseDouble(this.textField.getFormatter().stringToValue(cvalue).toString());
        }
        catch (Exception nfe) {
            String message;
            rc = false;
            this.errorMessage = true;
            if (this.step < 1.0) {
                String maxvalue;
                String minvalue;
                JFormattedTextField.AbstractFormatter formatter = this.textField.getFormatter();
                try {
                    minvalue = formatter.valueToString(new Double(this.min));
                }
                catch (ParseException pe) {
                    minvalue = Double.toString(this.min);
                }
                try {
                    maxvalue = formatter.valueToString(new Double(this.max));
                }
                catch (ParseException pe) {
                    maxvalue = Double.toString(this.max);
                }
                message = Message.format((String)RB.getStringResource(RB_KEY, "invalidNumber.fmt.txt"), (Object)minvalue, (Object)maxvalue);
            } else {
                message = Message.format((String)RB.getStringResource(RB_KEY, "invalidValue.fmt.txt"), (Object)new Double(this.min), (Object)new Double(this.max));
            }
            JOptionPane.showMessageDialog(this.textField, message, RB.getStringResource("inaneError.txt"), 0);
        }
        if (rc && (dvalue < this.min || dvalue >= this.max)) {
            String message;
            this.errorMessage = true;
            if (this.step < 1.0) {
                String maxvalue;
                String minvalue;
                JFormattedTextField.AbstractFormatter formatter = this.textField.getFormatter();
                try {
                    minvalue = formatter.valueToString(new Double(this.min));
                }
                catch (ParseException pe) {
                    minvalue = Double.toString(this.min);
                }
                try {
                    maxvalue = formatter.valueToString(new Double(this.max));
                }
                catch (ParseException pe) {
                    maxvalue = Double.toString(this.max);
                }
                message = Message.format((String)RB.getStringResource(RB_KEY, "invalidNumber.fmt.txt"), (Object)minvalue, (Object)maxvalue);
            } else {
                message = Message.format((String)RB.getStringResource(RB_KEY, "invalidValue.fmt.txt"), (Object)new Double(this.min), (Object)new Double(this.max));
            }
            JOptionPane.showMessageDialog(this.textField, message, RB.getStringResource("inaneError.txt"), 0);
            rc = false;
        }
        if (!rc) {
            this.value = this.spinner.getValue().toString();
            this.textField.setValue(this.spinner.getValue());
            try {
                dvalue = Double.parseDouble(this.textField.getFormatter().stringToValue(this.value).toString());
            }
            catch (Exception exception) {}
        } else {
            this.value = cvalue;
            this.doubleValue = dvalue;
        }
        this.spinner.setValue(new Double(dvalue));
        this.processingKey = false;
        this.errorMessage = false;
        return rc;
    }

    public void setCurrentValues(double val, double amax) {
        this.doubleValue = val;
        this.value = Double.toString(this.doubleValue);
    }

    @Override
    public void focusGained(FocusEvent e) {
    }

    @Override
    public void focusLost(FocusEvent e) {
        this.nextComponent = e.getOppositeComponent();
        if (this.nextComponent instanceof JButton && ((JButton)this.nextComponent).getActionCommand().equals("cancel")) {
            return;
        }
        double v1 = ((Number)this.spinner.getValue()).doubleValue();
        double v2 = 0.0;
        try {
            String cvalue = this.textField.getFormatter().stringToValue(this.textField.getText()).toString();
            v2 = Double.parseDouble(cvalue);
        }
        catch (Exception cvalue) {
            // empty catch block
        }
        if (v1 == v2) {
            return;
        }
        this.apply();
        if (this.nextComponent instanceof JButton && ((JButton)this.nextComponent).getActionCommand().equals("ok")) {
            ActionListener[] al = ((JButton)this.nextComponent).getActionListeners();
            ActionEvent ae = new ActionEvent(this.nextComponent, 0, "ok");
            for (int i = 0; i < al.length; ++i) {
                al[i].actionPerformed(ae);
            }
        }
    }

    @Override
    public void keyReleased(KeyEvent e) {
        int keyCode = e.getKeyCode();
        if (this.processingKey) {
            return;
        }
        if (this.errorMessage) {
            this.errorMessage = keyCode == 10;
            return;
        }
        if (keyCode == 10) {
            this.apply();
        }
    }

    @Override
    public void keyPressed(KeyEvent arg0) {
    }

    @Override
    public void keyTyped(KeyEvent arg0) {
    }

    public JFormattedTextField getTextField() {
        return this.textField;
    }

    public static void showInvalidMessage(Component parent, String minvalue, String maxvalue) {
        String message = Message.format((String)RB.getStringResource(RB_KEY, "invalidNumber.fmt.txt"), (Object)minvalue, (Object)maxvalue);
        JOptionPane.showMessageDialog(parent, message, RB.getStringResource("inaneError.txt"), 0);
    }

    public static boolean showWarningDialog(Component parent, SaveInterface save, double wmax, double hmax) {
        String title = RB.getStringResource(RB_KEY, "resolutionWarning.txt");
        WarningPanel wp = new WarningPanel(wmax, hmax);
        String sAndC = RB.getStringResource(RB_KEY, "saveAndContinue.txt");
        String continueButton = RB.getStringResource(RB_KEY, "continue.txt");
        String cancel = RB.getStringResource("cancel.txt");
        Object[] options = null;
        boolean rc = false;
        options = new Object[]{sAndC, continueButton, cancel};
        if (save != null) {
            int returnVal = JOptionPane.showOptionDialog(parent, wp, title, 1, -1, null, options, cancel);
            if (returnVal == 0) {
                save.save();
                rc = true;
            } else {
                rc = returnVal == 1;
            }
        } else {
            options = new Object[]{continueButton, cancel};
            int returnVal = JOptionPane.showOptionDialog(parent, wp, title, 0, -1, null, options, cancel);
            rc = returnVal == 0;
        }
        return rc;
    }
}

