/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.sg.ui;

import com.sas.graphics.sg.interfaces.DefaultMarkerInterface;
import com.sas.graphics.sg.interfaces.MarkerInterface;
import com.sas.graphics.sg.interfaces.MarkerStyleElementInterface;
import com.sas.graphics.sg.interfaces.ScatterInterface;
import com.sas.graphics.sg.ui.ColorComboBoxEditor;
import com.sas.graphics.sg.ui.ColorGrabber;
import com.sas.graphics.sg.ui.MarkerCellRenderer;
import com.sas.graphics.sg.ui.MarkerLabel;
import com.sas.graphics.sg.ui.RB;
import com.sas.graphics.sg.ui.SGCustomizerPanel;
import com.sas.graphics.sg.ui.SGDialog;
import com.sas.graphics.sg.ui.SwatchActionEvent;
import com.sas.graphics.sg.ui.SwatchComboBox;
import com.sas.graphics.sg.ui.SwatchRenderer;
import com.sas.graphics.sg.ui.UIUtil;
import com.sas.graphics.sg.util.Util;
import com.sas.graphics.util.Markers;
import com.sas.text.Message;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ComboBoxEditor;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JCheckBox;
import javax.swing.JColorChooser;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class MarkerCustomizerPanel
extends SGCustomizerPanel
implements ActionListener {
    protected MarkerInterface markerStyle;
    protected SwatchComboBox color;
    protected SwatchComboBox shape;
    protected JComboBox size;
    protected JComboBox style = null;
    protected String defaultColorSource = "";
    protected String defaultShapeSource = "";
    protected String defaultSizeSource = "";
    protected ColorGrabber colorGrabber = null;
    protected static Integer[] glMarkers;
    private JDialog dialog = null;

    public MarkerCustomizerPanel(MarkerInterface markerStyle) {
        this(markerStyle, null);
    }

    public MarkerCustomizerPanel(MarkerInterface markerStyle, ColorGrabber cg) {
        this.markerStyle = markerStyle;
        this.colorGrabber = cg;
        this.init();
    }

    private void init() {
        String[] sizeList;
        Dimension ps;
        this.setLayout(new BoxLayout(this, 1));
        DefaultMarkerInterface dmi = null;
        Color defaultColor = null;
        int defaultSize = -1;
        int defaultSymbol = -1;
        if (this.markerStyle instanceof DefaultMarkerInterface) {
            dmi = (DefaultMarkerInterface)((Object)this.markerStyle);
            defaultColor = dmi.getDefaultMarkerColor();
            defaultSize = dmi.getDefaultMarkerSize();
            defaultSymbol = dmi.getDefaultMarkerSymbol();
            this.defaultColorSource = dmi.getDefaultMarkerColorSource();
            this.defaultShapeSource = dmi.getDefaultMarkerSymbolSource();
            String ss = dmi.getDefaultMarkerSizeSource();
            this.defaultSizeSource = defaultSize >= 0 && ss != null ? Message.format((String)RB.getStringResource("automatic.fmt.txt"), (Object)Integer.toString(defaultSize)) : ss;
        }
        if (this.markerStyle instanceof MarkerStyleElementInterface) {
            MarkerStyleElementInterface styleInterface = (MarkerStyleElementInterface)((Object)this.markerStyle);
            JPanel stylePanel = new JPanel();
            stylePanel.setLayout(new BoxLayout(stylePanel, 0));
            JLabel stylelabel = new JLabel(RB.getStringResource("element.txt"));
            ps = stylelabel.getPreferredSize();
            this.labelSize.setSize(Math.max(this.labelSize.width, ps.width), Math.max(this.labelSize.height, ps.height));
            this.labels.add(stylelabel);
            stylePanel.add(stylelabel);
            stylePanel.add(Box.createRigidArea(new Dimension(3 * UIUtil.DLU, 0)));
            this.style = new JComboBox<String>(styleInterface.getAllMarkerStyleElements());
            this.style.setSelectedItem(styleInterface.getMarkerStyleElement());
            this.style.setActionCommand("style");
            this.style.addActionListener(this);
            this.style.setEnabled(this.style.getItemCount() > 1);
            ps = this.style.getPreferredSize();
            this.widgetSize.setSize(Math.max(this.widgetSize.width, ps.width), Math.max(this.widgetSize.height, ps.height));
            this.widgets.add(this.style);
            stylePanel.add(this.style);
            stylePanel.add(Box.createHorizontalGlue());
            this.add(stylePanel);
            this.add(Box.createRigidArea(new Dimension(0, 4 * UIUtil.DLU)));
        }
        JPanel colorPanel = new JPanel();
        colorPanel.setLayout(new BoxLayout(colorPanel, 0));
        JLabel colorlabel = new JLabel(RB.getStringResource("colorcolon.txt"));
        colorPanel.add(colorlabel);
        ps = colorlabel.getPreferredSize();
        this.labelSize.setSize(Math.max(ps.width, this.labelSize.width), Math.max(ps.height, this.labelSize.height));
        this.labels.add(colorlabel);
        colorPanel.add(Box.createRigidArea(new Dimension(UIUtil.DLU * 3, 0)));
        this.color = new SwatchComboBox(UIUtil.getColors(), 8, 4, this.colorGrabber, this.defaultColorSource, defaultColor, RB.getStringResource("morecolorsdots.txt"));
        Color c = this.markerStyle.getMarkerColor();
        this.color.setEditable(true);
        ColorComboBoxEditor editor = new ColorComboBoxEditor(this.defaultColorSource, defaultColor);
        this.color.setEditor(editor);
        editor.addMouseListener(this.color);
        if (c != null) {
            this.color.setSelectedItem(c);
        } else {
            this.color.setSelectedItem(this.defaultColorSource);
        }
        this.color.setRenderer(new SwatchRenderer());
        this.color.setActionCommand("mcolor");
        this.color.addActionListener(this);
        if (this.markerStyle instanceof ScatterInterface) {
            this.color.setEnabled(((ScatterInterface)this.markerStyle).isMarkerColorEditable());
        }
        ps = this.color.getPreferredSize();
        this.widgetSize.setSize(Math.max(ps.width, this.labelSize.width), Math.max(ps.height, this.labelSize.height));
        this.widgets.add(this.color);
        colorPanel.add(this.color);
        colorPanel.add(Box.createHorizontalGlue());
        this.add(colorPanel);
        this.add(Box.createRigidArea(new Dimension(0, UIUtil.DLU * 4)));
        JPanel shapePanel = new JPanel();
        shapePanel.setLayout(new BoxLayout(shapePanel, 0));
        JLabel shapelabel = new JLabel(RB.getStringResource("shape.txt"));
        shapePanel.add(shapelabel);
        ps = shapelabel.getPreferredSize();
        this.labelSize.setSize(Math.max(ps.width, this.labelSize.width), Math.max(ps.height, this.labelSize.height));
        this.labels.add(shapelabel);
        shapePanel.add(Box.createRigidArea(new Dimension(UIUtil.DLU * 3, 0)));
        String[] markerlist = UIUtil.getGLMarkers();
        int markerlistSize = markerlist.length - 2;
        glMarkers = new Integer[markerlistSize];
        Integer select = null;
        int curIndex = this.markerStyle.getMarkerSymbol();
        for (int i = 0; i < markerlistSize; ++i) {
            String glName = Util.toGL(markerlist[i + 2]);
            int ii = Markers.getShape((String)glName);
            MarkerCustomizerPanel.glMarkers[i] = new Integer(ii);
            if (ii != curIndex) continue;
            select = glMarkers[i];
        }
        this.shape = new SwatchComboBox(glMarkers, 6, 4, this.defaultShapeSource, new Integer(defaultSymbol), null);
        MarkerCellRenderer mcr = new MarkerCellRenderer();
        mcr.setBorder(UIUtil.emptyItemBorder);
        this.shape.setRenderer(mcr);
        this.shape.setMaximumRowCount(12);
        this.shape.setEditable(true);
        MarkerComboBoxEditor meditor = new MarkerComboBoxEditor();
        this.shape.setEditor(meditor);
        meditor.addMouseListener(this.shape);
        if (curIndex < 0) {
            this.shape.setSelectedItem(this.defaultShapeSource);
        } else if (select != null) {
            this.shape.setSelectedItem(select);
        } else {
            this.shape.setSelectedItem(glMarkers[0]);
        }
        this.shape.setActionCommand("mshape");
        this.shape.addActionListener(this);
        if (this.markerStyle instanceof ScatterInterface) {
            this.shape.setEnabled(((ScatterInterface)this.markerStyle).isMarkerSymbolEditable());
        }
        shapePanel.add(this.shape);
        shapePanel.add(Box.createHorizontalGlue());
        this.add(shapePanel);
        ps = this.shape.getPreferredSize();
        this.widgetSize.setSize(Math.max(ps.width, this.widgetSize.width), Math.max(ps.height, this.widgetSize.height));
        this.add(Box.createRigidArea(new Dimension(0, UIUtil.DLU * 4)));
        this.widgets.add(this.shape);
        JPanel sizePanel = new JPanel();
        sizePanel.setLayout(new BoxLayout(sizePanel, 0));
        JLabel sizelabel = new JLabel(RB.getStringResource("size.txt"));
        sizePanel.add(sizelabel);
        ps = sizelabel.getPreferredSize();
        this.labelSize.setSize(Math.max(ps.width, this.labelSize.width), Math.max(ps.height, this.labelSize.height));
        this.labels.add(sizelabel);
        sizePanel.add(Box.createRigidArea(new Dimension(UIUtil.DLU * 3, 0)));
        String[] sList = UIUtil.getMarkerSizes();
        if (this.defaultSizeSource != null) {
            sizeList = new String[sList.length + 1];
            sizeList[0] = this.defaultSizeSource;
            System.arraycopy(sList, 0, sizeList, 1, sList.length);
        } else {
            sizeList = sList;
        }
        this.size = new JComboBox<String>(sizeList);
        if (this.markerStyle instanceof ScatterInterface) {
            this.size.setEnabled(((ScatterInterface)this.markerStyle).isMarkerSizeEditable());
        }
        this.size.setEditable(true);
        this.size.setEditor(new MarkerComboBoxEditor());
        int cursize = this.markerStyle.getMarkerSize();
        if (cursize >= 0) {
            int i;
            boolean found = false;
            int count = this.size.getItemCount();
            int n = i = this.defaultSizeSource == null ? 0 : 1;
            while (i < count) {
                int value = Integer.parseInt((String)this.size.getItemAt(i));
                if (value == cursize) {
                    found = true;
                    this.size.setSelectedIndex(i);
                    break;
                }
                if (cursize < value) {
                    found = true;
                    this.size.insertItemAt(Integer.toString(cursize), i);
                    this.size.setSelectedIndex(i);
                    break;
                }
                ++i;
            }
            if (!found) {
                this.size.insertItemAt(Integer.toString(cursize), count);
                this.size.setSelectedIndex(count);
            }
        } else {
            this.size.setSelectedItem(this.defaultSizeSource);
        }
        this.size.addActionListener(this);
        this.size.setActionCommand("msize");
        sizePanel.add(this.size);
        sizePanel.add(Box.createHorizontalGlue());
        this.add(sizePanel);
        ps = this.size.getPreferredSize();
        this.widgetSize.setSize(Math.max(ps.width, this.widgetSize.width), Math.max(ps.height, this.widgetSize.height));
        this.widgets.add(this.size);
        this.setLabelPreferredSize(null);
        this.setWidgetPreferredSize(null);
    }

    @Override
    public void setValue(Object newValue) {
        Color c;
        if (!(newValue instanceof MarkerInterface)) {
            return;
        }
        this.markerStyle = (MarkerInterface)newValue;
        this.color.removeActionListener(this);
        this.shape.removeActionListener(this);
        this.size.removeActionListener(this);
        DefaultMarkerInterface dmi = null;
        Color defaultColor = null;
        int defaultSize = -1;
        int defaultSymbol = -1;
        if (this.markerStyle instanceof DefaultMarkerInterface) {
            dmi = (DefaultMarkerInterface)((Object)this.markerStyle);
            defaultColor = dmi.getDefaultMarkerColor();
            defaultSize = dmi.getDefaultMarkerSize();
            defaultSymbol = dmi.getDefaultMarkerSymbol();
            this.defaultColorSource = dmi.getDefaultMarkerColorSource();
            this.defaultShapeSource = dmi.getDefaultMarkerSymbolSource();
            String ss = dmi.getDefaultMarkerSizeSource();
            this.defaultSizeSource = defaultSize >= 0 && ss != null ? Message.format((String)RB.getStringResource("automatic.fmt.txt"), (Object)Integer.toString(defaultSize)) : ss;
            this.color.setAutomatic(this.defaultColorSource, defaultColor);
            this.color.setEditor(new ColorComboBoxEditor(this.defaultColorSource, defaultColor));
            this.color.updateUI();
            this.shape.setAutomatic(this.defaultShapeSource, new Integer(defaultSymbol));
            this.shape.updateUI();
        }
        if (this.style != null) {
            this.style.removeActionListener(this);
            this.style.setModel(new DefaultComboBoxModel<String>(((MarkerStyleElementInterface)((Object)this.markerStyle)).getAllMarkerStyleElements()));
            this.style.setSelectedItem(((MarkerStyleElementInterface)((Object)this.markerStyle)).getMarkerStyleElement());
            this.style.setEnabled(this.style.getItemCount() > 1);
            this.style.addActionListener(this);
        }
        if ((c = this.markerStyle.getMarkerColor()) == null) {
            this.color.setSelectedItem(this.defaultColorSource);
        } else {
            this.color.setSelectedItem(c);
        }
        if (this.markerStyle instanceof ScatterInterface) {
            this.color.setEnabled(((ScatterInterface)this.markerStyle).isMarkerColorEditable());
        }
        this.color.addActionListener(this);
        Integer select = null;
        int curIndex = this.markerStyle.getMarkerSymbol();
        for (int i = 0; i < glMarkers.length; ++i) {
            if (curIndex != glMarkers[i]) continue;
            select = glMarkers[i];
        }
        if (curIndex < 0) {
            this.shape.setSelectedItem(this.defaultShapeSource);
        } else if (select != null) {
            this.shape.setSelectedItem(select);
        } else {
            this.shape.setSelectedItem(glMarkers[0]);
        }
        if (this.markerStyle instanceof ScatterInterface) {
            this.shape.setEnabled(((ScatterInterface)this.markerStyle).isMarkerSymbolEditable());
        }
        this.shape.addActionListener(this);
        if (this.defaultSizeSource != null) {
            while (!this.size.getItemAt(0).equals(UIUtil.getMarkerSizes()[0])) {
                this.size.removeItemAt(0);
            }
            this.size.insertItemAt(this.defaultSizeSource, 0);
        }
        String cursize = Integer.toString(this.markerStyle.getMarkerSize());
        boolean inlist = false;
        for (int i = 0; i < this.size.getItemCount(); ++i) {
            if (!cursize.equals(this.size.getItemAt(i))) continue;
            inlist = true;
            break;
        }
        if (inlist) {
            this.size.setSelectedItem(cursize);
        } else if (Integer.parseInt(cursize) >= 0) {
            this.size.insertItemAt(cursize, 1);
            this.size.setSelectedIndex(1);
        } else {
            this.size.setSelectedItem(this.defaultSizeSource);
        }
        if (this.markerStyle instanceof ScatterInterface) {
            this.size.setEnabled(((ScatterInterface)this.markerStyle).isMarkerSizeEditable());
        }
        this.size.addActionListener(this);
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public void actionPerformed(ActionEvent e) {
        boolean inlist;
        String cursize;
        block41: {
            Container parent;
            JPanel panel;
            JColorChooser cc;
            Color save;
            block40: {
                String cmd;
                block39: {
                    cmd = e.getActionCommand();
                    if (!cmd.equals("mcolor")) break block39;
                    Object item = this.color.getSelectedItem();
                    if (item == null) return;
                    save = this.markerStyle.getMarkerColor();
                    if (!(item instanceof String)) {
                        if (!(item instanceof Color)) return;
                        this.markerStyle.setMarkerColor((Color)item);
                        return;
                    }
                    if (((String)item).equals(RB.getStringResource("morecolorsdots.txt"))) {
                        cc = UIUtil.colorChooser;
                        if (save == null) {
                            if (this.markerStyle instanceof DefaultMarkerInterface) {
                                cc.setColor(((DefaultMarkerInterface)((Object)this.markerStyle)).getDefaultMarkerColor());
                            }
                        } else {
                            cc.setColor(save);
                        }
                        cc.setPreviewPanel(new JPanel());
                        panel = new JPanel();
                        panel.setLayout(new BorderLayout());
                        panel.add(cc);
                        break block40;
                    } else {
                        if (((String)item).equals(this.defaultColorSource)) {
                            this.markerStyle.setMarkerColor(null);
                            return;
                        }
                        Container c = this.getTopLevelAncestor();
                        if (c instanceof SGDialog) {
                            SGDialog sgd = (SGDialog)c;
                            sgd.value = -1;
                            this.dialog = sgd.makeDisabledCopy(this.colorGrabber);
                            c.setVisible(false);
                            this.dialog.setVisible(true);
                        }
                        c = this.colorGrabber.grabComponent.getTopLevelAncestor();
                        c.requestFocus();
                        if (this.dialog != null) {
                            this.dialog.toFront();
                        }
                        this.colorGrabber.setMouseEventListener();
                        this.colorGrabber.addActionListener(this);
                        if (save == null) {
                            this.colorGrabber.setStartColor(this.defaultColorSource);
                            return;
                        }
                        this.colorGrabber.setStartColor(save);
                        return;
                    }
                }
                if (cmd.equals("colorpicker:done")) {
                    Object c = ((SwatchActionEvent)e).getValue();
                    this.color.setSelectedItem(c);
                    this.color.setEnabled(true);
                    this.colorGrabber.removeMouseEventListener();
                    this.colorGrabber.removeActionListener(this);
                    if (this.dialog == null) return;
                    this.dialog.dispose();
                    return;
                }
                if (cmd.equals("colorpicker:updating")) {
                    int i;
                    Color c = (Color)((SwatchActionEvent)e).getValue();
                    if (this.color == null) return;
                    ActionListener[] listener = this.color.getActionListeners();
                    for (i = 0; i < listener.length; ++i) {
                        this.color.removeActionListener(listener[i]);
                    }
                    this.color.setSelectedItem(c);
                    this.color.setEnabled(true);
                    i = 0;
                    while (i < listener.length) {
                        this.color.addActionListener(listener[i]);
                        ++i;
                    }
                    return;
                }
                if (cmd.startsWith("mshape")) {
                    Object item = this.shape.getSelectedItem();
                    if (item == null) {
                        return;
                    }
                    int save2 = this.markerStyle.getMarkerSymbol();
                    if (item instanceof Integer) {
                        int newValue = (Integer)item;
                        if (newValue == save2) return;
                        this.markerStyle.setMarkerSymbol(newValue);
                        return;
                    }
                    if (!(item instanceof String)) return;
                    if (!((String)item).equals(this.defaultShapeSource)) return;
                    this.markerStyle.setMarkerSymbol(-1);
                    return;
                }
                if (cmd.startsWith("msize")) {
                    int cur;
                    Object item = this.size.getSelectedItem();
                    if (item == null) return;
                    if (!(item instanceof String)) {
                        return;
                    }
                    if (((String)item).equals(this.defaultSizeSource)) {
                        this.markerStyle.setMarkerSize(-1);
                        return;
                    }
                    int value = Integer.parseInt((String)item);
                    if (value == (cur = this.markerStyle.getMarkerSize())) return;
                    this.markerStyle.setMarkerSize(value);
                    return;
                }
                if (!cmd.equals("style")) {
                    if (!cmd.equals("markerson")) return;
                    boolean on = ((JCheckBox)e.getSource()).isSelected();
                    this.setEnabledAll(on);
                    return;
                }
                ((MarkerStyleElementInterface)((Object)this.markerStyle)).setMarkerStyleElement((String)this.style.getSelectedItem());
                this.color.removeActionListener(this);
                Color c = this.markerStyle.getMarkerColor();
                if (c == null) {
                    this.color.setSelectedItem(this.defaultColorSource);
                } else {
                    this.color.setSelectedItem(c);
                }
                this.color.addActionListener(this);
                this.shape.removeActionListener(this);
                Integer select = null;
                int curIndex = this.markerStyle.getMarkerSymbol();
                for (int i = 0; i < glMarkers.length; ++i) {
                    if (curIndex != glMarkers[i]) continue;
                    select = glMarkers[i];
                }
                if (curIndex < 0) {
                    this.shape.setSelectedItem(this.defaultShapeSource);
                } else if (select != null) {
                    this.shape.setSelectedItem(select);
                } else {
                    this.shape.setSelectedItem(glMarkers[0]);
                }
                this.shape.addActionListener(this);
                this.size.removeActionListener(this);
                cursize = Integer.toString(this.markerStyle.getMarkerSize());
                inlist = false;
                break block41;
            }
            for (parent = this.getParent(); parent != null && !(parent instanceof JFrame); parent = parent.getParent()) {
            }
            int result = SGDialog.showInputDialog((JFrame)parent, RB.getStringResource("morecolors.txt"), panel);
            if (result == 0) {
                Color newColor = cc.getColor();
                if (newColor == null) {
                    if (save == null) {
                        this.color.setSelectedItem(this.defaultColorSource);
                        return;
                    }
                    this.color.setSelectedItem(save);
                    return;
                }
                if (save != null) {
                    if (save.getRGB() == newColor.getRGB()) return;
                }
                this.markerStyle.setMarkerColor(newColor);
                this.color.setSelectedItem(newColor);
                return;
            }
            if (save == null) {
                this.color.setSelectedItem(this.defaultColorSource);
                return;
            }
            this.color.setSelectedItem(save);
            return;
        }
        for (int i = 0; i < this.size.getItemCount(); ++i) {
            if (!cursize.equals(this.size.getItemAt(i))) continue;
            inlist = true;
            break;
        }
        if (inlist) {
            this.size.setSelectedItem(cursize);
        } else if (Integer.parseInt(cursize) >= 0) {
            this.size.insertItemAt(cursize, 1);
            this.size.setSelectedIndex(1);
        } else {
            this.size.setSelectedItem(this.defaultSizeSource);
        }
        this.size.addActionListener(this);
    }

    public void setEnabledAll(boolean state) {
        if (this.markerStyle instanceof ScatterInterface) {
            this.color.setEnabled(state && ((ScatterInterface)this.markerStyle).isMarkerColorEditable());
            this.shape.setEnabled(state && ((ScatterInterface)this.markerStyle).isMarkerSymbolEditable());
            this.size.setEnabled(state && ((ScatterInterface)this.markerStyle).isMarkerSizeEditable());
        } else {
            this.color.setEnabled(state);
            this.shape.setEnabled(state);
            this.size.setEnabled(state);
        }
        if (this.style != null) {
            this.style.setEnabled(state);
        }
    }

    public class MarkerComboBoxEditor
    extends MarkerLabel
    implements ComboBoxEditor {
        public MarkerComboBoxEditor() {
            this.setHorizontalAlignment(2);
            this.setHorizontalTextPosition(2);
            this.setIconTextGap(12);
            this.setBorder(BorderFactory.createEmptyBorder(0, UIUtil.DLU * 4, 0, 0));
            this.displayText(true);
        }

        @Override
        public void selectAll() {
        }

        @Override
        public Component getEditorComponent() {
            return this;
        }

        @Override
        public void addActionListener(ActionListener l) {
        }

        @Override
        public void removeActionListener(ActionListener l) {
        }

        @Override
        public Object getItem() {
            return this;
        }

        @Override
        public void setItem(Object anObject) {
            if (anObject == null || anObject instanceof ComboBoxEditor) {
                return;
            }
            if (anObject instanceof String) {
                String value = (String)anObject;
                this.setText(value);
                if (value.equals(MarkerCustomizerPanel.this.defaultShapeSource) && MarkerCustomizerPanel.this.markerStyle instanceof DefaultMarkerInterface) {
                    int ii = ((DefaultMarkerInterface)((Object)MarkerCustomizerPanel.this.markerStyle)).getDefaultMarkerSymbol();
                    if (ii >= 0) {
                        if (Markers.isUserDefinedMarker((int)ii)) {
                            this.setMarker(Markers.getUserDefinedMarkerName((int)ii), true);
                        } else {
                            this.setMarker(Util.GLMarkerNames[ii], true);
                        }
                    } else {
                        this.marker = null;
                    }
                    this.setText(value);
                    this.setIconTextGap(12);
                } else {
                    this.marker = null;
                }
            } else if (anObject instanceof Integer) {
                int ii = (Integer)anObject;
                if (ii >= 0) {
                    if (Markers.isUserDefinedMarker((int)ii)) {
                        this.setMarker(Markers.getUserDefinedMarkerName((int)ii), true);
                    } else {
                        this.setMarker(Util.GLMarkerNames[ii], true);
                    }
                } else {
                    this.setMarker(Util.GLMarkerNames[ii], true);
                }
            }
        }
    }
}

