/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.sg.ui;

import com.sas.graphics.sg.interfaces.LineInterface;
import com.sas.graphics.sg.interfaces.MarkerInterface;
import com.sas.graphics.sg.ui.MarkerLabel;
import com.sas.graphics.sg.util.Util;
import com.sas.graphics.util.Markers;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import javax.swing.BorderFactory;
import javax.swing.JList;
import javax.swing.ListCellRenderer;
import javax.swing.border.Border;

public class MarkerCellRenderer
extends MarkerLabel
implements ListCellRenderer {
    private Border lineBorder = BorderFactory.createLineBorder(new Color(0, 0, 132), 1);
    private Border line2Border = BorderFactory.createMatteBorder(2, 2, 0, 0, Color.white);
    private static MarkerCellRenderer selected;
    MarkerInterface mi;
    LineInterface li;

    public MarkerCellRenderer() {
        this.setOpaque(true);
    }

    public MarkerCellRenderer(MarkerInterface mi) {
        this.setOpaque(true);
        this.mi = mi;
    }

    public MarkerCellRenderer(MarkerInterface mi, LineInterface li) {
        this.setOpaque(true);
        this.mi = mi;
        this.li = li;
    }

    public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
        MarkerCellRenderer cur;
        int ii;
        if (!(value instanceof String) && !(value instanceof Integer)) {
            return null;
        }
        String aMarker = value instanceof String ? (String)value : ((ii = ((Integer)value).intValue()) >= 0 ? (Markers.isUserDefinedMarker((int)ii) ? Markers.getUserDefinedMarkerName((int)ii) : Util.GLMarkerNames[ii]) : "");
        int x = 20;
        int y = 20;
        if (isSelected) {
            if (selected == null) {
                selected = new MarkerCellRenderer();
            }
            cur = selected;
            cur.mi = this.mi;
            cur.li = this.li;
        } else {
            cur = this;
        }
        if (cur.mi != null || cur.li != null) {
            cur.displayText(true);
            if (cur.mi != null && cur.li != null) {
                cur.setText(aMarker);
            } else if (cur.mi != null) {
                cur.setText(this.marker.toString());
            } else {
                cur.setLine(this.line);
                cur.setText(this.marker.toString());
            }
            x = 200;
        } else {
            cur.setMarker(aMarker, isSelected);
        }
        if (isSelected) {
            cur.setBackground(list.getSelectionBackground());
            cur.setBorder(this.lineBorder);
        } else {
            cur.setBackground(list.getBackground());
            cur.setBorder(this.line2Border);
        }
        Dimension d = new Dimension(x, y);
        cur.setPreferredSize(d);
        return cur;
    }
}

