/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.sg.ui;

import com.sas.graphics.sg.elements.SGLine;
import com.sas.graphics.sg.interfaces.ColorEditableInterface;
import com.sas.graphics.sg.interfaces.DefaultLineInterface;
import com.sas.graphics.sg.interfaces.LineEditableInterface;
import com.sas.graphics.sg.interfaces.LineInterface;
import com.sas.graphics.sg.interfaces.LineStyleElementInterface;
import com.sas.graphics.sg.ui.ColorComboBoxEditor;
import com.sas.graphics.sg.ui.ColorGrabber;
import com.sas.graphics.sg.ui.LineComboBoxEditor;
import com.sas.graphics.sg.ui.LineRenderer;
import com.sas.graphics.sg.ui.RB;
import com.sas.graphics.sg.ui.SGCustomizerPanel;
import com.sas.graphics.sg.ui.SGDialog;
import com.sas.graphics.sg.ui.SwatchActionEvent;
import com.sas.graphics.sg.ui.SwatchComboBox;
import com.sas.graphics.sg.ui.SwatchLabel;
import com.sas.graphics.sg.ui.SwatchRenderer;
import com.sas.graphics.sg.ui.UIUtil;
import com.sas.graphics.sg.util.Util;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ComboBoxEditor;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JCheckBox;
import javax.swing.JColorChooser;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class LineCustomizerPanel
extends SGCustomizerPanel
implements ActionListener {
    protected LineInterface lineStyle;
    protected SwatchComboBox color;
    protected JComboBox lstyle;
    protected JComboBox thickness;
    protected JComboBox style = null;
    protected String defaultColorSource = "";
    protected String defaultWidthSource = "";
    protected String defaultPatternSource = "";
    ColorGrabber colorGrabber = null;
    private JDialog dialog = null;

    protected LineCustomizerPanel() {
    }

    public LineCustomizerPanel(LineInterface lineStyle) {
        this(lineStyle, null);
    }

    public LineCustomizerPanel(LineInterface lineStyle, ColorGrabber cg) {
        this.lineStyle = lineStyle;
        this.colorGrabber = cg;
        this.init();
    }

    protected void init() {
        LineEditableInterface lei;
        String[] sizeList;
        String[] patternList;
        Dimension ps;
        this.setLayout(new BoxLayout(this, 1));
        DefaultLineInterface dli = null;
        Color defaultColor = null;
        int defaultWidth = -1;
        int defaultPattern = -1;
        if (this.lineStyle instanceof DefaultLineInterface) {
            dli = (DefaultLineInterface)((Object)this.lineStyle);
            defaultColor = dli.getDefaultLineColor();
            defaultWidth = dli.getDefaultLineWidth();
            defaultPattern = dli.getDefaultLinePattern();
            this.defaultColorSource = dli.getDefaultLineColorSource();
            this.defaultPatternSource = dli.getDefaultLinePatternSource();
            this.defaultWidthSource = dli.getDefaultLineWidthSource();
        }
        if (this.lineStyle instanceof LineStyleElementInterface) {
            LineStyleElementInterface styleInterface = (LineStyleElementInterface)((Object)this.lineStyle);
            JPanel stylePanel = new JPanel();
            stylePanel.setLayout(new BoxLayout(stylePanel, 0));
            JLabel stylelabel = new JLabel(RB.getStringResource("element.txt"));
            ps = stylelabel.getPreferredSize();
            this.labelSize.setSize(Math.max(this.labelSize.width, ps.width), Math.max(this.labelSize.height, ps.height));
            this.labels.add(stylelabel);
            stylePanel.add(stylelabel);
            stylePanel.add(Box.createRigidArea(new Dimension(3 * UIUtil.DLU, 0)));
            this.style = new JComboBox<String>(styleInterface.getAllLineStyleElements());
            this.style.setSelectedItem(styleInterface.getLineStyleElement());
            this.style.setActionCommand("style");
            this.style.addActionListener(this);
            this.style.setEnabled(this.style.getItemCount() > 1);
            ps = this.style.getPreferredSize();
            this.widgetSize.setSize(Math.max(this.widgetSize.width, ps.width), Math.max(this.widgetSize.height, ps.height));
            this.widgets.add(this.style);
            stylePanel.add(this.style);
            stylePanel.add(Box.createHorizontalGlue());
            this.add(stylePanel);
            this.add(Box.createRigidArea(new Dimension(0, 4 * UIUtil.DLU)));
        }
        JPanel colorPanel = new JPanel();
        colorPanel.setLayout(new BoxLayout(colorPanel, 0));
        JLabel colorlabel = new JLabel(RB.getStringResource("colorcolon.txt"));
        colorPanel.add(colorlabel);
        colorPanel.add(Box.createRigidArea(new Dimension(3 * UIUtil.DLU, 0)));
        ps = colorlabel.getPreferredSize();
        this.labelSize.setSize(Math.max(this.labelSize.width, ps.width), Math.max(this.labelSize.height, ps.height));
        this.labels.add(colorlabel);
        this.color = new SwatchComboBox(UIUtil.getColors(), 8, 4, this.colorGrabber, this.defaultColorSource, defaultColor, RB.getStringResource("morecolorsdots.txt"));
        Color c = this.lineStyle.getLineColor();
        this.color.setEditable(true);
        SwatchLabel editor = this.lineStyle instanceof DefaultLineInterface ? new ColorComboBoxEditor(this.defaultColorSource, defaultColor) : new SimpleEditor();
        this.color.setEditor((ComboBoxEditor)((Object)editor));
        editor.addMouseListener(this.color);
        if (c != null) {
            this.color.setSelectedItem(c);
        } else {
            this.color.setSelectedItem(this.defaultColorSource);
        }
        this.color.setRenderer(new SwatchRenderer());
        this.color.setActionCommand("lcolor");
        this.color.addActionListener(this);
        colorPanel.add(this.color);
        if (this.lineStyle instanceof ColorEditableInterface) {
            this.color.setEnabled(((ColorEditableInterface)((Object)this.lineStyle)).isLineColorEditable());
        }
        colorPanel.add(Box.createHorizontalGlue());
        this.add(colorPanel);
        this.add(Box.createRigidArea(new Dimension(0, 4 * UIUtil.DLU)));
        ps = this.color.getPreferredSize();
        this.widgetSize.setSize(Math.max(this.widgetSize.width, ps.width), Math.max(this.widgetSize.height, ps.height));
        this.widgets.add(this.color);
        JPanel stylePanel = new JPanel();
        stylePanel.setLayout(new BoxLayout(stylePanel, 0));
        JLabel shapelabel = new JLabel(RB.getStringResource("pattern.txt"));
        stylePanel.add(shapelabel);
        stylePanel.add(Box.createRigidArea(new Dimension(3 * UIUtil.DLU, 0)));
        ps = shapelabel.getPreferredSize();
        this.labelSize.setSize(Math.max(this.labelSize.width, ps.width), Math.max(this.labelSize.height, ps.height));
        this.labels.add(shapelabel);
        if (this.lineStyle instanceof DefaultLineInterface && this.defaultPatternSource != null) {
            String[] pList = UIUtil.getLines();
            patternList = new String[pList.length + 1];
            patternList[0] = this.defaultPatternSource;
            System.arraycopy(pList, 0, patternList, 1, pList.length);
        } else {
            patternList = UIUtil.getLines();
        }
        this.lstyle = new JComboBox<String>(patternList);
        this.lstyle.setEditable(true);
        if (dli != null && this.defaultPatternSource != null) {
            SGLine dl = defaultPattern >= 0 ? new SGLine(defaultPattern, 2, this.lstyle.getForeground()) : null;
            this.lstyle.setRenderer(new LineRenderer(this.defaultPatternSource, dl));
            this.lstyle.setEditor(new LineComboBoxEditor(this.defaultPatternSource, dl));
        } else {
            this.lstyle.setRenderer(new LineRenderer());
            this.lstyle.setEditor(new LineComboBoxEditor());
        }
        int curIndex = this.lineStyle.getLinePattern();
        if (curIndex < 0) {
            this.lstyle.setSelectedItem(this.defaultPatternSource);
        } else {
            String curPattern = LineInterface.stipNames[this.lineStyle.getLinePattern()];
            boolean inlist = false;
            for (int i = 0; i < patternList.length; ++i) {
                if (!curPattern.equals(patternList[i])) continue;
                inlist = true;
                break;
            }
            if (inlist) {
                this.lstyle.setSelectedItem(curPattern);
            } else {
                this.lstyle.insertItemAt(curPattern, 1);
                this.lstyle.setSelectedIndex(1);
            }
        }
        this.lstyle.addActionListener(this);
        this.lstyle.setActionCommand("lstyle");
        stylePanel.add(this.lstyle);
        stylePanel.add(Box.createHorizontalGlue());
        this.add(stylePanel);
        this.add(Box.createRigidArea(new Dimension(0, 4 * UIUtil.DLU)));
        ps = this.lstyle.getPreferredSize();
        this.widgetSize.setSize(Math.max(this.widgetSize.width, ps.width), Math.max(this.widgetSize.height, ps.height));
        this.widgets.add(this.lstyle);
        JPanel sizePanel = new JPanel();
        sizePanel.setLayout(new BoxLayout(sizePanel, 0));
        JLabel sizelabel = new JLabel(RB.getStringResource("thickness.txt"));
        sizePanel.add(sizelabel);
        sizePanel.add(Box.createRigidArea(new Dimension(3 * UIUtil.DLU, 0)));
        ps = sizelabel.getPreferredSize();
        this.labelSize.setSize(Math.max(this.labelSize.width, ps.width), Math.max(this.labelSize.height, ps.height));
        this.labels.add(sizelabel);
        if (this.lineStyle instanceof DefaultLineInterface && this.defaultWidthSource != null) {
            String[] sList = UIUtil.getLineThickness();
            sizeList = new String[sList.length + 1];
            sizeList[0] = this.defaultWidthSource;
            System.arraycopy(sList, 0, sizeList, 1, sList.length);
        } else {
            sizeList = UIUtil.getLineThickness();
        }
        this.thickness = new JComboBox<String>(sizeList);
        this.thickness.setEditable(true);
        if (dli != null && this.defaultWidthSource != null) {
            SGLine dl = defaultWidth > 0 ? new SGLine(1, defaultWidth, this.lstyle.getForeground()) : null;
            this.thickness.setRenderer(new LineRenderer(this.defaultWidthSource, dl));
            this.thickness.setEditor(new LineComboBoxEditor(this.defaultWidthSource, dl));
        } else {
            this.thickness.setRenderer(new LineRenderer());
            this.thickness.setEditor(new LineComboBoxEditor());
        }
        String curWidth = Integer.toString(this.lineStyle.getLineWidth());
        boolean inlist = false;
        for (int i = 0; i < sizeList.length; ++i) {
            if (!curWidth.equals(sizeList[i])) continue;
            inlist = true;
            break;
        }
        if (inlist) {
            this.thickness.setSelectedItem(curWidth);
        } else if (Integer.parseInt(curWidth) >= 0) {
            this.thickness.insertItemAt(curWidth, 0);
            this.thickness.setSelectedIndex(0);
        } else {
            this.thickness.setSelectedItem(this.defaultWidthSource);
        }
        this.thickness.addActionListener(this);
        this.thickness.setActionCommand("lthickness");
        sizePanel.add(this.thickness);
        sizePanel.add(Box.createHorizontalGlue());
        this.add(sizePanel);
        ps = this.thickness.getPreferredSize();
        this.widgetSize.setSize(Math.max(this.widgetSize.width, ps.width), Math.max(this.widgetSize.height, ps.height));
        this.widgets.add(this.thickness);
        LineEditableInterface lineEditableInterface = lei = this.lineStyle instanceof LineEditableInterface ? (LineEditableInterface)((Object)this.lineStyle) : null;
        if (lei != null) {
            this.color.setEnabled(lei.isLineColorEditable());
            this.thickness.setEnabled(lei.isLineWidthEditable());
            this.lstyle.setEnabled(lei.isLinePatternEditable());
        }
        this.setLabelPreferredSize(null);
        this.setWidgetPreferredSize(null);
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public void actionPerformed(ActionEvent e) {
        int i;
        boolean inlist;
        block40: {
            String curPattern;
            block41: {
                Container parent;
                JPanel panel;
                JColorChooser cc;
                Color save;
                block38: {
                    block39: {
                        String cmd;
                        Object src;
                        block37: {
                            src = e.getSource();
                            cmd = e.getActionCommand();
                            if (!cmd.equals("lcolor")) break block37;
                            Object item = this.color.getSelectedItem();
                            if (item == null) return;
                            save = this.lineStyle.getLineColor();
                            if (!(item instanceof String)) {
                                if (!(item instanceof Color)) return;
                                this.lineStyle.setLineColor((Color)item);
                                return;
                            }
                            if (((String)item).equals(RB.getStringResource("morecolorsdots.txt"))) {
                                cc = UIUtil.colorChooser;
                                if (save == null) {
                                    if (this.lineStyle instanceof DefaultLineInterface) {
                                        cc.setColor(((DefaultLineInterface)((Object)this.lineStyle)).getDefaultLineColor());
                                    }
                                } else {
                                    cc.setColor(save);
                                }
                                cc.setPreviewPanel(new JPanel());
                                panel = new JPanel();
                                panel.setLayout(new BorderLayout());
                                panel.add(cc);
                                break block38;
                            } else {
                                if (((String)item).equals(this.defaultColorSource)) {
                                    this.lineStyle.setLineColor(null);
                                    return;
                                }
                                Container c = this.getTopLevelAncestor();
                                if (c instanceof SGDialog) {
                                    SGDialog sgd = (SGDialog)c;
                                    sgd.value = -1;
                                    this.dialog = sgd.makeDisabledCopy(this.colorGrabber);
                                    c.setVisible(false);
                                    this.dialog.setVisible(true);
                                }
                                c = this.colorGrabber.grabComponent.getTopLevelAncestor();
                                c.requestFocus();
                                if (this.dialog != null) {
                                    this.dialog.toFront();
                                }
                                this.colorGrabber.setMouseEventListener();
                                this.colorGrabber.addActionListener(this);
                                if (save == null) {
                                    this.colorGrabber.setStartColor(this.defaultColorSource);
                                    return;
                                }
                                this.colorGrabber.setStartColor(save);
                                return;
                            }
                        }
                        if (cmd.equals("colorpicker:done")) {
                            Object c = ((SwatchActionEvent)e).getValue();
                            this.color.setSelectedItem(c);
                            this.colorGrabber.removeMouseEventListener();
                            this.colorGrabber.removeActionListener(this);
                            if (this.dialog == null) return;
                            this.dialog.dispose();
                            return;
                        }
                        if (cmd.equals("colorpicker:updating")) {
                            int i2;
                            Color cc2 = (Color)((SwatchActionEvent)e).getValue();
                            if (cc2 == null) return;
                            ActionListener[] listener = this.color.getActionListeners();
                            for (i2 = 0; i2 < listener.length; ++i2) {
                                this.color.removeActionListener(listener[i2]);
                            }
                            this.color.setSelectedItem(cc2);
                            i2 = 0;
                            while (i2 < listener.length) {
                                this.color.addActionListener(listener[i2]);
                                ++i2;
                            }
                            return;
                        }
                        if (cmd.startsWith("lstyle")) {
                            Object obj = ((JComboBox)src).getSelectedItem();
                            if (!(obj instanceof String)) {
                                return;
                            }
                            String pattern = (String)obj;
                            if (pattern.equals(this.defaultPatternSource)) {
                                this.lineStyle.setLinePattern(-1);
                                return;
                            }
                            this.lineStyle.setLinePattern(Util.getLineEnum(pattern));
                            return;
                        }
                        if (cmd.startsWith("lthickness")) {
                            int cur;
                            Object item = this.thickness.getSelectedItem();
                            if (item == null) return;
                            if (!(item instanceof String)) {
                                return;
                            }
                            if (((String)item).equals(this.defaultWidthSource)) {
                                this.lineStyle.setLineWidth(-1);
                                return;
                            }
                            int value = Integer.parseInt((String)item);
                            if (value == (cur = this.lineStyle.getLineWidth())) return;
                            this.lineStyle.setLineWidth(value);
                            return;
                        }
                        if (cmd.equals("lineon")) {
                            boolean on = ((JCheckBox)e.getSource()).isSelected();
                            this.lstyle.setEnabled(on);
                            this.color.setEnabled(on);
                            this.thickness.setEnabled(on);
                            if (this.style == null) return;
                            this.style.setEnabled(on);
                            return;
                        }
                        if (!cmd.equals("style")) return;
                        ((LineStyleElementInterface)((Object)this.lineStyle)).setLineStyleElement((String)this.style.getSelectedItem());
                        this.color.removeActionListener(this);
                        Color c = this.lineStyle.getLineColor();
                        if (c == null) {
                            this.color.setSelectedItem(this.defaultColorSource);
                        } else {
                            this.color.setSelectedItem(c);
                        }
                        this.color.addActionListener(this);
                        this.lstyle.removeActionListener(this);
                        int curIndex = this.lineStyle.getLinePattern();
                        if (curIndex >= 0) break block39;
                        this.lstyle.setSelectedItem(this.defaultPatternSource);
                        break block40;
                    }
                    curPattern = LineInterface.stipNames[this.lineStyle.getLinePattern()];
                    inlist = false;
                    break block41;
                }
                for (parent = this.getParent(); parent != null && !(parent instanceof JFrame); parent = parent.getParent()) {
                }
                int result = SGDialog.showInputDialog((JFrame)parent, RB.getStringResource("morecolors.txt"), panel);
                if (result == 0) {
                    Color newColor = cc.getColor();
                    if (newColor == null) {
                        if (save == null) {
                            this.color.setSelectedItem(this.defaultColorSource);
                            return;
                        }
                        this.color.setSelectedItem(save);
                        return;
                    }
                    if (save != null) {
                        if (save.getRGB() == newColor.getRGB()) return;
                    }
                    this.lineStyle.setLineColor(newColor);
                    this.color.setSelectedItem(newColor);
                    return;
                }
                if (save == null) {
                    this.color.setSelectedItem(this.defaultColorSource);
                    return;
                }
                this.color.setSelectedItem(save);
                return;
            }
            for (i = 1; i < this.lstyle.getItemCount(); ++i) {
                if (!curPattern.equals(this.lstyle.getItemAt(i))) continue;
                inlist = true;
                break;
            }
            if (inlist) {
                this.lstyle.setSelectedItem(curPattern);
            } else {
                this.lstyle.insertItemAt(curPattern, 1);
                this.lstyle.setSelectedIndex(1);
            }
        }
        this.lstyle.addActionListener(this);
        this.thickness.removeActionListener(this);
        String curWidth = Integer.toString(this.lineStyle.getLineWidth());
        inlist = false;
        for (i = 0; i < this.thickness.getItemCount(); ++i) {
            if (!curWidth.equals(this.thickness.getItemAt(i))) continue;
            inlist = true;
            break;
        }
        if (inlist) {
            this.thickness.setSelectedItem(curWidth);
        } else if (Integer.parseInt(curWidth) >= 0) {
            this.thickness.insertItemAt(curWidth, 0);
            this.thickness.setSelectedIndex(0);
        } else {
            this.thickness.setSelectedItem(this.defaultWidthSource);
        }
        this.thickness.addActionListener(this);
    }

    @Override
    public void setValue(Object newValue) {
        LineEditableInterface lei;
        int i;
        boolean inlist;
        int curIndex;
        Color c;
        if (!(newValue instanceof LineInterface)) {
            return;
        }
        this.lineStyle = (LineInterface)newValue;
        this.color.removeActionListener(this);
        this.lstyle.removeActionListener(this);
        this.thickness.removeActionListener(this);
        Color defaultColor = null;
        int defaultWidth = -1;
        int defaultPattern = -1;
        DefaultLineInterface dli = null;
        if (this.lineStyle instanceof DefaultLineInterface) {
            dli = (DefaultLineInterface)((Object)this.lineStyle);
            defaultColor = dli.getDefaultLineColor();
            defaultWidth = dli.getDefaultLineWidth();
            defaultPattern = dli.getDefaultLinePattern();
            this.defaultColorSource = dli.getDefaultLineColorSource();
            this.defaultPatternSource = dli.getDefaultLinePatternSource();
            this.defaultWidthSource = dli.getDefaultLineWidthSource();
            this.color.setAutomatic(this.defaultColorSource, defaultColor);
            this.color.setEditor(new ColorComboBoxEditor(this.defaultColorSource, defaultColor));
            this.color.updateUI();
        }
        if (this.style != null) {
            this.style.removeActionListener(this);
            this.style.setModel(new DefaultComboBoxModel<String>(((LineStyleElementInterface)((Object)this.lineStyle)).getAllLineStyleElements()));
            this.style.setSelectedItem(((LineStyleElementInterface)((Object)this.lineStyle)).getLineStyleElement());
            this.style.setEnabled(this.style.getItemCount() > 1);
            this.style.addActionListener(this);
        }
        if ((c = this.lineStyle.getLineColor()) == null) {
            this.color.setSelectedItem(this.defaultColorSource);
        } else {
            this.color.setSelectedItem(c);
        }
        this.color.addActionListener(this);
        if (this.lineStyle instanceof ColorEditableInterface) {
            this.color.setEnabled(((ColorEditableInterface)((Object)this.lineStyle)).isLineColorEditable());
        } else {
            this.color.setEnabled(true);
        }
        if (dli != null && this.defaultPatternSource != null) {
            while (!this.lstyle.getItemAt(0).equals(UIUtil.getLines()[0])) {
                this.lstyle.removeItemAt(0);
            }
            this.lstyle.insertItemAt(this.defaultPatternSource, 0);
            SGLine dl = defaultPattern >= 0 ? new SGLine(defaultPattern, 2, this.lstyle.getForeground()) : null;
            this.lstyle.setRenderer(new LineRenderer(this.defaultPatternSource, dl));
            this.lstyle.setEditor(new LineComboBoxEditor(this.defaultPatternSource, dl));
        }
        if ((curIndex = this.lineStyle.getLinePattern()) < 0) {
            this.lstyle.setSelectedItem(this.defaultPatternSource);
        } else {
            String curPattern = LineInterface.stipNames[this.lineStyle.getLinePattern()];
            inlist = false;
            for (i = 1; i < this.lstyle.getItemCount(); ++i) {
                if (!curPattern.equals(this.lstyle.getItemAt(i))) continue;
                inlist = true;
                break;
            }
            if (inlist) {
                this.lstyle.setSelectedItem(curPattern);
            } else {
                this.lstyle.insertItemAt(curPattern, 1);
                this.lstyle.setSelectedIndex(1);
            }
        }
        this.lstyle.addActionListener(this);
        if (dli != null && this.defaultWidthSource != null) {
            while (!this.thickness.getItemAt(0).equals(UIUtil.getLineThickness()[0])) {
                this.thickness.removeItemAt(0);
            }
            this.thickness.insertItemAt(this.defaultWidthSource, 0);
            SGLine dl = defaultWidth > 0 ? new SGLine(1, defaultWidth, this.thickness.getForeground()) : null;
            this.thickness.setRenderer(new LineRenderer(this.defaultWidthSource, dl));
            this.thickness.setEditor(new LineComboBoxEditor(this.defaultWidthSource, dl));
        }
        String curWidth = Integer.toString(this.lineStyle.getLineWidth());
        inlist = false;
        for (i = 0; i < this.thickness.getItemCount(); ++i) {
            if (!curWidth.equals(this.thickness.getItemAt(i))) continue;
            inlist = true;
            break;
        }
        if (inlist) {
            this.thickness.setSelectedItem(curWidth);
        } else if (Integer.parseInt(curWidth) >= 0) {
            this.thickness.insertItemAt(curWidth, 0);
            this.thickness.setSelectedIndex(0);
        } else {
            this.thickness.setSelectedItem(this.defaultWidthSource);
        }
        this.thickness.addActionListener(this);
        LineEditableInterface lineEditableInterface = lei = this.lineStyle instanceof LineEditableInterface ? (LineEditableInterface)((Object)this.lineStyle) : null;
        if (lei != null) {
            this.color.setEnabled(lei.isLineColorEditable());
            this.thickness.setEnabled(lei.isLineWidthEditable());
            this.lstyle.setEnabled(lei.isLinePatternEditable());
        }
    }

    public void setEnabledAll(boolean state) {
        if (this.lineStyle instanceof ColorEditableInterface) {
            this.color.setEnabled(state && ((ColorEditableInterface)((Object)this.lineStyle)).isLineColorEditable());
        } else {
            this.color.setEnabled(state);
        }
        this.lstyle.setEnabled(state);
        this.thickness.setEnabled(state);
        if (this.style != null) {
            this.style.setEnabled(state);
        }
    }

    private class SimpleEditor
    extends SwatchLabel
    implements ComboBoxEditor {
        public SimpleEditor() {
            super((Object)"");
            this.setBorder(BorderFactory.createEmptyBorder(0, UIUtil.DLU * 12, 0, 0));
        }

        @Override
        public void selectAll() {
        }

        @Override
        public Component getEditorComponent() {
            return this;
        }

        @Override
        public void addActionListener(ActionListener l) {
        }

        @Override
        public void removeActionListener(ActionListener l) {
        }

        @Override
        public Object getItem() {
            return this;
        }

        @Override
        public void setItem(Object anObject) {
            if (anObject == null || anObject instanceof ComboBoxEditor) {
                return;
            }
            this.setValue(anObject);
        }
    }
}

