/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.sg.ui;

import com.sas.graphics.sg.interfaces.LineChartInterface;
import com.sas.graphics.sg.ui.ColorGrabber;
import com.sas.graphics.sg.ui.FillCustomizerPanel;
import com.sas.graphics.sg.ui.LineCustomizerPanel;
import com.sas.graphics.sg.ui.MarkerCustomizerPanel;
import com.sas.graphics.sg.ui.MyCheckBox;
import com.sas.graphics.sg.ui.RB;
import com.sas.graphics.sg.ui.SGCustomizerPanel;
import com.sas.graphics.sg.ui.UIUtil;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JCheckBox;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class LineChartCustomizerPanel
extends SGCustomizerPanel
implements ActionListener {
    private static final int dlu2 = UIUtil.DLU * 2;
    LineChartInterface lineChart;
    ColorGrabber colorGrabber = null;
    LineCustomizerPanel linePanel;
    MarkerCustomizerPanel markerPanel;
    FillCustomizerPanel fillPanel;
    JTabbedPane tabbedPane;
    private JCheckBox line;
    private JCheckBox markers;
    private JCheckBox fill;

    public LineChartCustomizerPanel(LineChartInterface linec) {
        this(linec, null);
    }

    public LineChartCustomizerPanel(LineChartInterface linec, ColorGrabber cg) {
        this.lineChart = linec;
        this.colorGrabber = cg;
        this.init();
    }

    private void init() {
        this.setLayout(new BoxLayout(this, 1));
        this.tabbedPane = new JTabbedPane(1, 0);
        JPanel lpanel = this.createLinePanel();
        lpanel.setBorder(UIUtil.emptyBorder);
        JPanel mpanel = this.createMarkersPanel();
        mpanel.setBorder(UIUtil.emptyBorder);
        JPanel fpanel = this.createFillPanel();
        fpanel.setBorder(UIUtil.emptyBorder);
        this.tabbedPane.addTab(RB.getStringResource("sline.txt"), lpanel);
        this.tabbedPane.setMnemonicAt(0, 49);
        this.tabbedPane.addTab(RB.getStringResource("smarkers.txt"), mpanel);
        this.tabbedPane.setMnemonicAt(1, 50);
        this.tabbedPane.addTab(RB.getStringResource("sfill.txt"), fpanel);
        this.tabbedPane.setMnemonicAt(2, 51);
        this.tabbedPane.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                if (e.getSource() == LineChartCustomizerPanel.this.tabbedPane) {
                    int index = LineChartCustomizerPanel.this.tabbedPane.getSelectedIndex();
                    if (index == 0) {
                        LineChartCustomizerPanel.this.linePanel.setValue(LineChartCustomizerPanel.this.lineChart);
                    } else if (index == 1) {
                        LineChartCustomizerPanel.this.markerPanel.setValue(LineChartCustomizerPanel.this.lineChart);
                    }
                }
            }
        });
        this.add(this.tabbedPane);
        Dimension ps = this.linePanel.getLabelPreferredSize();
        this.labelSize.width = Math.max(ps.width, this.labelSize.width);
        this.labelSize.height = Math.max(this.labelSize.height, ps.height);
        ps = this.fillPanel.getLabelPreferredSize();
        this.labelSize.width = Math.max(ps.width, this.labelSize.width);
        this.labelSize.height = Math.max(this.labelSize.height, ps.height);
        ps = this.markerPanel.getLabelPreferredSize();
        this.labelSize.width = Math.max(ps.width, this.labelSize.width);
        this.labelSize.height = Math.max(this.labelSize.height, ps.height);
        ps = this.linePanel.getWidgetPreferredSize();
        this.widgetSize.width = Math.max(ps.width, this.widgetSize.width);
        this.widgetSize.height = Math.max(this.widgetSize.height, ps.height);
        ps = this.fillPanel.getWidgetPreferredSize();
        this.widgetSize.width = Math.max(ps.width, this.widgetSize.width);
        this.widgetSize.height = Math.max(this.widgetSize.height, ps.height);
        ps = this.markerPanel.getWidgetPreferredSize();
        this.widgetSize.width = Math.max(ps.width, this.widgetSize.width);
        this.widgetSize.height = Math.max(this.widgetSize.height, ps.height);
        this.setLabelPreferredSize(null);
        this.setWidgetPreferredSize(null);
    }

    private JPanel createLinePanel() {
        boolean isLineOn = this.lineChart.isLineOn();
        boolean isMarkersOn = this.lineChart.isMarkersOn();
        boolean isFillOn = this.lineChart.isFillOn();
        JPanel lpanel = new JPanel();
        lpanel.setLayout(new BoxLayout(lpanel, 1));
        JPanel hpanel = new JPanel();
        hpanel.setLayout(new BoxLayout(hpanel, 0));
        this.line = new MyCheckBox(RB.getStringResource("sline.txt"));
        this.line.setSelected(isLineOn);
        this.line.setActionCommand("line");
        this.line.setEnabled(!isLineOn || isMarkersOn || isFillOn);
        this.line.addActionListener(this);
        this.line.setBorder(null);
        hpanel.add(this.line);
        hpanel.add(Box.createHorizontalGlue());
        lpanel.add(hpanel);
        lpanel.add(Box.createVerticalStrut(UIUtil.MARGIN));
        this.linePanel = new LineCustomizerPanel(this.lineChart, this.colorGrabber);
        this.linePanel.setEnabledAll(isLineOn);
        lpanel.add(this.linePanel);
        return lpanel;
    }

    private JPanel createMarkersPanel() {
        boolean isLineOn = this.lineChart.isLineOn();
        boolean isMarkersOn = this.lineChart.isMarkersOn();
        boolean isFillOn = this.lineChart.isFillOn();
        JPanel mpanel = new JPanel();
        mpanel.setLayout(new BoxLayout(mpanel, 1));
        JPanel hpanel = new JPanel();
        hpanel.setLayout(new BoxLayout(hpanel, 0));
        this.markers = new MyCheckBox(RB.getStringResource("smarkers.txt"));
        this.markers.setSelected(isMarkersOn);
        this.markers.setActionCommand("markers");
        this.markers.setEnabled(isLineOn || !isMarkersOn || isFillOn);
        this.markers.addActionListener(this);
        this.markers.setBorder(null);
        hpanel.add(this.markers);
        hpanel.add(Box.createHorizontalGlue());
        mpanel.add(hpanel);
        mpanel.add(Box.createVerticalStrut(UIUtil.MARGIN));
        this.markerPanel = new MarkerCustomizerPanel(this.lineChart, this.colorGrabber);
        this.markerPanel.setEnabledAll(isMarkersOn);
        mpanel.add(this.markerPanel);
        return mpanel;
    }

    private JPanel createFillPanel() {
        boolean isLineOn = this.lineChart.isLineOn();
        boolean isMarkersOn = this.lineChart.isMarkersOn();
        boolean isFillOn = this.lineChart.isFillOn();
        JPanel fpanel = new JPanel();
        fpanel.setLayout(new BoxLayout(fpanel, 1));
        JPanel hpanel = new JPanel();
        hpanel.setLayout(new BoxLayout(hpanel, 0));
        this.fill = new MyCheckBox(RB.getStringResource("sfill.txt"));
        this.fill.setSelected(isFillOn);
        this.fill.setActionCommand("fill");
        this.fill.setEnabled(!isLineOn || isMarkersOn || isFillOn);
        this.fill.addActionListener(this);
        this.fill.setBorder(null);
        hpanel.add(this.fill);
        hpanel.add(Box.createHorizontalGlue());
        fpanel.add(hpanel);
        fpanel.add(Box.createVerticalStrut(UIUtil.MARGIN));
        this.fillPanel = new FillCustomizerPanel(this.lineChart, this.colorGrabber);
        this.fillPanel.setEnabledAll(isFillOn);
        fpanel.add(this.fillPanel);
        return fpanel;
    }

    @Override
    public void setValue(Object style) {
        if (!(style instanceof LineChartInterface)) {
            return;
        }
        this.lineChart = (LineChartInterface)style;
        boolean isLineOn = this.lineChart.isLineOn();
        boolean isMarkersOn = this.lineChart.isMarkersOn();
        boolean isFillOn = this.lineChart.isFillOn();
        this.linePanel.setValue(this.lineChart);
        this.linePanel.setEnabledAll(isLineOn);
        this.line.removeActionListener(this);
        this.line.setSelected(isLineOn);
        this.line.setEnabled(!isLineOn || isFillOn || isMarkersOn);
        this.line.addActionListener(this);
        this.fillPanel.setValue(this.lineChart);
        this.fillPanel.setEnabledAll(isFillOn);
        this.fill.removeActionListener(this);
        this.fill.setSelected(isFillOn);
        this.fill.setEnabled(isLineOn || !isFillOn || isMarkersOn);
        this.fill.addActionListener(this);
        this.markerPanel.setValue(this.lineChart);
        this.markerPanel.setEnabledAll(isMarkersOn);
        this.markers.removeActionListener(this);
        this.markers.setSelected(isMarkersOn);
        this.markers.setEnabled(isLineOn || isFillOn || !isMarkersOn);
        this.markers.addActionListener(this);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        String cmd = e.getActionCommand();
        boolean isLineOn = this.line.isSelected();
        boolean isMarkersOn = this.markers.isSelected();
        boolean isFillOn = this.fill.isSelected();
        boolean update = false;
        if (cmd.equals("line")) {
            this.lineChart.setLineOn(isLineOn);
            this.linePanel.setEnabledAll(isLineOn);
            update = true;
        } else if (cmd.equals("markers")) {
            this.lineChart.setMarkersOn(isMarkersOn);
            this.markerPanel.setEnabledAll(isMarkersOn);
            update = true;
        } else if (cmd.equals("fill")) {
            this.lineChart.setFillOn(isFillOn);
            this.fillPanel.setEnabledAll(isFillOn);
            update = true;
        }
        if (update) {
            this.line.setEnabled(!isLineOn || isMarkersOn || isFillOn);
            this.fill.setEnabled(isLineOn || isMarkersOn || !isFillOn);
            this.markers.setEnabled(isLineOn || !isMarkersOn || isFillOn);
        }
    }
}

