/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.sg.ui;

import com.sas.graphics.sg.elements.SGLine;
import com.sas.graphics.sg.interfaces.GroupAttrsInterface;
import com.sas.graphics.sg.interfaces.LineInterface;
import com.sas.graphics.sg.ui.ColorComboBoxEditor;
import com.sas.graphics.sg.ui.ColorGrabber;
import com.sas.graphics.sg.ui.CompTitledBorder;
import com.sas.graphics.sg.ui.LineComboBoxEditor;
import com.sas.graphics.sg.ui.LineRenderer;
import com.sas.graphics.sg.ui.MarkerCellRenderer;
import com.sas.graphics.sg.ui.MarkerLabel;
import com.sas.graphics.sg.ui.RB;
import com.sas.graphics.sg.ui.SGCustomizerPanel;
import com.sas.graphics.sg.ui.SGDialog;
import com.sas.graphics.sg.ui.SwatchActionEvent;
import com.sas.graphics.sg.ui.SwatchComboBox;
import com.sas.graphics.sg.ui.SwatchRenderer;
import com.sas.graphics.sg.ui.UIUtil;
import com.sas.graphics.sg.util.Util;
import com.sas.graphics.util.Debug;
import com.sas.graphics.util.Markers;
import com.sas.visuals.SASIcons;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.net.URL;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ComboBoxEditor;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JColorChooser;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JViewport;

public class GroupAttrsCustomizerPanel
extends SGCustomizerPanel
implements ActionListener {
    protected static final int dlu7 = UIUtil.DLU * 7;
    protected static final int dlu4 = UIUtil.DLU * 4;
    public static final String[] RB_attrTypeList = new String[]{RB.getStringResource("Color.txt"), RB.getStringResource("AltColor.txt"), RB.getStringResource("MarkerSymbol.txt"), RB.getStringResource("LinePattern.txt")};
    public static final String[] attrTypeList = new String[]{"Color", "AltColor", "MarkerSymbol", "LinePattern"};
    public static final String[] RB_attrPriorityList = new String[]{RB.getStringResource("automatic.txt"), RB.getStringResource("None.txt"), RB.getStringResource("Color.txt")};
    public static final String[] attrPriorityList = new String[]{"Auto", "None", "Color"};
    private static final String HEX_PREFIX1 = "cx";
    private static final String HEX_PREFIX2 = "#";
    private static final String AUTO = RB.getStringResource("automatic.txt");
    protected GroupAttrsInterface groupAttrs;
    protected JComboBox priority;
    protected JComboBox attrType;
    protected Vector<String> attrValues;
    protected Vector<String> defaultAttrValues;
    protected Vector<String> styleAttrValues;
    protected Vector<JComboBox> attrList;
    protected Vector<JCheckBox> attrListSelected;
    protected JButton deleteAll;
    protected JButton copyFrom;
    protected JPanel attrPanel;
    protected JPanel attrTypePanel;
    protected JPanel listPanel;
    CompTitledBorder attrPanelBorder;
    protected JButton delete;
    protected JButton add;
    protected JButton up;
    protected JButton down;
    protected ColorGrabber colorGrabber = null;
    protected int curType;
    protected int sid = -1;
    private JDialog dialog = null;
    boolean activeListener = true;

    public GroupAttrsCustomizerPanel(GroupAttrsInterface groupAttrs, ColorGrabber colorGrabber) {
        this.groupAttrs = groupAttrs;
        this.colorGrabber = colorGrabber;
        this.init();
    }

    private void init() {
        this.setLayout(new BoxLayout(this, 1));
        this.setBorder(UIUtil.emptyBorder);
        this.curType = 0;
        if (this.groupAttrs.isAttrPrioritySupported()) {
            JPanel panel = new JPanel();
            panel.setLayout(new BoxLayout(panel, 0));
            panel.setBorder(UIUtil.tabBorder2);
            JLabel label1 = new JLabel(RB.getStringResource("AttrPriorityColon.txt"));
            panel.add(label1);
            panel.add(Box.createRigidArea(new Dimension(UIUtil.LABEL_GAP_HORZ, 0)));
            this.priority = new JComboBox<String>(RB_attrPriorityList);
            panel.add(this.priority);
            int index = this._priorityToIndex(this.groupAttrs.getAttrPriority());
            this.priority.setSelectedIndex(index);
            this.priority.addActionListener(this);
            this.priority.setActionCommand("priority");
            panel.add(Box.createHorizontalGlue());
            this.add(panel);
            Dimension ps = label1.getPreferredSize();
            this.labelSize.width = Math.max(ps.width, this.labelSize.width);
            this.labelSize.height = Math.max(ps.height, this.labelSize.height);
            this.labels.add(label1);
            ps = this.priority.getPreferredSize();
            this.widgetSize.width = Math.max(ps.width, this.widgetSize.width);
            this.widgetSize.height = Math.max(ps.height, this.widgetSize.height);
            this.widgets.add(this.priority);
            this.add(Box.createRigidArea(new Dimension(0, UIUtil.COMP_GAP)));
        }
        this.attrTypePanel = new JPanel();
        this.attrTypePanel.setLayout(new BoxLayout(this.attrTypePanel, 0));
        JLabel label1 = new JLabel(RB.getStringResource("type.txt"));
        this.attrTypePanel.add(label1);
        this.attrTypePanel.add(Box.createRigidArea(new Dimension(UIUtil.LABEL_GAP_HORZ, 0)));
        this.attrType = new JComboBox<String>(RB_attrTypeList);
        this.attrType.setActionCommand("type");
        this.attrType.setSelectedIndex(this.curType);
        this.attrType.addActionListener(this);
        this.attrTypePanel.add(this.attrType);
        this.attrTypePanel.setBorder(UIUtil.compBorder);
        JPanel borderPanel = new JPanel(){

            @Override
            public void doLayout() {
                Insets insets = this.getInsets();
                Rectangle rect = this.getBounds();
                rect.x = 0;
                rect.y = 0;
                if (GroupAttrsCustomizerPanel.this.attrPanelBorder == null) {
                    return;
                }
                Rectangle compR = GroupAttrsCustomizerPanel.this.attrPanelBorder.getComponentRect(rect, insets);
                GroupAttrsCustomizerPanel.this.attrTypePanel.setBounds(compR);
                rect.x += insets.left;
                rect.y += insets.top;
                rect.width -= insets.left + insets.right;
                rect.height -= insets.top + insets.bottom;
                GroupAttrsCustomizerPanel.this.attrPanel.setBounds(rect);
            }

            @Override
            public Dimension getPreferredSize() {
                Dimension ps1 = GroupAttrsCustomizerPanel.this.attrPanel.getPreferredSize();
                Dimension ps2 = GroupAttrsCustomizerPanel.this.attrTypePanel.getPreferredSize();
                return new Dimension(ps1.width, ps1.height + ps2.height + 2 * UIUtil.COMP_GAP);
            }

            @Override
            public Dimension getMaximumSize() {
                Dimension ps1 = GroupAttrsCustomizerPanel.this.attrPanel.getMaximumSize();
                Dimension ps2 = GroupAttrsCustomizerPanel.this.attrType.getMaximumSize();
                return new Dimension(ps1.width, ps1.height + ps2.height + 2 * UIUtil.COMP_GAP);
            }
        };
        borderPanel.setLayout(null);
        borderPanel.add(this.attrTypePanel);
        this.attrPanelBorder = new CompTitledBorder(UIUtil.lineBorder, this.attrTypePanel);
        borderPanel.setBorder(this.attrPanelBorder);
        this.attrPanel = new JPanel();
        this.attrPanel.setBorder(UIUtil.emptyBorder);
        this.attrPanel.setLayout(new BoxLayout(this.attrPanel, 1));
        JPanel xpanel = new JPanel();
        xpanel.setLayout(new BoxLayout(xpanel, 0));
        this.copyFrom = new JButton(RB.getStringResource("FromStyle.txt"));
        this.copyFrom.setActionCommand("copy");
        this.copyFrom.addActionListener(this);
        xpanel.add(this.copyFrom);
        xpanel.add(Box.createRigidArea(new Dimension(UIUtil.COMP_GAP, 0)));
        this.deleteAll = new JButton(RB.getStringResource("DeleteAll.txt"));
        this.deleteAll.setActionCommand("deleteAll");
        this.deleteAll.addActionListener(this);
        xpanel.add(this.deleteAll);
        xpanel.add(Box.createHorizontalGlue());
        Dimension ps1 = this.copyFrom.getPreferredSize();
        Dimension ps2 = this.deleteAll.getPreferredSize();
        Dimension ps = new Dimension(Math.max(ps1.width, ps2.width), Math.max(ps1.height, ps2.height));
        this.deleteAll.setPreferredSize(ps);
        this.deleteAll.setMaximumSize(ps);
        this.copyFrom.setMaximumSize(ps);
        this.copyFrom.setPreferredSize(ps);
        this.attrPanel.add(xpanel);
        this.attrPanel.add(Box.createRigidArea(new Dimension(0, UIUtil.MARGIN)));
        xpanel = new JPanel();
        xpanel.setLayout(new BoxLayout(xpanel, 0));
        this.attrValues = this.groupAttrs.getAttrList(this.curType);
        this.defaultAttrValues = this.groupAttrs.getAttrList(this.curType);
        this.styleAttrValues = this.groupAttrs.getAttrListFromStyle(this.curType);
        this.listPanel = new JPanel();
        this.listPanel.setLayout(new BoxLayout(this.listPanel, 1));
        this.attrList = new Vector();
        this.attrListSelected = new Vector();
        JPanel buttons = new JPanel();
        buttons.setLayout(new BoxLayout(buttons, 1));
        Class<SASIcons> iconClass = SASIcons.class;
        URL url = iconClass.getResource("res/GIF_16/NewStarburst.gif");
        Image image = Toolkit.getDefaultToolkit().getImage(url);
        this.add = new JButton(new ImageIcon(image));
        this.add.setActionCommand("add");
        this.add.setToolTipText(RB.getStringResource("New.txt"));
        buttons.add(this.add);
        buttons.add(Box.createRigidArea(new Dimension(0, UIUtil.COMP_GAP)));
        this.add.addActionListener(this);
        url = iconClass.getResource("res/GIF_16/ArrowSmallUp.gif");
        image = Toolkit.getDefaultToolkit().getImage(url);
        this.up = new JButton(new ImageIcon(image));
        this.up.setToolTipText(RB.getStringResource("MoveUp.txt"));
        this.up.setActionCommand("up");
        this.up.setEnabled(false);
        this.up.addActionListener(this);
        buttons.add(this.up);
        buttons.add(Box.createRigidArea(new Dimension(0, UIUtil.COMP_GAP)));
        url = iconClass.getResource("res/GIF_16/ArrowSmallDown.gif");
        image = Toolkit.getDefaultToolkit().getImage(url);
        this.down = new JButton(new ImageIcon(image));
        this.down.setToolTipText(RB.getStringResource("MoveDown.txt"));
        this.down.setEnabled(false);
        this.down.setActionCommand("down");
        this.down.addActionListener(this);
        buttons.add(this.down);
        buttons.add(Box.createRigidArea(new Dimension(0, UIUtil.COMP_GAP)));
        url = iconClass.getResource("res/GIF_16/Delete.gif");
        image = Toolkit.getDefaultToolkit().getImage(url);
        this.delete = new JButton(new ImageIcon(image));
        this.delete.setToolTipText(RB.getStringResource("Delete.txt"));
        this.delete.setEnabled(false);
        this.delete.setActionCommand("delete");
        this.delete.addActionListener(this);
        buttons.add(this.delete);
        buttons.add(Box.createRigidArea(new Dimension(0, UIUtil.COMP_GAP)));
        buttons.add(Box.createVerticalGlue());
        ps = this.delete.getPreferredSize();
        this.add.setPreferredSize(ps);
        this.add.setMaximumSize(ps);
        this.up.setPreferredSize(ps);
        this.up.setMaximumSize(ps);
        this.down.setPreferredSize(ps);
        this.down.setMaximumSize(ps);
        this.delete.setPreferredSize(ps);
        this.delete.setMaximumSize(ps);
        this.resetListPanel();
        JScrollPane scrollPane = new JScrollPane(this.listPanel);
        JViewport view = scrollPane.getViewport();
        int lw = this.listPanel.getPreferredSize().width;
        lw = Math.max(lw, UIUtil.DEFAULT_WIDGET_WIDTH + UIUtil.DEFAULT_WIDGET_HEIGHT + 3 * UIUtil.MARGIN);
        view.setPreferredSize(new Dimension(lw, 6 * (ps.height + UIUtil.RELATED_COMP_GAP)));
        scrollPane.setPreferredSize(new Dimension(view.getPreferredSize().width + scrollPane.getVerticalScrollBar().getPreferredSize().width + UIUtil.MARGIN, view.getPreferredSize().height + scrollPane.getHorizontalScrollBar().getPreferredSize().height + UIUtil.MARGIN));
        xpanel.add(scrollPane);
        xpanel.add(Box.createRigidArea(new Dimension(UIUtil.LABEL_GAP_HORZ, 0)));
        xpanel.add(buttons);
        xpanel.add(Box.createHorizontalGlue());
        this.attrPanel.add(xpanel);
        this.attrPanel.add(Box.createVerticalGlue());
        borderPanel.add(this.attrPanel);
        this.add(borderPanel);
        this.add(Box.createVerticalGlue());
    }

    private int _priorityToIndex(String priority) {
        for (int i = 0; i < attrPriorityList.length; ++i) {
            if (!attrPriorityList[i].equalsIgnoreCase(priority)) continue;
            return i;
        }
        return 0;
    }

    @Override
    protected void setValue(Object newValue) {
        if (!(newValue instanceof GroupAttrsInterface)) {
            return;
        }
        this.groupAttrs = (GroupAttrsInterface)newValue;
        if (this.priority != null) {
            int index = this._priorityToIndex(this.groupAttrs.getAttrPriority());
            this.priority.removeActionListener(this);
            this.priority.setSelectedIndex(index);
            this.priority.addActionListener(this);
            this.priority.setActionCommand("priority");
        }
        this.attrType.removeActionListener(this);
        this.curType = 0;
        this.attrType.setSelectedIndex(this.curType);
        this.attrType.addActionListener(this);
        this.attrValues = this.groupAttrs.getAttrList(this.curType);
        this.defaultAttrValues = this.groupAttrs.getDefaultAttrList(this.curType);
        this.styleAttrValues = this.groupAttrs.getAttrListFromStyle(this.curType);
        this.resetListPanel();
    }

    private String autoValue(int index) {
        if (this.defaultAttrValues != null && index < this.defaultAttrValues.size()) {
            return this.defaultAttrValues.get(index);
        }
        if (index < this.styleAttrValues.size()) {
            return this.styleAttrValues.get(index);
        }
        return this.styleAttrValues.lastElement();
    }

    private void resetListPanel() {
        this.listPanel.removeAll();
        this.attrList.clear();
        this.attrListSelected.clear();
        if (this.attrValues == null || this.attrValues.size() == 0) {
            return;
        }
        Dimension ps = new Dimension(UIUtil.DEFAULT_WIDGET_WIDTH, UIUtil.DEFAULT_WIDGET_HEIGHT);
        for (int i = 0; i < this.attrValues.size(); ++i) {
            JComboBox jb;
            this.sid = i;
            JCheckBox cb = new JCheckBox();
            cb.setActionCommand("update");
            cb.addActionListener(this);
            this.attrListSelected.add(cb);
            String dv = this.autoValue(i);
            switch (this.curType) {
                default: {
                    jb = this.colorComboBox(this.attrValues.get(i), dv);
                    break;
                }
                case 2: {
                    jb = this.symbolComboBox(this.attrValues.get(i), dv);
                    break;
                }
                case 3: {
                    jb = this.lineComboBox(this.enumToLineName(this.attrValues.get(i)), this.enumToLineName(dv));
                }
            }
            if (i == 0) {
                Dimension ps2 = jb.getPreferredSize();
                ps.height = Math.max(ps.height, ps2.height);
            }
            jb.setPreferredSize(ps);
            jb.setMaximumSize(ps);
            jb.setActionCommand("value");
            jb.addActionListener(this);
            this.attrList.add(jb);
            JPanel xp = new JPanel();
            xp.setLayout(new BoxLayout(xp, 0));
            xp.setBorder(UIUtil.emptyItemBorder);
            xp.add(jb);
            xp.add(Box.createRigidArea(new Dimension(UIUtil.RELATED_COMP_GAP, 0)));
            xp.add(cb);
            xp.add(Box.createHorizontalGlue());
            this.listPanel.add(xp);
        }
        this.listPanel.add(Box.createVerticalGlue());
        this.delete.setEnabled(false);
    }

    private void swap(int i, int j) {
        boolean jsel;
        if (this.attrValues == null || this.attrValues.size() == 0) {
            return;
        }
        boolean isel = this.attrListSelected.get(i).isSelected();
        if (isel != (jsel = this.attrListSelected.get(j).isSelected())) {
            JCheckBox cb1 = this.attrListSelected.get(i);
            JCheckBox cb2 = this.attrListSelected.get(j);
            cb1.setSelected(jsel);
            cb2.setSelected(isel);
        }
        JComboBox icb = this.attrList.get(i);
        JComboBox jcb = this.attrList.get(j);
        String iauto = this.autoValue(i);
        String jauto = this.autoValue(j);
        String ival = this.attrValues.get(i);
        String jval = this.attrValues.get(j);
        switch (this.curType) {
            default: {
                Color iac = this.getColor(iauto);
                Color jac = this.getColor(jauto);
                Color icol = this.getColor(ival);
                Color jcol = this.getColor(jval);
                if (jcol.getRGB() == iac.getRGB()) {
                    icb.setSelectedItem(AUTO);
                } else {
                    icb.setSelectedItem(jcol);
                }
                if (icol.getRGB() == jac.getRGB()) {
                    jcb.setSelectedItem(AUTO);
                    break;
                }
                jcb.setSelectedItem(icol);
                break;
            }
            case 2: {
                int im = Markers.getShape((String)ival);
                int iam = Markers.getShape((String)iauto);
                int jm = Markers.getShape((String)jval);
                int jam = Markers.getShape((String)jauto);
                if (jm == iam) {
                    icb.setSelectedItem(AUTO);
                } else {
                    icb.setSelectedItem(jm);
                }
                if (im == jam) {
                    jcb.setSelectedItem(AUTO);
                    break;
                }
                jcb.setSelectedItem(im);
                break;
            }
            case 3: {
                if (jval.equalsIgnoreCase(iauto)) {
                    icb.setSelectedItem(AUTO);
                } else {
                    icb.setSelectedItem(this.enumToLineName(jval));
                }
                if (ival.equalsIgnoreCase(jauto)) {
                    jcb.setSelectedItem(AUTO);
                    break;
                }
                jcb.setSelectedItem(this.enumToLineName(ival));
            }
        }
    }

    private void shift(int index, int dist) {
        boolean jsel;
        if (this.attrValues == null || this.attrValues.size() <= index) {
            return;
        }
        int j = index;
        int i = j - dist;
        boolean isel = this.attrListSelected.get(i).isSelected();
        if (isel != (jsel = this.attrListSelected.get(j).isSelected())) {
            JCheckBox cb1 = this.attrListSelected.get(i);
            cb1.removeActionListener(this);
            cb1.setSelected(jsel);
            cb1.addActionListener(this);
        }
        JComboBox icb = this.attrList.get(i);
        icb.removeActionListener(this);
        String iauto = this.autoValue(i);
        String jval = this.attrValues.get(j);
        switch (this.curType) {
            default: {
                Color iac = this.getColor(iauto);
                Color jcol = this.getColor(jval);
                if (jcol.getRGB() == iac.getRGB()) {
                    icb.setSelectedItem(AUTO);
                    break;
                }
                icb.setSelectedItem(jcol);
                break;
            }
            case 2: {
                int iam = Markers.getShape((String)iauto);
                int jm = Markers.getShape((String)jval);
                if (jm == iam) {
                    icb.setSelectedItem(AUTO);
                    break;
                }
                icb.setSelectedItem(jm);
                break;
            }
            case 3: {
                if (jval.equalsIgnoreCase(iauto)) {
                    icb.setSelectedItem(AUTO);
                    break;
                }
                icb.setSelectedItem(this.enumToLineName(jval));
            }
        }
        icb.addActionListener(this);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (!this.activeListener) {
            return;
        }
        String cmd = e.getActionCommand();
        Object src = e.getSource();
        if (cmd.equals("priority")) {
            this.groupAttrs.setAttrPriority(attrPriorityList[((JComboBox)src).getSelectedIndex()]);
        } else if (cmd.equals("copy")) {
            this.attrValues.clear();
            this.attrValues.addAll(this.styleAttrValues);
            this.resetListPanel();
            this.listPanel.invalidate();
            this.listPanel.validate();
            this.attrPanel.revalidate();
            this.attrPanel.repaint();
            this.groupAttrs.setAttrList(this.curType, this.attrValues);
        } else if (cmd.equals("deleteAll")) {
            this.attrValues.clear();
            this.listPanel.removeAll();
            this.attrList.clear();
            this.attrListSelected.clear();
            this.listPanel.invalidate();
            this.listPanel.validate();
            this.attrPanel.revalidate();
            this.attrPanel.repaint();
            this.groupAttrs.setAttrList(this.curType, null);
            this.up.setEnabled(false);
            this.down.setEnabled(false);
            this.delete.setEnabled(false);
        } else if (cmd.equals("type")) {
            this.curType = ((JComboBox)src).getSelectedIndex();
            this.attrValues = this.groupAttrs.getAttrList(this.curType);
            this.defaultAttrValues = this.groupAttrs.getDefaultAttrList(this.curType);
            this.styleAttrValues = this.groupAttrs.getAttrListFromStyle(this.curType);
            this.resetListPanel();
            this.listPanel.invalidate();
            this.listPanel.validate();
            this.attrPanel.revalidate();
            this.attrPanel.repaint();
        } else if (cmd.equals("value")) {
            JComboBox jb = (JComboBox)e.getSource();
            this.sid = this.attrList.indexOf(jb);
            Object value = jb.getSelectedItem();
            String str = null;
            if (this.curType == 2) {
                if (value == null || value instanceof ComboBoxEditor) {
                    return;
                }
                if (!value.equals(AUTO)) {
                    str = UIUtil.getGLMarkers()[jb.getSelectedIndex() + 2];
                }
            } else if (this.curType == 3) {
                if (value == null || value instanceof ComboBoxEditor) {
                    return;
                }
                if (!value.equals(AUTO)) {
                    str = Integer.toString(Util.getLineEnum(jb.getSelectedItem().toString()));
                }
            }
            if (str != null) {
                if (str.equals(AUTO)) {
                    str = this.autoValue(this.sid);
                }
                if (!str.equalsIgnoreCase(this.attrValues.get(this.sid))) {
                    this.attrValues.set(this.sid, str);
                    this.groupAttrs.setAttrList(this.curType, this.attrValues);
                }
            } else {
                Color c1;
                Color save = this.getColor(this.attrValues.get(this.sid));
                Color ds = this.getColor(this.autoValue(this.sid));
                if (value instanceof String) {
                    if (((String)value).equals(RB.getStringResource("morecolorsdots.txt"))) {
                        int result;
                        JColorChooser cc = UIUtil.colorChooser;
                        cc.setColor(save);
                        cc.setPreviewPanel(new JPanel());
                        JPanel panel = new JPanel();
                        panel.setLayout(new BorderLayout());
                        panel.add(cc);
                        Container container = this.getTopLevelAncestor();
                        if (!(container instanceof JFrame)) {
                            container = null;
                        }
                        if ((result = SGDialog.showInputDialog((JFrame)container, RB.getStringResource("morecolors.txt"), panel)) == 0) {
                            Color newColor = cc.getColor();
                            if (newColor == null) {
                                if (save.getRGB() == ds.getRGB()) {
                                    jb.setSelectedItem(AUTO);
                                } else {
                                    jb.setSelectedItem(save);
                                }
                            } else if (ds.getRGB() != newColor.getRGB()) {
                                jb.setSelectedItem(newColor);
                            } else {
                                jb.setSelectedItem(AUTO);
                            }
                            this.attrValues.set(this.sid, HEX_PREFIX2 + Integer.toHexString(((Color)value).getRGB()).substring(2).toUpperCase());
                            this.groupAttrs.setAttrList(this.curType, this.attrValues);
                        } else if (save.getRGB() == ds.getRGB()) {
                            jb.setSelectedItem(AUTO);
                        } else {
                            jb.setSelectedItem(save);
                        }
                    } else if (((String)value).equals(AUTO)) {
                        String vv = this.autoValue(this.sid);
                        if (!this.attrValues.get(this.sid).equals(vv)) {
                            this.attrValues.set(this.sid, vv);
                            this.groupAttrs.setAttrList(this.curType, this.attrValues);
                        }
                    } else {
                        Container c = this.getTopLevelAncestor();
                        if (c instanceof SGDialog) {
                            SGDialog sgd = (SGDialog)c;
                            sgd.value = -1;
                            this.dialog = sgd.makeDisabledCopy(this.colorGrabber);
                            c.setVisible(false);
                            this.dialog.setVisible(true);
                        }
                        c = this.colorGrabber.grabComponent.getTopLevelAncestor();
                        c.requestFocus();
                        if (this.dialog != null) {
                            this.dialog.toFront();
                        }
                        this.colorGrabber.grabComponent.repaint();
                        this.colorGrabber.setMouseEventListener();
                        this.colorGrabber.addActionListener(this);
                        this.colorGrabber.setStartColor(save);
                    }
                } else if (value instanceof Color && (c1 = this.getColor(this.attrValues.get(this.sid))).getRGB() != ((Color)value).getRGB()) {
                    this.attrValues.set(this.sid, HEX_PREFIX2 + Integer.toHexString(((Color)value).getRGB()).substring(2).toUpperCase());
                    this.groupAttrs.setAttrList(this.curType, this.attrValues);
                }
            }
        } else if (cmd.equals("colorpicker:done")) {
            Color c1;
            Color color = (Color)((SwatchActionEvent)e).getValue();
            if (color.getRGB() == this.getColor(this.autoValue(this.sid)).getRGB()) {
                this.attrList.get(this.sid).setSelectedItem(AUTO);
            } else {
                this.attrList.get(this.sid).setSelectedItem(color);
            }
            this.colorGrabber.removeMouseEventListener();
            this.colorGrabber.removeActionListener(this);
            if (this.dialog != null) {
                this.dialog.dispose();
            }
            if ((c1 = this.getColor(this.attrValues.get(this.sid))).getRGB() != color.getRGB()) {
                this.attrValues.set(this.sid, HEX_PREFIX2 + Integer.toHexString(color.getRGB()).substring(2).toUpperCase());
                this.groupAttrs.setAttrList(this.curType, this.attrValues);
            }
        } else if (cmd.equals("colorpicker:updating")) {
            Color color = (Color)((SwatchActionEvent)e).getValue();
            if (color != null) {
                int i;
                ActionListener[] listener = this.attrList.get(this.sid).getActionListeners();
                JComboBox jb = this.attrList.get(this.sid);
                for (i = 0; i < listener.length; ++i) {
                    jb.removeActionListener(listener[i]);
                }
                jb.setSelectedItem(color);
                jb.setEnabled(true);
                for (i = 0; i < listener.length; ++i) {
                    jb.addActionListener(listener[i]);
                }
            }
        } else if (cmd.equals("up")) {
            this.activeListener = false;
            int count = this.attrList.size();
            for (int i = 1; i < count; ++i) {
                if (!this.attrListSelected.get(i).isSelected()) continue;
                this.swap(i - 1, i);
                String val = this.attrValues.remove(i);
                this.attrValues.insertElementAt(val, i - 1);
            }
            this.up.setEnabled(!this.attrListSelected.get(0).isSelected());
            this.down.setEnabled(true);
            this.groupAttrs.setAttrList(this.curType, this.attrValues);
            this.activeListener = true;
        } else if (cmd.equals("down")) {
            this.activeListener = false;
            int count = this.attrList.size();
            for (int i = count - 2; i >= 0; --i) {
                if (!this.attrListSelected.get(i).isSelected()) continue;
                this.swap(i, i + 1);
                String val = this.attrValues.remove(i);
                this.attrValues.insertElementAt(val, i + 1);
            }
            this.up.setEnabled(true);
            this.down.setEnabled(!this.attrListSelected.get(count - 1).isSelected());
            this.groupAttrs.setAttrList(this.curType, this.attrValues);
            this.activeListener = true;
        } else if (cmd.startsWith("delete")) {
            this.activeListener = false;
            int count = this.attrList.size();
            int dist = 0;
            for (int i = 0; i < count; ++i) {
                if (dist > 0) {
                    this.shift(i, dist);
                    String val = this.attrValues.remove(i);
                    this.attrValues.insertElementAt(val, i - dist);
                }
                if (!this.attrListSelected.get(i).isSelected()) continue;
                ++dist;
            }
            while (dist > 0) {
                --dist;
                this.attrValues.remove(--count);
                this.listPanel.remove(this.listPanel.getComponent(count));
                this.attrList.remove(count);
                this.attrListSelected.remove(count);
            }
            this.up.setEnabled(false);
            this.down.setEnabled(false);
            this.delete.setEnabled(false);
            this.listPanel.invalidate();
            this.listPanel.validate();
            this.attrPanel.repaint();
            this.groupAttrs.setAttrList(this.curType, this.attrValues);
            this.activeListener = true;
        } else if (cmd.startsWith("add")) {
            JComboBox jb;
            if (this.attrValues == null) {
                this.attrValues = new Vector();
            }
            this.sid = this.attrValues.size();
            String str = this.autoValue(this.sid);
            switch (this.curType) {
                default: {
                    jb = this.colorComboBox(str, str);
                    break;
                }
                case 2: {
                    jb = this.symbolComboBox(str, str);
                    break;
                }
                case 3: {
                    String name = this.enumToLineName(str);
                    jb = this.lineComboBox(name, name);
                }
            }
            int count = this.attrValues.size();
            if (count == 0) {
                Dimension ps1 = jb.getPreferredSize();
                Dimension ps = new Dimension(Math.max(ps1.width, UIUtil.DEFAULT_WIDGET_WIDTH), Math.max(ps1.height, UIUtil.DEFAULT_WIDGET_HEIGHT));
                jb.setPreferredSize(ps);
                jb.setMaximumSize(ps);
            } else {
                JComboBox prev = this.attrList.lastElement();
                jb.setPreferredSize(prev.getPreferredSize());
                jb.setMaximumSize(prev.getMaximumSize());
            }
            this.attrValues.add(str);
            this.attrList.add(jb);
            JCheckBox cb = new JCheckBox();
            cb.setActionCommand("update");
            cb.addActionListener(this);
            cb.setEnabled(true);
            this.attrListSelected.add(cb);
            JPanel xp = new JPanel();
            xp.setLayout(new BoxLayout(xp, 0));
            xp.setBorder(UIUtil.emptyItemBorder);
            xp.add(jb);
            xp.add(Box.createRigidArea(new Dimension(UIUtil.RELATED_COMP_GAP, 0)));
            xp.add(cb);
            xp.add(Box.createHorizontalGlue());
            this.resetButtons();
            this.listPanel.add((Component)xp, count);
            this.listPanel.invalidate();
            this.listPanel.validate();
            this.attrPanel.revalidate();
            this.attrPanel.repaint();
            this.groupAttrs.setAttrList(this.curType, this.attrValues);
        } else if (cmd.startsWith("update")) {
            this.resetButtons();
        }
    }

    private void resetButtons() {
        int count = this.attrListSelected.size();
        boolean enable = false;
        for (int i = 0; i < count; ++i) {
            if (!this.attrListSelected.get(i).isSelected()) continue;
            enable = true;
            break;
        }
        this.up.setEnabled(enable && !this.attrListSelected.get(0).isSelected());
        this.down.setEnabled(enable && !this.attrListSelected.lastElement().isSelected());
        this.delete.setEnabled(enable);
    }

    private Color getColor(String name) {
        Color color = null;
        if (name != null && name.length() > 0) {
            try {
                color = new Color(this.decode(name));
            }
            catch (NumberFormatException e) {
                Debug.println((String)e.toString());
            }
        }
        return color;
    }

    private int decode(String nm) throws NumberFormatException {
        int result = nm.toLowerCase().startsWith(HEX_PREFIX1, 0) ? Integer.parseInt(nm.substring(2), 16) : (nm.startsWith(HEX_PREFIX2, 0) ? Integer.parseInt(nm.substring(1), 16) : Integer.parseInt(nm));
        return result;
    }

    private JComboBox colorComboBox(String col, String autoValue) {
        Color ac = this.getColor(autoValue);
        Color c = this.getColor(col);
        SwatchComboBox color = new SwatchComboBox(UIUtil.getColors(), 8, 4, this.colorGrabber, AUTO, ac, RB.getStringResource("morecolorsdots.txt"));
        color.setEditable(true);
        ColorComboBoxEditor editor = new ColorComboBoxEditor(AUTO, ac);
        color.setEditor(editor);
        editor.addMouseListener(color);
        if (ac.getRGB() == c.getRGB()) {
            color.setSelectedItem(AUTO);
        } else {
            color.setSelectedItem(c);
        }
        color.setRenderer(new SwatchRenderer());
        color.setActionCommand("value");
        color.addActionListener(this);
        return color;
    }

    private JComboBox lineComboBox(String line, String autoLine) {
        String[] pList = UIUtil.getLines();
        String[] patternList = new String[pList.length + 1];
        patternList[0] = AUTO;
        System.arraycopy(pList, 0, patternList, 1, pList.length);
        JComboBox<String> lstyle = new JComboBox<String>(patternList);
        lstyle.setEditable(true);
        int dp = Util.getLineEnum(autoLine);
        SGLine dl = new SGLine(dp, 2, lstyle.getForeground());
        lstyle.setRenderer(new LineRenderer(AUTO, dl));
        lstyle.setEditor(new LineComboBoxEditor(AUTO, dl));
        int lid = Util.getLineEnum(line);
        if (dp == lid) {
            lstyle.setSelectedItem(AUTO);
        } else {
            boolean inlist = false;
            for (int i = 0; i < patternList.length; ++i) {
                if (!line.equals(patternList[i])) continue;
                inlist = true;
                break;
            }
            if (inlist) {
                lstyle.setSelectedItem(line);
            } else {
                patternList = UIUtil.addLineToList(line);
                lstyle.addItem(line);
                lstyle.setSelectedItem(line);
            }
        }
        lstyle.addActionListener(this);
        lstyle.setActionCommand("value");
        return lstyle;
    }

    private JComboBox symbolComboBox(String marker, String autoValue) {
        String[] markerlist = UIUtil.getGLMarkers();
        int markerlistSize = markerlist.length - 2;
        Object[] glMarkers = new Integer[markerlistSize];
        int curIndex = marker == null ? 0 : Markers.getShape((String)marker);
        for (int i = 0; i < markerlistSize; ++i) {
            String glName = Util.toGL(markerlist[i + 2]);
            int ii = Markers.getShape((String)glName);
            glMarkers[i] = new Integer(ii);
        }
        int autoIndex = marker == null ? 0 : Markers.getShape((String)autoValue);
        SwatchComboBox shape = new SwatchComboBox(glMarkers, 6, 4, AUTO, new Integer(autoIndex), null);
        MarkerCellRenderer mcr = new MarkerCellRenderer();
        mcr.setBorder(UIUtil.emptyItemBorder);
        shape.setRenderer(mcr);
        shape.setMaximumRowCount(12);
        shape.setEditable(true);
        MarkerComboBoxEditor meditor = new MarkerComboBoxEditor(autoIndex);
        shape.setEditor(meditor);
        meditor.addMouseListener(shape);
        if (curIndex == autoIndex) {
            shape.setSelectedItem(AUTO);
        } else {
            shape.setSelectedItem(curIndex);
        }
        shape.setActionCommand("value");
        shape.addActionListener(this);
        return shape;
    }

    GroupAttrsCustomizerPanel getThis() {
        return this;
    }

    private String enumToLineName(String avalue) {
        int id = 1;
        try {
            id = Integer.parseInt(avalue);
        }
        catch (NumberFormatException nfe) {
            id = 1;
        }
        return LineInterface.stipNames[id];
    }

    public class MarkerComboBoxEditor
    extends MarkerLabel
    implements ComboBoxEditor {
        int autoIndex = 0;

        public MarkerComboBoxEditor(int index) {
            this.autoIndex = index;
            this.setHorizontalAlignment(2);
            this.setHorizontalTextPosition(2);
            this.setIconTextGap(12);
            this.setBorder(BorderFactory.createEmptyBorder(0, UIUtil.DLU * 4, 0, 0));
            this.displayText(true);
        }

        @Override
        public void selectAll() {
        }

        @Override
        public Component getEditorComponent() {
            return this;
        }

        @Override
        public void addActionListener(ActionListener l) {
        }

        @Override
        public void removeActionListener(ActionListener l) {
        }

        @Override
        public Object getItem() {
            return this;
        }

        @Override
        public void setItem(Object anObject) {
            int ii;
            if (anObject == null || anObject instanceof ComboBoxEditor) {
                return;
            }
            if (anObject instanceof String) {
                String value = (String)anObject;
                this.setText(value);
                if (value.equals(AUTO)) {
                    GroupAttrsCustomizerPanel gp = GroupAttrsCustomizerPanel.this.getThis();
                    if (this.autoIndex >= 0) {
                        if (Markers.isUserDefinedMarker((int)this.autoIndex)) {
                            this.setMarker(Markers.getUserDefinedMarkerName((int)this.autoIndex), true);
                        } else {
                            this.setMarker(Util.GLMarkerNames[this.autoIndex], true);
                        }
                    } else {
                        this.marker = null;
                    }
                    this.setText(value);
                    this.setIconTextGap(12);
                } else {
                    this.marker = null;
                }
            } else if (anObject instanceof Integer && (ii = ((Integer)anObject).intValue()) >= 0) {
                if (Markers.isUserDefinedMarker((int)ii)) {
                    this.setMarker(Markers.getUserDefinedMarkerName((int)ii), true);
                } else {
                    this.setMarker(Util.GLMarkerNames[ii], true);
                }
            }
        }
    }
}

