/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.sg.ui;

import com.sas.graphics.sg.interfaces.FillStyleElementInterface;
import com.sas.graphics.sg.interfaces.GraphInterface;
import com.sas.graphics.sg.interfaces.GroupAttrsInterface;
import com.sas.graphics.sg.interfaces.LineStyleElementInterface;
import com.sas.graphics.sg.interfaces.SaveInterface;
import com.sas.graphics.sg.ui.ColorComboBoxEditor;
import com.sas.graphics.sg.ui.ColorGrabber;
import com.sas.graphics.sg.ui.GroupAttrsCustomizerPanel;
import com.sas.graphics.sg.ui.NumberRangeListener;
import com.sas.graphics.sg.ui.RB;
import com.sas.graphics.sg.ui.SGDialog;
import com.sas.graphics.sg.ui.SwatchActionEvent;
import com.sas.graphics.sg.ui.SwatchComboBox;
import com.sas.graphics.sg.ui.SwatchRenderer;
import com.sas.graphics.sg.ui.UIUtil;
import com.sas.graphics.sg.util.Util;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.text.ParseException;
import java.util.ArrayList;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.InputVerifier;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JColorChooser;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFormattedTextField;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.border.Border;

public class GraphCustomizerPanel
extends JPanel
implements ActionListener {
    public static final String RB_KEY = "GraphCustomizerPanel.";
    private static final Border empty = BorderFactory.createEmptyBorder(0, 4 * UIUtil.DLU, 0, 4 * UIUtil.DLU);
    private static final int NUM_COLOR_ROWS = 4;
    private static final int NUM_COLOR_COLS = 8;
    private SwatchComboBox fillColor;
    private JComboBox fstyle;
    private JComboBox lstyle;
    private String defaultColorSource = "";
    JCheckBox scale;
    private JFormattedTextField width;
    private JFormattedTextField height;
    private GraphInterface graph;
    private JCheckBox border;
    ColorGrabber colorGrabber;
    double hmax;
    double hmin;
    double wmax;
    double wmin;
    double hardWMax;
    double hardHMax;
    double aspect = 1.0;
    JTabbedPane tabbedPane;
    private JDialog dialog = null;
    private boolean processing = false;

    public GraphCustomizerPanel(GraphInterface editor) {
        this(editor, null, 200, 1600, 150, 1200);
    }

    public GraphCustomizerPanel(GraphInterface editor, ColorGrabber cg) {
        this(editor, cg, 200, 1600, 150, 1200);
    }

    public GraphCustomizerPanel(GraphInterface editor, ColorGrabber cg, int minWidth, int maxWidth, int minHeight, int maxHeight) {
        this.graph = editor;
        this.colorGrabber = cg;
        this.init(minWidth, maxWidth, minHeight, maxHeight);
    }

    private void init(int minWidth, int maxWidth, int minHeight, int maxHeight) {
        this.tabbedPane = new JTabbedPane(1, 0);
        JPanel generalPanel = new JPanel();
        generalPanel.setLayout(new BoxLayout(generalPanel, 1));
        JPanel backPanel = this.createBackgroundPanel();
        generalPanel.add(backPanel);
        generalPanel.add(Box.createRigidArea(new Dimension(0, 7 * UIUtil.DLU)));
        JPanel sizePanel = this.createSizePanel(minWidth, maxWidth, minHeight, maxHeight);
        generalPanel.add(sizePanel);
        generalPanel.add(Box.createVerticalGlue());
        generalPanel.setBorder(UIUtil.emptyBorder);
        if (this.graph instanceof GroupAttrsInterface) {
            this.tabbedPane.addTab(RB.getStringResource("general.txt"), generalPanel);
            this.tabbedPane.setMnemonicAt(0, 49);
            GroupAttrsCustomizerPanel groupPanel = new GroupAttrsCustomizerPanel((GroupAttrsInterface)((Object)this.graph), this.colorGrabber);
            this.tabbedPane.addTab(RB.getStringResource("groupAttrs.txt"), groupPanel);
            this.tabbedPane.setMnemonicAt(1, 50);
            this.add(this.tabbedPane);
        } else {
            this.add(generalPanel);
        }
    }

    private JPanel createBackgroundPanel() {
        Dimension ps;
        JComponent cc;
        int i;
        JPanel backPanel = new JPanel();
        backPanel.setLayout(new BoxLayout(backPanel, 1));
        ArrayList<JCheckBox> labels = new ArrayList<JCheckBox>();
        ArrayList<SwatchComboBox> widgets = new ArrayList<SwatchComboBox>();
        if (this.graph instanceof FillStyleElementInterface) {
            FillStyleElementInterface styleInterface = (FillStyleElementInterface)((Object)this.graph);
            JPanel stylePanel = this.createStylePanel(styleInterface, labels, widgets);
            backPanel.add(stylePanel);
            backPanel.add(Box.createRigidArea(new Dimension(0, 4 * UIUtil.DLU)));
        }
        Color defaultColor = null;
        if (this.graph.isDefaultBackInterfaceEnabled()) {
            defaultColor = this.graph.getDefaultBackgroundColor();
            this.defaultColorSource = RB.getStringResource("automatic.txt");
        }
        JPanel fillPanel = new JPanel();
        fillPanel.setLayout(new BoxLayout(fillPanel, 0));
        fillPanel.setBorder(UIUtil.emptyItemBorder);
        JLabel label = new JLabel(RB.getStringResource("fill.txt"));
        fillPanel.add(label);
        fillPanel.add(Box.createRigidArea(new Dimension(3 * UIUtil.DLU, 0)));
        this.fillColor = new SwatchComboBox(UIUtil.getColors(), 8, 4, this.colorGrabber, this.defaultColorSource, defaultColor, RB.getStringResource("morecolorsdots.txt"));
        Color c = this.graph.getBackgroundColor();
        this.fillColor.setEditable(true);
        ColorComboBoxEditor editor = new ColorComboBoxEditor(this.defaultColorSource, defaultColor);
        this.fillColor.setEditor(editor);
        editor.addMouseListener(this.fillColor);
        if (c != null) {
            this.fillColor.setSelectedItem(c);
        } else {
            this.fillColor.setSelectedItem(this.defaultColorSource);
        }
        this.fillColor.setRenderer(new SwatchRenderer());
        this.fillColor.addActionListener(this);
        this.fillColor.setActionCommand("backColor");
        this.fillColor.setEnabled(true);
        fillPanel.add(this.fillColor);
        fillPanel.add(Box.createHorizontalGlue());
        backPanel.add(fillPanel);
        widgets.add(this.fillColor);
        if (this.graph instanceof LineStyleElementInterface) {
            LineStyleElementInterface styleInterface = (LineStyleElementInterface)((Object)this.graph);
            JPanel stylePanel = this.createStylePanel(styleInterface, labels, widgets);
            backPanel.add(stylePanel);
            backPanel.add(Box.createRigidArea(new Dimension(0, 4 * UIUtil.DLU)));
        }
        boolean line = this.graph.isBorderOn();
        JPanel borderPanel = new JPanel();
        borderPanel.setLayout(new BoxLayout(borderPanel, 0));
        this.border = new JCheckBox(RB.getStringResource("displayOutline.txt"));
        this.border.setActionCommand("border");
        labels.add(this.border);
        this.border.setSelected(line);
        this.border.addActionListener(this);
        borderPanel.add(this.border);
        borderPanel.add(Box.createHorizontalGlue());
        backPanel.add(borderPanel);
        Dimension labelSize = new Dimension(20, 14 * UIUtil.DLU);
        Dimension widgetSize = new Dimension(100, 14 * UIUtil.DLU);
        for (i = 0; i < labels.size(); ++i) {
            cc = (JComponent)labels.get(i);
            ps = cc.getPreferredSize();
            labelSize.width = Math.max(labelSize.width, ps.width);
            labelSize.height = Math.max(labelSize.height, ps.height);
        }
        for (i = 0; i < labels.size(); ++i) {
            cc = (JComponent)labels.get(i);
            cc.setPreferredSize(labelSize);
            cc.setMaximumSize(labelSize);
        }
        for (i = 0; i < widgets.size(); ++i) {
            cc = (JComponent)widgets.get(i);
            ps = cc.getPreferredSize();
            widgetSize.width = Math.max(widgetSize.width, ps.width);
            widgetSize.height = Math.max(widgetSize.height, ps.height);
        }
        for (i = 0; i < widgets.size(); ++i) {
            cc = (JComponent)widgets.get(i);
            cc.setPreferredSize(widgetSize);
            cc.setMaximumSize(widgetSize);
        }
        backPanel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createTitledBorder(BorderFactory.createLineBorder(Color.GRAY, 1), RB.getStringResource("bground.txt")), empty));
        return backPanel;
    }

    private JPanel createStylePanel(Object style, ArrayList labels, ArrayList widgets) {
        JLabel styleLabel = null;
        JPanel stylePanel = new JPanel();
        stylePanel.setLayout(new BoxLayout(stylePanel, 0));
        styleLabel = new JLabel(RB.getStringResource("element.txt"));
        stylePanel.add(styleLabel);
        labels.add(styleLabel);
        stylePanel.add(Box.createRigidArea(new Dimension(3 * UIUtil.DLU, 0)));
        if (style instanceof FillStyleElementInterface) {
            this.fstyle = new JComboBox<String>(((FillStyleElementInterface)style).getAllFillStyleElements());
            this.fstyle.setSelectedItem(((FillStyleElementInterface)style).getFillStyleElement());
        } else {
            this.fstyle = new JComboBox<String>(((LineStyleElementInterface)style).getAllLineStyleElements());
            this.fstyle.setSelectedItem(((LineStyleElementInterface)style).getLineStyleElement());
        }
        this.fstyle.setActionCommand("fillstyle");
        this.fstyle.addActionListener(this);
        widgets.add(this.fstyle);
        stylePanel.add(this.fstyle);
        stylePanel.add(Box.createHorizontalGlue());
        return stylePanel;
    }

    private JPanel createSizePanel(int minWidth, int maxWidth, int minHeight, int maxHeight) {
        JPanel sizePanel = new JPanel();
        sizePanel.setLayout(new BoxLayout(sizePanel, 1));
        JPanel panel = new JPanel();
        panel.setLayout(new BoxLayout(panel, 0));
        panel.setBorder(UIUtil.emptyItemBorder);
        JLabel wlabel = new JLabel(RB.getStringResource(RB_KEY, "width.txt"));
        panel.add(wlabel);
        panel.add(Box.createRigidArea(new Dimension(3 * UIUtil.DLU, 0)));
        Dimension graphSize = this.graph.getGraphSize();
        int gwidth = graphSize.width;
        int gheight = graphSize.height;
        this.wmax = (double)Math.max(maxWidth, gwidth) / 100.0;
        this.hmax = (double)Math.max(maxHeight, gheight) / 100.0;
        this.wmin = (double)Math.min(minWidth, gwidth) / 100.0;
        this.hmin = (double)Math.min(minHeight, gheight) / 100.0;
        this.hardWMax = this.graph instanceof SaveInterface ? 100.0 : this.wmax;
        this.hardHMax = this.graph instanceof SaveInterface ? 75.0 : this.hmax;
        double value = (double)graphSize.width / 100.0;
        InputVerifier verifier = new InputVerifier(){

            @Override
            public boolean verify(JComponent input) {
                GraphCustomizerPanel.this.acceptWidthUpdate();
                return true;
            }
        };
        this.width = new CustomFormattedField(this.wmin, this.hardWMax, verifier);
        this.width.setValue(new Double(value));
        panel.add(this.width);
        panel.add(Box.createHorizontalGlue());
        panel.add(Box.createHorizontalStrut(4 * UIUtil.DLU));
        this.aspect = (double)gwidth / (double)gheight;
        JLabel hlabel = new JLabel(RB.getStringResource("height.txt"));
        panel.add(hlabel);
        panel.add(Box.createRigidArea(new Dimension(3 * UIUtil.DLU, 0)));
        value = (double)graphSize.height / 100.0;
        verifier = new InputVerifier(){

            @Override
            public boolean verify(JComponent input) {
                GraphCustomizerPanel.this.acceptHeightUpdate();
                return true;
            }
        };
        this.height = new CustomFormattedField(this.hmin, this.hardHMax, verifier);
        this.height.setValue(new Double(value));
        this.height.setInputVerifier(new InputVerifier(){

            @Override
            public boolean verify(JComponent input) {
                GraphCustomizerPanel.this.acceptHeightUpdate();
                return true;
            }
        });
        panel.add(this.height);
        sizePanel.add(panel);
        Dimension ps1 = this.height.getPreferredSize();
        Dimension ps2 = this.width.getPreferredSize();
        if (ps1.width < ps2.width) {
            ps1.width = ps2.width;
        }
        if (ps1.width < UIUtil.DEFAULT_WIDGET_WIDTH) {
            ps1.width = UIUtil.DEFAULT_WIDGET_WIDTH;
        }
        if (ps1.height < UIUtil.DEFAULT_WIDGET_HEIGHT) {
            ps1.height = UIUtil.DEFAULT_WIDGET_HEIGHT;
        }
        this.width.setPreferredSize(ps1);
        this.width.setMaximumSize(ps1);
        this.height.setPreferredSize(ps1);
        this.height.setMaximumSize(ps1);
        ps1 = panel.getPreferredSize();
        ps2 = panel.getMaximumSize();
        ps2.height = ps1.height;
        panel.setMaximumSize(ps2);
        panel = new JPanel();
        panel.setLayout(new BoxLayout(panel, 0));
        panel.setBorder(UIUtil.emptyItemBorder);
        this.scale = new JCheckBox(RB.getStringResource(RB_KEY, "keepAspectRatio.txt"));
        this.scale.setSelected(this.graph.isAspectRatioEnabled());
        this.scale.setActionCommand("scale");
        this.scale.addActionListener(this);
        this.scale.setMaximumSize(this.scale.getPreferredSize());
        this.scale.setBorder(null);
        panel.add(this.scale);
        panel.add(Box.createHorizontalGlue());
        ps1 = panel.getPreferredSize();
        ps2 = panel.getMaximumSize();
        ps2.height = ps1.height;
        panel.setMaximumSize(ps2);
        sizePanel.add(panel);
        sizePanel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createTitledBorder(BorderFactory.createLineBorder(Color.GRAY, 1), RB.getStringResource(RB_KEY, "size.txt")), empty));
        return sizePanel;
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public void actionPerformed(ActionEvent e) {
        String cmd = e.getActionCommand();
        Object src = e.getSource();
        if (cmd.equals("backColor")) {
            Object item = this.fillColor.getSelectedItem();
            if (item == null) return;
            Color save = this.graph.getBackgroundColor();
            if (!(item instanceof String)) {
                if (!(item instanceof Color)) return;
                this.graph.setBackgroundColor((Color)item);
                return;
            }
            if (((String)item).equals(RB.getStringResource("morecolorsdots.txt"))) {
                int result;
                JColorChooser cc = UIUtil.colorChooser;
                if (save == null) {
                    if (this.graph.isDefaultBackInterfaceEnabled()) {
                        cc.setColor(this.graph.getDefaultBackgroundColor());
                    }
                } else {
                    cc.setColor(save);
                }
                cc.setPreviewPanel(new JPanel());
                JPanel panel = new JPanel();
                panel.setLayout(new BorderLayout());
                panel.add(cc);
                Container container = this.getTopLevelAncestor();
                if (!(container instanceof JFrame)) {
                    container = null;
                }
                if ((result = SGDialog.showInputDialog((JFrame)container, RB.getStringResource("morecolors.txt"), panel)) == 0) {
                    Color newColor = cc.getColor();
                    if (newColor == null) {
                        if (save == null) {
                            this.fillColor.setSelectedItem(this.defaultColorSource);
                            return;
                        }
                        this.fillColor.setSelectedItem(save);
                        return;
                    }
                    if (save != null) {
                        if (save.getRGB() == newColor.getRGB()) return;
                    }
                    this.graph.setBackgroundColor(newColor);
                    this.fillColor.setSelectedItem(newColor);
                    return;
                }
                if (save == null) {
                    this.fillColor.setSelectedItem(this.defaultColorSource);
                    return;
                }
                this.fillColor.setSelectedItem(save);
                return;
            }
            if (((String)item).equals(this.defaultColorSource)) {
                this.graph.setBackgroundColor(null);
                return;
            }
            Container c = this.getTopLevelAncestor();
            if (c instanceof SGDialog) {
                SGDialog sgd = (SGDialog)c;
                sgd.value = -1;
                this.dialog = sgd.makeDisabledCopy(this.colorGrabber);
                c.setVisible(false);
                this.dialog.setVisible(true);
            }
            c = this.colorGrabber.grabComponent.getTopLevelAncestor();
            c.requestFocus();
            if (this.dialog != null) {
                this.dialog.toFront();
            }
            this.colorGrabber.grabComponent.repaint();
            this.colorGrabber.setMouseEventListener();
            this.colorGrabber.addActionListener(this);
            if (save == null) {
                this.colorGrabber.setStartColor(this.defaultColorSource);
                return;
            }
            this.colorGrabber.setStartColor(save);
            return;
        }
        if (cmd.equals("colorpicker:done")) {
            Object color = ((SwatchActionEvent)e).getValue();
            this.fillColor.setSelectedItem(color);
            this.colorGrabber.removeMouseEventListener();
            this.colorGrabber.removeActionListener(this);
            if (this.dialog == null) return;
            this.dialog.dispose();
            return;
        }
        if (cmd.equals("colorpicker:updating")) {
            int i;
            Color color = (Color)((SwatchActionEvent)e).getValue();
            if (color == null) return;
            ActionListener[] listener = this.fillColor.getActionListeners();
            for (i = 0; i < listener.length; ++i) {
                this.fillColor.removeActionListener(listener[i]);
            }
            this.fillColor.setSelectedItem(color);
            this.fillColor.setEnabled(true);
            i = 0;
            while (i < listener.length) {
                this.fillColor.addActionListener(listener[i]);
                ++i;
            }
            return;
        }
        if (cmd.equals("fillstyle")) {
            ((FillStyleElementInterface)((Object)this.graph)).setFillStyleElement((String)this.fstyle.getSelectedItem());
            this.fillColor.removeActionListener(this);
            Color c = this.graph.getBackgroundColor();
            if (c != null) {
                this.fillColor.setSelectedItem(c);
            } else {
                this.fillColor.setSelectedItem(this.defaultColorSource);
            }
            this.fillColor.addActionListener(this);
            return;
        }
        if (cmd.equals("linestyle")) {
            ((LineStyleElementInterface)((Object)this.graph)).setLineStyleElement((String)this.lstyle.getSelectedItem());
            return;
        }
        if (cmd.equals("border")) {
            boolean line = this.border.isSelected();
            this.graph.setBorderOn(line);
            if (this.lstyle == null) return;
            this.lstyle.setEnabled(line);
            return;
        }
        if (!cmd.equals("scale")) return;
        this.graph.setAspectRatioEnabled(((JCheckBox)src).isSelected());
    }

    private void acceptWidthUpdate() {
        double ht;
        if (this.processing) {
            return;
        }
        this.processing = true;
        Dimension d = this.graph.getGraphSize();
        double oldvalue = (double)d.width * 0.01;
        String text = this.width.getText();
        JFormattedTextField.AbstractFormatter formatter = this.width.getFormatter();
        boolean errorWarning = false;
        double value = 0.0;
        try {
            value = Double.parseDouble(formatter.stringToValue(text).toString());
        }
        catch (Exception ee) {
            errorWarning = true;
        }
        if (errorWarning || value < this.wmin || value >= this.hardWMax) {
            String maxvalue;
            String minvalue;
            try {
                minvalue = formatter.valueToString(new Double(this.wmin));
            }
            catch (ParseException pe) {
                minvalue = Double.toString(this.wmin);
            }
            try {
                maxvalue = formatter.valueToString(new Double(this.hardWMax));
            }
            catch (ParseException pe) {
                maxvalue = Double.toString(this.hardWMax);
            }
            NumberRangeListener.showInvalidMessage(this.width, minvalue, maxvalue);
            this.width.setValue(oldvalue);
            this.processing = false;
            return;
        }
        double d2 = ht = this.scale.isSelected() ? value / this.aspect : (double)d.height / 100.0;
        if (value > this.wmax || ht > this.hmax) {
            SaveInterface save = this.graph instanceof SaveInterface ? (SaveInterface)((Object)this.graph) : null;
            this.processing = true;
            if (!NumberRangeListener.showWarningDialog(this, save, this.wmax, this.hmax)) {
                this.width.setValue(oldvalue);
                this.processing = false;
                return;
            }
        }
        this.width.setValue(value);
        this.wmax = Math.max(this.wmax, value);
        if (this.scale.isSelected()) {
            this.hmax = Math.max(this.hmax, ht);
            if (ht < this.hmin) {
                ht = this.hmin;
            }
            this.height.setValue(new Double(ht));
            if ((double)d.width != value * 100.0 || (double)d.height != ht * 100.0) {
                this.graph.setGraphSize(new Dimension((int)(100.0 * value), (int)(100.0 * ht)));
            }
        } else {
            this.aspect = value * 100.0 / (double)d.height;
            if ((double)d.width != value * 100.0) {
                this.graph.setGraphSize(new Dimension((int)(value * 100.0), d.height));
            }
        }
    }

    private void acceptHeightUpdate() {
        double wd;
        if (this.processing) {
            return;
        }
        this.processing = true;
        Dimension d = this.graph.getGraphSize();
        double oldvalue = (double)d.height * 0.01;
        String text = this.height.getText();
        JFormattedTextField.AbstractFormatter formatter = this.height.getFormatter();
        boolean errorWarning = false;
        double value = 0.0;
        try {
            value = Double.parseDouble(formatter.stringToValue(text).toString());
        }
        catch (Exception ee) {
            errorWarning = true;
        }
        if (errorWarning || value < this.hmin || value >= this.hardHMax) {
            String maxvalue;
            String minvalue;
            try {
                minvalue = formatter.valueToString(new Double(this.hmin));
            }
            catch (ParseException pe) {
                minvalue = Double.toString(this.hmin);
            }
            try {
                maxvalue = formatter.valueToString(new Double(this.hardHMax));
            }
            catch (ParseException pe) {
                maxvalue = Double.toString(this.hardHMax);
            }
            NumberRangeListener.showInvalidMessage(this.height, minvalue, maxvalue);
            this.height.setValue(oldvalue);
            this.processing = false;
            return;
        }
        double d2 = wd = this.scale.isSelected() ? value * this.aspect : (double)d.width / 100.0;
        if (value > this.hmax || wd > this.wmax) {
            SaveInterface save;
            SaveInterface saveInterface = save = this.graph instanceof SaveInterface ? (SaveInterface)((Object)this.graph) : null;
            if (!NumberRangeListener.showWarningDialog(this, save, this.wmax, this.hmax)) {
                this.height.setValue(oldvalue);
                this.processing = false;
                return;
            }
        }
        this.height.setValue(value);
        this.hmax = Math.max(this.hmax, value);
        if (this.scale.isSelected()) {
            this.wmax = Math.max(this.wmax, wd);
            if (wd < this.wmin) {
                wd = this.wmin;
            }
            this.width.setValue(wd);
            if ((double)d.width != wd * 100.0 || (double)d.height != value * 100.0) {
                this.graph.setGraphSize(new Dimension((int)(100.0 * wd), (int)(100.0 * value)));
            }
        } else {
            this.aspect = (double)d.width / (value * 100.0);
            if ((double)d.height != value * 100.0) {
                this.graph.setGraphSize(new Dimension(d.width, (int)(value * 100.0)));
            }
        }
    }

    public void setGraphSize(double ww, double hh) {
        this.width.removeActionListener(this);
        this.width.setValue(new Double(ww));
        this.width.addActionListener(this);
        this.height.removeActionListener(this);
        this.height.setValue(new Double(hh));
        this.height.addActionListener(this);
    }

    public double getMaxWidth() {
        return this.wmax;
    }

    public double getMaxHeight() {
        return this.hmax;
    }

    public void setValue(Object newValue) {
        if (!(newValue instanceof GraphInterface)) {
            return;
        }
        this.graph = (GraphInterface)newValue;
        if (this.graph instanceof FillStyleElementInterface && this.fstyle != null) {
            this.fstyle.removeActionListener(this);
            this.fstyle.setSelectedItem(((FillStyleElementInterface)((Object)this.graph)).getFillStyleElement());
            this.fstyle.addActionListener(this);
        }
        if (this.graph.isDefaultBackInterfaceEnabled()) {
            this.defaultColorSource = RB.getStringResource("automatic.txt");
        }
        this.fillColor.removeActionListener(this);
        Color c = this.graph.getBackgroundColor();
        if (c != null) {
            this.fillColor.setSelectedItem(c);
        } else {
            this.fillColor.setSelectedItem(this.defaultColorSource);
        }
        this.fillColor.addActionListener(this);
        boolean line = this.graph.isBorderOn();
        this.border.removeActionListener(this);
        this.border.setSelected(line);
        this.border.addActionListener(this);
        Dimension d = this.graph.getGraphSize();
        this.width.removeActionListener(this);
        this.width.setValue(new Double(0.01 * (double)d.width));
        this.width.addActionListener(this);
        this.height.removeActionListener(this);
        this.height.setValue(new Double(0.01 * (double)d.height));
        this.height.addActionListener(this);
        this.scale.removeActionListener(this);
        this.scale.setSelected(this.graph.isAspectRatioEnabled());
        this.scale.addActionListener(this);
        this.aspect = (double)d.width / (double)d.height;
    }

    class CustomFormattedField
    extends JFormattedTextField {
        double min;
        double max;

        public CustomFormattedField(double min, double max, InputVerifier verifier) {
            super(Util.DOUBLE_FORMAT);
            this.setColumns(5);
            this.min = min;
            this.max = max;
            this.setInputVerifier(verifier);
        }

        @Override
        public void commitEdit() {
            try {
                GraphCustomizerPanel.this.processing = true;
                super.commitEdit();
                GraphCustomizerPanel.this.processing = false;
                this.getInputVerifier().verify(this);
            }
            catch (ParseException pe) {
                String maxvalue;
                String minvalue;
                JFormattedTextField.AbstractFormatter formatter = this.getFormatter();
                try {
                    minvalue = formatter.valueToString(new Double(this.min));
                }
                catch (ParseException ee) {
                    minvalue = Double.toString(this.min);
                }
                try {
                    maxvalue = formatter.valueToString(new Double(this.max));
                }
                catch (ParseException ee) {
                    maxvalue = Double.toString(this.max);
                }
                NumberRangeListener.showInvalidMessage(this, minvalue, maxvalue);
                this.setValue(this.getValue());
                GraphCustomizerPanel.this.processing = false;
            }
        }

        @Override
        public void processFocusEvent(FocusEvent fe) {
            Component nextComponent = fe.getOppositeComponent();
            if (fe.getID() != 1005 || !(nextComponent instanceof JButton) || GraphCustomizerPanel.this.tabbedPane.getSelectedIndex() != 0) {
                super.processFocusEvent(fe);
                return;
            }
            if (((JButton)nextComponent).getActionCommand().equals("cancel")) {
                return;
            }
            super.processFocusEvent(fe);
            if (((JButton)nextComponent).getActionCommand().equals("ok")) {
                ActionListener[] al = ((JButton)nextComponent).getActionListeners();
                ActionEvent ae = new ActionEvent(nextComponent, 0, "ok");
                for (int i = 0; i < al.length; ++i) {
                    al[i].actionPerformed(ae);
                }
            }
        }
    }
}

