/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.sg.ui;

import com.sas.graphics.sg.interfaces.DefaultAreaInterface;
import com.sas.graphics.sg.interfaces.DefaultFillInterface;
import com.sas.graphics.sg.interfaces.FillStyleElementInterface;
import com.sas.graphics.sg.interfaces.OverlayContainerInterface;
import com.sas.graphics.sg.interfaces.SGOverlayContainer;
import com.sas.graphics.sg.ui.ColorComboBoxEditor;
import com.sas.graphics.sg.ui.ColorGrabber;
import com.sas.graphics.sg.ui.RB;
import com.sas.graphics.sg.ui.SGDialog;
import com.sas.graphics.sg.ui.SwatchActionEvent;
import com.sas.graphics.sg.ui.SwatchComboBox;
import com.sas.graphics.sg.ui.SwatchRenderer;
import com.sas.graphics.sg.ui.UIUtil;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JCheckBox;
import javax.swing.JColorChooser;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.Border;

public class GraphCellCustomizerPanel
extends JPanel
implements ActionListener {
    public static final String RB_KEY = "GraphCellCustomizerPanel.";
    private static final Border empty = BorderFactory.createEmptyBorder(0, 10, 0, 10);
    private static final int NUM_COLOR_ROWS = 4;
    private static final int NUM_COLOR_COLS = 8;
    private SwatchComboBox fillColor;
    private SwatchComboBox bfillColor;
    private JCheckBox fill;
    private JCheckBox outline;
    private JCheckBox bfill;
    private JCheckBox boutline;
    private JComboBox fstyle;
    private String defaultColorSource = "";
    private String defaultBColorSource = "";
    private SGOverlayContainer graph;
    private OverlayContainerInterface basegraph;
    private ColorGrabber colorGrabber;
    private SGDialog dialog = null;
    boolean isBackActive = false;

    public GraphCellCustomizerPanel(OverlayContainerInterface graph) {
        this(graph, null);
    }

    public GraphCellCustomizerPanel(OverlayContainerInterface graph, ColorGrabber cg) {
        this.basegraph = graph;
        if (graph instanceof SGOverlayContainer) {
            this.graph = (SGOverlayContainer)graph;
        }
        this.colorGrabber = cg;
        this.init();
    }

    private void init() {
        this.setLayout(new BoxLayout(this, 1));
        if (this.graph != null) {
            JPanel backPanel = this.createBackPanel();
            this.add(backPanel);
            this.add(Box.createRigidArea(new Dimension(0, 4 * UIUtil.DLU)));
            if (this.graph.isWallEnabled()) {
                this.add(Box.createRigidArea(new Dimension(0, 4 * UIUtil.DLU)));
                JPanel wallPanel = this.createWallPanel();
                this.add(wallPanel);
            }
        } else {
            JPanel wallPanel = this.createBaseWallPanel();
            this.add(wallPanel);
        }
        this.add(Box.createVerticalGlue());
        this.setBorder(UIUtil.emptyBorder);
    }

    private JPanel createWallPanel() {
        Dimension ps;
        JComponent cc;
        int i;
        JPanel wallPanel = new JPanel();
        Color defaultColor = null;
        boolean fillOn = this.graph.isWallOn();
        ArrayList<JCheckBox> labels = new ArrayList<JCheckBox>();
        ArrayList<SwatchComboBox> widgets = new ArrayList<SwatchComboBox>();
        wallPanel.setLayout(new BoxLayout(wallPanel, 1));
        JPanel fillPanel = new JPanel();
        fillPanel.setLayout(new BoxLayout(fillPanel, 0));
        this.fill = new JCheckBox(RB.getStringResource("fill.txt"));
        this.fill.setSelected(fillOn);
        this.fill.addActionListener(this);
        this.fill.setActionCommand("fill");
        fillPanel.add(this.fill);
        labels.add(this.fill);
        fillPanel.add(Box.createRigidArea(new Dimension(4 * UIUtil.DLU, 0)));
        defaultColor = this.graph.getDefaultWallColor();
        this.defaultColorSource = RB.getStringResource("automatic.txt");
        this.fillColor = new SwatchComboBox(UIUtil.getColors(), 8, 4, this.colorGrabber, this.defaultColorSource, defaultColor, RB.getStringResource("morecolorsdots.txt"));
        Color c = this.graph.getWallColor();
        this.fillColor.setEditable(true);
        ColorComboBoxEditor editor = new ColorComboBoxEditor(this.defaultColorSource, defaultColor);
        this.fillColor.setEditor(editor);
        editor.addMouseListener(this.fillColor);
        if (c != null) {
            this.fillColor.setSelectedItem(c);
        } else {
            this.fillColor.setSelectedItem(this.defaultColorSource);
        }
        this.fillColor.setRenderer(new SwatchRenderer());
        this.fillColor.addActionListener(this);
        this.fillColor.setActionCommand("fillColor");
        fillPanel.add(this.fillColor);
        widgets.add(this.fillColor);
        fillPanel.add(Box.createHorizontalGlue());
        wallPanel.add(fillPanel);
        wallPanel.add(Box.createRigidArea(new Dimension(0, 4 * UIUtil.DLU)));
        this.fillColor.setEnabled(fillOn);
        JPanel linePanel = new JPanel();
        linePanel.setLayout(new BoxLayout(linePanel, 0));
        this.outline = new JCheckBox(RB.getStringResource("displayOutline.txt"));
        this.outline.setSelected(this.graph.isWallBorderOn());
        this.outline.addActionListener(this);
        this.outline.setActionCommand("outline");
        linePanel.add(this.outline);
        linePanel.add(Box.createHorizontalGlue());
        wallPanel.add(linePanel);
        wallPanel.add(Box.createRigidArea(new Dimension(0, 7 * UIUtil.DLU)));
        Dimension labelSize = new Dimension(20, 14 * UIUtil.DLU);
        Dimension widgetSize = new Dimension(100, 14 * UIUtil.DLU);
        for (i = 0; i < labels.size(); ++i) {
            cc = (JComponent)labels.get(i);
            ps = cc.getPreferredSize();
            labelSize.width = Math.max(labelSize.width, ps.width);
            labelSize.height = Math.max(labelSize.height, ps.height);
        }
        for (i = 0; i < labels.size(); ++i) {
            cc = (JComponent)labels.get(i);
            cc.setPreferredSize(labelSize);
            cc.setMaximumSize(labelSize);
        }
        for (i = 0; i < widgets.size(); ++i) {
            cc = (JComponent)widgets.get(i);
            ps = cc.getPreferredSize();
            widgetSize.width = Math.max(widgetSize.width, ps.width);
            widgetSize.height = Math.max(widgetSize.height, ps.height);
        }
        for (i = 0; i < widgets.size(); ++i) {
            cc = (JComponent)widgets.get(i);
            cc.setPreferredSize(widgetSize);
            cc.setMaximumSize(widgetSize);
        }
        wallPanel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createTitledBorder(BorderFactory.createLineBorder(Color.GRAY, 1), RB.getStringResource(RB_KEY, "wall.txt")), empty));
        return wallPanel;
    }

    private JPanel createBaseWallPanel() {
        Dimension ps;
        JComponent cc;
        int i;
        JPanel wallPanel = new JPanel();
        Color defaultColor = null;
        boolean fillOn = this.basegraph.isFillOn();
        ArrayList<JCheckBox> labels = new ArrayList<JCheckBox>();
        ArrayList<SwatchComboBox> widgets = new ArrayList<SwatchComboBox>();
        wallPanel.setLayout(new BoxLayout(wallPanel, 1));
        if (this.basegraph instanceof FillStyleElementInterface) {
            FillStyleElementInterface styleInterface = (FillStyleElementInterface)((Object)this.basegraph);
            JPanel stylePanel = this.createStylePanel(styleInterface, labels, widgets, fillOn);
            wallPanel.add(stylePanel);
            wallPanel.add(Box.createRigidArea(new Dimension(0, 4 * UIUtil.DLU)));
        }
        JPanel fillPanel = new JPanel();
        fillPanel.setLayout(new BoxLayout(fillPanel, 0));
        this.fill = new JCheckBox(RB.getStringResource("fill.txt"));
        this.fill.setSelected(fillOn);
        this.fill.addActionListener(this);
        this.fill.setActionCommand("bgwfill");
        fillPanel.add(this.fill);
        labels.add(this.fill);
        fillPanel.add(Box.createRigidArea(new Dimension(4 * UIUtil.DLU, 0)));
        if (this.basegraph instanceof DefaultFillInterface) {
            DefaultFillInterface das = (DefaultFillInterface)((Object)this.basegraph);
            defaultColor = das.getDefaultFillColor();
            this.defaultColorSource = RB.getStringResource("automatic.txt");
        }
        this.fillColor = new SwatchComboBox(UIUtil.getColors(), 8, 4, this.colorGrabber, this.defaultColorSource, defaultColor, RB.getStringResource("morecolorsdots.txt"));
        Color c = this.basegraph.getFillColor();
        this.fillColor.setEditable(true);
        ColorComboBoxEditor editor = new ColorComboBoxEditor(this.defaultColorSource, defaultColor);
        this.fillColor.setEditor(editor);
        editor.addMouseListener(this.fillColor);
        if (c != null) {
            this.fillColor.setSelectedItem(c);
        } else {
            this.fillColor.setSelectedItem(this.defaultColorSource);
        }
        this.fillColor.setRenderer(new SwatchRenderer());
        this.fillColor.addActionListener(this);
        this.fillColor.setActionCommand("bgwfillColor");
        fillPanel.add(this.fillColor);
        widgets.add(this.fillColor);
        fillPanel.add(Box.createHorizontalGlue());
        wallPanel.add(fillPanel);
        wallPanel.add(Box.createRigidArea(new Dimension(0, 4 * UIUtil.DLU)));
        this.fillColor.setEnabled(fillOn);
        JPanel linePanel = new JPanel();
        linePanel.setLayout(new BoxLayout(linePanel, 0));
        this.outline = new JCheckBox(RB.getStringResource("displayOutline.txt"));
        this.outline.setSelected(this.basegraph.isLineOn());
        this.outline.addActionListener(this);
        this.outline.setActionCommand("bgwoutline");
        linePanel.add(this.outline);
        linePanel.add(Box.createHorizontalGlue());
        wallPanel.add(linePanel);
        wallPanel.add(Box.createRigidArea(new Dimension(0, 7 * UIUtil.DLU)));
        Dimension labelSize = new Dimension(20, 14 * UIUtil.DLU);
        Dimension widgetSize = new Dimension(100, 14 * UIUtil.DLU);
        for (i = 0; i < labels.size(); ++i) {
            cc = (JComponent)labels.get(i);
            ps = cc.getPreferredSize();
            labelSize.width = Math.max(labelSize.width, ps.width);
            labelSize.height = Math.max(labelSize.height, ps.height);
        }
        for (i = 0; i < labels.size(); ++i) {
            cc = (JComponent)labels.get(i);
            cc.setPreferredSize(labelSize);
            cc.setMaximumSize(labelSize);
        }
        for (i = 0; i < widgets.size(); ++i) {
            cc = (JComponent)widgets.get(i);
            ps = cc.getPreferredSize();
            widgetSize.width = Math.max(widgetSize.width, ps.width);
            widgetSize.height = Math.max(widgetSize.height, ps.height);
        }
        for (i = 0; i < widgets.size(); ++i) {
            cc = (JComponent)widgets.get(i);
            cc.setPreferredSize(widgetSize);
            cc.setMaximumSize(widgetSize);
        }
        wallPanel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createTitledBorder(BorderFactory.createLineBorder(Color.GRAY, 1), RB.getStringResource(RB_KEY, "wall.txt")), empty));
        return wallPanel;
    }

    private JPanel createBackPanel() {
        Dimension ps;
        JComponent cc;
        int i;
        JPanel backPanel = new JPanel();
        Color defaultColor = null;
        boolean fillOn = this.graph.isFillOn();
        ArrayList<JCheckBox> labels = new ArrayList<JCheckBox>();
        ArrayList<SwatchComboBox> widgets = new ArrayList<SwatchComboBox>();
        backPanel.setLayout(new BoxLayout(backPanel, 1));
        JPanel fillPanel = new JPanel();
        fillPanel.setLayout(new BoxLayout(fillPanel, 0));
        this.bfill = new JCheckBox(RB.getStringResource("fill.txt"));
        this.bfill.setSelected(fillOn);
        this.bfill.addActionListener(this);
        this.bfill.setActionCommand("bfill");
        fillPanel.add(this.bfill);
        labels.add(this.bfill);
        fillPanel.add(Box.createRigidArea(new Dimension(4 * UIUtil.DLU, 0)));
        defaultColor = this.graph.getDefaultFillColor();
        this.defaultBColorSource = RB.getStringResource("automatic.txt");
        this.bfillColor = new SwatchComboBox(UIUtil.getColors(), 8, 4, this.colorGrabber, this.defaultBColorSource, defaultColor, RB.getStringResource("morecolorsdots.txt"));
        Color c = this.graph.getFillColor();
        this.bfillColor.setEditable(true);
        ColorComboBoxEditor editor = new ColorComboBoxEditor(this.defaultBColorSource, defaultColor);
        this.bfillColor.setEditor(editor);
        editor.addMouseListener(this.bfillColor);
        if (c != null) {
            this.bfillColor.setSelectedItem(c);
        } else {
            this.bfillColor.setSelectedItem(this.defaultBColorSource);
        }
        this.bfillColor.setRenderer(new SwatchRenderer());
        this.bfillColor.addActionListener(this);
        this.bfillColor.setActionCommand("bfillColor");
        fillPanel.add(this.bfillColor);
        widgets.add(this.bfillColor);
        fillPanel.add(Box.createHorizontalGlue());
        backPanel.add(fillPanel);
        backPanel.add(Box.createRigidArea(new Dimension(0, 4 * UIUtil.DLU)));
        this.bfillColor.setEnabled(fillOn);
        JPanel linePanel = new JPanel();
        linePanel.setLayout(new BoxLayout(linePanel, 0));
        this.boutline = new JCheckBox(RB.getStringResource("displayOutline.txt"));
        this.boutline.setSelected(this.graph.isLineOn());
        this.boutline.addActionListener(this);
        this.boutline.setActionCommand("boutline");
        linePanel.add(this.boutline);
        linePanel.add(Box.createHorizontalGlue());
        backPanel.add(linePanel);
        backPanel.add(Box.createRigidArea(new Dimension(0, 7 * UIUtil.DLU)));
        Dimension labelSize = new Dimension(20, 14 * UIUtil.DLU);
        Dimension widgetSize = new Dimension(100, 14 * UIUtil.DLU);
        for (i = 0; i < labels.size(); ++i) {
            cc = (JComponent)labels.get(i);
            ps = cc.getPreferredSize();
            labelSize.width = Math.max(labelSize.width, ps.width);
            labelSize.height = Math.max(labelSize.height, ps.height);
        }
        for (i = 0; i < labels.size(); ++i) {
            cc = (JComponent)labels.get(i);
            cc.setPreferredSize(labelSize);
            cc.setMaximumSize(labelSize);
        }
        for (i = 0; i < widgets.size(); ++i) {
            cc = (JComponent)widgets.get(i);
            ps = cc.getPreferredSize();
            widgetSize.width = Math.max(widgetSize.width, ps.width);
            widgetSize.height = Math.max(widgetSize.height, ps.height);
        }
        for (i = 0; i < widgets.size(); ++i) {
            cc = (JComponent)widgets.get(i);
            cc.setPreferredSize(widgetSize);
            cc.setMaximumSize(widgetSize);
        }
        backPanel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createTitledBorder(BorderFactory.createLineBorder(Color.GRAY, 1), RB.getStringResource("bground.txt")), empty));
        return backPanel;
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public void actionPerformed(ActionEvent e) {
        Container parent;
        JPanel panel;
        JColorChooser cc;
        Color save;
        block61: {
            Container parent2;
            JPanel panel2;
            JColorChooser cc2;
            Color save2;
            block60: {
                Container parent3;
                JPanel panel3;
                JColorChooser cc3;
                Color save3;
                block63: {
                    String cmd;
                    block62: {
                        cmd = e.getActionCommand();
                        if (!cmd.equals("bfillColor")) break block62;
                        Object item = this.bfillColor.getSelectedItem();
                        if (item == null) return;
                        save3 = this.graph.getFillColor();
                        if (!(item instanceof String)) {
                            if (!(item instanceof Color)) return;
                            this.graph.setFillColor((Color)item);
                            return;
                        }
                        if (((String)item).equals(RB.getStringResource("morecolorsdots.txt"))) {
                            cc3 = UIUtil.colorChooser;
                            if (save3 == null) {
                                if (this.graph instanceof DefaultAreaInterface) {
                                    cc3.setColor(this.graph.getDefaultFillColor());
                                }
                            } else {
                                cc3.setColor(save3);
                            }
                            cc3.setPreviewPanel(new JPanel());
                            panel3 = new JPanel();
                            panel3.setLayout(new BorderLayout());
                            panel3.add(cc3);
                            break block63;
                        } else {
                            if (((String)item).equals(this.defaultBColorSource)) {
                                this.graph.setFillColor(null);
                                return;
                            }
                            Container c = this.getTopLevelAncestor();
                            this.isBackActive = true;
                            if (c instanceof SGDialog) {
                                SGDialog sgd = (SGDialog)c;
                                sgd.value = -1;
                                this.dialog = sgd.makeDisabledCopy(this.colorGrabber);
                                c.setVisible(false);
                                this.dialog.setVisible(true);
                            }
                            c = this.colorGrabber.grabComponent.getTopLevelAncestor();
                            c.requestFocus();
                            if (this.dialog != null) {
                                this.dialog.toFront();
                            }
                            this.colorGrabber.grabComponent.repaint();
                            this.colorGrabber.setMouseEventListener();
                            this.colorGrabber.addActionListener(this);
                            if (save3 == null) {
                                this.colorGrabber.setStartColor(this.defaultBColorSource);
                                return;
                            }
                            this.colorGrabber.setStartColor(save3);
                            return;
                        }
                    }
                    if (cmd.equals("colorpicker:done")) {
                        Object color = ((SwatchActionEvent)e).getValue();
                        if (this.isBackActive) {
                            this.bfillColor.setSelectedItem(color);
                        } else {
                            this.fillColor.setSelectedItem(color);
                        }
                        this.colorGrabber.removeMouseEventListener();
                        this.colorGrabber.removeActionListener(this);
                        if (this.dialog == null) return;
                        this.dialog.dispose();
                        return;
                    }
                    if (cmd.equals("colorpicker:updating")) {
                        int i;
                        Color color = (Color)((SwatchActionEvent)e).getValue();
                        if (color == null) return;
                        if (this.isBackActive) {
                            int i2;
                            ActionListener[] listener = this.bfillColor.getActionListeners();
                            for (i2 = 0; i2 < listener.length; ++i2) {
                                this.bfillColor.removeActionListener(listener[i2]);
                            }
                            this.bfillColor.setSelectedItem(color);
                            this.bfillColor.setEnabled(true);
                            i2 = 0;
                            while (i2 < listener.length) {
                                this.bfillColor.addActionListener(listener[i2]);
                                ++i2;
                            }
                            return;
                        }
                        ActionListener[] listener = this.fillColor.getActionListeners();
                        for (i = 0; i < listener.length; ++i) {
                            this.fillColor.removeActionListener(listener[i]);
                        }
                        this.fillColor.setSelectedItem(color);
                        this.fillColor.setEnabled(true);
                        i = 0;
                        while (i < listener.length) {
                            this.fillColor.addActionListener(listener[i]);
                            ++i;
                        }
                        return;
                    }
                    if (cmd.equals("bfill")) {
                        boolean fillOn = this.bfill.isSelected();
                        this.graph.setFillOn(fillOn);
                        this.bfillColor.setEnabled(fillOn);
                        return;
                    }
                    if (cmd.equals("boutline")) {
                        boolean lineOn = this.boutline.isSelected();
                        this.graph.setLineOn(lineOn);
                        return;
                    }
                    if (cmd.equals("fillColor")) {
                        Object item = this.fillColor.getSelectedItem();
                        if (item == null) return;
                        save2 = this.graph.getWallColor();
                        if (!(item instanceof String)) {
                            if (!(item instanceof Color)) return;
                            this.graph.setWallColor((Color)item);
                            return;
                        }
                        if (((String)item).equals(RB.getStringResource("morecolorsdots.txt"))) {
                            cc2 = UIUtil.colorChooser;
                            if (save2 == null) {
                                cc2.setColor(this.graph.getDefaultWallColor());
                            } else {
                                cc2.setColor(save2);
                            }
                            cc2.setPreviewPanel(new JPanel());
                            panel2 = new JPanel();
                            panel2.setLayout(new BorderLayout());
                            panel2.add(cc2);
                            break block60;
                        } else {
                            if (((String)item).equals(this.defaultColorSource)) {
                                this.graph.setWallColor(null);
                                return;
                            }
                            this.isBackActive = false;
                            Container c = this.getTopLevelAncestor();
                            if (c instanceof SGDialog) {
                                SGDialog sgd = (SGDialog)c;
                                sgd.value = -1;
                                this.dialog = sgd.makeDisabledCopy(this.colorGrabber);
                                c.setVisible(false);
                                this.dialog.setVisible(true);
                            }
                            c = this.colorGrabber.grabComponent.getTopLevelAncestor();
                            c.requestFocus();
                            if (this.dialog != null) {
                                this.dialog.toFront();
                            }
                            this.colorGrabber.grabComponent.repaint();
                            this.colorGrabber.setMouseEventListener();
                            this.colorGrabber.addActionListener(this);
                            if (save2 == null) {
                                this.colorGrabber.setStartColor(this.defaultColorSource);
                                return;
                            }
                            this.colorGrabber.setStartColor(save2);
                            return;
                        }
                    }
                    if (cmd.equals("fill")) {
                        boolean fillOn = this.fill.isSelected();
                        this.graph.setWallOn(fillOn);
                        this.fillColor.setEnabled(fillOn);
                        return;
                    }
                    if (cmd.equals("outline")) {
                        boolean lineOn = this.outline.isSelected();
                        this.graph.setWallBorderOn(lineOn);
                        return;
                    }
                    if (cmd.equals("bgwfillColor")) {
                        Object item = this.fillColor.getSelectedItem();
                        if (item == null) return;
                        save = this.basegraph.getFillColor();
                        if (!(item instanceof String)) {
                            if (!(item instanceof Color)) return;
                            this.basegraph.setFillColor((Color)item);
                            return;
                        }
                        if (((String)item).equals(RB.getStringResource("morecolorsdots.txt"))) {
                            cc = UIUtil.colorChooser;
                            cc.setColor(save);
                            cc.setPreviewPanel(new JPanel());
                            panel = new JPanel();
                            panel.setLayout(new BorderLayout());
                            panel.add(cc);
                            break block61;
                        } else {
                            if (((String)item).equals(this.defaultColorSource)) {
                                this.basegraph.setFillColor(null);
                                return;
                            }
                            Container c = this.getTopLevelAncestor();
                            this.isBackActive = true;
                            if (c instanceof SGDialog) {
                                SGDialog sgd = (SGDialog)c;
                                sgd.value = -1;
                                this.dialog = sgd.makeDisabledCopy(this.colorGrabber);
                                c.setVisible(false);
                                this.dialog.setVisible(true);
                            }
                            c = this.colorGrabber.grabComponent.getTopLevelAncestor();
                            c.requestFocus();
                            if (this.dialog != null) {
                                this.dialog.toFront();
                            }
                            this.colorGrabber.grabComponent.repaint();
                            this.colorGrabber.setMouseEventListener();
                            this.colorGrabber.addActionListener(this);
                            if (save == null) {
                                this.colorGrabber.setStartColor(this.defaultColorSource);
                                return;
                            }
                            this.colorGrabber.setStartColor(save);
                            return;
                        }
                    }
                    if (cmd.equals("bgwfill")) {
                        boolean fillOn = this.fill.isSelected();
                        this.basegraph.setFillOn(fillOn);
                        this.fillColor.setEnabled(fillOn);
                        return;
                    }
                    if (!cmd.equals("bgwoutline")) return;
                    boolean lineOn = this.outline.isSelected();
                    this.basegraph.setLineOn(lineOn);
                    return;
                }
                for (parent3 = this.getParent(); parent3 != null && !(parent3 instanceof JFrame); parent3 = parent3.getParent()) {
                }
                int result = SGDialog.showInputDialog((JFrame)parent3, RB.getStringResource("morecolors.txt"), panel3);
                if (result == 0) {
                    Color newColor = cc3.getColor();
                    if (newColor == null) {
                        if (save3 == null) {
                            this.bfillColor.setSelectedItem(this.defaultBColorSource);
                            return;
                        }
                        this.bfillColor.setSelectedItem(save3);
                        return;
                    }
                    if (save3 != null) {
                        if (save3.getRGB() == newColor.getRGB()) return;
                    }
                    this.graph.setFillColor(newColor);
                    this.bfillColor.setSelectedItem(newColor);
                    return;
                }
                if (save3 == null) {
                    this.bfillColor.setSelectedItem(this.defaultBColorSource);
                    return;
                }
                this.bfillColor.setSelectedItem(save3);
                return;
            }
            for (parent2 = this.getParent(); parent2 != null && !(parent2 instanceof JFrame); parent2 = parent2.getParent()) {
            }
            int result = SGDialog.showInputDialog((JFrame)parent2, RB.getStringResource("morecolors.txt"), panel2);
            if (result == 0) {
                Color newColor = cc2.getColor();
                if (newColor == null) {
                    if (save2 == null) {
                        this.fillColor.setSelectedItem(this.defaultColorSource);
                        return;
                    }
                    this.fillColor.setSelectedItem(save2);
                    return;
                }
                if (save2 != null) {
                    if (save2.getRGB() == newColor.getRGB()) return;
                }
                this.graph.setWallColor(newColor);
                this.fillColor.setSelectedItem(newColor);
                return;
            }
            if (save2 == null) {
                this.fillColor.setSelectedItem(this.defaultColorSource);
                return;
            }
            this.fillColor.setSelectedItem(save2);
            return;
        }
        for (parent = this.getParent(); parent != null && !(parent instanceof JFrame); parent = parent.getParent()) {
        }
        int result = SGDialog.showInputDialog((JFrame)parent, RB.getStringResource("morecolors.txt"), panel);
        if (result == 0) {
            Color newColor = cc.getColor();
            if (newColor == null) {
                if (save == null) {
                    this.fillColor.setSelectedItem(this.defaultColorSource);
                    return;
                }
                this.fillColor.setSelectedItem(save);
                return;
            }
            if (save != null) {
                if (save.getRGB() == newColor.getRGB()) return;
            }
            this.basegraph.setFillColor(newColor);
            this.fillColor.setSelectedItem(newColor);
            return;
        }
        if (save == null) {
            this.fillColor.setSelectedItem(this.defaultColorSource);
            return;
        }
        this.fillColor.setSelectedItem(save);
    }

    public void updateCurrentValues() {
        int i;
        int i2;
        int i3;
        ActionListener[] listener;
        if (this.outline != null) {
            listener = this.outline.getActionListeners();
            for (i3 = 0; i3 < listener.length; ++i3) {
                this.outline.removeActionListener(listener[i3]);
            }
            this.outline.setSelected(this.graph.isWallBorderOn());
            for (i3 = 0; i3 < listener.length; ++i3) {
                this.outline.addActionListener(listener[i3]);
            }
        }
        if (this.boutline != null) {
            listener = this.boutline.getActionListeners();
            for (i3 = 0; i3 < listener.length; ++i3) {
                this.boutline.removeActionListener(listener[i3]);
            }
            this.boutline.setSelected(this.graph.isLineOn());
            for (i3 = 0; i3 < listener.length; ++i3) {
                this.boutline.addActionListener(listener[i3]);
            }
        }
        boolean isfill = false;
        if (this.bfill != null) {
            isfill = this.graph.isFillOn();
            ActionListener[] listener2 = this.bfill.getActionListeners();
            for (i2 = 0; i2 < listener2.length; ++i2) {
                this.bfill.removeActionListener(listener2[i2]);
            }
            this.bfill.setSelected(isfill);
            for (i2 = 0; i2 < listener2.length; ++i2) {
                this.bfill.addActionListener(listener2[i2]);
            }
        }
        if (isfill && this.bfillColor != null) {
            ActionListener[] listener3 = this.bfillColor.getActionListeners();
            for (i2 = 0; i2 < listener3.length; ++i2) {
                this.bfillColor.removeActionListener(listener3[i2]);
            }
            Color c = this.graph.getFillColor();
            if (c == null) {
                this.bfillColor.setSelectedItem(this.defaultColorSource);
            } else {
                this.bfillColor.setSelectedItem(c);
            }
            this.bfillColor.setEnabled(true);
            for (i = 0; i < listener3.length; ++i) {
                this.bfillColor.addActionListener(listener3[i]);
            }
        }
        isfill = false;
        if (this.fill != null) {
            int i4;
            isfill = this.graph.isWallBorderOn();
            ActionListener[] listener4 = this.bfill.getActionListeners();
            for (i4 = 0; i4 < listener4.length; ++i4) {
                this.fill.removeActionListener(listener4[i4]);
            }
            this.fill.setSelected(isfill);
            for (i4 = 0; i4 < listener4.length; ++i4) {
                this.fill.addActionListener(listener4[i4]);
            }
        }
        if (isfill && this.fillColor != null) {
            ActionListener[] listener5 = this.fillColor.getActionListeners();
            for (int i5 = 0; i5 < listener5.length; ++i5) {
                this.fillColor.removeActionListener(listener5[i5]);
            }
            Color c = this.graph.getWallColor();
            if (c == null) {
                this.fillColor.setSelectedItem(this.defaultColorSource);
            } else {
                this.fillColor.setSelectedItem(c);
            }
            this.fillColor.setEnabled(true);
            for (i = 0; i < listener5.length; ++i) {
                this.fillColor.addActionListener(listener5[i]);
            }
        }
    }

    private JPanel createStylePanel(FillStyleElementInterface styleInterface, ArrayList labels, ArrayList widgets, boolean enable) {
        JLabel styleLabel = null;
        JPanel stylePanel = new JPanel();
        stylePanel.setLayout(new BoxLayout(stylePanel, 0));
        styleLabel = new JLabel(RB.getStringResource("element.txt"));
        stylePanel.add(styleLabel);
        labels.add(styleLabel);
        stylePanel.add(Box.createRigidArea(new Dimension(3 * UIUtil.DLU, 0)));
        this.fstyle = new JComboBox<String>(styleInterface.getAllFillStyleElements());
        this.fstyle.setSelectedItem(styleInterface.getFillStyleElement());
        this.fstyle.setActionCommand("style");
        this.fstyle.setEnabled(enable);
        this.fstyle.addActionListener(this);
        widgets.add(this.fstyle);
        stylePanel.add(this.fstyle);
        stylePanel.add(Box.createHorizontalGlue());
        return stylePanel;
    }
}

