/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.sg.ui;

import com.sas.graphics.sg.interfaces.ColorEditableInterface;
import com.sas.graphics.sg.interfaces.DefaultFillInterface;
import com.sas.graphics.sg.interfaces.FillInterface;
import com.sas.graphics.sg.interfaces.FillStyleElementInterface;
import com.sas.graphics.sg.ui.ColorComboBoxEditor;
import com.sas.graphics.sg.ui.ColorGrabber;
import com.sas.graphics.sg.ui.RB;
import com.sas.graphics.sg.ui.SGCustomizerPanel;
import com.sas.graphics.sg.ui.SGDialog;
import com.sas.graphics.sg.ui.SwatchActionEvent;
import com.sas.graphics.sg.ui.SwatchComboBox;
import com.sas.graphics.sg.ui.SwatchRenderer;
import com.sas.graphics.sg.ui.UIUtil;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JColorChooser;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class FillCustomizerPanel
extends SGCustomizerPanel
implements ActionListener,
ChangeListener {
    private static final int dlu3 = UIUtil.DLU * 3;
    private static final int dlu4 = UIUtil.DLU * 4;
    FillInterface fillStyle;
    SwatchComboBox fillColor;
    JComboBox fstyle;
    String defaultFillColorSource = "";
    protected JSlider transparency;
    ColorGrabber colorGrabber = null;
    private JDialog dialog = null;

    public FillCustomizerPanel(FillInterface fillStyle) {
        this(fillStyle, null);
    }

    public FillCustomizerPanel(FillInterface fillStyle, ColorGrabber cg) {
        this.colorGrabber = cg;
        this.fillStyle = fillStyle;
        this.init();
    }

    private void init() {
        this.setLayout(new BoxLayout(this, 1));
        Color defaultFillColor = null;
        if (this.fillStyle instanceof FillStyleElementInterface) {
            FillStyleElementInterface styleInterface = (FillStyleElementInterface)((Object)this.fillStyle);
            JPanel stylePanel = new JPanel();
            stylePanel.setLayout(new BoxLayout(stylePanel, 0));
            JLabel styleLabel = new JLabel(RB.getStringResource("element.txt"));
            Dimension ps = styleLabel.getPreferredSize();
            this.labelSize.setSize(Math.max(this.labelSize.width, ps.width), Math.max(this.labelSize.height, ps.height));
            this.labels.add(styleLabel);
            stylePanel.add(styleLabel);
            stylePanel.add(Box.createRigidArea(new Dimension(dlu3, 0)));
            this.fstyle = new JComboBox<String>(styleInterface.getAllFillStyleElements());
            this.fstyle.setSelectedItem(styleInterface.getFillStyleElement());
            this.fstyle.setActionCommand("fillstyle");
            this.fstyle.setEnabled(this.fstyle.getItemCount() > 1);
            this.fstyle.addActionListener(this);
            this.widgets.add(this.fstyle);
            ps = this.fstyle.getPreferredSize();
            this.widgetSize.setSize(Math.max(this.widgetSize.width, ps.width), Math.max(this.widgetSize.height, ps.height));
            stylePanel.add(this.fstyle);
            stylePanel.add(Box.createHorizontalGlue());
            this.add(stylePanel);
            this.add(Box.createRigidArea(new Dimension(0, dlu4)));
        }
        JPanel colorPanel = new JPanel();
        colorPanel.setLayout(new BoxLayout(colorPanel, 0));
        JLabel colorlabel = new JLabel(RB.getStringResource("colorcolon.txt"));
        colorPanel.add(colorlabel);
        colorPanel.add(Box.createRigidArea(new Dimension(dlu3, 0)));
        Dimension ps = colorlabel.getPreferredSize();
        this.labelSize.setSize(Math.max(this.labelSize.width, ps.width), Math.max(this.labelSize.height, ps.height));
        this.labels.add(colorlabel);
        if (this.fillStyle instanceof DefaultFillInterface) {
            DefaultFillInterface das = (DefaultFillInterface)((Object)this.fillStyle);
            this.defaultFillColorSource = das.getDefaultFillColorSource();
            defaultFillColor = das.getDefaultFillColor();
        }
        this.fillColor = new SwatchComboBox(UIUtil.getColors(), 8, 4, this.colorGrabber, this.defaultFillColorSource, defaultFillColor, RB.getStringResource("morecolorsdots.txt"));
        Color c = this.fillStyle.getFillColor();
        this.fillColor.setEditable(true);
        ColorComboBoxEditor editor = new ColorComboBoxEditor(this.defaultFillColorSource, defaultFillColor);
        this.fillColor.setEditor(editor);
        editor.addMouseListener(this.fillColor);
        if (c != null) {
            this.fillColor.setSelectedItem(c);
        } else {
            this.fillColor.setSelectedItem(this.defaultFillColorSource);
        }
        this.fillColor.setRenderer(new SwatchRenderer());
        this.fillColor.setActionCommand("fillcolor");
        this.add(this.fillColor);
        this.add(Box.createHorizontalGlue());
        this.fillColor.addActionListener(this);
        ps = this.fillColor.getPreferredSize();
        this.widgetSize.setSize(Math.max(this.widgetSize.width, ps.width), Math.max(this.widgetSize.height, ps.height));
        this.widgets.add(this.fillColor);
        colorPanel.add(this.fillColor);
        colorPanel.add(Box.createHorizontalGlue());
        this.add(colorPanel);
        this.add(Box.createRigidArea(new Dimension(0, dlu4)));
        JPanel transparencyPanel = new JPanel();
        transparencyPanel.setLayout(new BoxLayout(transparencyPanel, 0));
        JLabel translabel = new JLabel(RB.getStringResource("transparency.txt"));
        transparencyPanel.add(translabel);
        transparencyPanel.add(Box.createRigidArea(new Dimension(dlu3, 0)));
        ps = translabel.getPreferredSize();
        this.labelSize.setSize(Math.max(this.labelSize.width, ps.width), Math.max(this.labelSize.height, ps.height));
        this.labels.add(translabel);
        this.transparency = new JSlider(0, 0, 100, this.fillStyle.getFillTrans());
        this.transparency.addChangeListener(this);
        this.transparency.setMajorTickSpacing(25);
        this.transparency.setMinorTickSpacing(5);
        this.transparency.setPaintTicks(true);
        transparencyPanel.add(this.transparency);
        transparencyPanel.add(Box.createHorizontalGlue());
        this.add(transparencyPanel);
        this.setLabelPreferredSize(null);
        this.setWidgetPreferredSize(null);
        ps = this.transparency.getPreferredSize();
        this.transparency.setPreferredSize(new Dimension(this.widgetSize.width, ps.height));
    }

    @Override
    public void setValue(Object newValue) {
        if (!(newValue instanceof FillInterface)) {
            return;
        }
        this.fillStyle = (FillInterface)newValue;
        if (this.fillStyle instanceof DefaultFillInterface) {
            DefaultFillInterface das = (DefaultFillInterface)((Object)this.fillStyle);
            this.defaultFillColorSource = das.getDefaultFillColorSource();
            Color defaultFillColor = das.getDefaultFillColor();
            this.fillColor.setAutomatic(this.defaultFillColorSource, defaultFillColor);
            this.fillColor.updateUI();
            this.fillColor.setEditor(new ColorComboBoxEditor(this.defaultFillColorSource, defaultFillColor));
        }
        if (this.fstyle != null) {
            this.fstyle.removeActionListener(this);
            this.fstyle.setModel(new DefaultComboBoxModel<String>(((FillStyleElementInterface)((Object)this.fillStyle)).getAllFillStyleElements()));
            this.fstyle.setSelectedItem(((FillStyleElementInterface)((Object)this.fillStyle)).getFillStyleElement());
            this.fstyle.setEnabled(this.fstyle.getItemCount() > 1);
            this.fstyle.addActionListener(this);
        }
        Color c = this.fillStyle.getFillColor();
        this.fillColor.removeActionListener(this);
        if (c == null) {
            this.fillColor.setSelectedItem(this.defaultFillColorSource);
        } else {
            this.fillColor.setSelectedItem(c);
        }
        this.fillColor.addActionListener(this);
        this.transparency.removeChangeListener(this);
        this.transparency.setValue(this.fillStyle.getFillTrans());
        this.transparency.addChangeListener(this);
    }

    public void setFillOn(boolean fillOn) {
        this.transparency.setEnabled(fillOn);
        this.fillColor.setEnabled(fillOn);
        if (this.fstyle != null) {
            this.fstyle.setEnabled(fillOn);
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public void actionPerformed(ActionEvent e) {
        Container parent;
        JPanel panel;
        JColorChooser cc;
        Color save;
        block23: {
            String cmd;
            block22: {
                cmd = e.getActionCommand();
                if (!cmd.equals("fillcolor")) break block22;
                Object item = this.fillColor.getSelectedItem();
                if (item == null) return;
                save = this.fillStyle.getFillColor();
                if (!(item instanceof String)) {
                    if (!(item instanceof Color)) return;
                    this.fillStyle.setFillColor((Color)item);
                    return;
                }
                if (((String)item).equals(RB.getStringResource("morecolorsdots.txt"))) {
                    cc = UIUtil.colorChooser;
                    if (save == null) {
                        if (this.fillStyle instanceof DefaultFillInterface) {
                            cc.setColor(((DefaultFillInterface)((Object)this.fillStyle)).getDefaultFillColor());
                        }
                    } else {
                        cc.setColor(save);
                    }
                    cc.setPreviewPanel(new JPanel());
                    panel = new JPanel();
                    panel.setLayout(new BorderLayout());
                    panel.add(cc);
                    break block23;
                } else {
                    if (((String)item).equals(this.defaultFillColorSource)) {
                        this.fillStyle.setFillColor(null);
                        return;
                    }
                    Container c = this.getTopLevelAncestor();
                    if (c instanceof SGDialog) {
                        SGDialog sgd = (SGDialog)c;
                        sgd.value = -1;
                        this.dialog = sgd.makeDisabledCopy(this.colorGrabber);
                        c.setVisible(false);
                        this.dialog.setVisible(true);
                    }
                    c = this.colorGrabber.grabComponent.getTopLevelAncestor();
                    c.requestFocus();
                    if (this.dialog != null) {
                        this.dialog.toFront();
                    }
                    this.colorGrabber.setMouseEventListener();
                    this.colorGrabber.addActionListener(this);
                    if (save == null) {
                        this.colorGrabber.setStartColor(this.defaultFillColorSource);
                        return;
                    }
                    this.colorGrabber.setStartColor(save);
                    return;
                }
            }
            if (cmd.equals("colorpicker:done")) {
                Object color = ((SwatchActionEvent)e).getValue();
                this.fillColor.setSelectedItem(color);
                this.colorGrabber.removeMouseEventListener();
                this.colorGrabber.removeActionListener(this);
                if (this.dialog == null) return;
                this.dialog.dispose();
                return;
            }
            if (cmd.equals("colorpicker:updating")) {
                int i;
                Color color = (Color)((SwatchActionEvent)e).getValue();
                if (color == null) return;
                ActionListener[] listener = this.fillColor.getActionListeners();
                for (i = 0; i < listener.length; ++i) {
                    this.fillColor.removeActionListener(listener[i]);
                }
                this.fillColor.setSelectedItem(color);
                i = 0;
                while (i < listener.length) {
                    this.fillColor.addActionListener(listener[i]);
                    ++i;
                }
                return;
            }
            if (!cmd.equals("fillstyle")) return;
            ((FillStyleElementInterface)((Object)this.fillStyle)).setFillStyleElement((String)this.fstyle.getSelectedItem());
            Color c = this.fillStyle.getFillColor();
            this.fillColor.removeActionListener(this);
            if (c != null) {
                this.fillColor.setSelectedItem(c);
            } else {
                this.fillColor.setSelectedItem(this.defaultFillColorSource);
            }
            this.fillColor.addActionListener(this);
            return;
        }
        for (parent = this.getParent(); parent != null && !(parent instanceof JFrame); parent = parent.getParent()) {
        }
        int result = SGDialog.showInputDialog((JFrame)parent, RB.getStringResource("morecolors.txt"), panel);
        if (result == 0) {
            Color newColor = cc.getColor();
            if (newColor == null) {
                if (save == null) {
                    this.fillColor.setSelectedItem(this.defaultFillColorSource);
                    return;
                }
                this.fillColor.setSelectedItem(save);
                return;
            }
            if (save != null) {
                if (save.getRGB() == newColor.getRGB()) return;
            }
            this.fillStyle.setFillColor(newColor);
            this.fillColor.setSelectedItem(newColor);
            return;
        }
        if (save == null) {
            this.fillColor.setSelectedItem(this.defaultFillColorSource);
            return;
        }
        this.fillColor.setSelectedItem(save);
    }

    @Override
    public void stateChanged(ChangeEvent e) {
        int value1 = this.transparency.getModel().getValue();
        if (!this.transparency.getValueIsAdjusting()) {
            this.fillStyle.setFillTrans(value1);
        }
    }

    public void setTransparencyEnabled(boolean enable) {
        this.transparency.setEnabled(enable);
    }

    public void setEnabledAll(boolean state) {
        if (this.fillStyle instanceof ColorEditableInterface) {
            this.fillColor.setEnabled(state && ((ColorEditableInterface)((Object)this.fillStyle)).isFillColorEditable());
        } else {
            this.fillColor.setEnabled(state);
        }
        this.transparency.setEnabled(state);
        if (this.fstyle != null) {
            this.fstyle.setEnabled(state);
        }
    }
}

