/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.sg.ui;

import com.sas.graphics.sg.interfaces.DendrogramInterface;
import com.sas.graphics.sg.ui.ColorGrabber;
import com.sas.graphics.sg.ui.LineCustomizerPanel;
import com.sas.graphics.sg.ui.RB;
import com.sas.graphics.sg.ui.SGCustomizerPanel;
import com.sas.graphics.sg.ui.UIUtil;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class DendrogramCustomizerPanel
extends SGCustomizerPanel
implements ActionListener {
    private static final String RB_KEY = "DendrogramCustomizerPanel.";
    private static String[] tvalues = new String[]{RB.getStringResource("DendrogramCustomizerPanel.", "rectangular.txt"), RB.getStringResource("DendrogramCustomizerPanel.", "triangular.txt")};
    private static String[] values = new String[]{"rectangular", "triangular"};
    DendrogramInterface dendrogram;
    ColorGrabber colorGrabber = null;
    LineCustomizerPanel linePanel;
    private JComboBox type;

    public DendrogramCustomizerPanel(DendrogramInterface dendrogram) {
        this(dendrogram, null);
    }

    public DendrogramCustomizerPanel(DendrogramInterface dendrogram, ColorGrabber cg) {
        this.dendrogram = dendrogram;
        this.colorGrabber = cg;
        this.init();
    }

    private void init() {
        this.setLayout(new BoxLayout(this, 1));
        this.linePanel = new LineCustomizerPanel(this.dendrogram, this.colorGrabber);
        this.linePanel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), RB.getStringResource("sline.txt")), BorderFactory.createEmptyBorder(0, UIUtil.DLU * 7, 4 * UIUtil.DLU, 4 * UIUtil.DLU)));
        this.add(this.linePanel);
        this.add(Box.createRigidArea(new Dimension(0, 4 * UIUtil.DLU)));
        JPanel typePanel = new JPanel();
        typePanel.setLayout(new BoxLayout(typePanel, 0));
        typePanel.add(Box.createRigidArea(new Dimension(this.linePanel.getInsets().left, 0)));
        JLabel label = new JLabel(RB.getStringResource(RB_KEY, "treetype.txt"));
        typePanel.add(label);
        Dimension ps1 = this.linePanel.getLabelPreferredSize();
        Dimension ps2 = label.getPreferredSize();
        this.labelSize.setSize(Math.max(ps1.width, ps2.width), Math.max(ps1.height, ps2.height));
        this.labels.add(label);
        typePanel.add(Box.createRigidArea(new Dimension(3 * UIUtil.DLU, 0)));
        this.type = new JComboBox<String>(tvalues);
        this.type.setActionCommand("type");
        String value = this.dendrogram.getTreeType();
        int selected = 0;
        for (int i = 0; i < values.length; ++i) {
            if (!values[i].equalsIgnoreCase(value)) continue;
            selected = i;
            break;
        }
        this.type.setSelectedIndex(selected);
        typePanel.add(this.type);
        ps1 = this.type.getPreferredSize();
        ps2 = this.linePanel.getWidgetPreferredSize();
        this.widgetSize.setSize(Math.max(ps1.width, ps2.width), Math.max(ps1.height, ps2.height));
        this.widgets.add(this.type);
        typePanel.add(Box.createHorizontalGlue());
        this.type.addActionListener(this);
        this.add(typePanel);
        this.setLabelPreferredSize(this.labelSize);
        this.setWidgetPreferredSize(this.widgetSize);
        this.linePanel.setLabelPreferredSize(this.labelSize);
        this.linePanel.setWidgetPreferredSize(this.widgetSize);
    }

    @Override
    public void setValue(Object style) {
        if (!(style instanceof DendrogramInterface)) {
            return;
        }
        this.linePanel.setValue(style);
        this.dendrogram = (DendrogramInterface)style;
        this.type.removeActionListener(this);
        String value = this.dendrogram.getTreeType();
        for (int i = 0; i < values.length; ++i) {
            if (!values[i].equalsIgnoreCase(value)) continue;
            this.type.setSelectedIndex(i);
            break;
        }
        this.type.addActionListener(this);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        String cmd = e.getActionCommand();
        if (cmd.equals("type")) {
            int index = ((JComboBox)e.getSource()).getSelectedIndex();
            String value = values[index];
            this.dendrogram.setTreeType(value);
        } else {
            this.linePanel.actionPerformed(e);
        }
    }
}

