/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.sg.ui;

import com.sas.graphics.sg.interfaces.DecisionTreeInterface;
import com.sas.graphics.sg.interfaces.DefaultDecisionTreeInterface;
import com.sas.graphics.sg.interfaces.TextInterface;
import com.sas.graphics.sg.ui.ColorComboBoxEditor;
import com.sas.graphics.sg.ui.ColorGrabber;
import com.sas.graphics.sg.ui.CompTitledBorder;
import com.sas.graphics.sg.ui.FillCustomizerPanel;
import com.sas.graphics.sg.ui.LineCustomizerPanel;
import com.sas.graphics.sg.ui.RB;
import com.sas.graphics.sg.ui.SGCustomizerPanel;
import com.sas.graphics.sg.ui.SimpleTextCustomizerPanel;
import com.sas.graphics.sg.ui.UIUtil;
import com.sas.text.Message;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.border.Border;
import javax.swing.border.CompoundBorder;
import javax.swing.border.LineBorder;
import javax.swing.border.TitledBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class DecisionTreeCustomizerPanel
extends SGCustomizerPanel
implements ChangeListener,
ActionListener {
    private static final String RB_KEY = "DecisionTreeCustomizerPanel.";
    private static final Border lineBorder = new CompoundBorder(new LineBorder(Color.GRAY), UIUtil.tabBorder);
    private static String[] lvalues = new String[]{RB.getStringResource("DecisionTreeCustomizerPanel.", "curved.txt"), RB.getStringResource("DecisionTreeCustomizerPanel.", "spline.txt"), RB.getStringResource("DecisionTreeCustomizerPanel.", "orthogonal.txt"), RB.getStringResource("DecisionTreeCustomizerPanel.", "direct.txt")};
    private static String[] values = new String[]{"curved", "spline", "orthogonal", "direct"};
    private static String[] ltextAttrs = new String[]{RB.getStringResource("DecisionTreeCustomizerPanel.", "nodeTitle.txt"), RB.getStringResource("DecisionTreeCustomizerPanel.", "inputNodelabel.txt"), RB.getStringResource("DecisionTreeCustomizerPanel.", "outputNodelabel.txt"), RB.getStringResource("DecisionTreeCustomizerPanel.", "detailsNodelabel.txt")};
    private DecisionTreeInterface decisionTree;
    ColorGrabber colorGrabber = null;
    private SimpleTextCustomizerPanel textPanel;
    JTabbedPane tabbedPane;
    LineCustomizerPanel linePanel;
    LineCustomizerPanel outlinePanel;
    FillCustomizerPanel nodeFillPanel;
    FillCustomizerPanel linkFillPanel;
    JComboBox linkType;
    JComboBox textType;
    int defaultLinkIndex = -1;
    CompTitledBorder textBorder = null;
    JPanel titleBorderPanel = null;

    public DecisionTreeCustomizerPanel(DecisionTreeInterface decisionTree) {
        this(decisionTree, null);
    }

    public DecisionTreeCustomizerPanel(DecisionTreeInterface decisionTree, ColorGrabber cg) {
        Dimension ps2;
        JComponent c;
        int i;
        String[] dlvalues;
        this.decisionTree = decisionTree;
        this.colorGrabber = cg;
        this.setLayout(new BoxLayout(this, 1));
        this.tabbedPane = new JTabbedPane(1, 0);
        JPanel nodePanel = new JPanel();
        nodePanel.setLayout(new BoxLayout(nodePanel, 1));
        this.nodeFillPanel = new FillCustomizerPanel(decisionTree);
        nodePanel.add(this.nodeFillPanel);
        nodePanel.add(Box.createRigidArea(new Dimension(0, 4 * UIUtil.DLU)));
        this.nodeFillPanel.setBorder(new TitledBorder(lineBorder, RB.getStringResource(RB_KEY, "nodeFill.txt")));
        this.outlinePanel = new LineCustomizerPanel(decisionTree);
        this.outlinePanel.setBorder(new TitledBorder(lineBorder, RB.getStringResource(RB_KEY, "nodeOutline.txt")));
        nodePanel.add(this.outlinePanel);
        nodePanel.setBorder(UIUtil.tabbedBorder);
        nodePanel.add(Box.createVerticalGlue());
        this.tabbedPane.addTab(RB.getStringResource(RB_KEY, "node.txt"), nodePanel);
        this.tabbedPane.setMnemonicAt(0, 49);
        JPanel linkPanel = new JPanel();
        linkPanel.setLayout(new BoxLayout(linkPanel, 1));
        linkPanel.setBorder(UIUtil.tabBorder);
        JPanel typePanel = new JPanel();
        typePanel.setLayout(new BoxLayout(typePanel, 0));
        typePanel.add(Box.createRigidArea(new Dimension(UIUtil.MARGIN + 4 * UIUtil.DLU, 0)));
        JLabel label = new JLabel(RB.getStringResource("type.txt"));
        typePanel.add(label);
        Dimension ps = label.getPreferredSize();
        ps.width = Math.max(this.labelSize.width, ps.width);
        ps.height = UIUtil.DEFAULT_LABEL_HEIGHT;
        label.setPreferredSize(ps);
        label.setSize(ps);
        this.labelSize.setSize(ps);
        this.labels.add(label);
        typePanel.add(Box.createRigidArea(new Dimension(3 * UIUtil.DLU, 0)));
        if (decisionTree instanceof DefaultDecisionTreeInterface) {
            dlvalues = new String[lvalues.length];
            String defaultLinkType = ((DefaultDecisionTreeInterface)((Object)decisionTree)).getDefaultDecisionTreeLinkType();
            for (int i2 = 0; i2 < values.length; ++i2) {
                if (defaultLinkType.equalsIgnoreCase(values[i2])) {
                    this.defaultLinkIndex = i2;
                    dlvalues[i2] = Message.format((String)RB.getStringResource("automatic.fmt.txt"), (Object)lvalues[i2]);
                    continue;
                }
                dlvalues[i2] = lvalues[i2];
            }
        } else {
            dlvalues = lvalues;
        }
        this.linkType = new JComboBox<String>(dlvalues);
        this.linkType.setActionCommand("type");
        String value = decisionTree.getDecisionTreeLinkType();
        boolean enableFill = false;
        int index = 0;
        if (value == null || value.length() == 0) {
            index = this.defaultLinkIndex;
        } else {
            for (int i3 = 0; i3 < values.length; ++i3) {
                if (!value.equalsIgnoreCase(values[i3])) continue;
                index = i3;
                break;
            }
        }
        this.linkType.setSelectedIndex(index);
        enableFill = index < 2;
        typePanel.add(this.linkType);
        ps = this.linkType.getPreferredSize();
        ps.width = Math.max(this.widgetSize.width, ps.width);
        ps.height = UIUtil.DEFAULT_WIDGET_HEIGHT;
        this.linkType.setPreferredSize(ps);
        this.linkType.setSize(ps);
        this.widgets.add(this.linkType);
        typePanel.add(Box.createHorizontalGlue());
        this.linkType.addActionListener(this);
        linkPanel.add(Box.createRigidArea(new Dimension(0, UIUtil.MARGIN)));
        linkPanel.add(typePanel);
        linkPanel.add(Box.createRigidArea(new Dimension(0, 4 * UIUtil.DLU)));
        this.linePanel = new LineCustomizerPanel(decisionTree);
        linkPanel.add(this.linePanel);
        linkPanel.add(Box.createRigidArea(new Dimension(0, 4 * UIUtil.DLU)));
        this.linePanel.setBorder(new TitledBorder(lineBorder, RB.getStringResource(RB_KEY, "linkLine.txt")));
        this.linkFillPanel = new FillCustomizerPanel(decisionTree);
        linkPanel.add(this.linkFillPanel);
        this.linkFillPanel.setBorder(new TitledBorder(lineBorder, RB.getStringResource(RB_KEY, "linkFill.txt")));
        if (enableFill) {
            this.linePanel.color.setEnabled(false);
            this.linePanel.lstyle.setEnabled(false);
            this.linePanel.thickness.setEnabled(false);
        } else {
            this.linkFillPanel.fillColor.setEnabled(false);
            this.linkFillPanel.transparency.setEnabled(false);
            this.linePanel.thickness.setEnabled(decisionTree.isLinkSizeEditable());
        }
        linkPanel.add(Box.createVerticalGlue());
        this.tabbedPane.addTab(RB.getStringResource(RB_KEY, "link.txt"), linkPanel);
        this.tabbedPane.setMnemonicAt(1, 50);
        JPanel tPanel = this.createTextPanel();
        this.tabbedPane.addTab(RB.getStringResource(RB_KEY, "text.txt"), tPanel);
        this.tabbedPane.setMnemonicAt(2, 51);
        this.tabbedPane.addChangeListener(this);
        this.labels.addAll(this.linePanel.getLabels());
        this.labels.addAll(this.outlinePanel.getLabels());
        this.labels.addAll(this.nodeFillPanel.getLabels());
        this.labels.addAll(this.linkFillPanel.getLabels());
        this.widgets.addAll(this.linePanel.getWidgets());
        this.widgets.addAll(this.outlinePanel.getWidgets());
        this.widgets.addAll(this.nodeFillPanel.getWidgets());
        this.widgets.addAll(this.linkFillPanel.getWidgets());
        this.add(this.tabbedPane);
        ps = new Dimension(UIUtil.DEFAULT_LABEL_WIDTH, UIUtil.DEFAULT_LABEL_HEIGHT);
        for (i = 0; i < this.labels.size(); ++i) {
            c = (JComponent)this.labels.get(i);
            ps2 = c.getPreferredSize();
            ps.width = Math.max(ps.width, ps2.width);
            ps.height = Math.max(ps.height, ps2.height);
        }
        this.setLabelPreferredSize(ps);
        ps = new Dimension(UIUtil.DEFAULT_WIDGET_WIDTH, UIUtil.DEFAULT_WIDGET_HEIGHT);
        for (i = 0; i < this.widgets.size(); ++i) {
            c = (JComponent)this.widgets.get(i);
            ps2 = c.getPreferredSize();
            ps.width = Math.max(ps.width, ps2.width);
            ps.height = Math.max(ps.height, ps2.height);
        }
        this.setWidgetPreferredSize(ps);
    }

    public JPanel createTextPanel() {
        JPanel panel = new JPanel(){

            @Override
            public void doLayout() {
                Insets insets = this.getInsets();
                Rectangle rect = this.getBounds();
                rect.x = 0;
                rect.y = 0;
                if (DecisionTreeCustomizerPanel.this.textBorder == null) {
                    return;
                }
                Rectangle compR = DecisionTreeCustomizerPanel.this.textBorder.getComponentRect(rect, insets);
                DecisionTreeCustomizerPanel.this.titleBorderPanel.setBounds(compR);
                rect.x += insets.left;
                rect.y += insets.top;
                rect.width -= insets.left + insets.right;
                rect.height -= insets.top + insets.bottom;
                DecisionTreeCustomizerPanel.this.textPanel.setBounds(rect);
            }
        };
        this.titleBorderPanel = new JPanel();
        this.titleBorderPanel.setBorder(BorderFactory.createEmptyBorder(4 * UIUtil.DLU, 3 * UIUtil.DLU, 4 * UIUtil.DLU, 2 * UIUtil.DLU));
        this.titleBorderPanel.setLayout(new BoxLayout(this.titleBorderPanel, 0));
        JLabel titleLabel = new JLabel(RB.getStringResource(RB_KEY, "textAttrs.txt"));
        this.titleBorderPanel.add(titleLabel);
        this.titleBorderPanel.add(Box.createRigidArea(new Dimension(3 * UIUtil.DLU, 0)));
        this.textType = new JComboBox<String>(ltextAttrs);
        this.textType.setSelectedIndex(0);
        this.textType.addActionListener(this);
        this.textType.setActionCommand("text");
        Dimension pref = this.textType.getPreferredSize();
        this.textType.setPreferredSize(new Dimension(pref.width + 20, pref.height));
        this.titleBorderPanel.add(this.textType);
        int dlu7 = UIUtil.DLU * 7;
        CompoundBorder border = BorderFactory.createCompoundBorder(BorderFactory.createEmptyBorder(11 * UIUtil.DLU, dlu7, dlu7, dlu7), new LineBorder(Color.GRAY));
        this.textBorder = new CompTitledBorder((Border)border, this.titleBorderPanel);
        panel.setBorder(this.textBorder);
        panel.setLayout(null);
        panel.add(this.titleBorderPanel);
        this.textPanel = new SimpleTextCustomizerPanel(this.decisionTree.getNodeTitleTextStyle(), this.colorGrabber);
        panel.add(this.textPanel);
        Dimension ps1 = this.getPreferredSize();
        Dimension ps2 = this.textPanel.getPreferredSize();
        panel.add(this.textPanel);
        panel.add(Box.createVerticalGlue());
        panel.setPreferredSize(new Dimension(ps2.width + 28 * UIUtil.DLU, ps1.height + ps2.height + 56 * UIUtil.DLU));
        return panel;
    }

    @Override
    public void stateChanged(ChangeEvent e) {
        if (this.tabbedPane.getSelectedIndex() == 1) {
            this.decisionTree.setAttrState(1);
        } else {
            this.decisionTree.setAttrState(0);
        }
    }

    @Override
    public void setValue(Object newValue) {
        String[] dlvalues;
        if (!(newValue instanceof DecisionTreeInterface)) {
            return;
        }
        this.decisionTree = (DecisionTreeInterface)newValue;
        this.decisionTree.setAttrState(1);
        this.linkFillPanel.setValue(this.decisionTree);
        this.linePanel.setValue(this.decisionTree);
        this.decisionTree.setAttrState(0);
        this.nodeFillPanel.setValue(this.decisionTree);
        this.outlinePanel.setValue(this.decisionTree);
        if (this.tabbedPane.getSelectedIndex() == 1) {
            this.decisionTree.setAttrState(1);
        }
        if (this.decisionTree.hasNodeTitles()) {
            this.textType.setSelectedIndex(0);
        } else if (this.decisionTree.hasNodeInputLabels()) {
            this.textType.setSelectedIndex(1);
        } else if (this.decisionTree.hasNodeOutputLabels()) {
            this.textType.setSelectedIndex(2);
        } else if (this.decisionTree.hasNodeDetails()) {
            this.textType.setSelectedIndex(3);
        } else {
            this.textType.setSelectedIndex(0);
        }
        this.linkType.removeActionListener(this);
        if (this.decisionTree instanceof DefaultDecisionTreeInterface) {
            dlvalues = new String[lvalues.length];
            String defaultLinkType = ((DefaultDecisionTreeInterface)((Object)this.decisionTree)).getDefaultDecisionTreeLinkType();
            for (int i = 0; i < values.length; ++i) {
                if (defaultLinkType.equalsIgnoreCase(values[i])) {
                    this.defaultLinkIndex = i;
                    dlvalues[i] = Message.format((String)RB.getStringResource("automatic.fmt.txt"), (Object)lvalues[i]);
                    continue;
                }
                dlvalues[i] = lvalues[i];
            }
        } else {
            dlvalues = lvalues;
        }
        this.linkType.setModel(new DefaultComboBoxModel<String>(dlvalues));
        String value = this.decisionTree.getDecisionTreeLinkType();
        boolean enableFill = false;
        int index = 0;
        if (value == null || value.length() == 0) {
            index = this.defaultLinkIndex;
        } else {
            for (int i = 0; i < values.length; ++i) {
                if (!value.equalsIgnoreCase(values[i])) continue;
                index = i;
                break;
            }
        }
        this.linkType.setSelectedIndex(index);
        enableFill = index < 2;
        this.linePanel.color.setEnabled(!enableFill);
        this.linePanel.lstyle.setEnabled(!enableFill);
        this.linePanel.thickness.setEnabled(!enableFill && this.decisionTree.isLinkSizeEditable());
        this.linkFillPanel.fillColor.setEnabled(enableFill);
        this.linkFillPanel.transparency.setEnabled(enableFill);
        this.linkType.addActionListener(this);
    }

    private void updateTextPanel() {
        int newIndex = this.textType.getSelectedIndex();
        TextInterface textObject = null;
        switch (newIndex) {
            case 0: {
                textObject = this.decisionTree.getNodeTitleTextStyle();
                break;
            }
            case 1: {
                textObject = this.decisionTree.getNodeInputLabelTextStyle();
                break;
            }
            case 2: {
                textObject = this.decisionTree.getNodeOutputLabelTextStyle();
                break;
            }
            case 3: {
                textObject = this.decisionTree.getNodeDetailsTextStyle();
                break;
            }
        }
        if (textObject != null) {
            this.textPanel.setValue(textObject);
            this.textPanel.color.setEditor(new ColorComboBoxEditor(this.textPanel.color.autoLabel, (Color)this.textPanel.color.autoValue));
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        String cmd = e.getActionCommand();
        if (cmd.equals("type")) {
            Object src = e.getSource();
            int index = ((JComboBox)src).getSelectedIndex();
            String value = values[index];
            boolean enableFill = index < 2;
            this.decisionTree.setDecisionTreeLinkType(value);
            this.linePanel.color.setEnabled(!enableFill);
            this.linePanel.lstyle.setEnabled(!enableFill);
            this.linePanel.thickness.setEnabled(!enableFill && this.decisionTree.isLinkSizeEditable());
            this.linkFillPanel.fillColor.setEnabled(enableFill);
            this.linkFillPanel.transparency.setEnabled(enableFill);
        } else if (cmd.equals("text")) {
            this.updateTextPanel();
            this.repaint();
        }
    }
}

