/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.sg.ui;

import com.sas.graphics.sg.interfaces.ContourInterface;
import com.sas.graphics.sg.interfaces.DefaultContourInterface;
import com.sas.graphics.sg.ui.ColorGrabber;
import com.sas.graphics.sg.ui.LineCustomizerPanel;
import com.sas.graphics.sg.ui.MyCheckBox;
import com.sas.graphics.sg.ui.RB;
import com.sas.graphics.sg.ui.UIUtil;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class ContourCustomizerPanel
extends LineCustomizerPanel {
    public static final String RB_KEY = "ContourCustomizerPanel.";
    ContourInterface contour;
    private JCheckBox reverse;
    private JComboBox type;
    private static String[] lvalues = new String[]{RB.getStringResource("sline.txt"), RB.getStringResource("ContourCustomizerPanel.", "labeledline.txt"), RB.getStringResource("sfill.txt"), RB.getStringResource("ContourCustomizerPanel.", "gradient.txt")};
    private static String[] values = new String[]{"", "line", "labeledline", "fill", "gradient"};

    public ContourCustomizerPanel(ContourInterface contour) {
        this(contour, null);
    }

    public ContourCustomizerPanel(ContourInterface contour, ColorGrabber cg) {
        this.lineStyle = contour;
        this.contour = contour;
        this.colorGrabber = cg;
        this.setLayout(new BoxLayout(this, 1));
        this.init();
    }

    @Override
    protected void init() {
        JPanel typePanel = new JPanel();
        typePanel.setLayout(new BoxLayout(typePanel, 0));
        JLabel label = new JLabel(RB.getStringResource("type.txt"));
        typePanel.add(label);
        Dimension ps = label.getPreferredSize();
        this.labelSize.setSize(Math.max(this.labelSize.width, ps.width), Math.max(this.labelSize.height, ps.height));
        this.labels.add(label);
        typePanel.add(Box.createRigidArea(new Dimension(3 * UIUtil.DLU, 0)));
        if (this.contour instanceof DefaultContourInterface) {
            String[] dlvalues = new String[5];
            dlvalues[0] = RB.getStringResource("automatic.txt");
            System.arraycopy(lvalues, 0, dlvalues, 1, 4);
            this.type = new JComboBox<String>(dlvalues);
        } else {
            this.type = new JComboBox<String>(lvalues);
        }
        this.type.setActionCommand("type");
        String value = this.contour.getContourType();
        if (value == null || value.length() == 0) {
            this.type.setSelectedIndex(0);
        } else {
            for (int i = 1; i < values.length; ++i) {
                if (!value.equalsIgnoreCase(values[i])) continue;
                if (this.contour instanceof DefaultContourInterface) {
                    this.type.setSelectedIndex(i);
                    break;
                }
                this.type.setSelectedIndex(i);
                break;
            }
        }
        typePanel.add(this.type);
        ps = this.type.getPreferredSize();
        this.widgetSize.setSize(Math.max(this.widgetSize.width, ps.width), Math.max(this.widgetSize.height, ps.height));
        this.widgets.add(this.type);
        typePanel.add(Box.createHorizontalGlue());
        this.type.addActionListener(this);
        this.add(typePanel);
        this.add(Box.createRigidArea(new Dimension(0, 4 * UIUtil.DLU)));
        JPanel reversePanel = new JPanel();
        reversePanel.setLayout(new BoxLayout(reversePanel, 0));
        this.reverse = new MyCheckBox(RB.getStringResource(RB_KEY, "reverseGradient.txt"));
        this.reverse.setSelected(this.contour.isReverseColorRamp());
        this.reverse.setEnabled(this.contour.hasRamp());
        this.reverse.addActionListener(this);
        this.reverse.setActionCommand("reverse");
        reversePanel.add(this.reverse);
        reversePanel.add(Box.createHorizontalGlue());
        this.add(reversePanel);
        this.add(Box.createRigidArea(new Dimension(0, 4 * UIUtil.DLU)));
        super.init();
        this.setEnabledAll(this.contour.hasLine());
        this.add(Box.createVerticalGlue());
    }

    @Override
    public void setValue(Object obj) {
        if (!(obj instanceof ContourInterface)) {
            return;
        }
        this.contour = (ContourInterface)obj;
        this.type.removeActionListener(this);
        this.type.removeAllItems();
        if (this.contour instanceof DefaultContourInterface) {
            String defvalue = RB.getStringResource("automatic.txt");
            this.type.addItem(defvalue);
        }
        for (int i = 0; i < 4; ++i) {
            this.type.addItem(lvalues[i]);
        }
        String value = this.contour.getContourType();
        if (value == null || value.length() == 0) {
            this.type.setSelectedIndex(0);
        } else {
            for (int i = 1; i < values.length; ++i) {
                if (!value.equalsIgnoreCase(values[i])) continue;
                if (this.contour instanceof DefaultContourInterface) {
                    this.type.setSelectedIndex(i);
                    break;
                }
                this.type.setSelectedIndex(i);
                break;
            }
        }
        this.type.addActionListener(this);
        this.reverse.removeActionListener(this);
        this.reverse.setSelected(this.contour.isReverseColorRamp());
        this.reverse.setEnabled(this.contour.hasRamp());
        this.reverse.addActionListener(this);
        super.setValue(this.contour);
        this.setEnabledAll(this.contour.hasLine());
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        String cmd = e.getActionCommand();
        Object src = e.getSource();
        if (cmd.equals("type")) {
            int index = ((JComboBox)src).getSelectedIndex();
            String value = this.contour instanceof DefaultContourInterface ? values[index] : values[index + 1];
            this.contour.setContourType(value);
            this.reverse.setEnabled(this.contour.hasRamp());
            this.setEnabledAll(this.contour.hasLine());
        } else if (cmd.equals("reverse")) {
            this.contour.reverseColorRamp();
        } else {
            super.actionPerformed(e);
        }
    }
}

