/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.sg.ui;

import com.sas.graphics.sg.ui.UIUtil;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Rectangle;
import javax.swing.JComponent;
import javax.swing.border.Border;
import javax.swing.border.TitledBorder;

public class CompTitledBorder
extends TitledBorder {
    protected JComponent component;

    public CompTitledBorder(JComponent component) {
        this(null, component, 1, 2);
    }

    public CompTitledBorder(Border border) {
        this(border, (JComponent)null, 1, 2);
    }

    public CompTitledBorder(Border border, JComponent component) {
        this(border, component, 1, 2);
    }

    public CompTitledBorder(Border border, JComponent component, int titleJustification, int titlePosition) {
        super(border, null, titleJustification, titlePosition, null, null);
        this.component = component;
        if (border == null) {
            this.border = super.getBorder();
        }
    }

    @Override
    public void paintBorder(Component c, Graphics g, int x, int y, int width, int height) {
        Rectangle borderR = new Rectangle(x + 2, y + 2, width - 4, height - 4);
        Insets borderInsets = this.border != null ? this.border.getBorderInsets(c) : new Insets(0, 0, 0, 0);
        Rectangle rect = new Rectangle(x, y, width, height);
        Insets insets = this.getBorderInsets(c);
        Rectangle compR = this.getComponentRect(rect, insets);
        switch (this.titlePosition) {
            case 1: {
                int diff = compR.height + 2;
                borderR.y += diff;
                borderR.height -= diff;
                break;
            }
            case 0: 
            case 2: {
                int diff = insets.top / 2 - borderInsets.top - 2;
                borderR.y += diff;
                borderR.height -= diff;
                break;
            }
            case 3: 
            case 4: {
                break;
            }
            case 5: {
                int diff = insets.bottom / 2 - borderInsets.bottom - 2;
                borderR.height -= diff;
                break;
            }
            case 6: {
                int diff = compR.height + 2;
                borderR.height -= diff;
            }
        }
        this.border.paintBorder(c, g, borderR.x, borderR.y, borderR.width, borderR.height);
        Color col = g.getColor();
        g.setColor(c.getBackground());
        g.fillRect(compR.x, compR.y, compR.width, compR.height);
        g.setColor(col);
        this.component.repaint();
    }

    @Override
    public Insets getBorderInsets(Component c, Insets insets) {
        Insets borderInsets = this.border != null ? this.border.getBorderInsets(c) : new Insets(0, 0, 0, 0);
        insets.top = 4 + borderInsets.top;
        insets.right = 4 + borderInsets.right;
        insets.bottom = 4 + borderInsets.bottom;
        insets.left = 4 + borderInsets.left;
        if (c == null || this.component == null) {
            return insets;
        }
        int compHeight = 0;
        if (this.component != null) {
            compHeight = this.component.getPreferredSize().height;
        }
        switch (this.titlePosition) {
            case 1: {
                insets.top += compHeight + 2;
                break;
            }
            case 0: 
            case 2: {
                insets.top += Math.max(compHeight, borderInsets.top) - borderInsets.top;
                break;
            }
            case 3: {
                insets.top += compHeight + 2;
                break;
            }
            case 4: {
                insets.bottom += compHeight + 2;
                break;
            }
            case 5: {
                insets.bottom += Math.max(compHeight, borderInsets.bottom) - borderInsets.bottom;
                break;
            }
            case 6: {
                insets.bottom += compHeight + 2;
            }
        }
        return insets;
    }

    public JComponent getTitleComponent() {
        return this.component;
    }

    public void setTitleComponent(JComponent component) {
        this.component = component;
    }

    public Rectangle getComponentRect(Rectangle rect, Insets borderInsets) {
        Dimension compD = this.component.getPreferredSize();
        Rectangle compR = this.titleJustification == 1 ? new Rectangle(3 * UIUtil.DLU, 0, compD.width, compD.height) : new Rectangle(0, 0, compD.width + 3 * UIUtil.DLU, compD.height);
        switch (this.titlePosition) {
            case 1: {
                compR.y = 2;
                break;
            }
            case 0: 
            case 2: {
                compR.y = 2 + (borderInsets.top - 2 - 2 - compD.height) / 2;
                break;
            }
            case 3: {
                compR.y = borderInsets.top - compD.height - 2;
                break;
            }
            case 4: {
                compR.y = rect.height - borderInsets.bottom + 2;
                break;
            }
            case 5: {
                compR.y = rect.height - borderInsets.bottom + 2 + (borderInsets.bottom - 2 - 2 - compD.height) / 2;
                break;
            }
            case 6: {
                compR.y = rect.height - compD.height - 2;
            }
        }
        switch (this.titleJustification) {
            case 0: 
            case 1: {
                compR.x = 5 + borderInsets.left;
                break;
            }
            case 3: {
                compR.x = rect.width - borderInsets.right - 5 - compR.width;
                break;
            }
            case 2: {
                compR.x = (rect.width - compR.width) / 2;
            }
        }
        return compR;
    }
}

