/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.sg.ui;

import com.sas.graphics.sg.ui.CompTitledBorder;
import com.sas.graphics.sg.ui.RB;
import com.sas.graphics.sg.ui.RangeMenu;
import com.sas.graphics.sg.ui.UIUtil;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.ItemSelectable;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.font.FontRenderContext;
import java.awt.font.GlyphVector;
import java.awt.geom.AffineTransform;
import java.awt.geom.NoninvertibleTransformException;
import java.awt.geom.RectangularShape;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.HashMap;
import javax.accessibility.Accessible;
import javax.swing.AbstractAction;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.InputMap;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollBar;
import javax.swing.KeyStroke;
import javax.swing.UIManager;
import javax.swing.border.Border;

public class CharacterGrid
extends JPanel
implements AdjustmentListener,
ItemSelectable {
    public static final String RB_KEY = "CharacterGrid.";
    static final Color backColor = UIManager.getColor("TextPane.background");
    static final Color foreground = UIManager.getColor("TextPane.foreground");
    static final Color hiliteBackground = UIManager.getColor("TextPane.selectionBackground");
    static final Color hiliteForeground = UIManager.getColor("TextPane.selectionForeground");
    static final Font labelFont = UIManager.getFont("TextPane.font");
    static final Border border = UIManager.getBorder("TextPane.border");
    private int currMouseOverChar = -1;
    private final JScrollBar verticalBar;
    private RangeMenu rangeMenu;
    private String family;
    private int fontSize;
    private int fontStyle;
    private Font valueFont;
    private boolean useAntialias = true;
    private boolean useFractional = true;
    private boolean updateFontMetrics = true;
    private boolean updateBackBuffer = true;
    private int[] drawRange = null;
    private FontCanvas fc;
    private JPanel panel;
    CompTitledBorder titleBorder;
    HashMap charmap = new HashMap();
    private ArrayList listeners = new ArrayList();

    public CharacterGrid(Font font) {
        this.family = font.getFamily();
        this.fontSize = labelFont.getSize();
        this.fontStyle = labelFont.getStyle();
        this.valueFont = new Font(this.family, this.fontStyle, this.fontSize);
        JPanel titlePanel = new JPanel();
        titlePanel.setLayout(new BoxLayout(titlePanel, 0));
        JLabel titleLabel = new JLabel(RB.getStringResource(RB_KEY, "range.txt"));
        titlePanel.add(titleLabel);
        titlePanel.add(Box.createRigidArea(new Dimension(3 * UIUtil.DLU, 0)));
        this.rangeMenu = new RangeMenu();
        Dimension pref = this.rangeMenu.getPreferredSize();
        this.rangeMenu.setPreferredSize(new Dimension(pref.width + 20, pref.height));
        this.rangeMenu.setMaximumSize(this.rangeMenu.getPreferredSize());
        titlePanel.add(this.rangeMenu);
        titlePanel.add(Box.createHorizontalGlue());
        this.rangeMenu.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                CharacterGrid.this.updateRange();
            }
        });
        this.verticalBar = new JScrollBar(1);
        this.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent e) {
                CharacterGrid.this.updateBackBuffer = true;
                CharacterGrid.this.updateFontMetrics = true;
            }
        });
        this.fc = new FontCanvas();
        this.fc.setFocusable(true);
        this.panel = new JPanel();
        this.panel.setLayout(new BoxLayout(this.panel, 0));
        this.panel.setBorder(this.rangeMenu.getBorder());
        this.panel.add(this.fc);
        this.panel.add(this.verticalBar);
        this.setLayout(new BoxLayout(this, 1));
        this.add(titlePanel);
        this.add(Box.createRigidArea(new Dimension(0, 4 * UIUtil.DLU)));
        this.add(this.panel);
        this.verticalBar.addAdjustmentListener(this);
    }

    private void updateRange() {
        int[] actualRange = this.rangeMenu.getSelectedRange();
        this.charmap.clear();
        int index = -1;
        FontRenderContext frc = ((Graphics2D)this.getGraphics()).getFontRenderContext();
        for (int i = actualRange[0]; i <= actualRange[1]; ++i) {
            GlyphVector gv = this.valueFont.createGlyphVector(frc, new char[]{(char)i});
            if (gv.getNumGlyphs() == 1 && (gv.getGlyphCode(0) == 0 || gv.getGlyphCode(0) == 65535)) continue;
            this.charmap.put(Integer.toString(++index), new Integer(i));
        }
        if (index < 1) {
            index = 1;
        }
        if (this.drawRange == null) {
            this.drawRange = new int[]{0, index};
        } else {
            this.drawRange[1] = index;
        }
        this.updateFontMetrics = true;
        this.updateBackBuffer = true;
        this.fc.repaint();
    }

    @Override
    public Dimension getPreferredSize() {
        return new Dimension(300, 150);
    }

    public void setFontFamily(String family) {
        if (this.family.equals(family)) {
            return;
        }
        this.family = family;
        this.valueFont = new Font(family, this.fontStyle, this.fontSize);
        this.updateBackBuffer = true;
        this.updateFontMetrics = true;
        this.drawRange = null;
        this.fc.repaint();
    }

    public void setRenderingHints(boolean aa, boolean fm) {
        this.useAntialias = aa;
        this.useFractional = fm;
        this.updateBackBuffer = true;
        this.updateFontMetrics = true;
        this.fc.repaint();
    }

    @Override
    public void adjustmentValueChanged(AdjustmentEvent e) {
        this.updateBackBuffer = true;
        this.fc.repaint();
    }

    @Override
    public void addItemListener(ItemListener l) {
        this.listeners.add(l);
    }

    @Override
    public void removeItemListener(ItemListener l) {
        this.listeners.remove(l);
    }

    @Override
    public Object[] getSelectedObjects() {
        Object[] sel = new Integer[]{this.charmap.get(Integer.toString(this.currMouseOverChar))};
        return sel;
    }

    ItemSelectable getSelectable() {
        return this;
    }

    @Override
    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        this.fc.setEnabled(enabled);
        this.rangeMenu.setEnabled(enabled);
    }

    class MovingAction
    extends AbstractAction {
        int direction;
        FontCanvas component;

        MovingAction(FontCanvas fc, int dir) {
            this.component = fc;
            this.direction = dir;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            this.component.updateCurrent(this.direction);
        }
    }

    private class FontCanvas
    extends JPanel
    implements MouseListener,
    MouseMotionListener,
    FocusListener,
    Accessible {
        private int numCharAcross;
        private int numCharDown;
        private int drawStart;
        private int drawEnd;
        private int drawLimit;
        private int maxAscent;
        private int maxDescent;
        private int gridWidth = 0;
        private int gridHeight = 0;
        private int canvasInset_X = 0;
        private int canvasInset_Y = 0;
        private BufferedImage backBuffer = null;
        private int currMouseOverChar = -1;
        private int prevMouseOverChar = -1;
        private boolean firstTime = true;

        public FontCanvas() {
            this.addMouseListener(this);
            this.addMouseMotionListener(this);
            this.addFocusListener(this);
            this.setFocusable(true);
            this.addBindings();
        }

        protected void addBindings() {
            InputMap inputMap = this.getInputMap();
            MovingAction action = new MovingAction(this, 2);
            KeyStroke key = KeyStroke.getKeyStroke(66, 2);
            inputMap.put(key, action);
            key = KeyStroke.getKeyStroke(37, 0);
            inputMap.put(key, action);
            action = new MovingAction(this, 4);
            key = KeyStroke.getKeyStroke(70, 2);
            inputMap.put(key, action);
            key = KeyStroke.getKeyStroke(39, 0);
            inputMap.put(key, action);
            action = new MovingAction(this, 1);
            key = KeyStroke.getKeyStroke(80, 2);
            inputMap.put(key, action);
            key = KeyStroke.getKeyStroke(38, 0);
            inputMap.put(key, action);
            action = new MovingAction(this, 3);
            key = KeyStroke.getKeyStroke(78, 2);
            inputMap.put(key, action);
            key = KeyStroke.getKeyStroke(40, 0);
            inputMap.put(key, action);
        }

        @Override
        public void focusGained(FocusEvent e) {
            if (this.prevMouseOverChar != -1) {
                this.currMouseOverChar = this.prevMouseOverChar;
            } else {
                CharacterGrid.this.updateBackBuffer = true;
                this.currMouseOverChar = 0;
            }
            this.repaint();
        }

        @Override
        public void focusLost(FocusEvent e) {
            this.repaint();
        }

        public boolean firstTime() {
            return this.firstTime;
        }

        public void refresh() {
            this.firstTime = false;
            CharacterGrid.this.updateBackBuffer = true;
            this.repaint();
        }

        private void setParams(Graphics2D g2) {
            g2.setFont(CharacterGrid.this.valueFont);
            if (CharacterGrid.this.useAntialias) {
                g2.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
            } else {
                g2.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_OFF);
                g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
            }
            if (CharacterGrid.this.useFractional) {
                g2.setRenderingHint(RenderingHints.KEY_FRACTIONALMETRICS, RenderingHints.VALUE_FRACTIONALMETRICS_ON);
            } else {
                g2.setRenderingHint(RenderingHints.KEY_FRACTIONALMETRICS, RenderingHints.VALUE_FRACTIONALMETRICS_OFF);
            }
        }

        private void drawGrid(Graphics2D g2) {
            int i;
            int totalGridWidth = this.numCharAcross * this.gridWidth;
            int totalGridHeight = this.numCharDown * this.gridHeight;
            g2.setColor(this.getForeground());
            for (i = 0; i < this.numCharDown + 1; ++i) {
                g2.drawLine(this.canvasInset_X, i * this.gridHeight + this.canvasInset_Y, this.canvasInset_X + totalGridWidth, i * this.gridHeight + this.canvasInset_Y);
            }
            for (i = 0; i < this.numCharAcross + 1; ++i) {
                g2.drawLine(i * this.gridWidth + this.canvasInset_X, this.canvasInset_Y, i * this.gridWidth + this.canvasInset_X, this.canvasInset_Y + totalGridHeight);
            }
        }

        public void drawChar(Graphics2D g2, int charCode, int baseX, int baseY) {
            char[] oneChar = new char[]{(char)charCode};
            GlyphVector gv = CharacterGrid.this.valueFont.createGlyphVector(g2.getFontRenderContext(), oneChar);
            Rectangle r2d2 = gv.getPixelBounds(g2.getFontRenderContext(), 0.0f, 0.0f);
            int shiftedX = baseX;
            try {
                double[] pt = new double[]{((RectangularShape)r2d2).getX(), ((RectangularShape)r2d2).getY(), ((RectangularShape)r2d2).getX() + ((RectangularShape)r2d2).getWidth(), ((RectangularShape)r2d2).getY() + ((RectangularShape)r2d2).getHeight()};
                g2.getTransform().inverseTransform(pt, 0, pt, 0, 2);
                shiftedX = baseX - (int)(pt[2] / 2.0 + pt[0]);
            }
            catch (NoninvertibleTransformException pt) {
                // empty catch block
            }
            AffineTransform oldTx = g2.getTransform();
            g2.translate(shiftedX, baseY);
            if (CharacterGrid.this.valueFont.canDisplay((char)charCode)) {
                g2.setColor(foreground);
            } else {
                g2.setColor(Color.lightGray);
            }
            g2.drawChars(oneChar, 0, 1, 0, 0);
            g2.setTransform(oldTx);
        }

        private void resetScrollbar(int oldValue) {
            int numCharToDisplay = CharacterGrid.this.drawRange[1] - CharacterGrid.this.drawRange[0];
            if (numCharToDisplay <= this.numCharDown * this.numCharAcross) {
                CharacterGrid.this.verticalBar.setValues(0, this.numCharDown, 0, this.numCharDown);
                CharacterGrid.this.verticalBar.setEnabled(false);
            } else {
                int totalRows = (int)Math.ceil(1.0 * (double)numCharToDisplay / (double)this.numCharAcross);
                oldValue = Math.min(oldValue, totalRows - this.numCharDown);
                CharacterGrid.this.verticalBar.setValues(oldValue, this.numCharDown, 0, totalRows);
                CharacterGrid.this.verticalBar.setEnabled(true);
            }
        }

        private void calcFontMetrics(Graphics2D g2d, int w, int h) {
            Graphics2D g2 = (Graphics2D)g2d.create();
            FontMetrics fm = g2.getFontMetrics();
            this.maxAscent = fm.getMaxAscent();
            this.maxDescent = fm.getMaxDescent();
            this.maxAscent += 3 * UIUtil.DLU;
            this.maxDescent += 3 * UIUtil.DLU;
            this.gridWidth = fm.getMaxAdvance() + 6 * UIUtil.DLU;
            this.gridHeight = this.maxAscent + this.maxDescent;
            this.numCharAcross = (w - 4) / this.gridWidth;
            this.numCharDown = (h - 4) / this.gridHeight;
            this.canvasInset_X = (w - this.numCharAcross * this.gridWidth) / 2;
            this.canvasInset_Y = (h - this.numCharDown * this.gridHeight) / 2;
            this.resetScrollbar(CharacterGrid.this.verticalBar.getValue() * this.numCharAcross);
        }

        private void calcTextRange() {
            this.drawStart = CharacterGrid.this.verticalBar.getValue() * this.numCharAcross;
            this.drawStart += CharacterGrid.this.drawRange[0];
            this.drawLimit = CharacterGrid.this.drawRange[1];
            this.drawEnd = this.drawStart + this.numCharAcross * this.numCharDown - 1;
            if (this.drawEnd >= this.drawLimit) {
                this.drawEnd = this.drawLimit;
            }
            if (this.drawStart > this.drawEnd) {
                this.drawStart = 0;
                CharacterGrid.this.verticalBar.setValue(this.drawStart);
            }
        }

        void updateSelection() {
            int gridLocY;
            int gridLocX;
            int j;
            int i;
            Object obj;
            if (CharacterGrid.this.updateBackBuffer || CharacterGrid.this.updateFontMetrics || this.prevMouseOverChar == this.currMouseOverChar) {
                return;
            }
            Graphics2D g2 = this.backBuffer.createGraphics();
            this.setParams(g2);
            if (CharacterGrid.this.charmap.isEmpty()) {
                return;
            }
            if (this.prevMouseOverChar != -1 && this.prevMouseOverChar >= this.drawStart && this.prevMouseOverChar <= this.drawEnd && (obj = CharacterGrid.this.charmap.get(Integer.toString(this.prevMouseOverChar))) != null) {
                i = (this.prevMouseOverChar - this.drawStart) / this.numCharAcross;
                j = (this.prevMouseOverChar - this.drawStart) % this.numCharAcross;
                gridLocX = j * this.gridWidth + this.canvasInset_X;
                gridLocY = i * this.gridHeight + this.canvasInset_Y;
                g2.setColor(backColor);
                g2.fillRect(gridLocX, gridLocY, this.gridWidth, this.gridHeight);
                g2.setColor(foreground);
                g2.drawRect(gridLocX, gridLocY, this.gridWidth, this.gridHeight);
                this.drawChar(g2, (Integer)obj, gridLocX + this.gridWidth / 2, gridLocY + this.maxAscent);
            }
            if (this.currMouseOverChar != -1 && this.currMouseOverChar >= this.drawStart && this.currMouseOverChar <= this.drawEnd && (obj = CharacterGrid.this.charmap.get(Integer.toString(this.currMouseOverChar))) != null) {
                i = (this.currMouseOverChar - this.drawStart) / this.numCharAcross;
                j = (this.currMouseOverChar - this.drawStart) % this.numCharAcross;
                gridLocX = j * this.gridWidth + this.canvasInset_X;
                gridLocY = i * this.gridHeight + this.canvasInset_Y;
                g2.setColor(hiliteBackground);
                g2.fillRect(gridLocX, gridLocY, this.gridWidth, this.gridHeight);
                g2.setColor(hiliteForeground);
                g2.drawRect(gridLocX, gridLocY, this.gridWidth, this.gridHeight);
                this.drawChar(g2, (Integer)CharacterGrid.this.charmap.get(Integer.toString(this.currMouseOverChar)), gridLocX + this.gridWidth / 2, gridLocY + this.maxAscent);
            }
            this.prevMouseOverChar = this.currMouseOverChar;
            this.repaint();
        }

        private void drawText(Graphics g, int w, int h) {
            this.backBuffer = (BufferedImage)this.createImage(w, h);
            Graphics2D g2 = this.backBuffer.createGraphics();
            g2.setColor(backColor);
            g2.fillRect(0, 0, w, h);
            g2.setColor(foreground);
            this.setParams(g2);
            if (CharacterGrid.this.updateFontMetrics) {
                this.calcFontMetrics(g2, w, h);
                CharacterGrid.this.updateFontMetrics = false;
            }
            this.calcTextRange();
            int charToDraw = this.drawStart;
            this.drawGrid(g2);
            g.drawImage(this.backBuffer, 0, 0, this);
            for (int i = 0; i < this.numCharDown && charToDraw <= this.drawEnd; ++i) {
                for (int j = 0; j < this.numCharAcross && charToDraw <= this.drawEnd && charToDraw <= CharacterGrid.this.drawRange[1]; ++j, ++charToDraw) {
                    if (!CharacterGrid.this.charmap.containsKey(Integer.toString(charToDraw))) continue;
                    int gridLocX = j * this.gridWidth + this.canvasInset_X;
                    int gridLocY = i * this.gridHeight + this.canvasInset_Y;
                    if (charToDraw == this.currMouseOverChar) {
                        g2.setColor(hiliteBackground);
                        g2.fillRect(gridLocX, gridLocY, this.gridWidth, this.gridHeight);
                        g2.setColor(hiliteForeground);
                        g2.drawRect(gridLocX, gridLocY, this.gridWidth, this.gridHeight);
                    } else {
                        g2.setColor(foreground);
                    }
                    this.drawChar(g2, (Integer)CharacterGrid.this.charmap.get(Integer.toString(charToDraw)), gridLocX + this.gridWidth / 2, gridLocY + this.maxAscent);
                }
            }
            g.drawImage(this.backBuffer, 0, 0, this);
            g2.dispose();
        }

        @Override
        public void paintComponent(Graphics g) {
            ((Graphics2D)g).setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            ((Graphics2D)g).setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
            if (CharacterGrid.this.drawRange == null) {
                CharacterGrid.this.updateRange();
            }
            if (CharacterGrid.this.updateBackBuffer) {
                Dimension d = CharacterGrid.this.fc.getSize();
                try {
                    this.drawText(g, d.width, d.height);
                }
                catch (Exception e) {
                    e.printStackTrace();
                    return;
                }
            } else {
                g.drawImage(this.backBuffer, 0, 0, this);
            }
            CharacterGrid.this.updateBackBuffer = false;
        }

        private boolean checkMouseLoc(MouseEvent e) {
            if (this.gridWidth != 0 && this.gridHeight != 0) {
                int charLocX = (e.getX() - this.canvasInset_X) / this.gridWidth;
                int charLocY = (e.getY() - this.canvasInset_Y) / this.gridHeight;
                if (charLocX >= 0 && charLocY >= 0 && charLocX < this.numCharAcross && charLocY < this.numCharDown) {
                    int mouseOverChar = charLocX + (CharacterGrid.this.verticalBar.getValue() + charLocY) * this.numCharAcross;
                    this.prevMouseOverChar = this.currMouseOverChar;
                    if ((mouseOverChar += CharacterGrid.this.drawRange[0]) > this.drawEnd) {
                        this.currMouseOverChar = -1;
                        return false;
                    }
                    this.currMouseOverChar = mouseOverChar;
                    return true;
                }
            }
            return false;
        }

        @Override
        public void mousePressed(MouseEvent e) {
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            if (!this.isEnabled()) {
                return;
            }
            if (this.currMouseOverChar >= this.drawStart && this.currMouseOverChar <= this.drawEnd) {
                Object obj = CharacterGrid.this.charmap.get(Integer.toString(this.currMouseOverChar));
                if (obj == null) {
                    return;
                }
                ItemEvent event = new ItemEvent(CharacterGrid.this.getSelectable(), -1, obj, 1);
                for (int i = 0; i < CharacterGrid.this.listeners.size(); ++i) {
                    ((ItemListener)CharacterGrid.this.listeners.get(i)).itemStateChanged(event);
                }
            }
        }

        @Override
        public void mouseExited(MouseEvent e) {
        }

        @Override
        public void mouseMoved(MouseEvent e) {
            if (!this.isEnabled()) {
                return;
            }
            this.checkMouseLoc(e);
            if (this.currMouseOverChar != this.prevMouseOverChar) {
                this.updateSelection();
            }
        }

        @Override
        public void mouseDragged(MouseEvent e) {
        }

        @Override
        public void mouseClicked(MouseEvent e) {
        }

        @Override
        public void mouseEntered(MouseEvent e) {
        }

        public void updateCurrent(int direction) {
            switch (direction) {
                default: {
                    if ((this.currMouseOverChar + 1) % this.numCharAcross == 0) break;
                    this.prevMouseOverChar = this.currMouseOverChar++;
                    break;
                }
                case 2: {
                    if (this.currMouseOverChar % this.numCharAcross == 0) break;
                    this.prevMouseOverChar = this.currMouseOverChar--;
                    break;
                }
                case 1: {
                    if (this.currMouseOverChar < this.numCharAcross) break;
                    this.prevMouseOverChar = this.currMouseOverChar;
                    this.currMouseOverChar -= this.numCharAcross;
                    if (this.currMouseOverChar >= this.drawStart) break;
                    this.resetScrollbar(this.currMouseOverChar);
                    break;
                }
                case 3: {
                    if (this.currMouseOverChar >= CharacterGrid.this.drawRange[1] - this.numCharAcross) break;
                    this.prevMouseOverChar = this.currMouseOverChar;
                    this.currMouseOverChar += this.numCharAcross;
                    if (this.currMouseOverChar <= this.drawEnd) break;
                    this.resetScrollbar(this.currMouseOverChar);
                }
            }
            this.updateSelection();
        }
    }
}

