/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.sg.ui;

import com.sas.graphics.sg.interfaces.BubbleInterface;
import com.sas.graphics.sg.interfaces.LineInterface;
import com.sas.graphics.sg.ui.ColorGrabber;
import com.sas.graphics.sg.ui.CompTitledBorder;
import com.sas.graphics.sg.ui.FillCustomizerPanel;
import com.sas.graphics.sg.ui.LineCustomizerPanel;
import com.sas.graphics.sg.ui.MyCheckBox;
import com.sas.graphics.sg.ui.PlotCustomizerPanel;
import com.sas.graphics.sg.ui.RB;
import com.sas.graphics.sg.ui.SGCustomizerPanel;
import com.sas.graphics.sg.ui.UIUtil;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JCheckBox;
import javax.swing.JPanel;
import javax.swing.border.Border;
import javax.swing.border.LineBorder;

public class BubbleCustomizerPanel
extends SGCustomizerPanel
implements ActionListener {
    private static final int dlu2 = UIUtil.DLU * 2;
    private static final int dlu4 = UIUtil.DLU * 4;
    BubbleInterface bubble;
    ColorGrabber colorGrabber = null;
    BubbleLineCustomizerPanel linePanel;
    FillCustomizerPanel fillPanel;
    protected JPanel titlePanel;
    private JCheckBox edge;
    private JCheckBox fill;
    CompTitledBorder fillBorder;
    CompTitledBorder edgeBorder;

    public BubbleCustomizerPanel(BubbleInterface bubble) {
        this(bubble, null);
    }

    public BubbleCustomizerPanel(BubbleInterface bubble, ColorGrabber cg) {
        this.bubble = bubble;
        this.colorGrabber = cg;
        this.init();
    }

    private void init() {
        this.setBorder(null);
        this.setLayout(new BoxLayout(this, 1));
        this.fill = new MyCheckBox(RB.getStringResource("fill.txt"));
        boolean isFillOn = this.bubble.isFillOn();
        this.fill.setSelected(isFillOn);
        this.fill.setActionCommand("fill");
        this.fill.addActionListener(this);
        this.fill.setBorder(BorderFactory.createEmptyBorder(0, dlu2, 0, dlu2));
        this.fillPanel = new FillCustomizerPanel(this.bubble, this.colorGrabber);
        this.fillPanel.setBorder(PlotCustomizerPanel.tabBorder);
        this.fillPanel.setFillOn(isFillOn && this.bubble.isFillColorEditable());
        JPanel groupPanel = new JPanel(){

            @Override
            public void doLayout() {
                Insets insets = this.getInsets();
                Rectangle rect = this.getBounds();
                rect.x = 0;
                rect.y = 0;
                Rectangle compR = BubbleCustomizerPanel.this.fillBorder.getComponentRect(rect, insets);
                BubbleCustomizerPanel.this.fill.setBounds(compR);
                rect.x += insets.left;
                rect.y += insets.top;
                rect.width -= insets.left + insets.right;
                rect.height -= insets.top + insets.bottom;
                BubbleCustomizerPanel.this.fillPanel.setBounds(rect);
            }

            @Override
            public Dimension getPreferredSize() {
                Insets insets = super.getInsets();
                Dimension ps2 = BubbleCustomizerPanel.this.fillPanel.getPreferredSize();
                return new Dimension((int)ps2.getWidth(), (int)ps2.getHeight() + insets.top + insets.bottom);
            }
        };
        groupPanel.add(this.fill);
        groupPanel.add(this.fillPanel);
        this.fillBorder = new CompTitledBorder((Border)new LineBorder(Color.GRAY), this.fill);
        groupPanel.setBorder(this.fillBorder);
        this.add(groupPanel);
        this.add(Box.createRigidArea(new Dimension(0, dlu4)));
        this.edge = new MyCheckBox(RB.getStringResource("displayOutline.txt"));
        boolean isEdgeOn = this.bubble.isLineOn();
        this.edge.setSelected(isEdgeOn);
        this.edge.setActionCommand("line");
        this.edge.addActionListener(this);
        this.edge.setBorder(BorderFactory.createEmptyBorder(0, dlu2, 0, dlu2));
        this.linePanel = new BubbleLineCustomizerPanel(this.bubble, this.colorGrabber);
        this.linePanel.setBorder(PlotCustomizerPanel.tabBorder);
        this.linePanel.setEnabledAll(isEdgeOn);
        this.linePanel.add(Box.createVerticalGlue());
        this.linePanel.updateState(false);
        groupPanel = new JPanel(){

            @Override
            public void doLayout() {
                Insets insets = this.getInsets();
                Rectangle rect = this.getBounds();
                rect.x = 0;
                rect.y = 0;
                Rectangle compR = BubbleCustomizerPanel.this.edgeBorder.getComponentRect(rect, insets);
                BubbleCustomizerPanel.this.edge.setBounds(compR);
                rect.x += insets.left;
                rect.y += insets.top;
                rect.width -= insets.left + insets.right;
                rect.height -= insets.top + insets.bottom;
                BubbleCustomizerPanel.this.linePanel.setBounds(rect);
            }

            @Override
            public Dimension getPreferredSize() {
                Insets insets = super.getInsets();
                Dimension ps2 = BubbleCustomizerPanel.this.linePanel.getPreferredSize();
                return new Dimension((int)ps2.getWidth(), (int)ps2.getHeight() + insets.top + insets.bottom);
            }
        };
        groupPanel.add(this.edge);
        groupPanel.add(this.linePanel);
        this.edgeBorder = new CompTitledBorder((Border)new LineBorder(Color.GRAY), this.edge);
        groupPanel.setBorder(this.edgeBorder);
        this.add(groupPanel);
    }

    @Override
    public void setValue(Object style) {
        if (!(style instanceof BubbleInterface)) {
            return;
        }
        this.bubble = (BubbleInterface)style;
        this.fillPanel.setValue(this.bubble);
        boolean isEdgeOn = this.bubble.isLineOn();
        this.edge.removeActionListener(this);
        this.edge.setSelected(isEdgeOn);
        this.edge.addActionListener(this);
        boolean isFillOn = this.bubble.isFillOn();
        this.fill.removeActionListener(this);
        this.fill.setSelected(isFillOn);
        this.fill.addActionListener(this);
        this.fillPanel.setFillOn(isFillOn && this.bubble.isFillColorEditable());
        if (!this.bubble.isFillColorEditable() && isFillOn) {
            this.fillPanel.setTransparencyEnabled(true);
        }
        this.edge.setEnabled(isFillOn);
        this.fill.setEnabled(isEdgeOn);
        this.linePanel.setValue(true);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        String cmd = e.getActionCommand();
        if (cmd.equals("line")) {
            boolean selected = this.edge.isSelected();
            this.bubble.setLineOn(selected);
            selected = this.bubble.isLineOn();
            this.fill.setEnabled(selected);
            this.linePanel.updateState(true);
        } else if (cmd.equals("fill")) {
            boolean selected = this.fill.isSelected();
            this.bubble.setFillOn(selected);
            selected = this.bubble.isFillOn();
            this.edge.setEnabled(selected);
            this.fillPanel.setFillOn(selected && this.bubble.isFillColorEditable());
            if (!this.bubble.isFillColorEditable() && selected) {
                this.fillPanel.setTransparencyEnabled(true);
            }
            this.linePanel.updateState(true);
        } else {
            Object src = e.getSource();
            if (src instanceof JPanel) {
                if (((JPanel)src).getParent() == this.linePanel) {
                    this.linePanel.actionPerformed(e);
                } else if (((JPanel)src).getParent() == this.fillPanel) {
                    this.fillPanel.actionPerformed(e);
                }
            }
        }
    }

    class BubbleLineCustomizerPanel
    extends LineCustomizerPanel {
        protected BubbleLineCustomizerPanel() {
        }

        public BubbleLineCustomizerPanel(LineInterface lineStyle) {
            this(lineStyle, null);
        }

        public BubbleLineCustomizerPanel(LineInterface lineStyle, ColorGrabber cg) {
            super(lineStyle, cg);
        }

        public void updateState(boolean setValues) {
            if (setValues) {
                this.setValue(BubbleCustomizerPanel.this.bubble);
            }
            boolean isEdgeOn = BubbleCustomizerPanel.this.edge.isSelected();
            boolean isFillOn = BubbleCustomizerPanel.this.fill.isSelected();
            this.setEnabledAll(isEdgeOn);
            if (!isFillOn && !BubbleCustomizerPanel.this.bubble.isFillColorEditable()) {
                this.color.setEnabled(false);
            }
        }
    }
}

