/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.sg.ui;

import com.sas.graphics.sg.interfaces.BoxInterface;
import com.sas.graphics.sg.interfaces.DefaultAreaInterface;
import com.sas.graphics.sg.interfaces.DefaultBoxInterface;
import com.sas.graphics.sg.interfaces.FillStyleElementInterface;
import com.sas.graphics.sg.ui.ColorComboBoxEditor;
import com.sas.graphics.sg.ui.LineComponent;
import com.sas.graphics.sg.ui.LineCustomizerPanel;
import com.sas.graphics.sg.ui.MarkerCustomizerPanel;
import com.sas.graphics.sg.ui.RB;
import com.sas.graphics.sg.ui.SGDialog;
import com.sas.graphics.sg.ui.SwatchComboBox;
import com.sas.graphics.sg.ui.SwatchRenderer;
import com.sas.graphics.sg.ui.UIUtil;
import com.sas.text.Message;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JCheckBox;
import javax.swing.JColorChooser;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class BoxCustomizerPanel
extends JPanel
implements ActionListener,
ChangeListener {
    private static final String RB_KEY = "BoxCustomizerPanel.";
    private static final String[] shapeValues = new String[]{RB.getStringResource("BoxCustomizerPanel.", "serif.txt"), RB.getStringResource("sline.txt"), RB.getStringResource("BoxCustomizerPanel.", "bracket.txt")};
    JCheckBox auto;
    JCheckBox caps;
    JCheckBox connect;
    JCheckBox fill;
    JCheckBox mean;
    JCheckBox median;
    JCheckBox outlier;
    SwatchComboBox fillColor;
    JComboBox fstyle;
    JComboBox shape;
    boolean showfill = true;
    boolean showline = true;
    private Dimension labelSize;
    private Dimension comboBoxSize;
    String defaultFillColorSource = "";
    MarkerCustomizerPanel outlierPanel;
    MarkerCustomizerPanel meanPanel;
    LineCustomizerPanel outlinePanel;
    LineCustomizerPanel medianPanel;
    LineCustomizerPanel whiskerPanel;
    LineCustomizerPanel connectPanel;
    JTabbedPane tabbedPane;
    BoxInterface boxStyle;

    public BoxCustomizerPanel(BoxInterface boxStyle) {
        this.boxStyle = boxStyle;
        this.init();
        this.setSize(this.getPreferredSize());
    }

    private void init() {
        this.setLayout(new BoxLayout(this, 1));
        this.tabbedPane = new JTabbedPane(1, 0);
        this.boxStyle.setEditingState(0);
        JPanel generalPanel = this.createGeneralPanel();
        generalPanel.setBorder(UIUtil.emptyBorder);
        this.boxStyle.setEditingState(1);
        JPanel boxPanel = this.createBoxPanel();
        boxPanel.setBorder(UIUtil.emptyBorder);
        this.boxStyle.setEditingState(3);
        this.meanPanel = new MarkerCustomizerPanel(this.boxStyle);
        this.meanPanel.setBorder(UIUtil.emptyBorder);
        this.boxStyle.setEditingState(4);
        this.medianPanel = new LineCustomizerPanel(this.boxStyle);
        this.medianPanel.setBorder(UIUtil.emptyBorder);
        this.boxStyle.setEditingState(5);
        this.whiskerPanel = new LineCustomizerPanel(this.boxStyle);
        this.whiskerPanel.setBorder(UIUtil.emptyBorder);
        this.boxStyle.setEditingState(6);
        this.outlierPanel = new MarkerCustomizerPanel(this.boxStyle);
        this.outlierPanel.setBorder(UIUtil.emptyBorder);
        this.boxStyle.setEditingState(2);
        this.connectPanel = new LineCustomizerPanel(this.boxStyle);
        this.connectPanel.setBorder(UIUtil.emptyBorder);
        this.tabbedPane.addTab(RB.getStringResource("general.txt"), generalPanel);
        this.tabbedPane.setMnemonicAt(0, 49);
        this.tabbedPane.addTab(RB.getStringResource(RB_KEY, "box.txt"), boxPanel);
        this.tabbedPane.setMnemonicAt(1, 50);
        this.tabbedPane.addTab(RB.getStringResource(RB_KEY, "connect.txt"), this.connectPanel);
        this.tabbedPane.setMnemonicAt(2, 51);
        this.tabbedPane.addTab(RB.getStringResource(RB_KEY, "mean.txt"), this.meanPanel);
        this.tabbedPane.setMnemonicAt(3, 52);
        this.tabbedPane.addTab(RB.getStringResource(RB_KEY, "median.txt"), this.medianPanel);
        this.tabbedPane.setMnemonicAt(4, 53);
        this.tabbedPane.addTab(RB.getStringResource(RB_KEY, "whisker.txt"), this.whiskerPanel);
        this.tabbedPane.setMnemonicAt(5, 54);
        this.tabbedPane.addTab(RB.getStringResource(RB_KEY, "outlier.txt"), this.outlierPanel);
        this.tabbedPane.setMnemonicAt(6, 55);
        this.tabbedPane.addChangeListener(this);
        this.tabbedPane.setSelectedIndex(0);
        this.tabbedPane.setEnabledAt(2, this.connect.isSelected());
        this.tabbedPane.setEnabledAt(3, this.mean.isSelected());
        this.tabbedPane.setEnabledAt(4, this.median.isSelected());
        this.tabbedPane.setEnabledAt(6, this.outlier.isSelected());
        this.add(this.tabbedPane);
        this.add(Box.createRigidArea(new Dimension(0, 4 * UIUtil.DLU)));
    }

    private JPanel createBoxPanel() {
        JPanel boxPanel = new JPanel();
        boxPanel.setLayout(new BoxLayout(boxPanel, 1));
        this.labelSize = new Dimension(20, 14 * UIUtil.DLU);
        this.comboBoxSize = new Dimension(100, 14 * UIUtil.DLU);
        JLabel styleLabel = null;
        if (this.boxStyle instanceof FillStyleElementInterface) {
            FillStyleElementInterface styleInterface = (FillStyleElementInterface)((Object)this.boxStyle);
            JPanel stylePanel = new JPanel();
            stylePanel.setLayout(new BoxLayout(stylePanel, 0));
            styleLabel = new JLabel(RB.getStringResource("element.txt"));
            Dimension ps = styleLabel.getPreferredSize();
            this.labelSize.setSize(Math.max(this.labelSize.width, ps.width), Math.max(this.labelSize.height, ps.height));
            stylePanel.add(styleLabel);
            stylePanel.add(Box.createRigidArea(new Dimension(3 * UIUtil.DLU, 0)));
            this.fstyle = new JComboBox<String>(styleInterface.getAllFillStyleElements());
            this.fstyle.setSelectedItem(styleInterface.getFillStyleElement());
            this.fstyle.setActionCommand("fillstyle");
            this.fstyle.addActionListener(this);
            ps = this.fstyle.getPreferredSize();
            this.comboBoxSize.setSize(Math.max(this.comboBoxSize.width, ps.width), Math.max(this.comboBoxSize.height, ps.height));
            stylePanel.add(this.fstyle);
            stylePanel.add(Box.createHorizontalGlue());
            boxPanel.add(stylePanel);
            boxPanel.add(Box.createRigidArea(new Dimension(0, 4 * UIUtil.DLU)));
        }
        JPanel fillPanel = new JPanel();
        fillPanel.setLayout(new BoxLayout(fillPanel, 0));
        JLabel fillLabel = new JLabel(RB.getStringResource("fill.txt"));
        fillPanel.add(fillLabel);
        fillPanel.add(Box.createRigidArea(new Dimension(3 * UIUtil.DLU, 0)));
        Color defaultFillColor = null;
        if (this.boxStyle instanceof DefaultAreaInterface) {
            defaultFillColor = ((DefaultAreaInterface)((Object)this.boxStyle)).getDefaultFillColor();
            this.defaultFillColorSource = RB.getStringResource("automatic.txt");
        }
        this.fillColor = new SwatchComboBox(UIUtil.getColors(), 8, 4, this.defaultFillColorSource, defaultFillColor, RB.getStringResource("morecolorsdots.txt"));
        Color c = this.boxStyle.getFillColor();
        this.fillColor.setEditable(true);
        ColorComboBoxEditor editor = new ColorComboBoxEditor(this.defaultFillColorSource, defaultFillColor);
        this.fillColor.setEditor(editor);
        editor.addMouseListener(this.fillColor);
        if (c != null) {
            this.fillColor.setSelectedItem(c);
        } else {
            this.fillColor.setSelectedItem(this.defaultFillColorSource);
        }
        this.fillColor.setEnabled(this.boxStyle.isOn(2));
        this.fillColor.setRenderer(new SwatchRenderer());
        this.fillColor.setActionCommand("fillcolor");
        this.fillColor.addActionListener(this);
        fillPanel.add(this.fillColor);
        fillPanel.add(Box.createHorizontalGlue());
        boxPanel.add(fillPanel);
        boxPanel.add(Box.createRigidArea(new Dimension(0, 4 * UIUtil.DLU)));
        this.outlinePanel = new LineCustomizerPanel(this.boxStyle);
        boxPanel.add(this.outlinePanel);
        boxPanel.add(Box.createVerticalGlue());
        Dimension ps = fillLabel.getPreferredSize();
        this.labelSize.setSize(ps.width, ps.height);
        ps = this.outlinePanel.getLabelPreferredSize();
        this.labelSize.setSize(Math.max((double)ps.width, this.labelSize.getWidth()), Math.max((double)ps.height, this.labelSize.getHeight()));
        this.outlinePanel.setLabelPreferredSize(this.labelSize);
        fillLabel.setPreferredSize(this.labelSize);
        fillLabel.setMaximumSize(this.labelSize);
        if (styleLabel != null) {
            styleLabel.setPreferredSize(this.labelSize);
            styleLabel.setMaximumSize(this.labelSize);
        }
        ps = this.outlinePanel.getWidgetPreferredSize();
        this.comboBoxSize = this.fillColor.getPreferredSize();
        this.comboBoxSize = new Dimension(Math.max(this.comboBoxSize.width, ps.width), Math.max(this.comboBoxSize.height, ps.height));
        this.outlinePanel.setWidgetPreferredSize(this.comboBoxSize);
        this.fillColor.setPreferredSize(this.comboBoxSize);
        this.fillColor.setMaximumSize(this.comboBoxSize);
        return boxPanel;
    }

    private JPanel createGeneralPanel() {
        String[] values;
        JPanel generalPanel = new JPanel();
        generalPanel.setLayout(new BoxLayout(generalPanel, 1));
        this.labelSize = new Dimension(20, 14 * UIUtil.DLU);
        this.comboBoxSize = new Dimension(100, 14 * UIUtil.DLU);
        JPanel displayPanel = new JPanel();
        displayPanel.setLayout(new BoxLayout(displayPanel, 1));
        displayPanel.add(new LineComponent(RB.getStringResource("sdisplay.txt")));
        JPanel display1 = new JPanel();
        display1.setLayout(new BoxLayout(display1, 0));
        this.auto = new JCheckBox(RB.getStringResource("automatic.txt"));
        this.auto.setActionCommand("auto");
        boolean autoOn = false;
        String str = this.boxStyle.getDisplay();
        if (str == null || str.length() == 0) {
            autoOn = true;
        }
        this.auto.setSelected(autoOn);
        this.auto.addActionListener(this);
        display1.add(this.auto);
        display1.add(Box.createHorizontalGlue());
        if (this.boxStyle instanceof DefaultBoxInterface) {
            displayPanel.add(display1);
        }
        JPanel display2 = new JPanel();
        display2.setLayout(new BoxLayout(display2, 0));
        this.caps = new JCheckBox(RB.getStringResource(RB_KEY, "dcaps.txt"));
        this.caps.setActionCommand("caps");
        this.caps.setSelected(this.boxStyle.isOn(0));
        this.caps.addActionListener(this);
        display2.add(this.caps);
        display2.add(Box.createRigidArea(new Dimension(4 * UIUtil.DLU, 0)));
        this.connect = new JCheckBox(RB.getStringResource(RB_KEY, "connect.txt"));
        this.connect.setActionCommand("connect");
        this.connect.setSelected(this.boxStyle.isOn(1));
        this.connect.addActionListener(this);
        display2.add(this.connect);
        display2.add(Box.createRigidArea(new Dimension(4 * UIUtil.DLU, 0)));
        this.fill = new JCheckBox(RB.getStringResource("sfill.txt"));
        this.fill.setActionCommand("fill");
        this.fill.setSelected(this.boxStyle.isOn(2));
        this.fill.addActionListener(this);
        display2.add(this.fill);
        display2.add(Box.createHorizontalGlue());
        displayPanel.add(display2);
        JPanel display3 = new JPanel();
        display3.setLayout(new BoxLayout(display3, 0));
        this.mean = new JCheckBox(RB.getStringResource(RB_KEY, "mean.txt"));
        this.mean.setActionCommand("mean");
        this.mean.setSelected(this.boxStyle.isOn(3));
        this.mean.addActionListener(this);
        display3.add(this.mean);
        this.median = new JCheckBox(RB.getStringResource(RB_KEY, "median.txt"));
        this.median.setActionCommand("median");
        this.median.setSelected(this.boxStyle.isOn(4));
        this.median.addActionListener(this);
        display3.add(this.median);
        display3.add(Box.createRigidArea(new Dimension(4 * UIUtil.DLU, 0)));
        this.outlier = new JCheckBox(RB.getStringResource(RB_KEY, "outliers.txt"));
        this.outlier.setActionCommand("outlier");
        this.outlier.setSelected(this.boxStyle.isOn(5));
        this.outlier.addActionListener(this);
        display3.add(this.outlier);
        display3.add(Box.createHorizontalGlue());
        displayPanel.add(display3);
        generalPanel.add(displayPanel);
        generalPanel.add(new LineComponent(RB.getStringResource(RB_KEY, "dcaps.txt")));
        JPanel capPanel = new JPanel();
        capPanel.setLayout(new BoxLayout(capPanel, 0));
        capPanel.add(Box.createRigidArea(new Dimension(4 * UIUtil.DLU, 0)));
        JLabel capLabel = new JLabel(RB.getStringResource("shape.txt"));
        capPanel.add(capLabel);
        capPanel.add(Box.createRigidArea(new Dimension(3 * UIUtil.DLU, 0)));
        if (this.boxStyle instanceof DefaultBoxInterface) {
            String defaultShape = ((DefaultBoxInterface)((Object)this.boxStyle)).getDefaultCap();
            String s = Message.format((String)RB.getStringResource("automatic.fmt.txt"), (Object)defaultShape);
            values = new String[]{s, shapeValues[0], shapeValues[1], shapeValues[2]};
        } else {
            values = shapeValues;
        }
        this.shape = new JComboBox<String>(values);
        String value = this.boxStyle.getCap();
        if (value != null && value.length() > 0) {
            this.shape.setSelectedItem(value);
        } else {
            this.shape.setSelectedIndex(0);
        }
        this.shape.setEnabled(this.boxStyle.isOn(0));
        this.shape.setActionCommand("shape");
        this.shape.addActionListener(this);
        capPanel.add(this.shape);
        capPanel.add(Box.createHorizontalGlue());
        generalPanel.add(capPanel);
        generalPanel.add(Box.createRigidArea(new Dimension(0, 7 * UIUtil.DLU)));
        generalPanel.add(Box.createVerticalGlue());
        Dimension ps = this.auto.getPreferredSize();
        this.labelSize.setSize(ps.width, ps.height);
        ps = this.caps.getPreferredSize();
        this.labelSize.setSize(Math.max((double)ps.width, this.labelSize.getWidth()), Math.max((double)ps.height, this.labelSize.getHeight()));
        ps = this.connect.getPreferredSize();
        this.labelSize.setSize(Math.max((double)ps.width, this.labelSize.getWidth()), Math.max((double)ps.height, this.labelSize.getHeight()));
        ps = this.fill.getPreferredSize();
        this.labelSize.setSize(Math.max((double)ps.width, this.labelSize.getWidth()), Math.max((double)ps.height, this.labelSize.getHeight()));
        ps = this.mean.getPreferredSize();
        this.labelSize.setSize(Math.max((double)ps.width, this.labelSize.getWidth()), Math.max((double)ps.height, this.labelSize.getHeight()));
        ps = this.median.getPreferredSize();
        this.labelSize.setSize(Math.max((double)ps.width, this.labelSize.getWidth()), Math.max((double)ps.height, this.labelSize.getHeight()));
        ps = this.outlier.getPreferredSize();
        this.labelSize.setSize(Math.max((double)ps.width, this.labelSize.getWidth()), Math.max((double)ps.height, this.labelSize.getHeight()));
        ps = capLabel.getPreferredSize();
        this.labelSize.setSize(Math.max((double)ps.width, this.labelSize.getWidth()), Math.max((double)ps.height, this.labelSize.getHeight()));
        this.auto.setPreferredSize(this.labelSize);
        this.auto.setMaximumSize(this.labelSize);
        this.caps.setPreferredSize(this.labelSize);
        this.caps.setMaximumSize(this.labelSize);
        this.connect.setPreferredSize(this.labelSize);
        this.connect.setMaximumSize(this.labelSize);
        this.fill.setPreferredSize(this.labelSize);
        this.fill.setMaximumSize(this.labelSize);
        this.mean.setPreferredSize(this.labelSize);
        this.mean.setMaximumSize(this.labelSize);
        this.median.setPreferredSize(this.labelSize);
        this.median.setMaximumSize(this.labelSize);
        this.outlier.setPreferredSize(this.labelSize);
        this.outlier.setMaximumSize(this.labelSize);
        capLabel.setPreferredSize(this.labelSize);
        capLabel.setMaximumSize(this.labelSize);
        this.comboBoxSize = this.shape.getPreferredSize();
        this.comboBoxSize = new Dimension(Math.max(this.comboBoxSize.width, this.labelSize.width), Math.max(this.comboBoxSize.height, this.labelSize.height));
        this.shape.setPreferredSize(this.comboBoxSize);
        this.shape.setMaximumSize(this.comboBoxSize);
        return generalPanel;
    }

    public void setValue(BoxInterface boxStyle) {
        String value;
        Color c;
        this.boxStyle = boxStyle;
        boxStyle.setEditingState(1);
        this.auto.removeActionListener(this);
        boolean autoOn = false;
        String str = boxStyle.getDisplay();
        if (str == null || str.length() == 0) {
            autoOn = true;
        }
        this.auto.setSelected(autoOn);
        this.auto.addActionListener(this);
        this.caps.removeActionListener(this);
        this.caps.setSelected(boxStyle.isOn(0));
        this.caps.addActionListener(this);
        this.connect.removeActionListener(this);
        this.connect.setSelected(boxStyle.isOn(1));
        this.connect.addActionListener(this);
        this.fill.removeActionListener(this);
        this.fill.setSelected(boxStyle.isOn(2));
        this.fill.addActionListener(this);
        this.mean.removeActionListener(this);
        this.mean.setSelected(boxStyle.isOn(3));
        this.mean.addActionListener(this);
        this.median.removeActionListener(this);
        this.median.setSelected(boxStyle.isOn(4));
        this.median.addActionListener(this);
        this.outlier.removeActionListener(this);
        this.outlier.setSelected(boxStyle.isOn(5));
        this.outlier.addActionListener(this);
        if (boxStyle instanceof FillStyleElementInterface) {
            this.fstyle.removeActionListener(this);
            this.fstyle.setSelectedItem(((FillStyleElementInterface)((Object)boxStyle)).getFillStyleElement());
            this.fstyle.addActionListener(this);
            this.fstyle.setEnabled(boxStyle.isOn(2));
        }
        Color defaultFillColor = null;
        this.fillColor.removeActionListener(this);
        if (boxStyle instanceof DefaultAreaInterface) {
            defaultFillColor = ((DefaultAreaInterface)((Object)boxStyle)).getDefaultFillColor();
            this.fillColor.setAutomatic(this.defaultFillColorSource, defaultFillColor);
            this.fillColor.updateUI();
            this.fillColor.setEditor(new ColorComboBoxEditor(this.defaultFillColorSource, defaultFillColor));
        }
        if ((c = boxStyle.getFillColor()) != null) {
            this.fillColor.setSelectedItem(c);
        } else {
            this.fillColor.setSelectedItem(this.defaultFillColorSource);
        }
        this.fillColor.setEnabled(boxStyle.isOn(2));
        this.fillColor.addActionListener(this);
        this.shape.removeActionListener(this);
        if (boxStyle instanceof DefaultBoxInterface) {
            String defaultShape = ((DefaultBoxInterface)((Object)boxStyle)).getDefaultCap();
            String s = Message.format((String)RB.getStringResource("automatic.fmt.txt"), (Object)defaultShape);
            this.shape.removeAllItems();
            this.shape.addItem(s);
            this.shape.addItem(shapeValues[0]);
            this.shape.addItem(shapeValues[1]);
            this.shape.addItem(shapeValues[2]);
        }
        if ((value = boxStyle.getCap()) != null && value.length() > 0) {
            this.shape.setSelectedItem(value);
        } else {
            this.shape.setSelectedIndex(0);
        }
        this.shape.setEnabled(boxStyle.isOn(0));
        this.shape.addActionListener(this);
        this.outlinePanel.setValue(boxStyle);
        boxStyle.setEditingState(3);
        this.meanPanel.setValue(boxStyle);
        this.tabbedPane.setEnabledAt(3, this.mean.isSelected());
        boxStyle.setEditingState(4);
        this.medianPanel.setValue(boxStyle);
        this.tabbedPane.setEnabledAt(4, this.median.isSelected());
        boxStyle.setEditingState(5);
        this.whiskerPanel.setValue(boxStyle);
        boxStyle.setEditingState(6);
        this.outlierPanel.setValue(boxStyle);
        this.tabbedPane.setEnabledAt(6, this.outlier.isSelected());
        boxStyle.setEditingState(2);
        this.connectPanel.setValue(boxStyle);
        this.tabbedPane.setEnabledAt(2, this.connect.isSelected());
        boxStyle.setEditingState(this.tabbedPane.getSelectedIndex());
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public void actionPerformed(ActionEvent e) {
        Container parent;
        JPanel panel;
        JColorChooser cc;
        Color save;
        String cmd = e.getActionCommand();
        if (cmd.equals("auto")) {
            boolean on = this.auto.isSelected();
            if (!on) return;
            this.boxStyle.setDisplay("");
            this.caps.removeActionListener(this);
            this.caps.setSelected(this.boxStyle.isOn(0));
            this.caps.addActionListener(this);
            this.connect.removeActionListener(this);
            this.connect.setSelected(this.boxStyle.isOn(1));
            this.connect.addActionListener(this);
            this.fill.removeActionListener(this);
            this.fill.setSelected(this.boxStyle.isOn(2));
            this.fill.addActionListener(this);
            this.mean.removeActionListener(this);
            this.mean.setSelected(this.boxStyle.isOn(3));
            this.mean.addActionListener(this);
            this.median.removeActionListener(this);
            this.median.setSelected(this.boxStyle.isOn(4));
            this.median.addActionListener(this);
            this.outlier.removeActionListener(this);
            this.outlier.setSelected(this.boxStyle.isOn(5));
            this.outlier.addActionListener(this);
            this.tabbedPane.setEnabledAt(3, this.boxStyle.isOn(3));
            this.tabbedPane.setEnabledAt(4, this.boxStyle.isOn(4));
            this.tabbedPane.setEnabledAt(6, this.boxStyle.isOn(5));
            this.tabbedPane.setEnabledAt(2, this.boxStyle.isOn(1));
            this.fillColor.setEnabled(this.boxStyle.isOn(2));
            if (this.fstyle != null) {
                this.fstyle.setEnabled(this.boxStyle.isOn(2));
            }
            this.shape.setEnabled(this.boxStyle.isOn(0));
            return;
        }
        if (cmd.equals("caps")) {
            this.boxStyle.setOn(0, this.caps.isSelected());
            this.shape.setEnabled(this.caps.isSelected());
            this.auto.setSelected(false);
            return;
        }
        if (cmd.equals("connect")) {
            this.boxStyle.setOn(1, this.connect.isSelected());
            this.tabbedPane.setEnabledAt(2, this.connect.isSelected());
            this.auto.setSelected(false);
            return;
        }
        if (cmd.equals("mean")) {
            this.boxStyle.setOn(3, this.mean.isSelected());
            this.tabbedPane.setEnabledAt(3, this.mean.isSelected());
            this.auto.setSelected(false);
            return;
        }
        if (cmd.equals("median")) {
            this.boxStyle.setOn(4, this.median.isSelected());
            this.tabbedPane.setEnabledAt(4, this.median.isSelected());
            this.auto.setSelected(false);
            return;
        }
        if (cmd.equals("fill")) {
            this.boxStyle.setOn(2, this.fill.isSelected());
            this.fillColor.setEnabled(this.fill.isSelected());
            if (this.fstyle != null) {
                this.fstyle.setEnabled(this.fill.isSelected());
            }
            this.auto.setSelected(false);
            return;
        }
        if (cmd.equals("outlier")) {
            this.boxStyle.setOn(5, this.outlier.isSelected());
            this.tabbedPane.setEnabledAt(6, this.outlier.isSelected());
            this.auto.setSelected(false);
            return;
        }
        if (cmd.equals("shape")) {
            String value = (String)this.shape.getSelectedItem();
            if (this.shape.getSelectedIndex() == 0) {
                value = "";
            }
            this.boxStyle.setCap(value);
            return;
        }
        if (cmd.equals("fillcolor")) {
            Object item = this.fillColor.getSelectedItem();
            if (item == null) return;
            save = this.boxStyle.getFillColor();
            if (!(item instanceof String)) {
                if (!(item instanceof Color)) return;
                this.boxStyle.setFillColor((Color)item);
                return;
            }
            if (!((String)item).equals(RB.getStringResource("morecolorsdots.txt"))) {
                if (!((String)item).equals(this.defaultFillColorSource)) return;
                this.boxStyle.setFillColor(null);
                return;
            }
            cc = UIUtil.colorChooser;
            if (save == null) {
                if (this.boxStyle instanceof DefaultAreaInterface) {
                    cc.setColor(((DefaultAreaInterface)((Object)this.boxStyle)).getDefaultFillColor());
                }
            } else {
                cc.setColor(save);
            }
            cc.setPreviewPanel(new JPanel());
            panel = new JPanel();
            panel.setLayout(new BorderLayout());
            panel.add(cc);
        } else {
            if (!cmd.equals("fillstyle")) return;
            ((FillStyleElementInterface)((Object)this.boxStyle)).setFillStyleElement((String)this.fstyle.getSelectedItem());
            Color c = this.boxStyle.getFillColor();
            this.fillColor.removeActionListener(this);
            if (c != null) {
                this.fillColor.setSelectedItem(c);
                return;
            }
            this.fillColor.setSelectedItem(this.defaultFillColorSource);
            return;
        }
        for (parent = this.getParent(); parent != null && !(parent instanceof JFrame); parent = parent.getParent()) {
        }
        int result = SGDialog.showInputDialog((JFrame)parent, RB.getStringResource("morecolors.txt"), panel);
        if (result == 0) {
            Color newColor = cc.getColor();
            if (newColor == null) {
                if (save == null) {
                    this.fillColor.setSelectedItem(this.defaultFillColorSource);
                    return;
                }
                this.fillColor.setSelectedItem(save);
                return;
            }
            if (save != null) {
                if (save.getRGB() == newColor.getRGB()) return;
            }
            this.boxStyle.setFillColor(newColor);
            this.fillColor.setSelectedItem(newColor);
            return;
        }
        if (save == null) {
            this.fillColor.setSelectedItem(this.defaultFillColorSource);
            return;
        }
        this.fillColor.setSelectedItem(save);
    }

    @Override
    public void stateChanged(ChangeEvent e) {
        int index = this.tabbedPane.getSelectedIndex();
        this.boxStyle.setEditingState(index);
    }

    public Dimension getLabelPreferredSize() {
        return this.labelSize;
    }

    public Dimension getComboboxPreferredSize() {
        return this.comboBoxSize;
    }
}

