/*
 * Decompiled with CFR 0.152.
 */
package com.sas.svcs.workspace.client.impl;

import com.sas.svcs.workspace.client.ODSFileEventListenerInterface;
import com.sas.svcs.workspace.client.WorkspaceServiceInterface;
import com.sas.svcs.workspace.client.impl.AbstractEventHandler;
import com.sas.svcs.workspace.client.types.AnchorElementODSFileWorkspaceEvent;
import com.sas.svcs.workspace.client.types.DirectoryBeginODSFileWorkspaceEvent;
import com.sas.svcs.workspace.client.types.DirectoryEndODSFileWorkspaceEvent;
import com.sas.svcs.workspace.client.types.FileODSFileWorkspaceEvent;
import com.sas.svcs.workspace.client.types.ODSFileWorkspaceEvent;
import com.sas.svcs.workspace.client.types.OutputElementODSFileWorkspaceEvent;
import java.util.Collections;
import java.util.List;

public class ODSFileEventHandler
extends AbstractEventHandler<ODSFileEventListenerInterface, ODSFileWorkspaceEvent, WorkspaceServiceInterface> {
    @Override
    public List<ODSFileWorkspaceEvent> getEvents() {
        List<ODSFileWorkspaceEvent> events = null;
        events = !this.isDestroyed() && this._service != null ? ((WorkspaceServiceInterface)this._service).getODSFileEvents().getODSFileWorkspaceEvents() : Collections.emptyList();
        return events;
    }

    @Override
    public void handleEvents(List<ODSFileWorkspaceEvent> list) {
        for (ODSFileWorkspaceEvent event : list) {
            switch (event.getType()) {
                case ANCHOR_ELEMENT: {
                    this.anchorElement((AnchorElementODSFileWorkspaceEvent)event);
                    break;
                }
                case COMPLETE: {
                    this.odsComplete(event);
                    break;
                }
                case DIRECTORY_BEGIN: {
                    this.directoryBegin((DirectoryBeginODSFileWorkspaceEvent)event);
                    break;
                }
                case DIRECTORY_END: {
                    this.directoryEnd((DirectoryEndODSFileWorkspaceEvent)event);
                    break;
                }
                case FILE_CLOSE: {
                    this.fileClose((FileODSFileWorkspaceEvent)event);
                    break;
                }
                case FILE_OPEN: {
                    this.fileOpen((FileODSFileWorkspaceEvent)event);
                    break;
                }
                case OUTPUT_ELEMENT: {
                    this.outputElement((OutputElementODSFileWorkspaceEvent)event);
                    break;
                }
            }
        }
    }

    void odsComplete(ODSFileWorkspaceEvent event) {
        for (ODSFileEventListenerInterface listener : this.getListeners()) {
            listener.odsComplete(event);
        }
    }

    void fileOpen(FileODSFileWorkspaceEvent event) {
        for (ODSFileEventListenerInterface listener : this.getListeners()) {
            listener.fileOpen(event);
        }
    }

    void fileClose(FileODSFileWorkspaceEvent event) {
        for (ODSFileEventListenerInterface listener : this.getListeners()) {
            listener.fileClose(event);
        }
    }

    void directoryBegin(DirectoryBeginODSFileWorkspaceEvent event) {
        for (ODSFileEventListenerInterface listener : this.getListeners()) {
            listener.directoryBegin(event);
        }
    }

    void directoryEnd(DirectoryEndODSFileWorkspaceEvent event) {
        for (ODSFileEventListenerInterface listener : this.getListeners()) {
            listener.directoryEnd(event);
        }
    }

    void outputElement(OutputElementODSFileWorkspaceEvent event) {
        for (ODSFileEventListenerInterface listener : this.getListeners()) {
            listener.outputElement(event);
        }
    }

    void anchorElement(AnchorElementODSFileWorkspaceEvent event) {
        for (ODSFileEventListenerInterface listener : this.getListeners()) {
            listener.anchorElement(event);
        }
    }
}

