/*
 * Decompiled with CFR 0.152.
 */
package com.sas.svcs.workspace.client.impl;

import com.sas.svcs.workspace.client.GeneralServiceExceptionHolder;
import com.sas.svcs.workspace.client.LibrefEventListenerInterface;
import com.sas.svcs.workspace.client.LibrefServiceInterface;
import com.sas.svcs.workspace.client.impl.AbstractEventHandler;
import com.sas.svcs.workspace.client.types.LibrefWorkspaceEvent;
import java.util.Collections;
import java.util.List;

public class LibrefEventHandler
extends AbstractEventHandler<LibrefEventListenerInterface, LibrefWorkspaceEvent, LibrefServiceInterface>
implements LibrefEventListenerInterface {
    @Override
    public void handleEvents(List<LibrefWorkspaceEvent> list) {
        for (LibrefWorkspaceEvent event : list) {
            switch (event.getType()) {
                case MEMBER_CREATE: {
                    this.memberCreate(event);
                    break;
                }
                case MEMBER_DELETE: {
                    this.memberDelete(event);
                    break;
                }
                case MEMBER_RENAME: {
                    this.memberRename(event);
                    break;
                }
                case MEMBER_REPLACE: {
                    this.memberReplace(event);
                    break;
                }
            }
        }
    }

    @Override
    public List<LibrefWorkspaceEvent> getEvents() {
        List<LibrefWorkspaceEvent> events = null;
        if (!this.isDestroyed() && this._service != null) {
            try {
                events = ((LibrefServiceInterface)this._service).getLibrefEvents().getListOfEvents();
            }
            catch (GeneralServiceExceptionHolder e) {
                events = Collections.emptyList();
            }
        }
        if (events == null) {
            events = Collections.emptyList();
        }
        return events;
    }

    @Override
    public void memberCreate(LibrefWorkspaceEvent event) {
        for (LibrefEventListenerInterface listener : this.getListeners()) {
            listener.memberCreate(event);
        }
    }

    @Override
    public void memberDelete(LibrefWorkspaceEvent event) {
        for (LibrefEventListenerInterface listener : this.getListeners()) {
            listener.memberCreate(event);
        }
    }

    @Override
    public void memberRename(LibrefWorkspaceEvent event) {
        for (LibrefEventListenerInterface listener : this.getListeners()) {
            listener.memberCreate(event);
        }
    }

    @Override
    public void memberReplace(LibrefWorkspaceEvent event) {
        for (LibrefEventListenerInterface listener : this.getListeners()) {
            listener.memberCreate(event);
        }
    }
}

