/*
 * Decompiled with CFR 0.152.
 */
package com.sas.svcs.workspace.client.impl;

import com.sas.svcs.workspace.client.DataEventListenerInterface;
import com.sas.svcs.workspace.client.DataMemberEventListenerInterface;
import com.sas.svcs.workspace.client.DataServiceInterface;
import com.sas.svcs.workspace.client.GeneralServiceExceptionHolder;
import com.sas.svcs.workspace.client.impl.AbstractEventHandler;
import com.sas.svcs.workspace.client.types.DataMemberWorkspaceEvent;
import com.sas.svcs.workspace.client.types.DataWorkspaceEvent;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class DataEventHandler
extends AbstractEventHandler<DataEventListenerInterface, DataWorkspaceEvent, DataServiceInterface>
implements DataEventListenerInterface,
DataMemberEventListenerInterface {
    private final List<DataMemberEventListenerInterface> _memberListeners = new ArrayList<DataMemberEventListenerInterface>(5);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean addMemberListener(DataMemberEventListenerInterface listener) {
        this.verifyNotDestroyed();
        boolean wasAdded = false;
        if (null != listener) {
            List<DataMemberEventListenerInterface> list = this._memberListeners;
            synchronized (list) {
                wasAdded = this._memberListeners.add(listener);
            }
        }
        return wasAdded;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean removeMemberListener(DataMemberEventListenerInterface listener) {
        this.verifyNotDestroyed();
        boolean wasRemoved = false;
        if (null != listener) {
            List<DataMemberEventListenerInterface> list = this._memberListeners;
            synchronized (list) {
                wasRemoved = this._memberListeners.remove(listener);
            }
        }
        return wasRemoved;
    }

    @Override
    public void handleEvents(List<DataWorkspaceEvent> list) {
        for (DataWorkspaceEvent event : list) {
            switch (event.getType()) {
                case LIBRARY_ASSIGN: {
                    this.libraryAssign(event);
                    break;
                }
                case LIBRARY_DEASSIGN: {
                    this.libraryDeassign(event);
                    break;
                }
                case MEMBER_CREATE: {
                    this.memberCreate((DataMemberWorkspaceEvent)event);
                    break;
                }
                case MEMBER_DELETE: {
                    this.memberDelete((DataMemberWorkspaceEvent)event);
                    break;
                }
                case MEMBER_RENAME: {
                    this.memberRename((DataMemberWorkspaceEvent)event);
                    break;
                }
                case MEMBER_REPLACE: {
                    this.memberReplace((DataMemberWorkspaceEvent)event);
                    break;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private DataMemberEventListenerInterface[] getMemberListeners() {
        DataMemberEventListenerInterface[] listeners = null;
        List<DataMemberEventListenerInterface> list = this._memberListeners;
        synchronized (list) {
            listeners = new DataMemberEventListenerInterface[this._memberListeners.size()];
            listeners = this._memberListeners.toArray(listeners);
        }
        return listeners;
    }

    @Override
    public List<DataWorkspaceEvent> getEvents() {
        List<DataWorkspaceEvent> events = null;
        if (!this.isDestroyed() && null != this._service) {
            try {
                events = ((DataServiceInterface)this._service).getDataEvents().getListOfEvents();
            }
            catch (GeneralServiceExceptionHolder e) {
                events = Collections.emptyList();
            }
        }
        if (events == null) {
            events = Collections.emptyList();
        }
        return events;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void destroy() {
        try {
            super.destroy();
        }
        finally {
            List<DataMemberEventListenerInterface> list = this._memberListeners;
            synchronized (list) {
                this._memberListeners.clear();
            }
        }
    }

    @Override
    public void libraryAssign(DataWorkspaceEvent event) {
        for (DataEventListenerInterface listener : this.getListeners()) {
            listener.libraryAssign(event);
        }
    }

    @Override
    public void libraryDeassign(DataWorkspaceEvent event) {
        for (DataEventListenerInterface listener : this.getListeners()) {
            listener.libraryDeassign(event);
        }
    }

    @Override
    public void memberCreate(DataMemberWorkspaceEvent event) {
        for (DataMemberEventListenerInterface listener : this.getMemberListeners()) {
            listener.memberCreate(event);
        }
    }

    @Override
    public void memberDelete(DataMemberWorkspaceEvent event) {
        for (DataMemberEventListenerInterface listener : this.getMemberListeners()) {
            listener.memberDelete(event);
        }
    }

    @Override
    public void memberRename(DataMemberWorkspaceEvent event) {
        for (DataMemberEventListenerInterface listener : this.getMemberListeners()) {
            listener.memberRename(event);
        }
    }

    @Override
    public void memberReplace(DataMemberWorkspaceEvent event) {
        for (DataMemberEventListenerInterface listener : this.getMemberListeners()) {
            listener.memberReplace(event);
        }
    }
}

