/*
 * Decompiled with CFR 0.152.
 */
package com.sas.svcs.workspace.client.impl;

import com.sas.svcs.workspace.client.impl.EventHandlerInterface;
import java.util.ArrayList;
import java.util.List;

public abstract class AbstractEventHandler<L, E, S>
implements EventHandlerInterface<L, E, S>,
Runnable {
    protected S _service;
    private final List<L> _listeners = new ArrayList<L>(5);
    private static final long POLL_INTERVAL_5000_MSEC = 5000L;
    private long _pollIntervalMSEC = 5000L;
    private boolean _isDestroyed;

    public long getPollInterval() {
        return this._pollIntervalMSEC;
    }

    public void setPollInterval(long pollIntervalMsec) {
        if (pollIntervalMsec <= 0L) {
            throw new IllegalArgumentException("The polling interval must be greater than 0 msec.");
        }
        this._pollIntervalMSEC = pollIntervalMsec;
    }

    public boolean isDestroyed() {
        return this._isDestroyed;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void destroy() {
        this._isDestroyed = true;
        List<L> list = this._listeners;
        synchronized (list) {
            this._listeners.clear();
        }
    }

    @Override
    public void run() {
        while (!this.isDestroyed()) {
            try {
                this.handleEvents(this.getEvents());
                Thread.sleep(this.getPollInterval());
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected List<L> getListeners() {
        ArrayList<L> listeners = null;
        List<L> list = this._listeners;
        synchronized (list) {
            listeners = new ArrayList<L>(this._listeners);
        }
        return listeners;
    }

    @Override
    public abstract List<E> getEvents();

    @Override
    public abstract void handleEvents(List<E> var1);

    @Override
    public final void setService(S service) {
        this._service = service;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean addListener(L listener) {
        this.verifyNotDestroyed();
        boolean wasAdded = false;
        if (null != listener) {
            List<L> list = this._listeners;
            synchronized (list) {
                wasAdded = this._listeners.add(listener);
            }
        }
        return wasAdded;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean removeListener(L listener) {
        this.verifyNotDestroyed();
        boolean wasRemoved = false;
        if (null != listener) {
            List<L> list = this._listeners;
            synchronized (list) {
                wasRemoved = this._listeners.remove(listener);
            }
        }
        return wasRemoved;
    }

    protected void verifyNotDestroyed() {
        if (this._isDestroyed) {
            throw new IllegalStateException("This object has been destroyed.");
        }
    }
}

