/*
 * Decompiled with CFR 0.152.
 */
package com.sas.svcs.workspace.client;

import com.sas.svcs.workspace.client.types.DataServiceEventEnum;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;

public final class DataServiceEventEnums {
    private static final Set<DataServiceEventEnum> DATA_EVENT_TYPES = Collections.unmodifiableSet(new HashSet<DataServiceEventEnum>(Arrays.asList(DataServiceEventEnum.LIBRARY_ASSIGN, DataServiceEventEnum.LIBRARY_DEASSIGN)));
    private static final Set<DataServiceEventEnum> DATA_MEMBER_EVENT_TYPES = Collections.unmodifiableSet(new HashSet<DataServiceEventEnum>(Arrays.asList(DataServiceEventEnum.MEMBER_CREATE, DataServiceEventEnum.MEMBER_DELETE, DataServiceEventEnum.MEMBER_RENAME, DataServiceEventEnum.MEMBER_REPLACE)));

    private DataServiceEventEnums() {
    }

    public static Set<DataServiceEventEnum> getDataEventTypes() {
        return DATA_EVENT_TYPES;
    }

    public static Set<DataServiceEventEnum> getDataMemberEventTypes() {
        return DATA_MEMBER_EVENT_TYPES;
    }

    public static boolean containsDataEventType(Collection<DataServiceEventEnum> eventTypes) {
        return DataServiceEventEnums.containsEventType(eventTypes, DATA_EVENT_TYPES);
    }

    public static boolean containsDataMemberEventType(Collection<DataServiceEventEnum> eventTypes) {
        return DataServiceEventEnums.containsEventType(eventTypes, DATA_MEMBER_EVENT_TYPES);
    }

    private static boolean containsEventType(Collection<DataServiceEventEnum> eventTypes, Set<DataServiceEventEnum> eventTypes2) {
        boolean hasEvent = false;
        if (null != eventTypes) {
            for (DataServiceEventEnum eventType : eventTypes2) {
                if (!eventTypes.contains((Object)eventType)) continue;
                hasEvent = true;
                break;
            }
        }
        return hasEvent;
    }
}

