/*
 * Decompiled with CFR 0.152.
 */
package com.sas.tools.deployjni.shortcut;

import com.sas.tools.deployjni.JNIUtils;
import com.sas.tools.deployjni.Utilities;
import com.sas.tools.deployjni.shortcut.ShortcutAPIDef;
import com.sas.tools.deployjni.shortcut.ShortcutException;
import java.util.HashMap;

public class ShortcutAPI {
    public static String JNI_LIBRARY_PATH = System.getProperty("user.dir");
    public static HashMap<String, String> libNames = new HashMap();

    public static void setLoadPath(String path) {
        JNI_LIBRARY_PATH = path;
    }

    public static boolean libraryLoaded() {
        return JNIUtils.libraryLoaded(JNI_LIBRARY_PATH, libNames);
    }

    public static void createShortcut(String folderName, boolean createForAllUsers, String displayName, String targetName, String arguments, String startDirectoryName, String shortcutIconFile) throws ShortcutException {
        if (Utilities.getOS() == 1) {
            ShortcutAPIDef.WinCreateShortcut(folderName, createForAllUsers, displayName, targetName, arguments, startDirectoryName, shortcutIconFile);
        }
    }

    public static boolean deleteShortcut(String folderName, String displayName, boolean removeFolders) throws ShortcutException {
        if (Utilities.getOS() == 1) {
            return ShortcutAPIDef.WinDeleteShortcut(folderName, displayName, removeFolders);
        }
        return false;
    }

    public static String shortcutLocation(String folderName, boolean allUsers, String displayName) throws ShortcutException {
        if (Utilities.getOS() == 1) {
            return ShortcutAPIDef.WinShortcutAbsolutePath(folderName, allUsers, displayName);
        }
        return null;
    }

    static {
        libNames.put("win", "libShortcutW32.dll");
        libNames.put("w64", "libShortcutW64.dll");
        libNames.put("wx6", "libShortcutWX6.dll");
    }
}

