/*
 * Decompiled with CFR 0.152.
 */
package com.sas.tools.deployjni.saswin;

import com.sas.tools.deployjni.Utilities;
import com.sas.tools.deployjni.saswin.SASWinAPIDef;
import com.sas.tools.deployjni.winregistry.WinRegAPI;
import java.util.HashMap;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.core.Logger;

public class SASWinAPI {
    public static String JNI_LIBRARY_PATH = System.getProperty("user.dir");
    public static HashMap<String, String> libNames = new HashMap();
    public static final int MOVEFILE_REPLACE_EXISTING = 1;
    public static final int MOVEFILE_COPY_ALLOWED = 2;
    public static final int MOVEFILE_DELAY_UNTIL_REBOOT = 4;
    public static final int MOVEFILE_WRITE_THROUGH = 8;
    public static final int MOVEFILE_CREATE_HARDLINK = 16;
    public static final int MOVEFILE_FAIL_IF_NOT_TRACKABLE = 32;
    protected static Logger log;

    public static String GetWinVerStr() {
        String return_value = null;
        if (Utilities.getOS() == 1) {
            return_value = SASWinAPIDef.GetWinVerStr();
        }
        return return_value;
    }

    public static String GetSasWinVersion() {
        String return_value = null;
        if (Utilities.getOS() == 1) {
            return_value = SASWinAPIDef.GetSasWinVersion();
        }
        return return_value;
    }

    public static boolean isWow64() {
        boolean return_value = false;
        if (Utilities.getOS() == 1) {
            return_value = SASWinAPIDef.isWow64();
        }
        return return_value;
    }

    public static String getSystemDirectory() {
        String return_value = null;
        if (Utilities.getOS() == 1) {
            return_value = SASWinAPIDef.getSystemDirectory();
        }
        return return_value;
    }

    public static String getSysDr() {
        String return_value = null;
        if (Utilities.getOS() == 1) {
            return_value = SASWinAPIDef.getSysDr();
        }
        return return_value;
    }

    public static String GetProcessorName() {
        String processorName = null;
        if (Utilities.getOS() == 1 && (processorName = WinRegAPI.getWindowsRegistryValue(8, "HARDWARE\\DESCRIPTION\\System\\CentralProcessor\\0", "ProcessorNameString")) == null && (processorName = WinRegAPI.getWindowsRegistryValue(8, "HARDWARE\\DESCRIPTION\\System\\CentralProcessor\\0", "Identifier")) == null) {
            processorName = "Architecture " + SASWinAPI.GetArchitectureWin() + "  Family " + SASWinAPI.GetCPULevelWin() + "  Model" + SASWinAPI.GetCPUModelWin() + "  Stepping" + SASWinAPI.GetCPUSteppingWin();
        }
        return processorName;
    }

    public static int GetCPUNumWin() {
        int return_value = 0;
        if (Utilities.getOS() == 1) {
            return_value = SASWinAPIDef.GetCPUNumWin();
        }
        return return_value;
    }

    public static int GetArchitectureWin() {
        int return_value = 0;
        if (Utilities.getOS() == 1) {
            return_value = SASWinAPIDef.GetArchitectureWin();
        }
        return return_value;
    }

    public static int GetCPULevelWin() {
        int return_value = 0;
        if (Utilities.getOS() == 1) {
            return_value = SASWinAPIDef.GetCPULevelWin();
        }
        return return_value;
    }

    public static int GetCPUModelWin() {
        int return_value = 0;
        if (Utilities.getOS() == 1) {
            return_value = SASWinAPIDef.GetCPUModelWin();
        }
        return return_value;
    }

    public static int GetCPUSteppingWin() {
        int return_value = 0;
        if (Utilities.getOS() == 1) {
            return_value = SASWinAPIDef.GetCPUSteppingWin();
        }
        return return_value;
    }

    public static boolean registerFont(String fontPath) {
        boolean return_value = false;
        if (Utilities.getOS() == 1) {
            return_value = SASWinAPIDef.registerFont(fontPath);
        }
        return return_value;
    }

    public static boolean registerEnvironmentChange() {
        boolean return_value = false;
        if (Utilities.getOS() == 1) {
            return_value = SASWinAPIDef.registerEnvironmentChange();
        }
        return return_value;
    }

    public static boolean unregisterFont(String fontPath) {
        boolean return_value = false;
        if (Utilities.getOS() == 1) {
            return_value = SASWinAPIDef.unregisterFont(fontPath);
        }
        return return_value;
    }

    public static boolean MoveFileEx(String source, String destination, int flags) {
        if (Utilities.getOS() == 1) {
            return SASWinAPIDef.MoveFileEx(source, destination, flags);
        }
        return false;
    }

    public static boolean Copy64NoRedirect(String source, String destination) {
        if (Utilities.getOS() == 1) {
            return SASWinAPIDef.Copy64NoRedirect(source, destination);
        }
        return false;
    }

    public static boolean Delete64NoRedirect(String target) {
        if (Utilities.getOS() == 1) {
            return SASWinAPIDef.Delete64NoRedirect(target);
        }
        return false;
    }

    public static String GetShortPath(String longPath) {
        if (Utilities.getOS() == 1 && longPath != null) {
            if (longPath.startsWith("\"") && longPath.endsWith("\"")) {
                longPath = longPath.substring(1, longPath.length() - 1);
            }
            return SASWinAPIDef.GetShortPath(longPath);
        }
        return null;
    }

    public static boolean SystemShutdown() {
        boolean return_value = false;
        if (Utilities.getOS() == 1) {
            return_value = SASWinAPIDef.SystemShutdown();
        }
        return return_value;
    }

    public static boolean isFileLocked(String path) {
        boolean return_value = false;
        if (Utilities.getOS() == 1) {
            return_value = SASWinAPIDef.IsFileWriteLocked(path);
        }
        return return_value;
    }

    static {
        libNames.put("win", "libSASWinW32.dll");
        libNames.put("w64", "libSASWinW64.dll");
        libNames.put("wx6", "libSASWinWX6.dll");
        log = (Logger)LogManager.getLogger(WinRegAPI.class);
    }
}

