/*
 * Decompiled with CFR 0.152.
 */
package com.sas.tools.deployjni;

import java.io.BufferedReader;
import java.io.File;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.util.HashMap;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.core.Logger;

public class Utilities {
    public static final boolean DEBUG = false;
    public static final int OS_UNDEFINED = 0;
    public static final int OS_WINDOWS = 1;
    public static final int OS_LINUX = 2;
    public static final int OS_SOLARIS = 3;
    public static final int OS_HPUX = 4;
    public static final int OS_AIX = 5;
    public static final int OS_OPENVMS = 6;
    public static final int OS_ALX = 7;
    public static final int OS_MVS = 8;
    public static final int OS_MAC = 9;
    public static final int OS_FREEBSD = 10;
    public static final String OS_SUFFIX_SAX = "sax";
    public static final String OS_SUFFIX_S64 = "s64";
    public static final String OS_SUFFIX_LIX = "lix";
    public static final String OS_SUFFIX_LAX = "lax";
    public static final String OS_SUFFIX_LNX = "lnx";
    public static final String OS_SUFFIX_H6I = "h6i";
    public static final String OS_SUFFIX_H64 = "h64";
    public static final String OS_SUFFIX_R64 = "r64";
    public static final String OS_SUFFIX_ALX = "alx";
    public static final String OS_SUFFIX_W64 = "w64";
    public static final String OS_SUFFIX_WX6 = "wx6";
    public static final String OS_SUFFIX_WIN = "win";
    public static final String OS_SUFFIX_MVS = "mvs";
    public static final String OS_SUFFIX_MAC = "mac";
    public static final String OS_SUFFIX_BSD = "bsd";
    protected static Logger log = (Logger)LogManager.getLogger((String)"com.sas.tools.deployjni.Utilities");
    public static final HashMap<String, String> osDisplayStrings = new HashMap();
    static int m_os;
    static String m_osSuffix;

    public static int getOS() {
        int rc = 0;
        String osName = System.getProperty("os.name");
        if (osName.startsWith("Windows")) {
            rc = 1;
        } else if (osName.equalsIgnoreCase("Linux")) {
            rc = 2;
        } else if (osName.equalsIgnoreCase("Solaris") || osName.equalsIgnoreCase("SunOS")) {
            rc = 3;
        } else if (osName.equalsIgnoreCase("HP-UX")) {
            rc = 4;
        } else if (osName.equalsIgnoreCase("AIX")) {
            rc = 5;
        } else if (osName.equalsIgnoreCase("OpenVMS")) {
            rc = 6;
        } else if (osName.equalsIgnoreCase("Compaq's Digital UNIX") || osName.equalsIgnoreCase("OSF1")) {
            rc = 7;
        } else if (osName.equalsIgnoreCase("z/OS")) {
            rc = 8;
        } else if (osName.startsWith("Mac")) {
            rc = 9;
        } else if (osName.startsWith("OpenVMS")) {
            rc = 6;
        } else if (osName.equalsIgnoreCase("FreeBSD")) {
            rc = 10;
        }
        return rc;
    }

    public static String joinPath(String path1, String path2) {
        String sPath = "";
        String sTemp1 = path1;
        String sTemp2 = path2;
        while (sTemp1.endsWith(File.separator)) {
            sTemp1 = sTemp1.substring(0, sTemp1.length() - 1);
        }
        while (sTemp2.startsWith(File.separator)) {
            sTemp2 = sTemp2.substring(1, sTemp2.length());
        }
        sPath = sTemp1 + File.separator + sTemp2;
        return sPath;
    }

    public static String joinPath(String path1, String path2, String path3) {
        return Utilities.joinPath(Utilities.joinPath(path1, path2), path3);
    }

    public static void logStackTrace(Throwable ex) {
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter((Writer)sw, true);
        ex.printStackTrace(pw);
        log.error("An error occurred during processing:  ");
        if (ex.getMessage() != null) {
            log.error(ex.getMessage());
        }
        log.error(sw.toString());
        for (Throwable cause = ex.getCause(); cause != null; cause = cause.getCause()) {
            sw = new StringWriter();
            pw = new PrintWriter((Writer)sw, true);
            cause.printStackTrace(pw);
            log.error("Caused by:  ");
            if (cause.getMessage() != null) {
                log.error(cause.getMessage());
            }
            log.error(sw.toString());
        }
    }

    static String ExecuteCommand(String[] RunCmd, String[] envp) {
        String buffer = "";
        try {
            String data;
            Process p = Runtime.getRuntime().exec(RunCmd, envp);
            p.waitFor();
            BufferedReader in = new BufferedReader(new InputStreamReader(p.getInputStream()));
            while ((data = in.readLine()) != null) {
                buffer = buffer + data + System.getProperty("line.separator");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return buffer;
    }

    static {
        osDisplayStrings.put(OS_SUFFIX_H64, "HP/UX on RISC");
        osDisplayStrings.put(OS_SUFFIX_H6I, "HP/UX on Itanium");
        osDisplayStrings.put(OS_SUFFIX_LAX, "Linux (64 bit)");
        osDisplayStrings.put(OS_SUFFIX_LNX, "Linux (32 bit)");
        osDisplayStrings.put(OS_SUFFIX_MVS, "z/OS");
        osDisplayStrings.put(OS_SUFFIX_R64, "AIX");
        osDisplayStrings.put(OS_SUFFIX_S64, "Solaris on Sparc");
        osDisplayStrings.put(OS_SUFFIX_SAX, "Solaris on x64");
        osDisplayStrings.put(OS_SUFFIX_W64, "Windows on Itanium");
        osDisplayStrings.put(OS_SUFFIX_WIN, "Windows (32 bit)");
        osDisplayStrings.put(OS_SUFFIX_WX6, "Windows (64 bit on x64)");
        m_os = 0;
        m_osSuffix = null;
    }
}

