/*
 * Decompiled with CFR 0.152.
 */
package com.sas.tools.deployjni;

import com.sas.tools.deployjni.Utilities;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.util.HashMap;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.core.Logger;

public class JNIUtils {
    public static HashMap<String, Boolean> loadedLibs;
    protected static Logger log;
    public static String jniLibKey;
    public static String JNI_LIB_BASE;

    public static boolean libraryLoaded(String loadPath, HashMap<String, String> platforms) {
        if (loadedLibs == null) {
            loadedLibs = new HashMap();
        }
        String libraryName = null;
        libraryName = JNIUtils.getJniLib(platforms);
        if (libraryName == null) {
            return false;
        }
        if (loadedLibs.get(libraryName) == null) {
            loadedLibs.put(libraryName, false);
        }
        if (!loadedLibs.get(libraryName).booleanValue()) {
            if (loadPath == null) {
                loadPath = System.getProperty("user.dir");
            }
            String jniLibrary = Utilities.joinPath(loadPath, libraryName);
            String msg = "";
            if (jniLibrary == "") {
                loadedLibs.put(libraryName, false);
            } else {
                try {
                    System.load(jniLibrary);
                    loadedLibs.put(libraryName, true);
                }
                catch (Throwable e) {
                    loadedLibs.put(libraryName, false);
                    msg = e.getLocalizedMessage();
                }
            }
            if (!loadedLibs.get(libraryName).booleanValue()) {
                System.err.println(msg);
                return false;
            }
        }
        return true;
    }

    public static String getWindowsPlatform() {
        String suffix = "";
        suffix = JNIUtils.isWindows64OS() ? "wx6" : "win";
        return suffix;
    }

    private static boolean isWindows64OS() {
        return System.getenv("ProgramFiles(x86)") != null;
    }

    private static boolean is32bJavaOn64bWin() {
        boolean is32bJavaProcess;
        boolean is64OS = JNIUtils.isWindows64OS();
        String osArch = System.getProperty("os.arch");
        boolean bl = is32bJavaProcess = osArch.length() >= 3 && osArch.substring(0, 3).equalsIgnoreCase("x86");
        return is64OS && is32bJavaProcess;
    }

    private static boolean is64bJavaOn64bWin() {
        boolean is32bJavaProcess;
        boolean is64OS = JNIUtils.isWindows64OS();
        String osArch = System.getProperty("os.arch");
        boolean bl = is32bJavaProcess = osArch.length() >= 3 && osArch.substring(0, 3).equalsIgnoreCase("x86");
        return is64OS && !is32bJavaProcess;
    }

    /*
     * Unable to fully structure code
     */
    public static String getJniLibKey() {
        block23: {
            if (JNIUtils.jniLibKey != null) break block23;
            osArch = System.getProperty("os.arch");
            itanium = osArch.length() >= 4 && osArch.substring(0, 4).equalsIgnoreCase("ia64") != false;
            x86 = osArch.length() >= 3 && osArch.substring(0, 3).equalsIgnoreCase("x86") != false;
            x86_64 = osArch.length() >= 5 && osArch.substring(0, 5).equalsIgnoreCase("amd64") != false;
            switch (Utilities.getOS()) {
                case 3: {
                    if (x86) {
                        JNIUtils.jniLibKey = "sax";
                        break;
                    }
                    if (x86_64) {
                        JNIUtils.jniLibKey = "sax";
                        break;
                    }
                    JNIUtils.jniLibKey = "s64";
                    break;
                }
                case 2: {
                    if (x86_64) ** GOTO lbl38
                    p = null;
                    try {
                        p = Runtime.getRuntime().exec(new String[]{"sh", "-c", "if [ `uname -m` = \"x86_64\" ] ; then exit 1 ; else exit 0 ; fi"});
                        x86_64 = p.waitFor() == 1;
                    }
                    catch (Exception e) {
                        Utilities.logStackTrace(e);
                        e.printStackTrace();
                        System.out.println("Error running sh -c 'if [ `uname -m` = \"x86_64\" ] ; then exit 1 ; else exit 0 ; fi'");
                        JNIUtils.log.error("Error running sh -c 'if [ `uname -m` = \"x86_64\" ] ; then exit 1 ; else exit 0 ; fi'");
                        if (p == null) ** GOTO lbl38
                        in = new BufferedReader(new InputStreamReader(p.getErrorStream()));
                        try {
                            while ((data = in.readLine()) != null) {
                                System.out.println(data + System.getProperty("line.separator"));
                                JNIUtils.log.error(data + System.getProperty("line.separator"));
                            }
                        }
                        catch (IOException e1) {
                            System.out.println("e1:  " + e1);
                        }
                    }
lbl38:
                    // 5 sources

                    if (itanium) {
                        JNIUtils.jniLibKey = "lix";
                        break;
                    }
                    if (x86_64) {
                        JNIUtils.jniLibKey = "lax";
                        break;
                    }
                    JNIUtils.jniLibKey = "lnx";
                    break;
                }
                case 4: {
                    if (itanium) {
                        JNIUtils.jniLibKey = "h6i";
                        break;
                    }
                    JNIUtils.jniLibKey = "h64";
                    break;
                }
                case 5: {
                    JNIUtils.jniLibKey = "r64";
                    break;
                }
                case 7: {
                    JNIUtils.jniLibKey = "alx";
                    break;
                }
                case 1: {
                    if (itanium) {
                        JNIUtils.jniLibKey = "w64";
                        break;
                    }
                    if (JNIUtils.is32bJavaOn64bWin()) {
                        JNIUtils.jniLibKey = "win";
                        break;
                    }
                    if (JNIUtils.is64bJavaOn64bWin()) {
                        JNIUtils.jniLibKey = "wx6";
                        break;
                    }
                    JNIUtils.jniLibKey = "win";
                    break;
                }
                case 10: {
                    JNIUtils.jniLibKey = "bsd";
                    break;
                }
                case 8: {
                    JNIUtils.jniLibKey = "mvs";
                    break;
                }
            }
        }
        return JNIUtils.jniLibKey;
    }

    public static String getJniLib(HashMap<String, String> platforms) {
        return platforms.get(JNIUtils.getJniLibKey());
    }

    static {
        log = (Logger)LogManager.getLogger((String)"com.sas.tools.deployjni.JNIUtils");
        jniLibKey = null;
        if (System.getProperty("sharedLibs") != null) {
            JNI_LIB_BASE = System.getProperty("sharedLibs");
        } else {
            try {
                JNI_LIB_BASE = new File(URLDecoder.decode(JNIUtils.class.getProtectionDomain().getCodeSource().getLocation().getFile(), "UTF-8")).getParentFile().getAbsolutePath();
            }
            catch (UnsupportedEncodingException e) {
                JNI_LIB_BASE = new File(URLDecoder.decode(JNIUtils.class.getProtectionDomain().getCodeSource().getLocation().getFile())).getParentFile().getAbsolutePath();
            }
        }
    }
}

