/*
 * Decompiled with CFR 0.152.
 */
package com.sas.svcs.config.client;

import java.io.Serializable;
import java.net.InetAddress;
import java.net.UnknownHostException;

public class ApplicationRegistration
implements Serializable {
    private static final long serialVersionUID = 1L;
    private String name;
    private String protocol;
    private String host;
    private int port = -1;
    private String context;
    private String subnet;
    private String externalProtocol;
    private String externalHost;
    private String externalContext;
    private int externalPort = -1;

    public void setContext(String c) {
        this.context = c;
    }

    public void setHost(String h) {
        this.host = h;
    }

    public void setPort(int p) {
        this.port = p;
    }

    public void setProtocol(String p) {
        this.protocol = p;
    }

    public int getPort() {
        return this.port;
    }

    public String getProtocol() {
        return this.protocol;
    }

    public String getContext() {
        return this.context;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String n) {
        this.name = n;
    }

    public String getHost() {
        return this.host;
    }

    public boolean isSecure() {
        return "https".equalsIgnoreCase(this.protocol);
    }

    public String getExternalProtocol() {
        if (null != this.externalProtocol) {
            return this.externalProtocol;
        }
        return this.getProtocol();
    }

    public void setExternalProtocol(String externalProtocol) {
        this.externalProtocol = externalProtocol;
    }

    public String getExternalHost() {
        if (null != this.externalHost) {
            return this.externalHost;
        }
        return this.getHost();
    }

    public void setExternalHost(String externalHost) {
        this.externalHost = externalHost;
    }

    public int getExternalPort() {
        if (-1 != this.externalPort) {
            return this.externalPort;
        }
        return this.getPort();
    }

    public void setExternalPort(int externalPort) {
        this.externalPort = externalPort;
    }

    public String getExternalContext() {
        if (null != this.externalContext) {
            return this.externalContext;
        }
        return this.getContext();
    }

    public void setExternalContext(String externalService) {
        this.externalContext = externalService;
    }

    public String getSubnet() {
        return this.subnet;
    }

    public void setSubnet(String subnet) {
        this.subnet = subnet;
    }

    public String getExternalUrl() {
        if (null == this.externalContext || null == this.externalHost || -1 == this.externalPort) {
            return this.getUrl();
        }
        return this.getUri(this.getExternalProtocol(), this.externalHost, this.externalPort, this.externalContext);
    }

    public String getUrl() {
        return this.getUri(this.host);
    }

    public String getIPUrl() {
        try {
            InetAddress address = InetAddress.getByName(this.host);
            return this.getUri(address.getHostAddress());
        }
        catch (UnknownHostException e) {
            IllegalStateException ise = new IllegalStateException("Unable to determine IP Address for " + this.host);
            ise.initCause(e);
            throw ise;
        }
    }

    protected String getUri(String server) {
        return this.getUri(this.protocol, server, this.port, this.context);
    }

    protected String getUri(String prtcl, String hst, int prt, String cntxt) {
        if (null == hst) {
            throw new IllegalStateException("The server host must be specified.");
        }
        StringBuffer uri = new StringBuffer();
        if (!"".equals(hst)) {
            if (!hst.startsWith("http:") && !hst.startsWith("https:")) {
                uri.append(prtcl);
                uri.append("://");
            }
            uri.append(hst);
            if (prt != -1 && 80 != prt && 443 != prt) {
                uri.append(':').append(prt);
            }
        }
        if (0 == cntxt.length() || '/' != cntxt.charAt(0)) {
            uri.append('/');
        }
        uri.append(cntxt);
        return uri.toString();
    }

    public String toString() {
        return "ApplicationRegistration [name=" + this.name + ", protocol=" + this.protocol + ", host=" + this.host + ", port=" + this.port + ", context=" + this.context + ", subnet=" + this.subnet + ", externalProtocol=" + this.externalProtocol + ", externalHost=" + this.externalHost + ", externalContext=" + this.externalContext + ", externalPort=" + this.externalPort + "]";
    }
}

