/*
 * Decompiled with CFR 0.152.
 */
package com.sas.tkgridmon.client;

import com.sas.tkgridmon.client.LocalMon;
import com.sas.tkgridmon.client.RankDisplay;
import com.sas.tkgridmon.client.TKGridMonProcess;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;

public class jobLabel
extends Component
implements Comparable<jobLabel> {
    private static final long serialVersionUID = 1L;
    JPopupMenu popup;
    JMenuItem menuItem;
    JFrame jobFrame;
    JPanel jobPane;
    JScrollPane scroll;
    boolean active;
    String name;
    ArrayList<TKGridMonProcess> ranks;
    int nice;
    int pid;
    int sure = 0;
    String targetUserName;
    jobLabel self = this;
    int updateCounter = 0;
    boolean fullScale = true;

    public jobLabel(String name) {
        this.name = name;
        this.jobFrame = new JFrame();
        this.jobFrame.setSize(400, 200);
        this.jobFrame.setLocation(100, 100);
        this.jobPane = new JPanel();
        JMenuBar menuBar = new JMenuBar();
        JMenu menu = new JMenu("Menu");
        menu.setMnemonic(65);
        this.jobFrame.setJMenuBar(menuBar);
        JMenu scaling = new JMenu("Scaling");
        final JMenuItem option1 = new JMenuItem("One CPU");
        final JMenuItem option2 = new JMenuItem("Full Node");
        option1.setOpaque(true);
        option2.setOpaque(true);
        option2.setBackground(Color.GRAY);
        option1.setBackground(Color.WHITE);
        option1.addMouseListener(new MouseListener(){

            @Override
            public void mouseClicked(MouseEvent e) {
            }

            @Override
            public void mouseEntered(MouseEvent e) {
            }

            @Override
            public void mouseExited(MouseEvent e) {
            }

            @Override
            public void mousePressed(MouseEvent e) {
                option1.setBackground(Color.GRAY);
                option2.setBackground(Color.WHITE);
                jobLabel.this.fullScale = false;
            }

            @Override
            public void mouseReleased(MouseEvent e) {
            }
        });
        scaling.add(option1);
        option2.addMouseListener(new MouseListener(){

            @Override
            public void mouseClicked(MouseEvent e) {
            }

            @Override
            public void mouseEntered(MouseEvent e) {
            }

            @Override
            public void mouseExited(MouseEvent e) {
            }

            @Override
            public void mousePressed(MouseEvent e) {
                option2.setBackground(Color.GRAY);
                option1.setBackground(Color.WHITE);
                jobLabel.this.fullScale = true;
            }

            @Override
            public void mouseReleased(MouseEvent e) {
            }
        });
        scaling.add(option2);
        menu.add(scaling);
        menuBar.add(menu);
        this.jobPane.setBackground(Color.white);
        this.jobPane.setSize(500, 800);
        this.scroll = new JScrollPane(this.jobPane);
        this.scroll.getVerticalScrollBar().setUnitIncrement(16);
        this.scroll.setHorizontalScrollBarPolicy(31);
        this.jobPane.setAlignmentX(0.0f);
        this.jobPane.setLayout(new FlowLayout(0));
        this.setMaximumSize(new Dimension(500, 20));
        this.scroll.addComponentListener(new ComponentListener(){

            @Override
            public void componentHidden(ComponentEvent e) {
            }

            @Override
            public void componentMoved(ComponentEvent e) {
            }

            @Override
            public void componentResized(ComponentEvent arg0) {
                int a = (jobLabel.this.jobPane.getComponentCount() / ((jobLabel.this.jobPane.getWidth() + 1) / 80) + 1) * 40 + 5;
                if (jobLabel.this.jobPane.getComponentCount() % ((jobLabel.this.jobPane.getWidth() + 1) / 80) == 0) {
                    a -= 46;
                }
                jobLabel.this.jobPane.setPreferredSize(new Dimension(jobLabel.this.jobFrame.getWidth() - 25, a));
                jobLabel.this.jobPane.setSize(new Dimension(jobLabel.this.jobFrame.getWidth() - 25, a));
            }

            @Override
            public void componentShown(ComponentEvent e) {
            }
        });
        this.jobFrame.add(this.scroll);
        this.jobFrame.setTitle(name);
        this.jobPane.setName(name);
        int a = (this.jobPane.getComponentCount() / ((this.jobPane.getWidth() + 1) / 80) + 1) * 40 + 5;
        if (this.jobPane.getComponentCount() % ((this.jobPane.getWidth() + 1) / 80) == 0) {
            a -= 46;
        }
        this.jobPane.setPreferredSize(new Dimension(this.jobFrame.getWidth() - 25, a));
        this.jobPane.setSize(new Dimension(this.jobFrame.getWidth() - 25, a));
        PopupListener popupListener = new PopupListener();
        this.addMouseListener(popupListener);
        this.popup = new JPopupMenu();
        this.menuItem = new JMenuItem("Kill Job");
        this.menuItem.addMouseListener(new MouseListener(){

            @Override
            public void mouseClicked(MouseEvent e) {
            }

            @Override
            public void mouseEntered(MouseEvent e) {
            }

            @Override
            public void mouseExited(MouseEvent e) {
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                int x = 0;
                String data = "";
                if (System.getenv().get("GRIDRSHCOMMAND") != "") {
                    data = "\"export GRIDRSHCOMMAND=" + System.getenv().get("GRIDRSHCOMMAND") + "; ";
                }
                if (jobLabel.this.isRootOrSame()) {
                    data = data + LocalMon.gridInstall + "/bin/killpid.sh ";
                } else if (jobLabel.this.getSudo(jobLabel.this.targetUserName).equals("sudo")) {
                    data = data + LocalMon.gridInstall + "/bin/sudokillpid.sh ";
                } else {
                    return;
                }
                while (x < jobLabel.this.ranks.size()) {
                    ArrayList<String> cmds = new ArrayList<String>();
                    if (!LocalMon.TKsshPath.equals("")) {
                        if (LocalMon.TKsshPath.contains("sdssas")) {
                            for (int x1 = 0; x1 < LocalMon.TKsshPath.split(" ").length; ++x1) {
                                if (LocalMon.TKsshPath.split(" ")[x1].trim() == "") continue;
                                cmds.add(LocalMon.TKsshPath.split(" ")[x1].trim());
                            }
                        } else {
                            cmds.add(LocalMon.TKsshPath);
                        }
                        cmds.add(LocalMon.gridHost);
                    }
                    if (File.separatorChar == '/') {
                        cmds.add(LocalMon.gridSSHPath);
                    } else {
                        cmds.add(LocalMon.gridSSHPath);
                    }
                    cmds.add(LocalMon.gridHost);
                    for (int y = 0; y < 30 && x < jobLabel.this.ranks.size(); ++x, ++y) {
                        data = data + jobLabel.this.ranks.get(x).getHostName() + " " + jobLabel.this.ranks.get(x).getPid() + " ";
                    }
                    data = data + "\"";
                    cmds.add(data);
                    ProcessBuilder pb = new ProcessBuilder(cmds.toArray(new String[cmds.size()]));
                    try {
                        pb.start();
                    }
                    catch (IOException e1) {
                        System.out.println("failed to kill");
                        e1.printStackTrace();
                    }
                }
            }

            @Override
            public void mousePressed(MouseEvent e) {
            }
        });
        this.popup.add(this.menuItem);
        this.menuItem = new JMenuItem("Increase Priority (Requires Sudo or Root)");
        this.menuItem.addMouseListener(new MouseListener(){

            @Override
            public void mouseClicked(MouseEvent e) {
            }

            @Override
            public void mouseEntered(MouseEvent e) {
            }

            @Override
            public void mouseExited(MouseEvent e) {
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                for (int x = 0; x < jobLabel.this.ranks.size(); ++x) {
                    ArrayList<String> cmds = new ArrayList<String>();
                    if (!LocalMon.TKsshPath.equals("")) {
                        if (LocalMon.TKsshPath.contains("sdssas")) {
                            for (int x1 = 0; x1 < LocalMon.TKsshPath.split(" ").length; ++x1) {
                                if (LocalMon.TKsshPath.split(" ")[x1].trim() == "") continue;
                                cmds.add(LocalMon.TKsshPath.split(" ")[x1].trim());
                            }
                        } else {
                            cmds.add(LocalMon.TKsshPath);
                        }
                        cmds.add(LocalMon.gridHost);
                    }
                    if (File.separatorChar == '/') {
                        cmds.add(LocalMon.gridSSHPath);
                    } else {
                        cmds.add(LocalMon.gridSSHPath);
                    }
                    cmds.add(LocalMon.gridHost);
                    if (!jobLabel.this.isRoot()) {
                        return;
                    }
                    String data = "\"sudo renice " + (jobLabel.this.nice - 1) + " -p \\ `ls /proc/" + jobLabel.this.ranks.get(x).getPid() + "/task\\`\"";
                    cmds.add(data);
                    ProcessBuilder pb = new ProcessBuilder(cmds.toArray(new String[cmds.size()]));
                    try {
                        pb.start();
                        continue;
                    }
                    catch (IOException e1) {
                        System.out.println("failed to increase priority");
                        e1.printStackTrace();
                    }
                }
            }

            @Override
            public void mousePressed(MouseEvent e) {
            }
        });
        this.menuItem = new JMenuItem("Decrease Priority");
        this.menuItem.addMouseListener(new MouseListener(){

            @Override
            public void mouseClicked(MouseEvent e) {
            }

            @Override
            public void mouseEntered(MouseEvent e) {
            }

            @Override
            public void mouseExited(MouseEvent e) {
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                String sudo = jobLabel.this.getSudo(jobLabel.this.targetUserName);
                if (sudo.equals("cancel")) {
                    return;
                }
                for (int x = 0; x < jobLabel.this.ranks.size(); ++x) {
                    ArrayList<String> cmds = new ArrayList<String>();
                    if (!LocalMon.TKsshPath.equals("")) {
                        if (LocalMon.TKsshPath.contains("sdssas")) {
                            for (int x1 = 0; x1 < LocalMon.TKsshPath.split(" ").length; ++x1) {
                                if (LocalMon.TKsshPath.split(" ")[x1].trim() == "") continue;
                                cmds.add(LocalMon.TKsshPath.split(" ")[x1].trim());
                            }
                        } else {
                            cmds.add(LocalMon.TKsshPath);
                        }
                        cmds.add(LocalMon.gridHost);
                    }
                    if (File.separatorChar == '/') {
                        cmds.add(LocalMon.gridSSHPath);
                    } else {
                        cmds.add(LocalMon.gridSSHPath);
                    }
                    cmds.add(LocalMon.gridHost);
                    String data = "\"" + sudo + " renice " + (jobLabel.this.nice + 1) + " -p \\ `ls /proc/" + jobLabel.this.ranks.get(x).getPid() + "/task\\`\"";
                    cmds.add(data);
                    System.out.println(x + " " + jobLabel.this.ranks.size());
                    ProcessBuilder pb = new ProcessBuilder(cmds.toArray(new String[cmds.size()]));
                    try {
                        pb.start();
                        continue;
                    }
                    catch (IOException e1) {
                        System.out.println("failed to decrease priority");
                        e1.printStackTrace();
                    }
                }
                ++jobLabel.this.nice;
            }

            @Override
            public void mousePressed(MouseEvent e) {
            }
        });
        this.menuItem = new JMenuItem("Show Ranks");
        this.menuItem.addMouseListener(new MouseListener(){

            @Override
            public void mouseClicked(MouseEvent e) {
            }

            @Override
            public void mouseEntered(MouseEvent e) {
            }

            @Override
            public void mouseExited(MouseEvent e) {
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                if (!jobLabel.this.jobFrame.isVisible()) {
                    if (jobLabel.this.jobPane.getComponentCount() < 15) {
                        jobLabel.this.jobFrame.setSize(400, 200);
                    } else {
                        jobLabel.this.jobFrame.setSize(500, 500);
                    }
                    jobLabel.this.jobFrame.setLocation(100, 100);
                }
                jobLabel.this.jobFrame.setVisible(true);
            }

            @Override
            public void mousePressed(MouseEvent e) {
                if (!jobLabel.this.jobFrame.isVisible()) {
                    if (jobLabel.this.jobPane.getComponentCount() < 15) {
                        jobLabel.this.jobFrame.setSize(400, 200);
                    } else {
                        jobLabel.this.jobFrame.setSize(500, 500);
                    }
                    jobLabel.this.jobFrame.setLocation(100, 100);
                }
                jobLabel.this.jobFrame.setVisible(true);
            }
        });
        this.popup.add(this.menuItem);
    }

    protected boolean isRootOrSame() {
        String userName = System.getenv().get("TKSSH_USER") != null ? System.getenv().get("TKSSH_USER") : (File.separatorChar == '/' ? System.getenv().get("USER") : System.getenv().get("USERNAME"));
        return userName.equals("root") || userName.equals(this.targetUserName);
    }

    public void setText(String name2) {
        this.name = name2;
    }

    String getText() {
        return this.name;
    }

    @Override
    public void paint(Graphics G) {
        Graphics2D g = (Graphics2D)G;
        g.setColor(Color.black);
        g.setFont(new Font("Courier", 0, 13));
        g.drawString(" " + this.getText(), 0, 12);
    }

    public void updateRanks(ArrayList<TKGridMonProcess> ranks) {
        this.updateCounter = 0;
        Collections.sort(ranks);
        this.ranks = ranks;
        if (ranks != null) {
            for (int x = 0; x < ranks.size(); ++x) {
                if (this.jobPane.getComponentCount() <= x) {
                    this.jobPane.add(new RankDisplay("" + ranks.get(x).getRank(), this));
                }
                if (ranks.get(x).getSnapServerPort() != 0) {
                    String title = this.name + "   Lasr Port: " + ranks.get(x).getSnapServerPort() + "   Connections " + ranks.get((int)x).activeConnections + ":" + ranks.get((int)x).pendingConnections;
                    if (!this.jobFrame.getTitle().equals(title)) {
                        this.jobFrame.setTitle(title);
                    }
                    this.ranks.get(0).setSnapServerPort(ranks.get(x).getSnapServerPort());
                    this.ranks.get(0).setActiveC(ranks.get((int)x).activeConnections);
                    this.ranks.get(0).setPendingC(ranks.get((int)x).pendingConnections);
                } else {
                    this.jobFrame.setTitle(this.name);
                }
                String clip = ranks.get(x).getUserID().split(":")[0] + this.spaces(20 - ranks.get(x).getUserID().split(":")[0].length()) + ranks.get(x).getUserID().split(":")[1] + this.spaces(20 - ranks.get(x).getUserID().split(":")[1].length()) + ranks.get(x).getPid() + this.spaces(20 - (ranks.get(x).getPid() + "").length()) + ranks.get(x).getRunningTime() + this.spaces(20 - ranks.get(x).getRunningTime().length()) + ranks.get(x).getCpuUsage() / (double)ranks.get(x).getCpus() + this.spaces(15 - (ranks.get(x).getCpuUsage() / (double)ranks.get(x).getCpus() + "").length()) + ranks.get(x).getMemUsed() / ranks.get(x).getMemTotal() + this.spaces(20 - (ranks.get(x).getMemUsed() / ranks.get(x).getMemTotal() + "").length()) + ranks.get(x).getSnapServerPort() + this.spaces(15 - (ranks.get(x).getSnapServerPort() + "").length()) + ranks.get((int)x).activeConnections + this.spaces(10 - (ranks.get((int)x).activeConnections + "").length()) + ranks.get((int)x).pendingConnections + "\n";
                ((RankDisplay)this.jobPane.getComponent(x)).setNumbers(ranks.get(x).getCpuUsage() / ((double)ranks.get(x).getCpus() * 100.0), ranks.get((int)x).timeLeft, ranks.get((int)x).maxTime, ranks.get(x).getHostName(), ranks.get(x).getRank(), ranks.get(x).getPid(), ranks.get(x).getParentpid(), (double)ranks.get(x).getMemUsed() / (double)ranks.get(x).getMemTotal(), ranks.get(x).getNice(), (double)ranks.get(x).getMemUsed() / 1048576.0, clip, ranks.get(x).getCpus(), this.fullScale);
            }
        }
    }

    @Override
    public int compareTo(jobLabel arg0) {
        return this.name.compareTo(arg0.name);
    }

    protected boolean isRoot() {
        String userName = System.getenv().get("TKSSH_USER") != null ? System.getenv().get("TKSSH_USER") : (File.separatorChar == '/' ? System.getenv().get("USER") : System.getenv().get("USERNAME"));
        return userName.equals("root");
    }

    String getSudo(String targetName) {
        this.sure = 0;
        String userName = System.getenv().get("TKSSH_USER") != null ? System.getenv().get("TKSSH_USER") : (File.separatorChar == '/' ? System.getenv().get("USER") : System.getenv().get("USERNAME"));
        if (userName.equals(targetName) || userName.equals("root")) {
            return "";
        }
        JFrame frame = new JFrame();
        Object[] options = new Object[]{"Yes", "No"};
        int n = JOptionPane.showOptionDialog(frame, "You are trying to modify a process that is not your own.\nDo you want to modify " + targetName + "'s process?", "Sudo Action?", 1, 3, null, options, options[1]);
        if (this.sure == 0) {
            return "sudo";
        }
        if (this.sure == 1) {
            return "cancel";
        }
        return "";
    }

    public int getNice() {
        return this.nice;
    }

    public void setNice(int nice) {
        this.nice = nice;
    }

    public int getPid() {
        return this.pid;
    }

    public void setPid(int pid) {
        this.pid = pid;
    }

    public void setUserName(String p1) {
        this.targetUserName = p1;
    }

    public JFrame getFrame() {
        return this.jobFrame;
    }

    String spaces(int n) {
        String x = "";
        for (int y = 0; y < n; ++y) {
            x = x + " ";
        }
        return x;
    }

    class PopupListener
    extends MouseAdapter {
        PopupListener() {
        }

        @Override
        public void mousePressed(MouseEvent e) {
            if (e.getButton() == 1) {
                jobLabel.this.jobFrame.setVisible(true);
            }
            if (e.getButton() == 3) {
                jobLabel.this.popup.show(e.getComponent(), e.getX(), e.getY());
            }
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            if (e.getButton() == 1) {
                jobLabel.this.jobFrame.setVisible(true);
            }
        }
    }
}

