/*
 * Decompiled with CFR 0.152.
 */
package com.sas.tkgridmon.client;

import com.sas.tkgridmon.client.LocalMon;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;

public class UserDataGraph
extends Component {
    String[] names = new String[]{"1", "2", "3", "4", "5"};
    double[] percents = new double[]{50.0, 20.0, 20.0, 5.0, 1.0};
    double[] percentMems = new double[]{50.0, 70.0, 20.0, 60.0, 1.0};
    double[] actualMems = new double[]{50.0, 70.0, 20.0, 60.0, 1.0};
    double totalMem;
    private static final long serialVersionUID = -843463815069684332L;

    public UserDataGraph() {
        this.setPreferredSize(new Dimension(250, 150));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void paint(Graphics G) {
        Graphics2D g = (Graphics2D)G;
        g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g.setFont(LocalMon.f);
        int pxPerBar = 40;
        g.setColor(Color.black);
        g.drawRect(0, 0, this.getWidth(), this.getHeight());
        g.setColor(Color.white);
        g.fillRect(0, 0, this.getWidth(), this.getHeight());
        String[] stringArray = this.names;
        synchronized (this.names) {
            int x;
            for (x = 0; x < this.percents.length; ++x) {
                int y;
                String nameSpace = "";
                String cpuToMemSpacing = "";
                if (this.percentMems[x] < 0.0) {
                    this.percentMems[x] = 0.0;
                }
                if (this.percents[x] < 0.0) {
                    this.percents[x] = 0.0;
                }
                if (this.names[x] == null || this.names[x].equals("")) break;
                String cpuToMem = (double)((int)(this.percents[x] * 100.0)) / 100.0 + "% CPU";
                for (y = 0; y < 22 - cpuToMem.length(); ++y) {
                    cpuToMemSpacing = cpuToMemSpacing + " ";
                }
                for (y = 0; y < 21 - this.names[x].length(); ++y) {
                    nameSpace = nameSpace + " ";
                }
                g.setColor(Color.black);
                g.drawRect(0, (pxPerBar + 5) * x, this.getWidth() - 5, pxPerBar);
                g.setColor(Color.green);
                g.fillRect(1, (pxPerBar + 5) * x, (int)(this.percents[x] / 100.0 * (double)(this.getWidth() - 5)), pxPerBar / 2);
                g.setColor(Color.cyan);
                g.fillRect(1, (pxPerBar + 5) * x + pxPerBar / 2, (int)(this.percentMems[x] / 100.0 * (double)(this.getWidth() - 5)), pxPerBar / 2);
                g.setColor(Color.blue);
                g.drawString("    " + this.names[x] + nameSpace + (double)((int)(this.percents[x] * 100.0)) / 100.0 + "% CPU" + cpuToMemSpacing + (double)((int)(this.percentMems[x] * 10.0)) / 10.0 + "% Memory, " + this.actualMems[x] + "/" + this.totalMem + " GB", 0, (pxPerBar + 5) * x + 13);
            }
            // ** MonitorExit[var5_4] (shouldn't be in output)
            this.setSize(this.getWidth(), x * (pxPerBar + 5));
            this.setPreferredSize(new Dimension(this.getWidth(), x * (pxPerBar + 5)));
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setData(double[] percents2, double[] percentMems, String[] names2, double[] actualMems, long totalMem) {
        String[] stringArray = this.names;
        synchronized (this.names) {
            this.percents = percents2;
            this.names = names2;
            this.actualMems = actualMems;
            this.totalMem = totalMem;
            this.percentMems = percentMems;
            for (int x = 0; x < this.percents.length; ++x) {
                int n = x;
                this.actualMems[n] = this.actualMems[n] / 1048576.0;
                this.actualMems[x] = (double)((int)(this.actualMems[x] * 10.0)) / 10.0;
            }
            this.totalMem /= 1048576.0;
            this.totalMem = (double)((int)(this.totalMem * 10.0)) / 10.0;
            // ** MonitorExit[var7_6] (shouldn't be in output)
            return;
        }
    }
}

