/*
 * Decompiled with CFR 0.152.
 */
package com.sas.tkgridmon.client;

import com.sas.tkgridmon.client.TKGridMonProcess;
import com.sas.tkgridmon.client.TKGridMonUser;
import java.io.Serializable;
import java.util.Arrays;

public class TKGridMonNode
implements Serializable {
    private static final long serialVersionUID = 1375727306542117856L;
    private final String name;
    private final int rank;
    private final int cpuCount;
    private int[] cpuLevels;
    private int[] meanCpuLevels;
    private int bytesIn;
    private int bytesOut;
    private int memTotal;
    private int memFree;
    private TKGridMonProcess[] processInfo;
    private TKGridMonUser[] userInfo;
    private long lastUpdateTime;
    private boolean unresponsive;
    private int maxNet;

    protected TKGridMonNode copy() {
        TKGridMonNode n = new TKGridMonNode(this.name, this.rank, this.cpuCount);
        if (this.cpuLevels != null) {
            n.cpuLevels = new int[this.cpuLevels.length];
            System.arraycopy(this.cpuLevels, 0, n.cpuLevels, 0, this.cpuLevels.length);
        }
        if (this.meanCpuLevels != null) {
            n.meanCpuLevels = new int[this.meanCpuLevels.length];
            System.arraycopy(this.meanCpuLevels, 0, n.meanCpuLevels, 0, this.meanCpuLevels.length);
        }
        n.bytesIn = this.bytesIn;
        n.bytesOut = this.bytesOut;
        n.memTotal = this.memTotal;
        n.memFree = this.memFree;
        n.userInfo = null;
        n.lastUpdateTime = this.lastUpdateTime;
        n.unresponsive = this.unresponsive;
        n.processInfo = this.processInfo;
        n.maxNet = this.maxNet;
        return n;
    }

    public TKGridMonNode(String name, int rank, int cpuCount) {
        this.name = name;
        this.rank = rank;
        this.cpuCount = cpuCount;
        this.cpuLevels = new int[cpuCount];
        this.meanCpuLevels = new int[cpuCount];
        this.unresponsive = false;
    }

    public String getName() {
        return this.name;
    }

    public int getRank() {
        return this.rank;
    }

    public int getCpuCount() {
        return this.cpuCount;
    }

    public int[] getCpuLevels() {
        return this.cpuLevels;
    }

    protected void setCpuLevel(int idx, int cpuLevel) {
        this.cpuLevels[idx] = cpuLevel;
    }

    protected void setMeanCpuLevel(int idx, int cpuLevel) {
        this.meanCpuLevels[idx] = cpuLevel;
    }

    public int getBytesIn() {
        return this.bytesIn;
    }

    protected void setBytesIn(int bytesIn) {
        this.bytesIn = bytesIn;
    }

    public int getBytesOut() {
        return this.bytesOut;
    }

    protected void setBytesOut(int bytesOut) {
        this.bytesOut = bytesOut;
    }

    public int getMemTotal() {
        return this.memTotal;
    }

    protected void setMemTotal(int memTotal) {
        this.memTotal = memTotal;
    }

    public int getMemFree() {
        return this.memFree;
    }

    protected void setMemFree(int memFree) {
        this.memFree = memFree;
    }

    public synchronized TKGridMonProcess[] getProcessInfo() {
        return this.processInfo;
    }

    protected void setProcessInfo(TKGridMonProcess[] processInfo) {
        this.processInfo = processInfo;
    }

    public synchronized TKGridMonUser[] getUserInfo() {
        return this.userInfo;
    }

    protected synchronized void setUserInfo(TKGridMonUser[] userInfo) {
        this.userInfo = userInfo;
    }

    protected long getLastUpdateTime() {
        return this.lastUpdateTime;
    }

    protected void setLastUpdateTime(long lastUpdateTime) {
        this.lastUpdateTime = lastUpdateTime;
    }

    public boolean isUnresponsive() {
        return this.unresponsive;
    }

    protected void setUnresponsive(boolean unresponsive) {
        this.unresponsive = unresponsive;
    }

    public String toString() {
        return "TKGridMonNode [name=" + this.name + ", rank=" + this.rank + ", bytesIn=" + this.bytesIn + ", bytesOut=" + this.bytesOut + ", cpuCount=" + this.cpuCount + ", cpuLevels=" + Arrays.toString(this.cpuLevels) + ", memFree=" + this.memFree + ", memTotal=" + this.memTotal + ", userInfo=" + Arrays.toString(this.userInfo) + "]";
    }

    public int[] getMeanCpuLevels() {
        return this.meanCpuLevels;
    }

    public void setMaxNet(int max) {
        this.maxNet = max;
    }

    public int getnetMax() {
        return this.maxNet;
    }
}

