/*
 * Decompiled with CFR 0.152.
 */
package com.sas.tkgridmon.client;

import com.sas.tkgridmon.client.LocalMon;
import com.sas.tkgridmon.client.TKGridMonNode;
import com.sas.tkgridmon.client.TKGridMonProcess;
import com.sas.tkgridmon.client.TKGridMonUser;
import java.awt.Label;
import java.io.BufferedReader;
import java.io.DataInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.ServerSocket;
import java.net.Socket;
import java.util.ArrayList;
import java.util.Map;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import javax.swing.JFrame;

public class TKGridMonConnectionManager {
    private int connectionTimeoutSeconds = 120;
    private int unresponsiveTimeoutSeconds = 30;
    private String shellCommand;
    private String startCommand;
    private ServerSocket serverSocket;
    private Socket socket;
    private int maxRanks = 10000;
    private final BlockingQueue<Socket> socketQueue = new LinkedBlockingQueue<Socket>();
    private final byte[] nameBuffer = new byte[64];
    private TKGridMonNode[] nodes = new TKGridMonNode[200];
    private int highRank;
    private final Object nodeLock = new Object();
    public boolean isStarted = false;
    Process tkgridmonProcess;

    public TKGridMonConnectionManager() {
        this.shellCommand = File.separatorChar == '/' ? "/bin/sh" : "cmd /c";
    }

    public synchronized void shutdownNow() {
        this.tkgridmonProcess.destroy();
        this.close(this.socket);
        this.socket = null;
        this.close(this.serverSocket);
        this.serverSocket = null;
    }

    private void close(Socket socket) {
        if (socket != null) {
            try {
                socket.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private void close(ServerSocket serverSocket) {
        if (serverSocket != null) {
            try {
                serverSocket.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public synchronized void startTKGridMon(int port) throws IOException {
        this.close(this.serverSocket);
        this.serverSocket = new ServerSocket(port);
        this.log("ServerSocket open on " + this.serverSocket.getLocalPort());
        Thread t = new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    TKGridMonConnectionManager.this.socket = TKGridMonConnectionManager.this.serverSocket.accept();
                    DataInputStream in = new DataInputStream(TKGridMonConnectionManager.this.socket.getInputStream());
                    while (TKGridMonConnectionManager.this.serverSocket != null && in.available() == 0) {
                        Thread.sleep(100L);
                    }
                    TKGridMonConnectionManager.this.socketQueue.add(TKGridMonConnectionManager.this.socket);
                    while (true) {
                        TKGridMonConnectionManager.this.readRecord(in);
                    }
                }
                catch (Exception ex) {
                    TKGridMonConnectionManager.this.shutdownNow();
                    return;
                }
            }
        }, "socketHandler");
        t.setDaemon(true);
        t.start();
        this.startProcess(this.serverSocket.getLocalPort());
        try {
            Socket s = this.socketQueue.poll(this.getConnectionTimeoutSeconds(), TimeUnit.SECONDS);
            if (s == null) {
                JFrame ConnectionFail = new JFrame();
                ConnectionFail.add(new Label("Failed to connect "));
                ConnectionFail.setDefaultCloseOperation(3);
                ConnectionFail.setSize(150, 70);
                ConnectionFail.show();
                this.shutdownNow();
                throw new IOException("TKGridMon failed to start within " + this.getConnectionTimeoutSeconds() + " seconds");
            }
            if (!LocalMon.noUI) {
                this.log("TKGridMon ready on port " + s.getLocalPort());
            }
        }
        catch (Exception ex) {
            this.shutdownNow();
            throw new IOException(ex.getMessage());
        }
        Thread sweeper = new Thread(new Runnable(){

            @Override
            public void run() {
                while (TKGridMonConnectionManager.this.serverSocket != null) {
                    TKGridMonConnectionManager.this.checkNodes();
                    try {
                        Thread.sleep(1000L);
                    }
                    catch (Exception exception) {}
                }
            }
        }, "node-sweeper");
        sweeper.setDaemon(true);
        sweeper.start();
        this.isStarted = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void checkNodes() {
        Object object = this.nodeLock;
        synchronized (object) {
            long uTime = System.currentTimeMillis() - (long)(this.getUnresponsiveTimeoutSeconds() * 1000);
            for (TKGridMonNode node : this.nodes) {
                if (node == null || node.isUnresponsive() || node.getLastUpdateTime() >= uTime) continue;
                node.setUnresponsive(true);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TKGridMonNode[] getNodes() {
        TKGridMonNode[] a = null;
        Object object = this.nodeLock;
        synchronized (object) {
            a = this.nodes;
        }
        return a;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TKGridMonNode[] getCopyOfNodes() {
        TKGridMonNode[] a = null;
        Object object = this.nodeLock;
        synchronized (object) {
            if (this.nodes != null) {
                a = new TKGridMonNode[this.nodes.length];
                for (int i = 0; i < this.nodes.length; ++i) {
                    if (this.nodes[i] == null) continue;
                    a[i] = this.nodes[i].copy();
                }
            }
        }
        return a;
    }

    public int getNodeCount() {
        return this.highRank + 1;
    }

    protected void startProcess(int localPort) {
        final ArrayList<String> cmds = new ArrayList<String>();
        this.startCommand = this.startCommand.trim();
        if (this.startCommand.contains("sdssas")) {
            for (int x = 0; x < this.startCommand.split(" ").length; ++x) {
                if (this.startCommand.split(" ")[x].trim() == "") continue;
                cmds.add(this.startCommand.split(" ")[x].trim());
            }
        } else {
            cmds.add(this.startCommand);
        }
        cmds.add("-showranks");
        cmds.add("-shownice");
        cmds.add("-nousers");
        cmds.add("-guiport");
        cmds.add(Integer.toString(localPort));
        this.log("Executing " + cmds);
        Thread e = new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    TKGridMonConnectionManager.this.execCommand(cmds.toArray(new String[cmds.size()]), null);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }, "execCommand");
        e.setDaemon(true);
        e.start();
    }

    protected void readRecord(DataInputStream in) throws IOException {
        String name = this.readString(in, this.nameBuffer);
        int rank = TKGridMonConnectionManager.intSwap(in.readInt());
        int numRanks = TKGridMonConnectionManager.intSwap(in.readInt());
        int numCpus = TKGridMonConnectionManager.intSwap(in.readInt());
        TKGridMonNode node = this.getNode(name, rank, numCpus);
        node.setLastUpdateTime(System.currentTimeMillis());
        node.setUnresponsive(false);
        for (int i = 0; i < 32; ++i) {
            int n = in.readInt();
            if (i >= numCpus) continue;
            int cpuLevel = TKGridMonConnectionManager.firstInt(TKGridMonConnectionManager.intSwap(n));
            node.setCpuLevel(i, cpuLevel);
            cpuLevel = TKGridMonConnectionManager.secondInt(TKGridMonConnectionManager.intSwap(n));
            node.setMeanCpuLevel(i, cpuLevel);
        }
        int netread = TKGridMonConnectionManager.intSwap(in.readInt());
        int netwrite = TKGridMonConnectionManager.intSwap(in.readInt());
        int memTotal = TKGridMonConnectionManager.intSwap(in.readInt());
        node.setMemTotal(memTotal);
        int memFree = TKGridMonConnectionManager.intSwap(in.readInt());
        node.setMemFree(memFree);
        int numUsers = TKGridMonConnectionManager.intSwap(in.readInt());
        int max = TKGridMonConnectionManager.intSwap(in.readInt());
        if (max == 0) {
            max = 100000000;
        }
        node.setBytesIn(this.getNetworkLevel(netread, max));
        node.setBytesOut(this.getNetworkLevel(netwrite, max));
        node.setMaxNet(max);
        for (int i = 0; i < 6; ++i) {
            in.readInt();
        }
        TKGridMonProcess[] rankInfo = new TKGridMonProcess[numRanks];
        for (int i = 0; i < numRanks; ++i) {
            String hostName = this.readString(in, this.nameBuffer);
            String userID = this.readString(in, this.nameBuffer);
            TKGridMonProcess p = new TKGridMonProcess(userID);
            p.setHostName(hostName);
            int processRank = TKGridMonConnectionManager.intSwap(in.readInt());
            p.setRank(processRank);
            int processPort = TKGridMonConnectionManager.intSwap(in.readInt());
            p.setPort(processPort);
            int processCpuUsage = TKGridMonConnectionManager.intSwap(in.readInt());
            p.setCpuUsage(processCpuUsage);
            int pid = TKGridMonConnectionManager.intSwap(in.readInt());
            p.setPid(pid);
            int processMemUsed = TKGridMonConnectionManager.intSwap(in.readInt());
            p.setMemUsed(processMemUsed);
            int processMemTotal = TKGridMonConnectionManager.intSwap(in.readInt());
            p.setMemTotal(processMemTotal);
            int parentpid = TKGridMonConnectionManager.intSwap(in.readInt());
            p.setParentpid(parentpid);
            int maxTime = TKGridMonConnectionManager.intSwap(in.readInt());
            p.setMaxTime(maxTime);
            int currentRunTime = TKGridMonConnectionManager.intSwap(in.readInt());
            p.setTimeLeft(currentRunTime);
            int snapserverport = TKGridMonConnectionManager.intSwap(in.readInt());
            p.setSnapServerPort(snapserverport);
            int snapstarttime = TKGridMonConnectionManager.intSwap(in.readInt());
            p.setSnapStartTime(snapstarttime);
            int snaplastusetime = TKGridMonConnectionManager.intSwap(in.readInt());
            p.setSnapLastUseTime(snaplastusetime);
            int nice = TKGridMonConnectionManager.intSwap(in.readInt());
            p.setNice(nice);
            int snapnumactiveconnections = TKGridMonConnectionManager.shortSwap(in.readShort());
            if (snapserverport != 0) {
                p.setActiveC(snapnumactiveconnections);
            }
            int snapnumpendingconnections = TKGridMonConnectionManager.shortSwap(in.readShort());
            if (snapserverport != 0) {
                p.setPendingC(snapnumpendingconnections);
            }
            for (int j = 0; j < 0; ++j) {
                in.readInt();
            }
            rankInfo[i] = p;
        }
        node.setProcessInfo(rankInfo);
        TKGridMonUser[] userInfo = new TKGridMonUser[numUsers];
        for (int i = 0; i < numUsers; ++i) {
            String hostName = this.readString(in, this.nameBuffer);
            String userID = this.readString(in, this.nameBuffer);
            TKGridMonUser u = new TKGridMonUser(userID);
            int userCpuUsage = TKGridMonConnectionManager.intSwap(in.readInt());
            u.setCpuUsage(userCpuUsage);
            int userMemUsed = TKGridMonConnectionManager.intSwap(in.readInt());
            u.setMemUsed(userMemUsed);
            int userMemTotal = TKGridMonConnectionManager.intSwap(in.readInt());
            u.setMemTotal(userMemTotal);
            int userProcesses = TKGridMonConnectionManager.intSwap(in.readInt());
            u.setProcesses(userProcesses);
            u.setHostName(hostName);
            for (int j = 0; j < 7; ++j) {
                in.readInt();
            }
            userInfo[i] = u;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected TKGridMonNode getNode(String name, int rank, int numcpus) throws IOException {
        TKGridMonNode node = null;
        if (rank < 0 || rank > this.getMaxRanks()) {
            throw new IOException("Illegal rank for " + name + " of " + rank);
        }
        if (rank < this.nodes.length && (node = this.nodes[rank]) != null && !node.getName().equals(name)) {
            System.out.println("## WARNING: Rank " + rank + " has " + node.getName() + " change to " + name);
        }
        if (node == null) {
            node = new TKGridMonNode(name, rank, numcpus);
            if (rank >= this.nodes.length) {
                int newCapacity = this.nodes.length * 3 / 2 + 1;
                if (newCapacity < rank) {
                    newCapacity = rank + 1;
                }
                Object object = this.nodeLock;
                synchronized (object) {
                    TKGridMonNode[] newArray = new TKGridMonNode[newCapacity];
                    System.arraycopy(this.nodes, 0, newArray, 0, this.nodes.length);
                    this.nodes = newArray;
                }
            }
            this.nodes[rank] = node;
            if (rank > this.highRank) {
                this.highRank = rank;
            }
        }
        return node;
    }

    protected byte getNetworkLevel(int n, int max) {
        return (byte)Math.min(100, n / (max / 100));
    }

    protected String readString(DataInputStream in, byte[] buf) {
        int len = 0;
        try {
            in.readFully(buf, len, buf.length - len);
        }
        catch (IOException e) {
            LocalMon.ConnectionLost.add(new Label("Connection to grid lost"));
            LocalMon.ConnectionLost.setDefaultCloseOperation(3);
            LocalMon.ConnectionLost.setLocation(100, 100);
            LocalMon.ConnectionLost.setVisible(true);
        }
        for (len = 0; len < buf.length && buf[len] != 0; ++len) {
        }
        return new String(buf, 0, len);
    }

    public static int intSwap(int n) {
        return ((n & 0xFF) << 24) + ((n & 0xFF00) << 8) + ((n & 0xFF0000) >>> 8) + ((n & 0xFF000000) >>> 24);
    }

    public static int shortSwap(short n) {
        return (n & 0xFF00) >>> 8 | (n & 0xFF) << 8;
    }

    public static int firstInt(int n) {
        return n & 0xFF;
    }

    public static int secondInt(int n) {
        return n >> 16 & 0xFF;
    }

    protected int execCommand(String[] commands, Map<String, String> envp) throws IOException {
        String line;
        String line2;
        ProcessBuilder pb = new ProcessBuilder(commands);
        if (envp != null) {
            for (Map.Entry<String, String> entry : envp.entrySet()) {
                pb.environment().put(entry.getKey(), entry.getValue());
            }
        }
        pb.environment().put("GRIDHOST", LocalMon.gridHost + ":" + LocalMon.gridInstall);
        this.tkgridmonProcess = pb.start();
        BufferedReader stdout = new BufferedReader(new InputStreamReader(this.tkgridmonProcess.getInputStream()));
        StringBuffer sb = new StringBuffer();
        while ((line2 = stdout.readLine()) != null) {
            if ((line2 = line2.trim()).length() == 0) continue;
            if (sb.length() > 0) {
                sb.append("\n");
            }
            sb.append(line2);
            if (!line2.contains("Unable to enumerate grid")) continue;
            this.shutdownNow();
        }
        this.log(sb.toString());
        sb = new StringBuffer();
        BufferedReader stderr = new BufferedReader(new InputStreamReader(this.tkgridmonProcess.getErrorStream()));
        while ((line = stderr.readLine()) != null) {
            if ((line = line.trim()).length() == 0) continue;
            if (sb.length() > 0) {
                sb.append("\n");
            }
            sb.append(line);
        }
        if (sb.length() > 0) {
            this.log(sb.toString());
            throw new IOException(sb.toString());
        }
        int exitValue = this.tkgridmonProcess.exitValue();
        if (exitValue != 0) {
            this.tkgridmonProcess.destroy();
        }
        return exitValue;
    }

    public String getShellCommand() {
        return this.shellCommand;
    }

    public void setShellCommand(String shellCommand) {
        this.shellCommand = shellCommand;
    }

    public String getStartCommand() {
        return this.startCommand;
    }

    public void setStartCommand(String startCommand) {
        this.startCommand = startCommand;
    }

    public int getConnectionTimeoutSeconds() {
        return this.connectionTimeoutSeconds;
    }

    public void setConnectionTimeoutSeconds(int connectionTimeoutSeconds) {
        this.connectionTimeoutSeconds = connectionTimeoutSeconds;
    }

    public int getUnresponsiveTimeoutSeconds() {
        return this.unresponsiveTimeoutSeconds;
    }

    public void setUnresponsiveTimeoutSeconds(int unresponsiveTimeoutSeconds) {
        this.unresponsiveTimeoutSeconds = unresponsiveTimeoutSeconds;
    }

    public int getMaxRanks() {
        return this.maxRanks;
    }

    public void setMaxRanks(int maxRanks) {
        this.maxRanks = maxRanks;
    }

    protected void log(String s) {
        System.out.println("TKGridMon: " + s);
    }
}

