/*
 * Decompiled with CFR 0.152.
 */
package com.sas.tkgridmon.client;

import com.sas.tkgridmon.client.DiskLabel;
import com.sas.tkgridmon.client.Graph;
import com.sas.tkgridmon.client.JobWindow;
import com.sas.tkgridmon.client.TKGridMonConnectionManager;
import com.sas.tkgridmon.client.TKGridMonNode;
import com.sas.tkgridmon.client.TKGridMonProcess;
import com.sas.tkgridmon.client.TKGridMonUser;
import com.sas.tkgridmon.client.UserDataList;
import com.sas.tkgridmon.client.jobLabel;
import com.sas.tkgridmon.client.nodeDisplay;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.Label;
import java.awt.TextArea;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Scanner;
import javax.swing.BoxLayout;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;

public class LocalMon {
    static JPanel usersPanel;
    static JPanel newJobPanel;
    static JFrame mainPanel;
    private static JFrame gridCPUHistoryFrame;
    private static JFrame userDataFrame;
    static JFrame newJobFrame;
    static JFrame ConnectionLost;
    public static JFrame jobsFrame;
    private static JFrame diskFrame;
    private static JScrollPane jobScroll;
    private static JScrollPane diskScroll;
    private static JPanel subMain;
    static JPanel clusterPanel;
    public static JPanel jobPane;
    static JPanel diskPane;
    static Graph cpuGraph;
    static UserDataList userDataGraph;
    static JobWindow jobWindow;
    static JScrollPane scrollPane;
    static ArrayList<jobLabel> usersLabels;
    static ArrayList<DiskLabel> diskLabels;
    static int nodeX;
    static int nodeXBuffer;
    static int nodeY;
    static long totalMem;
    double memFree = 0.0;
    static JComboBox sortArg;
    static JPanel infoRow;
    static JScrollPane userScroll;
    static int nodeSizeSelection;
    NumberFormat format;
    TextArea pixelBox;
    boolean dragging = false;
    int gradientSize = 400;
    JPanel gridview;
    JPanel CPUUsers;
    JPanel MemoryUsers;
    JPanel topCPUNodes;
    boolean needsrefresh;
    int prevtotalcpu = 0;
    int totalcpu = 0;
    double prevpercent = 0.0;
    int totalnumcpus;
    String config;
    int oldnodecount = 0;
    JPanel CommandPanel = new JPanel();
    JPanel extraInfoPanel;
    Label CommandLabel;
    Label UserLabel;
    Label PasswordLabel;
    Label CommandLine;
    String Target;
    int failCounter = 0;
    Label uploadLabel;
    Label uploadNumber;
    Label downloadLabel;
    Label downloadNumber;
    static Object dataLock;
    static Object jobPaneLock;
    static ArrayList<nodeDisplay> nodes;
    static ArrayList<JPanel> nodeBoxes;
    static String userName;
    static TKGridMonConnectionManager manager;
    static int[] cpuHistory;
    static int[] memHistory;
    static String[] cmdLine;
    static int numCPUs;
    static Font f;
    static String gridHost;
    static String gridInstall;
    static String TKsshPath;
    static String gridSSHPath;
    protected static String prevCommand;
    protected static ArrayList savedCommands;
    public static long GridMemory;
    boolean reformat = false;
    static BufferedWriter errWriter;
    static int startPort;
    static boolean noUI;
    static int cmdstart;

    public static void main(String[] args) {
        File errLog = null;
        errLog = File.separatorChar == '/' ? new File(System.getenv().get("HOME") + "/GridmonErrors.txt") : new File(System.getenv().get("USERPROFILE") + "\\GridmonErrors.txt");
        try {
            errWriter = new BufferedWriter(new FileWriter(errLog));
        }
        catch (IOException e2) {
            e2.printStackTrace();
        }
        Thread.setDefaultUncaughtExceptionHandler(new Thread.UncaughtExceptionHandler(){

            @Override
            public void uncaughtException(Thread t, Throwable e) {
                try {
                    StackTraceElement[] a = e.getStackTrace();
                    if (!a[0].toString().contains("Vector")) {
                        errWriter.write(e.toString() + '\n');
                        for (int x = 0; x < a.length; ++x) {
                            errWriter.write(a[x] + "\n");
                        }
                        errWriter.write("\n");
                    }
                }
                catch (IOException e1) {
                    e1.printStackTrace();
                }
            }
        });
        f = new Font("SansSerif", 0, 13);
        usersLabels = new ArrayList();
        diskLabels = new ArrayList();
        cmdLine = new String[50];
        for (int x = 0; x < args.length; ++x) {
            String s = args[x];
            LocalMon.cmdLine[x] = new String(s);
            if (s.contains("Gridhost=")) {
                gridHost = s.substring(s.indexOf("=") + 1);
                ++cmdstart;
            }
            if (s.contains("GridInstall=")) {
                gridInstall = s.substring(s.indexOf("=") + 1);
                ++cmdstart;
            }
            if (s.contains("TKsshPath=")) {
                TKsshPath = s.substring(s.indexOf("=") + 1).trim();
                ++cmdstart;
            }
            if (s.contains("GridmonPort=")) {
                startPort = Integer.parseInt(s.substring(s.indexOf("=") + 1));
                ++cmdstart;
            }
            if (!s.contains("-NoUI")) continue;
            noUI = true;
            ++cmdstart;
        }
        if (File.separatorChar == '/' && !noUI && (System.getenv("DISPLAY") == null || System.getenv("DISPLAY").equals(""))) {
            System.out.println("Gridmon requires the DISPLAY to be properly set.");
            System.exit(1);
        }
        try {
            sortArg = new JComboBox<String>(new String[]{"Sort by CPU", "Sort by Username", "Sort by Memory"});
        }
        catch (NoClassDefFoundError e) {
            System.out.println("Unable to intialize X connection, please check DISPLAY.\nThe current value in DISPLAY is: " + System.getenv("DISPLAY"));
            System.exit(1);
        }
        try {
            for (UIManager.LookAndFeelInfo info : UIManager.getInstalledLookAndFeels()) {
                if (!"Windows".equals(info.getName()) && !"GTK+".equals(info.getName())) continue;
                UIManager.setLookAndFeel(info.getClassName());
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                userName = System.getenv().get("TKSSH_USER") != null ? System.getenv().get("TKSSH_USER") : (File.separatorChar == '/' ? System.getenv().get("USER") : System.getenv().get("USERNAME"));
                nodes = new ArrayList();
                cpuGraph = new Graph();
                userDataGraph = new UserDataList();
                jobWindow = new JobWindow();
                ConnectionLost = new JFrame();
                ConnectionLost.setSize(150, 70);
                jobPane = new JPanel();
                jobPane.setBackground(Color.white);
                jobPane.setAlignmentX(1.0f);
                jobPane.setLayout(new BoxLayout(jobPane, 1));
                diskPane = new JPanel();
                diskPane.setBackground(Color.white);
                diskPane.setAlignmentX(1.0f);
                diskPane.setLayout(new BoxLayout(diskPane, 1));
                nodeBoxes = new ArrayList();
                cpuHistory = new int[60];
                memHistory = new int[60];
                try {
                    LocalMon.createAndShowGUI();
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                try {
                    int startarg;
                    manager = new TKGridMonConnectionManager();
                    if (startarg == cmdLine.length) {
                        try {
                            throw new Exception();
                        }
                        catch (Exception e) {
                            System.out.println("requires direction to tkgridmon process");
                        }
                    } else {
                        String startCommand = "";
                        for (startarg = cmdstart; startarg < cmdLine.length && cmdLine[startarg] != null; ++startarg) {
                            startCommand = startCommand + " " + cmdLine[startarg];
                        }
                        startCommand = startCommand.trim();
                        manager.setStartCommand(startCommand);
                    }
                    manager.setConnectionTimeoutSeconds(120);
                    manager.setUnresponsiveTimeoutSeconds(30);
                    UpdateThread updater = new UpdateThread();
                    updater.setManager(manager);
                    updater.start();
                    manager.startTKGridMon(startPort);
                    if (TKsshPath.contains("sdssas")) {
                        final ArrayList<String> cmds = new ArrayList<String>();
                        TKsshPath = TKsshPath.trim();
                        for (int x = 0; x < TKsshPath.split(" ").length; ++x) {
                            if (TKsshPath.split(" ")[x].trim() == "") continue;
                            cmds.add(TKsshPath.split(" ")[x].trim());
                        }
                        System.out.println("executing+ " + cmds);
                        Thread e = new Thread(new Runnable(){

                            @Override
                            public void run() {
                                try {
                                    TKsshPath = LocalMon.execCommand(cmds.toArray(new String[cmds.size()]), null);
                                    if (TKsshPath.contains("command line:")) {
                                        TKsshPath = TKsshPath.substring(TKsshPath.indexOf(":") + 1, TKsshPath.length()).trim();
                                    }
                                }
                                catch (Exception ex) {
                                    ex.printStackTrace();
                                }
                            }
                        }, "execCommand");
                        e.setDaemon(true);
                        e.start();
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (System.getenv().get("GRIDRSHCOMMAND") != null && System.getenv().get("GRIDRSHCOMMAND") != "") {
                    TKsshPath = System.getenv().get("GRIDRSHCOMMAND");
                }
                gridSSHPath = gridInstall + "/bin/ssh.sh";
            }
        });
    }

    private static void createAndShowGUI() throws InterruptedException {
        int maxY;
        JMenuBar jobFrameMenuBar = new JMenuBar();
        JMenu menu = new JMenu("Menu");
        JMenu jobFrameMenu = new JMenu("Job Menu");
        JMenuBar menuBar = new JMenuBar();
        menu.setMnemonic(65);
        JMenuItem GraphMenuItem = new JMenuItem("Show Grid History", 71);
        GraphMenuItem.addMouseListener(new MouseListener(){

            @Override
            public void mouseClicked(MouseEvent arg0) {
            }

            @Override
            public void mouseEntered(MouseEvent arg0) {
            }

            @Override
            public void mouseExited(MouseEvent arg0) {
            }

            @Override
            public void mousePressed(MouseEvent arg0) {
                gridCPUHistoryFrame.setVisible(true);
            }

            @Override
            public void mouseReleased(MouseEvent arg0) {
                gridCPUHistoryFrame.setVisible(true);
            }
        });
        menu.add(GraphMenuItem);
        GraphMenuItem = new JMenuItem("Show Jobs on Grid", 85);
        GraphMenuItem.addMouseListener(new MouseListener(){

            @Override
            public void mouseClicked(MouseEvent arg0) {
            }

            @Override
            public void mouseEntered(MouseEvent arg0) {
            }

            @Override
            public void mouseExited(MouseEvent arg0) {
            }

            @Override
            public void mousePressed(MouseEvent arg0) {
                newJobFrame.setVisible(true);
            }

            @Override
            public void mouseReleased(MouseEvent arg0) {
                newJobFrame.setVisible(true);
            }
        });
        menu.add(GraphMenuItem);
        GraphMenuItem = new JMenuItem("Show User Totals on Grid", 85);
        GraphMenuItem.addMouseListener(new MouseListener(){

            @Override
            public void mouseClicked(MouseEvent arg0) {
            }

            @Override
            public void mouseEntered(MouseEvent arg0) {
            }

            @Override
            public void mouseExited(MouseEvent arg0) {
            }

            @Override
            public void mousePressed(MouseEvent arg0) {
                userDataFrame.setVisible(true);
            }

            @Override
            public void mouseReleased(MouseEvent arg0) {
                userDataFrame.setVisible(true);
            }
        });
        GraphMenuItem = new JMenuItem("Show Classic Jobs View", 74);
        GraphMenuItem.addMouseListener(new MouseListener(){

            @Override
            public void mouseClicked(MouseEvent e) {
            }

            @Override
            public void mouseEntered(MouseEvent e) {
            }

            @Override
            public void mouseExited(MouseEvent e) {
            }

            @Override
            public void mousePressed(MouseEvent e) {
                jobsFrame.setVisible(true);
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                jobsFrame.setVisible(true);
            }
        });
        GraphMenuItem = new JMenuItem("Show Disks", 74);
        GraphMenuItem.addMouseListener(new MouseListener(){

            @Override
            public void mouseClicked(MouseEvent e) {
            }

            @Override
            public void mouseEntered(MouseEvent e) {
            }

            @Override
            public void mouseExited(MouseEvent e) {
            }

            @Override
            public void mousePressed(MouseEvent e) {
                diskFrame.setVisible(true);
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                diskFrame.setVisible(true);
            }
        });
        menu.add(GraphMenuItem);
        menu.addSeparator();
        JMenu size = new JMenu("Node Width");
        JMenuItem option = new JMenuItem("Small");
        option.addMouseListener(new MouseListener(){

            @Override
            public void mouseClicked(MouseEvent e) {
            }

            @Override
            public void mouseEntered(MouseEvent e) {
            }

            @Override
            public void mouseExited(MouseEvent e) {
            }

            @Override
            public void mousePressed(MouseEvent e) {
                nodeSizeSelection = 1;
                nodeX = LocalMon.maxNodeSize();
                nodeY = 50;
                LocalMon.resizeNodes();
            }

            @Override
            public void mouseReleased(MouseEvent e) {
            }
        });
        size.add(option);
        option = new JMenuItem("Normal");
        option.addMouseListener(new MouseListener(){

            @Override
            public void mouseClicked(MouseEvent e) {
            }

            @Override
            public void mouseEntered(MouseEvent e) {
            }

            @Override
            public void mouseExited(MouseEvent e) {
            }

            @Override
            public void mousePressed(MouseEvent e) {
                nodeSizeSelection = 2;
                nodeX = LocalMon.maxNodeSize();
                nodeY = 50;
                LocalMon.resizeNodes();
            }

            @Override
            public void mouseReleased(MouseEvent e) {
            }
        });
        size.add(option);
        option = new JMenuItem("Large");
        option.addMouseListener(new MouseListener(){

            @Override
            public void mouseClicked(MouseEvent e) {
            }

            @Override
            public void mouseEntered(MouseEvent e) {
            }

            @Override
            public void mouseExited(MouseEvent e) {
            }

            @Override
            public void mousePressed(MouseEvent e) {
                nodeSizeSelection = 3;
                nodeX = LocalMon.maxNodeSize();
                nodeY = 50;
                LocalMon.resizeNodes();
            }

            @Override
            public void mouseReleased(MouseEvent e) {
            }
        });
        size.add(option);
        menu.add(size);
        menuBar.add(menu);
        nodes = new ArrayList();
        mainPanel = new JFrame();
        mainPanel.setMinimumSize(new Dimension(310, 300));
        mainPanel.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                if (!newJobFrame.isVisible()) {
                    File F = null;
                    F = File.separatorChar == '/' ? new File(System.getenv().get("HOME") + "/GridmonConfig.txt") : new File(System.getenv().get("USERPROFILE") + "\\GridmonConfig.txt");
                    try {
                        BufferedWriter writer = new BufferedWriter(new FileWriter(F));
                        writer.write("size " + nodeSizeSelection);
                        writer.newLine();
                        writer.write("mainpanel " + LocalMon.mainPanel.getLocationOnScreen().x + " " + LocalMon.mainPanel.getLocationOnScreen().y + " " + LocalMon.mainPanel.getSize().width + " " + LocalMon.mainPanel.getSize().height);
                        writer.newLine();
                        if (jobsFrame.isVisible()) {
                            writer.write("jobsFrame " + LocalMon.jobsFrame.getLocationOnScreen().x + " " + LocalMon.jobsFrame.getLocationOnScreen().y + " " + LocalMon.jobsFrame.getSize().width + " " + LocalMon.jobsFrame.getSize().height);
                            writer.newLine();
                        }
                        if (diskFrame.isVisible()) {
                            writer.write("diskFrame " + diskFrame.getLocationOnScreen().x + " " + diskFrame.getLocationOnScreen().y + " " + diskFrame.getSize().width + " " + diskFrame.getSize().height);
                            writer.newLine();
                        }
                        if (gridCPUHistoryFrame.isVisible()) {
                            writer.write("gridCPUHistoryFrame " + gridCPUHistoryFrame.getLocationOnScreen().x + " " + gridCPUHistoryFrame.getLocationOnScreen().y + " " + gridCPUHistoryFrame.getSize().width + " " + gridCPUHistoryFrame.getSize().height);
                            writer.newLine();
                        }
                        if (userDataFrame.isVisible()) {
                            writer.write("userDataFrame " + userDataFrame.getLocationOnScreen().x + " " + userDataFrame.getLocationOnScreen().y + " " + userDataFrame.getSize().width + " " + userDataFrame.getSize().height);
                            writer.newLine();
                        }
                        newJobFrame.setVisible(true);
                        if (newJobFrame.isVisible()) {
                            writer.write("newJobFrame " + LocalMon.newJobFrame.getLocationOnScreen().x + " " + LocalMon.newJobFrame.getLocationOnScreen().y + " " + LocalMon.newJobFrame.getSize().width + " " + LocalMon.newJobFrame.getSize().height);
                            writer.newLine();
                        }
                        writer.write("activeWindow=NodeView");
                        writer.newLine();
                        writer.write("SavedCommands=" + savedCommands);
                        writer.newLine();
                        if (writer != null) {
                            writer.close();
                        }
                        if (errWriter != null) {
                            errWriter.close();
                        }
                    }
                    catch (FileNotFoundException e1) {
                        System.out.println("File containing personal configuration not found, one will be created upon termination of this gridmon.");
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                    System.exit(0);
                }
            }
        });
        mainPanel.setJMenuBar(menuBar);
        userDataFrame = new JFrame();
        userDataFrame.setLocation(100, 100);
        newJobFrame = new JFrame();
        newJobFrame.setLocation(100, 100);
        newJobFrame.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                if (!mainPanel.isVisible()) {
                    File F = null;
                    F = File.separatorChar == '/' ? new File(System.getenv().get("HOME") + "/GridmonConfig.txt") : new File(System.getenv().get("USERPROFILE") + "\\GridmonConfig.txt");
                    try {
                        BufferedWriter writer = new BufferedWriter(new FileWriter(F));
                        writer.write("size " + nodeSizeSelection);
                        writer.newLine();
                        mainPanel.setVisible(true);
                        if (mainPanel.isVisible()) {
                            writer.write("mainpanel " + LocalMon.mainPanel.getLocationOnScreen().x + " " + LocalMon.mainPanel.getLocationOnScreen().y + " " + LocalMon.mainPanel.getSize().width + " " + LocalMon.mainPanel.getSize().height);
                        } else {
                            writer.write("mainpanel 100 100 400 400");
                        }
                        writer.newLine();
                        if (jobsFrame.isVisible()) {
                            writer.write("jobsFrame " + LocalMon.jobsFrame.getLocationOnScreen().x + " " + LocalMon.jobsFrame.getLocationOnScreen().y + " " + LocalMon.jobsFrame.getSize().width + " " + LocalMon.jobsFrame.getSize().height);
                            writer.newLine();
                        }
                        if (diskFrame.isVisible()) {
                            writer.write("diskFrame " + diskFrame.getLocationOnScreen().x + " " + diskFrame.getLocationOnScreen().y + " " + diskFrame.getSize().width + " " + diskFrame.getSize().height);
                            writer.newLine();
                        }
                        if (gridCPUHistoryFrame.isVisible()) {
                            writer.write("gridCPUHistoryFrame " + gridCPUHistoryFrame.getLocationOnScreen().x + " " + gridCPUHistoryFrame.getLocationOnScreen().y + " " + gridCPUHistoryFrame.getSize().width + " " + gridCPUHistoryFrame.getSize().height);
                            writer.newLine();
                        }
                        if (userDataFrame.isVisible()) {
                            writer.write("userDataFrame " + userDataFrame.getLocationOnScreen().x + " " + userDataFrame.getLocationOnScreen().y + " " + userDataFrame.getSize().width + " " + userDataFrame.getSize().height);
                            writer.newLine();
                        }
                        if (newJobFrame.isVisible()) {
                            writer.write("newJobFrame " + LocalMon.newJobFrame.getLocationOnScreen().x + " " + LocalMon.newJobFrame.getLocationOnScreen().y + " " + LocalMon.newJobFrame.getSize().width + " " + LocalMon.newJobFrame.getSize().height);
                            writer.newLine();
                        }
                        writer.write("activeWindow=JobView");
                        writer.newLine();
                        writer.write("SavedCommands=" + savedCommands);
                        writer.newLine();
                        writer.close();
                        errWriter.close();
                    }
                    catch (FileNotFoundException e1) {
                        System.out.println("File containing personal configuration not found, one will be created upon termination of this gridmon.");
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                    System.exit(0);
                }
            }
        });
        jobsFrame = new JFrame();
        jobsFrame.setLocation(100, 100);
        jobsFrame.setMinimumSize(new Dimension(250, 250));
        diskFrame = new JFrame();
        diskFrame.setLocation(100, 100);
        gridCPUHistoryFrame = new JFrame();
        gridCPUHistoryFrame.setLocation(100, 100);
        subMain = new JPanel();
        subMain.setLayout(new BorderLayout());
        clusterPanel = new JPanel();
        clusterPanel.setBackground(Color.white);
        clusterPanel.setLayout(new FlowLayout(0));
        clusterPanel.setAlignmentX(1.0f);
        JPanel outer = new JPanel();
        JPanel rightAlign = new JPanel();
        rightAlign.setAlignmentX(1.0f);
        outer.add(rightAlign);
        scrollPane = new JScrollPane(clusterPanel);
        scrollPane.getVerticalScrollBar().setUnitIncrement(16);
        scrollPane.setHorizontalScrollBarPolicy(31);
        scrollPane.setVerticalScrollBarPolicy(22);
        scrollPane.addComponentListener(new ComponentListener(){

            @Override
            public void componentHidden(ComponentEvent e) {
            }

            @Override
            public void componentMoved(ComponentEvent e) {
            }

            @Override
            public void componentResized(ComponentEvent arg0) {
                if (clusterPanel.getWidth() > 3) {
                    int a = (nodes.size() / ((clusterPanel.getWidth() + 1) / (nodeX + nodeXBuffer)) + 1) * (nodeY + 17);
                    if (nodes.size() % ((clusterPanel.getWidth() + 1) / (nodeX + nodeXBuffer)) == 0) {
                        a -= nodeY + 17;
                    }
                    clusterPanel.setPreferredSize(new Dimension(mainPanel.getWidth() - 25, a));
                    clusterPanel.setSize(new Dimension(mainPanel.getWidth() - 25, a));
                }
            }

            @Override
            public void componentShown(ComponentEvent e) {
            }
        });
        clusterPanel.setVisible(true);
        subMain.add(scrollPane);
        clusterPanel.validate();
        clusterPanel.repaint();
        mainPanel.add(subMain);
        subMain.setVisible(true);
        mainPanel.setTitle("Grid Monitor");
        gridCPUHistoryFrame.setSize(225, 145);
        gridCPUHistoryFrame.add(cpuGraph);
        gridCPUHistoryFrame.setTitle("Grid History");
        gridCPUHistoryFrame.getContentPane().validate();
        sortArg = new JComboBox<String>(new String[]{"Sort by CPU", "Sort by Username", "Sort by Memory"});
        sortArg.setMaximumSize(new Dimension(150, 50));
        sortArg.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
            }
        });
        usersPanel = new JPanel();
        usersPanel.setLayout(new BoxLayout(usersPanel, 1));
        usersPanel.setBackground(Color.white);
        usersPanel.add(userDataGraph.getPanel());
        usersPanel.setBackground(Color.black);
        userDataFrame.add(usersPanel);
        userDataFrame.setTitle("User Totals on Grid");
        userDataFrame.setMinimumSize(new Dimension(275, 200));
        newJobPanel = new JPanel();
        newJobPanel.setLayout(new BoxLayout(newJobPanel, 1));
        newJobPanel.setBackground(Color.white);
        newJobPanel.add(jobWindow.getPanel());
        newJobFrame.add(newJobPanel);
        newJobFrame.setTitle("Jobs on GridHost: " + gridHost);
        JMenuItem menuItem = new JMenuItem("  ", 65);
        menuItem = new JMenuItem("Show Node View", 75);
        menuItem.addMouseListener(new MouseListener(){

            @Override
            public void mouseClicked(MouseEvent arg0) {
            }

            @Override
            public void mouseEntered(MouseEvent arg0) {
            }

            @Override
            public void mouseExited(MouseEvent arg0) {
            }

            @Override
            public void mousePressed(MouseEvent arg0) {
            }

            @Override
            public void mouseReleased(MouseEvent arg0) {
                mainPanel.setVisible(true);
                JFrame dummy = new JFrame();
                dummy.setLocation(-100, 0);
                dummy.setVisible(true);
                dummy.setVisible(false);
            }
        });
        jobFrameMenu.add(menuItem);
        menuItem = new JMenuItem("Export list to clipboard", 75);
        menuItem.addMouseListener(new MouseListener(){

            @Override
            public void mouseClicked(MouseEvent arg0) {
            }

            @Override
            public void mouseEntered(MouseEvent arg0) {
            }

            @Override
            public void mouseExited(MouseEvent arg0) {
            }

            @Override
            public void mousePressed(MouseEvent arg0) {
            }

            @Override
            public void mouseReleased(MouseEvent arg0) {
                jobWindow.export();
            }
        });
        jobFrameMenu.add(menuItem);
        menuItem = new JMenuItem("Kill Old Processes...", 75);
        menuItem.addMouseListener(new MouseListener(){

            @Override
            public void mouseClicked(MouseEvent arg0) {
            }

            @Override
            public void mouseEntered(MouseEvent arg0) {
            }

            @Override
            public void mouseExited(MouseEvent arg0) {
            }

            @Override
            public void mousePressed(MouseEvent arg0) {
            }

            @Override
            public void mouseReleased(MouseEvent arg0) {
                jobWindow.killOld();
            }
        });
        jobFrameMenu.add(menuItem);
        menuItem = new JMenuItem("Display Totals", 84);
        menuItem.addMouseListener(new MouseListener(){

            @Override
            public void mouseClicked(MouseEvent arg0) {
            }

            @Override
            public void mouseEntered(MouseEvent arg0) {
            }

            @Override
            public void mouseExited(MouseEvent arg0) {
            }

            @Override
            public void mousePressed(MouseEvent arg0) {
            }

            @Override
            public void mouseReleased(MouseEvent arg0) {
                jobWindow.displayTotals();
            }
        });
        jobFrameMenu.add(menuItem);
        jobFrameMenuBar.add(jobFrameMenu);
        newJobFrame.setJMenuBar(jobFrameMenuBar);
        jobScroll = new JScrollPane();
        diskScroll = new JScrollPane();
        jobScroll.getVerticalScrollBar().setUnitIncrement(16);
        diskScroll.getVerticalScrollBar().setUnitIncrement(16);
        jobPane.addComponentListener(new ComponentListener(){

            @Override
            public void componentHidden(ComponentEvent arg0) {
            }

            @Override
            public void componentMoved(ComponentEvent arg0) {
                for (int x = 0; x < usersLabels.size(); ++x) {
                    usersLabels.get(x).repaint();
                }
            }

            @Override
            public void componentResized(ComponentEvent arg0) {
            }

            @Override
            public void componentShown(ComponentEvent arg0) {
            }
        });
        diskPane.addComponentListener(new ComponentListener(){

            @Override
            public void componentHidden(ComponentEvent arg0) {
            }

            @Override
            public void componentMoved(ComponentEvent arg0) {
                for (int x = 0; x < diskLabels.size(); ++x) {
                    diskLabels.get(x).repaint();
                }
            }

            @Override
            public void componentResized(ComponentEvent arg0) {
            }

            @Override
            public void componentShown(ComponentEvent arg0) {
            }
        });
        jobScroll.getViewport().add(jobPane);
        jobsFrame.add(jobScroll);
        jobsFrame.setTitle("Jobs");
        jobsFrame.setSize(250, 250);
        jobsFrame.getContentPane().validate();
        diskScroll.getViewport().add(diskPane);
        diskFrame.add(diskScroll);
        diskFrame.setTitle("Disks");
        diskFrame.setSize(225, 250);
        diskFrame.getContentPane().validate();
        File F = null;
        F = File.separatorChar == '/' ? new File(System.getenv().get("HOME") + "/GridmonConfig.txt") : new File(System.getenv().get("USERPROFILE") + "\\GridmonConfig.txt");
        GraphicsEnvironment ge = GraphicsEnvironment.getLocalGraphicsEnvironment();
        GraphicsDevice[] gs = ge.getScreenDevices();
        int maxX = 0;
        boolean activeFound = false;
        if (gs[0].getDisplayMode() != null) {
            maxY = gs[0].getDisplayMode().getHeight();
            for (int i = 0; i < gs.length; ++i) {
                maxX += gs[i].getDisplayMode().getWidth();
            }
        } else {
            maxY = 900;
            maxX = 1500;
        }
        try {
            String line;
            BufferedReader reader = new BufferedReader(new FileReader(F));
            boolean mainPanelData = false;
            while ((line = reader.readLine()) != null) {
                JFrame dummy;
                String s;
                int height;
                int width;
                int y;
                int x;
                Scanner scan;
                if (line.contains("size")) {
                    scan = new Scanner(line);
                    scan.next();
                    int nodeSize = scan.nextInt();
                    switch (nodeSize) {
                        case 1: {
                            nodeSizeSelection = 1;
                            nodeX = LocalMon.maxNodeSize();
                            nodeY = 50;
                            LocalMon.resizeNodes();
                            break;
                        }
                        case 2: {
                            nodeSizeSelection = 2;
                            nodeX = LocalMon.maxNodeSize();
                            nodeY = 50;
                            LocalMon.resizeNodes();
                            break;
                        }
                        case 3: {
                            nodeSizeSelection = 3;
                            nodeX = LocalMon.maxNodeSize();
                            nodeY = 50;
                            LocalMon.resizeNodes();
                        }
                    }
                }
                if (line.contains("mainpanel")) {
                    scan = new Scanner(line);
                    scan.next();
                    x = scan.nextInt();
                    y = scan.nextInt();
                    width = scan.nextInt();
                    height = scan.nextInt();
                    if (x < 0 || x > maxX || y > maxY) {
                        x = 100;
                        y = 100;
                    }
                    mainPanel.setSize(width, height);
                    mainPanel.setLocation(x, y);
                    mainPanelData = true;
                }
                if (line.contains("jobsFrame")) {
                    scan = new Scanner(line);
                    scan.next();
                    x = scan.nextInt();
                    y = scan.nextInt();
                    width = scan.nextInt();
                    height = scan.nextInt();
                    if (x < 0 || x > maxX || y > maxY) {
                        x = 0;
                        y = 0;
                    }
                    newJobFrame.setLocation(x, y);
                    newJobFrame.setSize(width, height);
                    if (x >= 0) {
                        newJobFrame.setVisible(true);
                    }
                }
                if (line.contains("diskFrame")) {
                    scan = new Scanner(line);
                    scan.next();
                    x = scan.nextInt();
                    y = scan.nextInt();
                    width = scan.nextInt();
                    height = scan.nextInt();
                    if (x < 0 || x > maxX || y > maxY) {
                        x = 0;
                        y = 0;
                    }
                    diskFrame.setLocation(x, y);
                    diskFrame.setSize(width, height);
                    if (x >= 0) {
                        diskFrame.setVisible(true);
                    }
                }
                if (line.contains("gridCPUHistoryFrame")) {
                    scan = new Scanner(line);
                    scan.next();
                    x = scan.nextInt();
                    y = scan.nextInt();
                    width = scan.nextInt();
                    height = scan.nextInt();
                    if (x < 0 || x > maxX || y > maxY) {
                        x = 0;
                        y = 0;
                    }
                    gridCPUHistoryFrame.setLocation(x, y);
                    gridCPUHistoryFrame.setSize(width, height);
                    if (x >= 0) {
                        gridCPUHistoryFrame.setVisible(true);
                    }
                }
                if (line.contains("userDataFrame")) {
                    scan = new Scanner(line);
                    scan.next();
                    x = scan.nextInt();
                    y = scan.nextInt();
                    width = scan.nextInt();
                    height = scan.nextInt();
                    if (x < 0 || x > maxX || y > maxY) {
                        x = 0;
                        y = 0;
                    }
                    userDataFrame.setLocation(x, y);
                    userDataFrame.setSize(width, height);
                    if (x >= 0) {
                        // empty if block
                    }
                }
                if (line.contains("newJobFrame")) {
                    scan = new Scanner(line);
                    scan.next();
                    x = scan.nextInt();
                    y = scan.nextInt();
                    width = scan.nextInt();
                    height = scan.nextInt();
                    if (x < 0 || x > maxX || y > maxY) {
                        x = 0;
                        y = 0;
                    }
                    newJobFrame.setLocation(x, y);
                    newJobFrame.setSize(width, height);
                    if (x >= 0) {
                        // empty if block
                    }
                }
                if (line.contains("PrevCommand=")) {
                    prevCommand = line.substring(line.indexOf("=") + 1);
                }
                if (line.contains("SavedCommands=")) {
                    s = line.substring(line.indexOf("=") + 1);
                    Scanner scan2 = new Scanner(s).useDelimiter(",");
                    while (scan2.hasNext()) {
                        String s1 = scan2.next();
                        s1 = s1.replace("[", "");
                        s1 = s1.replace(",", "");
                        s1 = s1.replace("]", "");
                        if ((s1 = s1.trim()).equals("")) continue;
                        savedCommands.add(s1);
                    }
                }
                if (!line.contains("activeWindow") || noUI) continue;
                activeFound = true;
                s = line.substring(line.indexOf("=") + 1);
                if (s.contains("JobView")) {
                    newJobFrame.setVisible(true);
                    mainPanel.setVisible(false);
                    dummy = new JFrame();
                    dummy.setLocation(-100, 0);
                    dummy.setVisible(true);
                    dummy.setVisible(false);
                    continue;
                }
                mainPanel.setVisible(true);
                dummy = new JFrame();
                dummy.setLocation(-100, 0);
                dummy.setVisible(true);
                dummy.setVisible(false);
            }
        }
        catch (FileNotFoundException e1) {
            System.out.println("File containing personal configuration not found, one will be created upon termination of this gridmon.");
            mainPanel.setSize(310, 300);
            mainPanel.setLocation(100, 100);
        }
        catch (IOException e1) {
            // empty catch block
        }
        if (!activeFound && !noUI) {
            mainPanel.setVisible(true);
            mainPanel.repaint();
            JFrame dummy = new JFrame();
            dummy.setLocation(-100, 0);
            dummy.setVisible(true);
            dummy.setVisible(false);
        }
    }

    private static int maxNodeSize() {
        int high = 0;
        for (int x = 0; x < nodes.size(); ++x) {
            if (LocalMon.nodes.get((int)x).values.length + 4 <= high) continue;
            high = LocalMon.nodes.get((int)x).values.length + 4;
        }
        return high * nodeSizeSelection * 2;
    }

    private static int maxNameSize() {
        int high = 0;
        for (int x = 0; x < nodes.size(); ++x) {
            if (nodes.get(x).getName().length() <= high) continue;
            high = nodes.get(x).getName().length();
        }
        return 8 * high;
    }

    protected static void resizeNodes() {
        if (nodeX < nodeY) {
            nodeX = nodeY;
        }
        for (int x = 0; x < nodes.size(); ++x) {
            nodes.get(x).setPreferredSize(new Dimension(nodeX, nodeY));
            nodes.get(x).setSize(new Dimension(nodeX, nodeY));
        }
    }

    static double StringToDouble(String name) {
        double value = 0.0;
        for (int x = 0; x < name.length(); ++x) {
            value += (double)(name.charAt(x) - 96) / 2.7 * 10.0 / 10.0 * Math.pow(10.0, -2 * x);
        }
        return 1.0 / value;
    }

    protected static String execCommand(String[] commands, Map<String, String> envp) throws IOException {
        String line;
        String line2;
        String newPath = "";
        ProcessBuilder pb = new ProcessBuilder(commands);
        if (envp != null) {
            for (Map.Entry<String, String> entry : envp.entrySet()) {
                pb.environment().put(entry.getKey(), entry.getValue());
            }
        }
        pb.environment().put("GRIDHOST", gridHost + ":" + gridInstall);
        Process p = pb.start();
        try {
            p.waitFor();
        }
        catch (InterruptedException e) {
            System.out.println("new meh");
        }
        BufferedReader stdout = new BufferedReader(new InputStreamReader(p.getInputStream()));
        StringBuffer sb = new StringBuffer();
        while ((line2 = stdout.readLine()) != null) {
            if ((line2 = line2.trim()).length() == 0) continue;
            if (sb.length() > 0) {
                sb.append("\n");
            }
            sb.append(line2);
            newPath = line2;
            System.out.println(line2);
        }
        sb = new StringBuffer();
        BufferedReader stderr = new BufferedReader(new InputStreamReader(p.getErrorStream()));
        while ((line = stderr.readLine()) != null) {
            if ((line = line.trim()).length() == 0) continue;
            if (sb.length() > 0) {
                sb.append("\n");
            }
            sb.append(line);
        }
        if (sb.length() > 0) {
            System.out.println(sb.toString());
            throw new IOException(sb.toString());
        }
        int exitValue = p.exitValue();
        if (exitValue != 0) {
            p.destroy();
        }
        return newPath;
    }

    static {
        nodeX = 100;
        nodeXBuffer = 15;
        nodeY = 50;
        totalMem = 0L;
        nodeSizeSelection = 2;
        dataLock = new Object();
        jobPaneLock = new Object();
        TKsshPath = "";
        gridSSHPath = "";
        prevCommand = "";
        savedCommands = new ArrayList();
        startPort = 0;
        noUI = false;
        cmdstart = 0;
    }

    static class UpdateThread
    extends Thread {
        TKGridMonConnectionManager manager;
        TKGridMonUser[] newUsers;
        HashMap<String, TKGridMonUser> userData = new HashMap();
        HashMap<String, ArrayList<TKGridMonProcess>> jobs = new HashMap();
        HashMap<String, ArrayList<TKGridMonProcess>> disks = new HashMap();
        ArrayList<TKGridMonUser> users = new ArrayList();
        int fails = 0;
        int counter = 0;

        UpdateThread() {
        }

        @Override
        public void run() {
            jobPane.setLocation(LocalMon.jobPane.getLocation().x + 1, LocalMon.jobPane.getLocation().y);
            while (!ConnectionLost.isVisible()) {
                int y;
                int y2;
                try {
                    UpdateThread.sleep(1000L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                ++this.counter;
                if (this.counter % 5 == 0) {
                    nodeX = LocalMon.maxNodeSize();
                    nodeY = 50;
                    LocalMon.resizeNodes();
                    if (this.counter > 10000) {
                        this.counter = 1;
                    }
                }
                this.userData = new HashMap();
                this.disks = new HashMap();
                this.jobs = new HashMap();
                for (int x = 59; x > 0; --x) {
                    LocalMon.cpuHistory[x] = cpuHistory[x - 1];
                    LocalMon.memHistory[x] = memHistory[x - 1];
                }
                int nodeCount = this.manager.getNodeCount();
                TKGridMonNode[] data = this.manager.getCopyOfNodes();
                double totalCpu = 0.0;
                double usedMem = 0.0;
                int totalProcessors = 0;
                numCPUs = 0;
                this.fails = 0;
                int updates = 0;
                long localTotalMem = 0L;
                if (data != null && data[0] != null) {
                    for (int x = 0; x < nodeCount; ++x) {
                        TKGridMonProcess[] processInfo;
                        localTotalMem += (long)data[x].getMemTotal();
                        if (data[x].isUnresponsive()) {
                            ++this.fails;
                        }
                        if (this.fails > 3 && !ConnectionLost.isVisible()) {
                            ConnectionLost.add(new Label("Connection to grid lost"));
                            ConnectionLost.setDefaultCloseOperation(3);
                            ConnectionLost.setLocation(100, 100);
                            ConnectionLost.setVisible(true);
                        }
                        if ((processInfo = data[x].getProcessInfo()) != null) {
                            for (TKGridMonProcess element : processInfo) {
                                element.setCpus(data[x].getCpuCount());
                                String jobName = element.getUserID() + " " + element.getPort();
                                if (this.jobs.get(jobName) != null) {
                                    this.jobs.get(jobName).add(element);
                                    continue;
                                }
                                ArrayList<TKGridMonProcess> newList = new ArrayList<TKGridMonProcess>();
                                newList.add(element);
                                this.jobs.put(jobName, newList);
                            }
                        }
                        if (data[x].getUserInfo() != null) {
                            for (int y3 = 0; y3 < data[x].getUserInfo().length; ++y3) {
                                if (data[x].getUserInfo()[y3] == null) continue;
                                if (this.userData.get(data[x].getUserInfo()[y3].getUserID()) != null) {
                                    int newCPU = this.userData.get(data[x].getUserInfo()[y3].getUserID()).getCpuUsage() + data[x].getUserInfo()[y3].getCpuUsage();
                                    int newMem = this.userData.get(data[x].getUserInfo()[y3].getUserID()).getMemUsed() + data[x].getUserInfo()[y3].getMemUsed();
                                    TKGridMonUser newUser = new TKGridMonUser(data[x].getUserInfo()[y3].getUserID());
                                    newUser.setCpuUsage(newCPU);
                                    newUser.setMemUsed(newMem);
                                    this.userData.put(data[x].getUserInfo()[y3].getUserID(), newUser);
                                    continue;
                                }
                                this.userData.put(data[x].getUserInfo()[y3].getUserID(), data[x].getUserInfo()[y3]);
                            }
                        }
                        numCPUs += data[x].getCpuCount();
                        if (nodes.size() <= x) {
                            nodes.add(new nodeDisplay(dataLock));
                        }
                        if (nodeBoxes.size() <= x) {
                            JPanel nodeBox = new JPanel();
                            nodeBox.setBackground(Color.white);
                            nodeBoxes.add(nodeBox);
                        }
                        if (data[x] == null) continue;
                        nodes.get(x).setName(data[x].getName());
                        nodes.get(x).setNumbers(data[x].getCpuLevels(), data[x].getMeanCpuLevels(), data[x].getBytesIn(), data[x].getBytesOut(), data[x].getMemTotal(), data[x].getMemFree(), data[x]);
                        totalMem = data[x].getMemTotal();
                        ++updates;
                        int[] levels = data[x].getCpuLevels();
                        for (int a = 0; a < data[x].getCpuCount(); ++a) {
                            totalCpu += (double)levels[a];
                            ++totalProcessors;
                        }
                        usedMem += (double)(data[x].getMemTotal() - data[x].getMemFree());
                        if (nodes.get(x) == null) continue;
                        JPanel nodeBox = nodeBoxes.get(x);
                        if (nodeBoxes.get(x).getComponentCount() == 0) {
                            nodeBox.add(nodes.get(x));
                            clusterPanel.add(nodeBox);
                        }
                        LocalMon.nodes.get((int)x).cpuGraph.repaint();
                    }
                }
                mainPanel.setTitle("Grid Monitor - " + nodes.size() + " Machines");
                if (localTotalMem > GridMemory) {
                    GridMemory = localTotalMem;
                }
                LocalMon.cpuHistory[0] = (int)(totalCpu / (double)totalProcessors);
                LocalMon.memHistory[0] = (int)(100.0 * usedMem / (double)(totalMem * (long)nodeCount));
                double formattedUsed = (double)((int)(usedMem * 10.0)) / 10.0;
                double formattedTotal = (double)((int)(totalMem * (long)nodeCount * 10L)) / 10.0;
                LocalMon.jobWindow.cpuT.setText(" " + cpuHistory[0] + "%");
                cpuGraph.setData(cpuHistory, null, null, memHistory, null, 0);
                double[] percents = new double[100];
                double[] percentMems = new double[100];
                String[] names = new String[100];
                long[] actualMems = new long[100];
                int positionOfBiggest = 0;
                TKGridMonUser[] a = new TKGridMonUser[100];
                this.userData.values().toArray(a);
                for (int x = 0; x < a.length; ++x) {
                    a = new TKGridMonUser[100];
                    this.userData.values().toArray(a);
                    positionOfBiggest = 0;
                    double bigValue = 0.0;
                    for (int y4 = 1; y4 < a.length; ++y4) {
                        if (a[y4] == null) continue;
                        double newValue = 0.0;
                        if (sortArg.getSelectedIndex() == 0) {
                            newValue = a[y4].getCpuUsage();
                        }
                        if (sortArg.getSelectedIndex() == 1) {
                            newValue = LocalMon.StringToDouble(a[y4].getUserID());
                        }
                        if (sortArg.getSelectedIndex() == 2) {
                            newValue = a[y4].getMemUsed();
                        }
                        if (!(newValue > bigValue)) continue;
                        positionOfBiggest = y4;
                        bigValue = newValue;
                    }
                    if (a[positionOfBiggest] == null) continue;
                    percents[x] = (double)a[positionOfBiggest].getCpuUsage() / (double)numCPUs;
                    percentMems[x] = (double)((long)a[positionOfBiggest].getMemUsed() / totalMem) / (double)nodeCount * 100.0;
                    names[x] = a[positionOfBiggest].getUserID();
                    actualMems[x] = a[positionOfBiggest].getMemUsed();
                    if (actualMems[x] < 0L) {
                        actualMems[x] = 0L;
                    }
                    this.userData.remove(names[x]);
                }
                Object[] a1 = this.jobs.keySet().toArray();
                Object[] a3 = this.jobs.values().toArray();
                HashMap nodeRankLists = new HashMap();
                for (int z = 0; z < nodes.size(); ++z) {
                    nodeRankLists.put(nodes.get(z).getName(), new ArrayList());
                    block11: for (int y5 = 0; y5 < this.jobs.size(); ++y5) {
                        String name = (String)a1[y5];
                        for (int rankNum = 0; rankNum < ((ArrayList)a3[y5]).size(); ++rankNum) {
                            if (!((String)a1[y5]).contains(":") || !((TKGridMonProcess)((ArrayList)a3[y5]).get(rankNum)).getHostName().equals(nodes.get(z).getName())) continue;
                            ((TKGridMonProcess)((ArrayList)a3[y5]).get(rankNum)).setJobID(Integer.parseInt(name.substring(name.lastIndexOf(" ") + 1)));
                            ((ArrayList)nodeRankLists.get(nodes.get(z).getName())).add((TKGridMonProcess)((ArrayList)a3[y5]).get(rankNum));
                            continue block11;
                        }
                    }
                    nodes.get(z).updateRanks((ArrayList)nodeRankLists.get(nodes.get(z).getName()));
                }
                String[] users = new String[1000];
                String[] jobNames = new String[1000];
                int[] runtimes = new int[1000];
                int[] ports = new int[1000];
                int disksRead = 0;
                for (y2 = 0; y2 < this.jobs.size(); ++y2) {
                    int x;
                    String p3;
                    String p2;
                    String name = (String)a1[y2];
                    if (!name.contains(":")) {
                        for (int z = 0; z < this.jobs.get(name).size(); ++z) {
                            TKGridMonProcess disk = this.jobs.get(name).get(z);
                            if (this.disks.get(disk.getUserID()) != null) {
                                this.disks.get(disk.getUserID()).add(disk);
                                continue;
                            }
                            ArrayList<TKGridMonProcess> newList = new ArrayList<TKGridMonProcess>();
                            newList.add(disk);
                            this.disks.put(disk.getUserID(), newList);
                        }
                        ++disksRead;
                        continue;
                    }
                    boolean found = false;
                    for (int z = 0; z < jobPane.getComponentCount(); ++z) {
                        if (!((jobLabel)jobPane.getComponent(z)).getName().equals(name)) continue;
                        ((jobLabel)jobPane.getComponent(z)).updateRanks(this.jobs.get(name));
                        String p1 = name.substring(0, name.indexOf(":"));
                        p2 = name.substring(name.indexOf(":") + 2, name.lastIndexOf(" "));
                        p3 = name.substring(name.lastIndexOf(" ") + 1);
                        while (p1.length() < 10) {
                            p1 = p1 + " ";
                        }
                        while (p2.length() < 10) {
                            p2 = p2 + " ";
                        }
                        TKGridMonProcess rank1 = this.jobs.get(name).get(0);
                        runtimes[y2 - disksRead] = rank1.maxTime - rank1.timeLeft;
                        name = p1 + p2 + p3;
                        if (p1 == null) {
                            System.out.println("problem");
                        }
                        users[y2 - disksRead] = p1;
                        jobNames[y2 - disksRead] = p2;
                        ports[y2 - disksRead] = Integer.parseInt(p3);
                        ((jobLabel)jobPane.getComponent(z)).setText(name);
                        ((jobLabel)LocalMon.jobPane.getComponent((int)z)).active = true;
                        ((jobLabel)jobPane.getComponent(z)).repaint();
                        found = true;
                        break;
                    }
                    if (found) continue;
                    jobLabel newEntry = new jobLabel(name);
                    newEntry.setName(name);
                    newEntry.setPid(this.jobs.get(a1[y2 - disksRead]).get(0).getPid());
                    newEntry.setNice(this.jobs.get(a1[y2 - disksRead]).get(0).getNice());
                    String p1 = name.substring(0, name.indexOf(":"));
                    newEntry.setUserName(p1);
                    p2 = name.substring(name.indexOf(":") + 2, name.lastIndexOf(" "));
                    p3 = name.substring(name.lastIndexOf(" ") + 1);
                    while (p1.length() < 10) {
                        p1 = p1 + " ";
                    }
                    while (p2.length() < 10) {
                        p2 = p2 + " ";
                    }
                    name = p1 + p2 + p3;
                    if (p1 == null) {
                        System.out.println("problem");
                    }
                    users[y2 - disksRead] = p1;
                    jobNames[y2 - disksRead] = p2;
                    ports[y2 - disksRead] = Integer.parseInt(p3);
                    newEntry.setText(name);
                    newEntry.active = true;
                    newEntry.setPreferredSize(new Dimension(175, 25));
                    for (x = 0; x < jobPane.getComponentCount() && p1.compareTo(((jobLabel)jobPane.getComponent(x)).getText()) >= 0; ++x) {
                    }
                    jobPane.add((Component)newEntry, x);
                    jobPane.setSize(jobPane.getWidth(), jobPane.getHeight() + 20);
                    usersLabels.add(newEntry);
                }
                for (y2 = 0; y2 < jobPane.getComponentCount(); ++y2) {
                    if (!((jobLabel)LocalMon.jobPane.getComponent((int)y2)).active && jobPane.getComponent(y2).isVisible()) {
                        usersLabels.remove(jobPane.getComponent(y2));
                        ((jobLabel)LocalMon.jobPane.getComponent((int)y2)).jobFrame.setVisible(false);
                        jobPane.remove(y2);
                        continue;
                    }
                    ((jobLabel)LocalMon.jobPane.getComponent((int)y2)).active = false;
                }
                for (int z = 0; z < jobPane.getComponentCount(); ++z) {
                    if (((jobLabel)LocalMon.jobPane.getComponent((int)z)).updateCounter <= 15) continue;
                    ((jobLabel)LocalMon.jobPane.getComponent((int)z)).jobFrame.setVisible(false);
                }
                jobWindow.setData(users, jobNames, ports, runtimes, this.jobs.size(), disksRead);
                if (noUI && this.jobs.size() > 0 && !LocalMon.jobWindow.listModel7.get(0).equals("0")) {
                    jobWindow.printData();
                    System.exit(0);
                }
                Object[] diskList = this.disks.keySet().toArray();
                for (y = 0; y < this.disks.size(); ++y) {
                    String name = (String)diskList[y];
                    boolean found = false;
                    for (int z = 0; z < diskPane.getComponentCount(); ++z) {
                        if (!((DiskLabel)LocalMon.diskPane.getComponent((int)z)).name.equals(name)) continue;
                        ((DiskLabel)diskPane.getComponent(z)).updateData(this.disks.get(name));
                        ((DiskLabel)diskPane.getComponent(z)).setText(name);
                        ((DiskLabel)LocalMon.diskPane.getComponent((int)z)).active = true;
                        ((DiskLabel)diskPane.getComponent(z)).repaint();
                        found = true;
                        break;
                    }
                    if (found) continue;
                    DiskLabel newEntry = new DiskLabel(name);
                    newEntry.active = true;
                    newEntry.setPreferredSize(new Dimension(175, 25));
                    diskPane.add(newEntry);
                    diskPane.setSize(diskPane.getWidth(), diskPane.getHeight() + 20);
                    diskLabels.add(newEntry);
                }
                for (y = 0; y < diskPane.getComponentCount(); ++y) {
                    if (!((DiskLabel)LocalMon.diskPane.getComponent((int)y)).active && diskPane.getComponent(y).isVisible()) {
                        ((DiskLabel)LocalMon.diskPane.getComponent((int)y)).diskFrame.setVisible(false);
                        diskLabels.remove(diskPane.getComponent(y));
                        diskPane.getComponent(y).setVisible(false);
                        --y;
                        continue;
                    }
                    ((DiskLabel)LocalMon.diskPane.getComponent((int)y)).active = false;
                }
                diskPane.validate();
                diskPane.repaint();
                userDataGraph.repaint();
                clusterPanel.revalidate();
                clusterPanel.repaint();
                cpuGraph.repaint();
                if (clusterPanel.getWidth() <= 3) continue;
                int a2 = (nodes.size() / ((clusterPanel.getWidth() + 1) / (nodeX + nodeXBuffer)) + 1) * (nodeY + 17);
                if (nodes.size() % ((clusterPanel.getWidth() + 1) / (nodeX + nodeXBuffer)) == 0) {
                    a2 -= nodeY + 17;
                }
                clusterPanel.setPreferredSize(new Dimension(mainPanel.getWidth() - 25, a2));
                clusterPanel.setSize(new Dimension(mainPanel.getWidth() - 25, a2));
            }
        }

        public void setManager(TKGridMonConnectionManager m) {
            this.manager = m;
        }
    }
}

