/*
 * Decompiled with CFR 0.152.
 */
package com.sas.tkgridmon.client;

import com.sas.tkgridmon.client.DiskDisplay;
import com.sas.tkgridmon.client.LocalMon;
import com.sas.tkgridmon.client.TKGridMonProcess;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Graphics;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;

public class DiskLabel
extends Component {
    private static final long serialVersionUID = 1L;
    JPopupMenu popup;
    JFrame diskFrame;
    JPanel diskPane;
    JScrollPane scroll;
    boolean active;
    String name;
    private ArrayList<TKGridMonProcess> disks;

    public DiskLabel(String name) {
        this.name = name;
        this.diskFrame = new JFrame();
        this.diskFrame.setSize(400, 200);
        this.diskFrame.setLocation(100, 100);
        this.diskPane = new JPanel();
        this.diskPane.setBackground(Color.white);
        this.diskPane.setSize(500, 500);
        this.scroll = new JScrollPane(this.diskPane);
        this.scroll.setHorizontalScrollBarPolicy(31);
        this.diskPane.setAlignmentX(0.0f);
        this.diskPane.setLayout(new FlowLayout(0));
        this.setMaximumSize(new Dimension(500, 25));
        this.scroll.addComponentListener(new ComponentListener(){

            @Override
            public void componentHidden(ComponentEvent e) {
            }

            @Override
            public void componentMoved(ComponentEvent e) {
            }

            @Override
            public void componentResized(ComponentEvent arg0) {
                int a = (DiskLabel.this.diskPane.getComponentCount() / ((DiskLabel.this.diskPane.getWidth() + 1) / 80) + 1) * 40 + 5;
                if (DiskLabel.this.diskPane.getComponentCount() % ((DiskLabel.this.diskPane.getWidth() + 1) / 80) == 0) {
                    a -= 46;
                }
                DiskLabel.this.diskPane.setPreferredSize(new Dimension(DiskLabel.this.diskFrame.getWidth() - 25, a));
                DiskLabel.this.diskPane.setSize(new Dimension(DiskLabel.this.diskFrame.getWidth() - 25, a));
            }

            @Override
            public void componentShown(ComponentEvent e) {
            }
        });
        this.diskFrame.add(this.scroll);
        this.diskFrame.setTitle(name);
        this.diskPane.setName(name);
        this.setText(name);
        PopupListener popupListener = new PopupListener();
        this.addMouseListener(popupListener);
        this.popup = new JPopupMenu();
    }

    public void setText(String name2) {
        this.name = name2;
    }

    private String getText() {
        return this.name;
    }

    @Override
    public void paint(Graphics g) {
        g.setColor(Color.black);
        g.setFont(LocalMon.f);
        g.drawString(" " + this.getText(), 0, 12);
    }

    public void updateData(ArrayList<TKGridMonProcess> arrayList) {
        this.diskFrame.setTitle(this.name);
        this.disks = arrayList;
        if (arrayList != null) {
            for (int x = 0; x < arrayList.size(); ++x) {
                if (this.diskPane.getComponentCount() <= x) {
                    this.diskPane.add(new DiskDisplay("" + arrayList.get(x).getUserID(), this));
                }
                ((DiskDisplay)this.diskPane.getComponent(x)).setNumbers(arrayList.get(x).getUserID(), arrayList.get(x).getHostName(), arrayList.get(x).getMemUsed(), arrayList.get(x).getMemTotal());
            }
        }
        if (this.diskPane.getWidth() > 80) {
            int a = (this.diskPane.getComponentCount() / ((this.diskPane.getWidth() + 1) / 80) + 1) * 40 + 5;
            if (this.diskPane.getComponentCount() % ((this.diskPane.getWidth() + 1) / 80) == 0) {
                a -= 46;
            }
            this.diskPane.setPreferredSize(new Dimension(this.diskFrame.getWidth() - 25, a));
            this.diskPane.setSize(new Dimension(this.diskFrame.getWidth() - 25, a));
        }
        this.diskPane.repaint();
    }

    class PopupListener
    extends MouseAdapter {
        PopupListener() {
        }

        @Override
        public void mousePressed(MouseEvent e) {
            if (e.getButton() == 1) {
                DiskLabel.this.diskFrame.setVisible(true);
            }
            if (e.getButton() == 3) {
                DiskLabel.this.popup.show(e.getComponent(), e.getX(), e.getY());
            }
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            if (e.getButton() == 1) {
                DiskLabel.this.diskFrame.setVisible(true);
            }
        }
    }
}

