/*
 * Decompiled with CFR 0.152.
 */
package com.sas.tkgridmon.client;

import com.sas.tkgridmon.client.DiskLabel;
import com.sas.tkgridmon.client.LocalMon;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import java.io.IOException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.text.DecimalFormat;
import java.util.ArrayList;
import javax.swing.JComponent;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.ToolTipManager;

public class DiskDisplay
extends JComponent {
    private static final long serialVersionUID = -2231942284994428789L;
    String name;
    double cpu;
    JPopupMenu popup;
    private String hostName;
    private int pid;
    private DiskLabel Parent;
    private String diskName;
    private double used;
    private double total;

    public DiskDisplay(String name, DiskLabel diskLabel) {
        this.setBackground(Color.white);
        this.name = "Rank: " + name;
        this.Parent = diskLabel;
        this.setPreferredSize(new Dimension(75, 35));
        PopupListener popupListener = new PopupListener();
        this.addMouseListener(popupListener);
        this.popup = new JPopupMenu();
        JMenuItem XTermMenuItem = new JMenuItem("XTerm", 88);
        XTermMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                String compAddress = "";
                try {
                    InetAddress addr = InetAddress.getLocalHost();
                    compAddress = addr.getCanonicalHostName();
                }
                catch (UnknownHostException addr) {
                    // empty catch block
                }
                ArrayList<String> cmds = new ArrayList<String>();
                if (!LocalMon.TKsshPath.equals("")) {
                    if (LocalMon.TKsshPath.contains("sdssas")) {
                        for (int x1 = 0; x1 < LocalMon.TKsshPath.split(" ").length; ++x1) {
                            if (LocalMon.TKsshPath.split(" ")[x1].trim() == "") continue;
                            cmds.add(LocalMon.TKsshPath.split(" ")[x1].trim());
                        }
                    } else {
                        cmds.add(LocalMon.TKsshPath);
                    }
                    cmds.add(LocalMon.gridHost);
                }
                if (File.separatorChar == '/') {
                    cmds.add(LocalMon.TKsshPath);
                    compAddress = System.getenv("DISPLAY");
                } else {
                    cmds.add(LocalMon.TKsshPath);
                    compAddress = compAddress + ":0";
                }
                cmds.add(DiskDisplay.this.hostName);
                cmds.add("xterm -display " + compAddress);
                System.out.println(cmds);
                ProcessBuilder pb = new ProcessBuilder(cmds.toArray(new String[cmds.size()]));
                try {
                    pb.start();
                }
                catch (IOException e1) {
                    System.out.println("failed to open xterm");
                    e1.printStackTrace();
                }
            }
        });
        this.popup.add(XTermMenuItem);
    }

    public void setNumbers(String diskName, String hostName, int used, int total) {
        this.used = used;
        this.total = total;
        this.diskName = diskName;
        this.hostName = hostName;
        DecimalFormat xFormat = new DecimalFormat("0.00");
        String toolTip = "<html><font face=\"sansserif\" color=\"black\">";
        if (total != 0) {
            toolTip = toolTip + "Disk Name: " + diskName + "<br>Host Name: " + hostName + "<br>Space Used: " + xFormat.format((double)used / 1048576.0) + " GB, " + xFormat.format((double)used / (double)total * 100.0) + "% <br>Total Space: " + xFormat.format((double)total / 1048576.0) + " GB</font></html>";
        }
        this.setToolTipText(toolTip);
        ToolTipManager.sharedInstance().setDismissDelay(1000000);
    }

    @Override
    public void paint(Graphics G) {
        Graphics2D g = (Graphics2D)G;
        g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g.setFont(LocalMon.f);
        g.setColor(Color.black);
        g.drawRect(0, 0, this.getWidth() - 3, this.getHeight() - 3);
        int width = (int)(this.used * (double)(this.getWidth() - 5) / this.total);
        if (width > 0) {
            g.setColor(Color.red);
            g.fillRect(1, 1, width, this.getHeight() - 4);
        }
        g.setColor(Color.black);
        g.drawString(" " + this.hostName, 0, (int)((double)this.getHeight() * 0.5));
    }

    class PopupListener
    extends MouseAdapter {
        PopupListener() {
        }

        @Override
        public void mousePressed(MouseEvent e) {
            if (e.getButton() == 3) {
                DiskDisplay.this.popup.show(e.getComponent(), e.getX(), e.getY());
            }
        }

        @Override
        public void mouseReleased(MouseEvent e) {
        }
    }
}

