/*
 * Decompiled with CFR 0.152.
 */
package com.sas.tkgridmon.client;

import com.sas.tkgridmon.client.JobWindow;
import com.sas.tkgridmon.client.LocalMon;
import java.awt.Button;
import java.awt.Checkbox;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.DefaultListModel;
import javax.swing.JFrame;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.border.Border;

public class CustomCommandUI
extends JPanel {
    String popupHost;
    int pid;
    final JList list1;
    final Checkbox openOutput;
    String TargetUID;
    boolean errDoneFlag = false;
    JFrame frame;

    public CustomCommandUI(String popupHost, int pid, String targetUser) {
        this.TargetUID = targetUser;
        Dimension maxButton = new Dimension(200, 30);
        this.popupHost = popupHost;
        this.pid = pid;
        final JTextField newCommand = new JTextField();
        this.openOutput = new Checkbox("Open Output Window?");
        this.openOutput.setState(true);
        final DefaultListModel listModel1 = new DefaultListModel();
        this.list1 = new JList(listModel1);
        KeyListener altShortcutListener = new KeyListener(){

            @Override
            public void keyTyped(KeyEvent arg0) {
            }

            @Override
            public void keyReleased(KeyEvent arg0) {
                if (arg0.getKeyChar() == '\n' && CustomCommandUI.this.list1.getSelectedIndex() != -1) {
                    CustomCommandUI.this.runcommand();
                    newCommand.setText("");
                    newCommand.requestFocusInWindow();
                }
                if (!arg0.isAltDown()) {
                    return;
                }
                int key = arg0.getKeyCode() - 48;
                CustomCommandUI.this.list1.setSelectedIndex(key - 1);
            }

            @Override
            public void keyPressed(KeyEvent arg0) {
            }
        };
        KeyListener enterKeyListener = new KeyListener(){

            @Override
            public void keyPressed(KeyEvent arg0) {
            }

            @Override
            public void keyReleased(KeyEvent arg0) {
                if (arg0.getKeyChar() != '\n') {
                    return;
                }
                if (newCommand.getText() != null && !newCommand.getText().equals("")) {
                    if (!listModel1.contains(newCommand.getText())) {
                        LocalMon.savedCommands.add(newCommand.getText());
                        listModel1.add(listModel1.getSize(), newCommand.getText());
                    }
                    CustomCommandUI.this.list1.setSelectedIndex(listModel1.indexOf(newCommand.getText()));
                    newCommand.setText("");
                    newCommand.requestFocusInWindow();
                    if (CustomCommandUI.this.list1.getSelectedIndex() != -1) {
                        CustomCommandUI.this.runcommand();
                    }
                }
            }

            @Override
            public void keyTyped(KeyEvent arg0) {
            }
        };
        this.list1.addKeyListener(altShortcutListener);
        newCommand.addKeyListener(enterKeyListener);
        this.list1.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                newCommand.setText((String)CustomCommandUI.this.list1.getSelectedValue());
                newCommand.requestFocusInWindow();
                if (evt.getClickCount() > 1) {
                    CustomCommandUI.this.runcommand();
                }
            }
        });
        this.setLayout(new BoxLayout(this, 1));
        JPanel right = new JPanel();
        JPanel bottomPanel = new JPanel();
        right.setLayout(new BoxLayout(right, 1));
        bottomPanel.setLayout(new BoxLayout(bottomPanel, 1));
        JPanel buttonRow = new JPanel();
        buttonRow.setLayout(new BoxLayout(buttonRow, 0));
        Border empty = BorderFactory.createEmptyBorder(10, 0, 10, 0);
        Border line = BorderFactory.createLineBorder(Color.LIGHT_GRAY, 5);
        newCommand.setBorder(BorderFactory.createCompoundBorder(line, empty));
        newCommand.setMaximumSize(new Dimension(Integer.MAX_VALUE, newCommand.getPreferredSize().height));
        right.add(newCommand);
        Button addCommand = new Button("Add");
        addCommand.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                if (newCommand.getText() != null && !newCommand.getText().equals("")) {
                    if (!listModel1.contains(newCommand.getText())) {
                        LocalMon.savedCommands.add(newCommand.getText());
                        listModel1.add(listModel1.getSize(), newCommand.getText());
                    }
                    CustomCommandUI.this.list1.setSelectedIndex(listModel1.indexOf(newCommand.getText()));
                    newCommand.setText("");
                    newCommand.requestFocusInWindow();
                }
            }
        });
        addCommand.setMaximumSize(maxButton);
        buttonRow.add(addCommand);
        if (LocalMon.savedCommands != null) {
            for (int x = 0; x < LocalMon.savedCommands.size(); ++x) {
                listModel1.add(x, LocalMon.savedCommands.get(x));
            }
        }
        JScrollPane listScrollPane = new JScrollPane(this.list1);
        listScrollPane.getVerticalScrollBar().setUnitIncrement(16);
        listScrollPane.setBackground(Color.white);
        right.add(listScrollPane);
        Button exe = new Button("Execute");
        exe.setMaximumSize(maxButton);
        exe.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                if (CustomCommandUI.this.list1.getSelectedIndex() != -1) {
                    CustomCommandUI.this.runcommand();
                }
            }
        });
        buttonRow.add(exe);
        Button remove = new Button("Remove");
        remove.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                if (CustomCommandUI.this.list1.getSelectedIndex() != -1) {
                    if (LocalMon.savedCommands.contains(CustomCommandUI.this.list1.getSelectedValue())) {
                        LocalMon.savedCommands.remove(LocalMon.savedCommands.indexOf(CustomCommandUI.this.list1.getSelectedValue()));
                    }
                    listModel1.remove(CustomCommandUI.this.list1.getSelectedIndex());
                    newCommand.setText("");
                    newCommand.requestFocusInWindow();
                }
            }
        });
        remove.setMaximumSize(maxButton);
        buttonRow.add(remove);
        bottomPanel.add(buttonRow);
        JPanel buffer = new JPanel();
        buffer.setMaximumSize(new Dimension(100, 100000));
        buffer.setBorder(BorderFactory.createLineBorder(Color.BLACK, 1));
        this.openOutput.setMaximumSize(new Dimension(150, 40));
        exe.addKeyListener(altShortcutListener);
        remove.addKeyListener(altShortcutListener);
        addCommand.addKeyListener(altShortcutListener);
        this.add(right);
        this.add(bottomPanel);
        newCommand.requestFocusInWindow();
    }

    void runcommand() {
        JFrame outputWindow = new JFrame();
        final JTextArea outputarea = new JTextArea();
        JScrollPane outputpanel = new JScrollPane(outputarea);
        outputpanel.setVerticalScrollBarPolicy(22);
        outputWindow.add(outputpanel);
        outputWindow.setTitle("Command Output");
        outputarea.setEditable(false);
        outputarea.setLineWrap(true);
        outputarea.setWrapStyleWord(true);
        outputarea.setFont(new Font("Monospaced", 0, 12));
        String compAddress = "";
        try {
            InetAddress addr = InetAddress.getLocalHost();
            compAddress = addr.getCanonicalHostName();
        }
        catch (UnknownHostException addr) {
            // empty catch block
        }
        ArrayList<String> cmds = new ArrayList<String>();
        if (!LocalMon.TKsshPath.equals("")) {
            if (LocalMon.TKsshPath.contains("sdssas")) {
                for (int x1 = 0; x1 < LocalMon.TKsshPath.split(" ").length; ++x1) {
                    if (LocalMon.TKsshPath.split(" ")[x1].trim() == "") continue;
                    String s = LocalMon.TKsshPath.split(" ")[x1].trim();
                    s.replace("\\", "\\\\");
                    cmds.add(s);
                    System.out.println("previous output=\n" + LocalMon.TKsshPath.split(" ")[x1].trim() + "\nNew Output:\n" + s);
                }
            } else {
                cmds.add(LocalMon.TKsshPath);
            }
        } else {
            System.out.println("ssh path not set");
            return;
        }
        cmds.add(LocalMon.gridHost);
        if (File.separatorChar == '/') {
            cmds.add(LocalMon.gridSSHPath);
            compAddress = System.getenv("DISPLAY");
        } else {
            cmds.add(LocalMon.gridSSHPath);
            compAddress = compAddress + ":0";
        }
        cmds.add(this.popupHost);
        String command = (String)this.list1.getSelectedValue();
        String commanda = (String)this.list1.getSelectedValue();
        if (command.contains("%p") && this.pid == 0) {
            JOptionPane.showMessageDialog(null, "The %p field is only valid on indivual processes.", "pid error", 0);
            return;
        }
        if (command.contains("%p") && this.pid != 0) {
            int sudo = -1;
            sudo = !JobWindow.isRootOrSame(this.TargetUID) ? JOptionPane.showConfirmDialog(null, "Run command as sudo?", "sudo run?", 0) : 1;
            if (sudo == -1) {
                return;
            }
            if (sudo == 0) {
                command = "sudo " + command;
            }
            command = command.replace("%p", this.pid + "");
        }
        String c2 = "export DISPLAY=%d\\; ";
        command = c2 + command;
        command = command.replace("%d", compAddress);
        commanda = commanda.replace("%p", this.pid + "");
        commanda = commanda.replace("%d", compAddress);
        outputWindow.setTitle(commanda);
        cmds.add(command);
        System.out.println(cmds);
        final ProcessBuilder pb = new ProcessBuilder(cmds);
        if (this.openOutput.getState()) {
            outputWindow.setSize(600, 500);
            outputWindow.setLocation(100, 100);
            outputWindow.setVisible(true);
            JFrame dummy = new JFrame();
            dummy.setLocation(-100, 0);
            dummy.setVisible(true);
            dummy.setVisible(false);
        }
        Thread runCommand = new Thread(){

            @Override
            public void run() {
                try {
                    final Process p = pb.start();
                    CustomCommandUI.this.errDoneFlag = false;
                    final Thread out = new Thread(){

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         * Enabled aggressive block sorting
                         * Enabled unnecessary exception pruning
                         * Enabled aggressive exception aggregation
                         */
                        @Override
                        public void run() {
                            JTextArea jTextArea;
                            InputStream is = p.getInputStream();
                            InputStreamReader isr = new InputStreamReader(is);
                            BufferedReader br = new BufferedReader(isr);
                            try {
                                String line;
                                while ((line = br.readLine()) != null) {
                                    jTextArea = outputarea;
                                    synchronized (jTextArea) {
                                        outputarea.setText(outputarea.getText() + '\n' + line);
                                    }
                                }
                            }
                            catch (IOException e) {
                                e.printStackTrace();
                            }
                            jTextArea = outputarea;
                            synchronized (jTextArea) {
                                if (!CustomCommandUI.this.errDoneFlag) return;
                                outputarea.setText(outputarea.getText() + "\n\nProgram Complete");
                                return;
                            }
                        }
                    };
                    Thread err = new Thread(){

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         * Enabled aggressive block sorting
                         * Enabled unnecessary exception pruning
                         * Enabled aggressive exception aggregation
                         */
                        @Override
                        public void run() {
                            JTextArea jTextArea;
                            InputStream is = p.getErrorStream();
                            InputStreamReader isr = new InputStreamReader(is);
                            BufferedReader br = new BufferedReader(isr);
                            try {
                                String line;
                                while ((line = br.readLine()) != null) {
                                    jTextArea = outputarea;
                                    synchronized (jTextArea) {
                                        outputarea.setText(outputarea.getText() + '\n' + line);
                                    }
                                }
                            }
                            catch (IOException e) {
                                e.printStackTrace();
                            }
                            jTextArea = outputarea;
                            synchronized (jTextArea) {
                                if (!out.isAlive()) {
                                    outputarea.setText(outputarea.getText() + "\n\nProgram Complete");
                                }
                                CustomCommandUI.this.errDoneFlag = true;
                                return;
                            }
                        }
                    };
                    out.start();
                    err.start();
                }
                catch (IOException e1) {
                    System.out.println("failed to exe");
                    e1.printStackTrace();
                }
            }
        };
        runCommand.start();
    }

    public void setframe(JFrame commandFrame) {
        this.frame = commandFrame;
    }
}

