/*
 * Decompiled with CFR 0.152.
 */
package com.atomikos.tomcat;

import com.atomikos.beans.PropertyException;
import com.atomikos.beans.PropertyUtils;
import com.atomikos.jms.AtomikosConnectionFactoryBean;
import com.atomikos.util.ClassLoadingHelper;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.List;
import javax.jms.JMSException;
import javax.jms.XAConnectionFactory;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.Name;
import javax.naming.NamingException;
import javax.naming.RefAddr;
import javax.naming.Reference;
import javax.naming.spi.ObjectFactory;
import org.apache.juli.logging.Log;
import org.apache.juli.logging.LogFactory;
import org.apache.naming.ResourceRef;

public class ConnectionFactoryBeanFactory
implements ObjectFactory {
    private static Log TOMCAT_LOG = LogFactory.getLog(ConnectionFactoryBeanFactory.class);
    private static List<String> propertiesToIgnore = Arrays.asList("name", "type", "factory", "scope", "description", "auth", "xaConnectionFactory", "singleton");

    @Override
    public synchronized Object getObjectInstance(Object obj, Name name, Context nameCtx, Hashtable<?, ?> environment) throws NamingException {
        AtomikosConnectionFactoryBean bean = null;
        if (obj instanceof ResourceRef) {
            Reference ref = (Reference)obj;
            bean = this.instantiateConnectionFactoryBean(ref);
            this.setBeanProperties(ref, bean);
            if (bean.getXaConnectionFactoryClassName() == null) {
                RefAddr xaConnectionFactoryRef = ref.get("xaConnectionFactory");
                XAConnectionFactory xaConnectionFactory = this.lookupForConnectionFactory((String)xaConnectionFactoryRef.getContent());
                bean.setXaConnectionFactory(xaConnectionFactory);
            }
        }
        this.initializeConnectionFactoryBean(bean);
        return bean;
    }

    private void initializeConnectionFactoryBean(AtomikosConnectionFactoryBean bean) throws NamingException {
        TOMCAT_LOG.info((Object)("Initializing atomikos connection factory: " + bean.getUniqueResourceName()));
        try {
            bean.init();
        }
        catch (JMSException e) {
            throw (NamingException)new NamingException("Could not initialize atomikos connection factory").initCause(e);
        }
    }

    private XAConnectionFactory lookupForConnectionFactory(String jndiName) throws NamingException {
        Context context = (Context)new InitialContext().lookup("java:/");
        return (XAConnectionFactory)context.lookup(jndiName);
    }

    private AtomikosConnectionFactoryBean instantiateConnectionFactoryBean(Reference ref) throws NamingException {
        String beanClassName = ref.getClassName();
        AtomikosConnectionFactoryBean bean = (AtomikosConnectionFactoryBean)ClassLoadingHelper.newInstance((String)beanClassName);
        if (bean == null) {
            throw new NamingException("Could not instantiate class : " + beanClassName);
        }
        return bean;
    }

    private void setBeanProperties(Reference ref, AtomikosConnectionFactoryBean bean) {
        Enumeration<RefAddr> en = ref.getAll();
        while (en.hasMoreElements()) {
            RefAddr ra = en.nextElement();
            String propName = ra.getType();
            if (propertiesToIgnore.contains(propName)) continue;
            String value = (String)ra.getContent();
            if (TOMCAT_LOG.isDebugEnabled()) {
                TOMCAT_LOG.debug((Object)("Setting property '" + propName + "' to '" + value + "'"));
            }
            try {
                PropertyUtils.setProperty((Object)bean, (String)propName, (Object)value);
            }
            catch (PropertyException e) {
                TOMCAT_LOG.warn((Object)("cannot set property " + propName + " on instance of class " + bean.getClass()));
            }
        }
    }
}

