/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.tests;

import junit.framework.TestCase;
import junit.textui.TestRunner;
import org.jgroups.Address;
import org.jgroups.ChannelClosedException;
import org.jgroups.ChannelNotConnectedException;
import org.jgroups.JChannel;
import org.jgroups.Message;
import org.jgroups.TimeoutException;

public class UnicastLoopbackTest
extends TestCase {
    JChannel channel = null;

    public UnicastLoopbackTest(String name) {
        super(name);
    }

    protected void setUp() throws Exception {
        super.setUp();
        this.channel = new JChannel();
        this.channel.connect("demo-group");
    }

    protected void tearDown() throws Exception {
        super.tearDown();
        if (this.channel != null) {
            this.channel.close();
            this.channel = null;
        }
    }

    public void testUnicastMsgs() throws ChannelClosedException, ChannelNotConnectedException, TimeoutException {
        int NUM = 1000;
        Address local_addr = this.channel.getLocalAddress();
        for (int i = 1; i <= NUM; ++i) {
            this.channel.send(new Message(local_addr, null, new Integer(i)));
            if (i % 100 != 0) continue;
            System.out.println("-- sent " + i);
        }
        int received = 0;
        while (received < NUM) {
            Object o = this.channel.receive(0L);
            if (!(o instanceof Message)) continue;
            Message m = (Message)o;
            Integer num = (Integer)m.getObject();
            ++received;
            if (num % 100 != 0) continue;
            System.out.println("-- received " + num);
        }
        UnicastLoopbackTest.assertEquals((int)NUM, (int)received);
    }

    public static void main(String[] args) {
        String[] testCaseName = new String[]{UnicastLoopbackTest.class.getName()};
        TestRunner.main((String[])testCaseName);
    }
}

