/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.protocols;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectInputStream;
import java.io.ObjectOutput;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Hashtable;
import java.util.Properties;
import java.util.Random;
import java.util.Vector;
import javax.jms.IllegalStateException;
import javax.jms.InvalidClientIDException;
import javax.jms.JMSException;
import javax.jms.MessageListener;
import javax.jms.ObjectMessage;
import javax.jms.Topic;
import javax.jms.TopicConnection;
import javax.jms.TopicConnectionFactory;
import javax.jms.TopicPublisher;
import javax.jms.TopicSession;
import javax.jms.TopicSubscriber;
import javax.naming.Context;
import javax.naming.InitialContext;
import org.jgroups.Address;
import org.jgroups.Event;
import org.jgroups.Message;
import org.jgroups.View;
import org.jgroups.stack.Protocol;
import org.jgroups.util.Util;

public class JMS
extends Protocol
implements MessageListener {
    public static final String DEFAULT_CONNECTION_FACTORY = "ConnectionFactory";
    public static final String INIT_CONNECTION_FACTORY = "cf";
    public static final String INIT_TOPIC_NAME = "topicName";
    public static final String INIT_JNDI_CONTEXT = "jndiCtx";
    public static final String INIT_PROVIDER_URL = "providerURL";
    public static final String TIME_TO_LIVE = "ttl";
    public static final String GROUP_NAME_PROPERTY = "jgroups_group_name";
    public static final String SRC_PROPERTY = "src";
    public static final String DEST_PROPERTY = "dest";
    private final Vector members = new Vector();
    private TopicConnectionFactory connectionFactory;
    private Topic topic;
    private TopicConnection connection;
    private TopicSession session;
    private TopicPublisher publisher;
    private TopicSubscriber subscriber;
    private String cfName;
    private String topicName;
    private String initCtxFactory;
    private String providerUrl;
    private long timeToLive;
    private Context ctx;
    private String group_addr;
    private Address local_addr;
    private Address mcast_addr;
    private final ByteArrayOutputStream out_stream = new ByteArrayOutputStream(65535);
    private static final Random RND = new Random();

    public String getName() {
        return "JMS";
    }

    public String toString() {
        return "Protocol JMS(local address: " + this.local_addr + ')';
    }

    public boolean setProperties(Properties props) {
        super.setProperties(props);
        this.cfName = props.getProperty(INIT_CONNECTION_FACTORY, DEFAULT_CONNECTION_FACTORY);
        props.remove(INIT_CONNECTION_FACTORY);
        this.topicName = props.getProperty(INIT_TOPIC_NAME);
        if (this.topicName == null) {
            throw new IllegalArgumentException("JMS topic has not been specified.");
        }
        props.remove(INIT_TOPIC_NAME);
        this.initCtxFactory = props.getProperty(INIT_JNDI_CONTEXT);
        props.remove(INIT_JNDI_CONTEXT);
        this.providerUrl = props.getProperty(INIT_PROVIDER_URL);
        props.remove(INIT_PROVIDER_URL);
        String ttl = props.getProperty(TIME_TO_LIVE);
        if (ttl == null) {
            if (this.log.isErrorEnabled()) {
                this.log.error((Object)"ttl property not found.");
            }
            return false;
        }
        props.remove(TIME_TO_LIVE);
        try {
            this.timeToLive = Long.parseLong(ttl);
        }
        catch (NumberFormatException nfex) {
            if (this.log.isErrorEnabled()) {
                this.log.error((Object)"ttl property does not contain numeric value.");
            }
            return false;
        }
        return props.size() == 0;
    }

    public void onMessage(javax.jms.Message jmsMessage) {
        block13: {
            try {
                JMSAddress dest;
                String groupName = jmsMessage.getStringProperty(GROUP_NAME_PROPERTY);
                if (groupName == null) {
                    return;
                }
                if (this.log.isDebugEnabled()) {
                    this.log.debug((Object)("Got message for group [" + groupName + ']' + ", my group is [" + this.group_addr + ']'));
                }
                if (!this.group_addr.equals(groupName)) {
                    return;
                }
                JMSAddress src = jmsMessage.getStringProperty(SRC_PROPERTY) != null ? new JMSAddress(jmsMessage.getStringProperty(SRC_PROPERTY)) : null;
                JMSAddress jMSAddress = dest = jmsMessage.getStringProperty(DEST_PROPERTY) != null ? new JMSAddress(jmsMessage.getStringProperty(DEST_PROPERTY)) : null;
                if (src != null && dest != null && !dest.equals(this.local_addr) && !dest.isMulticastAddress()) {
                    return;
                }
                if (jmsMessage instanceof ObjectMessage) {
                    byte[] buf = (byte[])((ObjectMessage)jmsMessage).getObject();
                    ByteArrayInputStream inp_stream = new ByteArrayInputStream(buf);
                    ObjectInputStream inp = new ObjectInputStream(inp_stream);
                    Message msg = new Message();
                    msg.readExternal(inp);
                    Event evt = new Event(1, msg);
                    if (this.log.isDebugEnabled()) {
                        this.log.debug((Object)("Message is " + msg + ", headers are " + msg.getHeaders()));
                    }
                    if (this.observer != null) {
                        this.observer.up(evt, this.up_queue.size());
                    }
                    this.passUp(evt);
                }
            }
            catch (JMSException ex) {
                ex.printStackTrace();
                if (this.log.isErrorEnabled()) {
                    this.log.error((Object)("JMSException : " + ex.toString()));
                }
            }
            catch (IOException ioex) {
                ioex.printStackTrace();
                if (this.log.isErrorEnabled()) {
                    this.log.error((Object)("IOException : " + ioex.toString()));
                }
            }
            catch (ClassNotFoundException cnfex) {
                cnfex.printStackTrace();
                if (!this.log.isErrorEnabled()) break block13;
                this.log.error((Object)("ClassNotFoundException : " + cnfex.toString()));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void handleDownEvent(Event evt) {
        switch (evt.getType()) {
            case 6: 
            case 15: {
                Vector vector = this.members;
                synchronized (vector) {
                    this.members.removeAllElements();
                    Vector tmpvec = ((View)evt.getArg()).getMembers();
                    for (int i = 0; i < tmpvec.size(); ++i) {
                        this.members.addElement(tmpvec.elementAt(i));
                    }
                    break;
                }
            }
            case 7: {
                this.passUp(new Event(8, this.local_addr));
                break;
            }
            case 2: {
                this.group_addr = (String)evt.getArg();
                this.passUp(new Event(3));
                break;
            }
            case 4: {
                this.passUp(new Event(5));
            }
        }
    }

    public void down(Event evt) {
        if (this.log.isInfoEnabled()) {
            this.log.info((Object)("event is " + evt + ", group_addr=" + this.group_addr + ", time=" + System.currentTimeMillis() + ", hdrs are " + Util.printEvent(evt)));
        }
        if (evt.getType() != 1) {
            this.handleDownEvent(evt);
            return;
        }
        Message msg = (Message)evt.getArg();
        if (this.observer != null) {
            this.observer.passDown(evt);
        }
        this.sendMessage(msg);
    }

    protected void sendMessage(Message msg) {
        block9: {
            try {
                if (msg.getSrc() == null) {
                    msg.setSrc(this.local_addr);
                }
                if (msg.getDest() == null) {
                    msg.setDest(this.mcast_addr);
                }
                if (this.log.isInfoEnabled()) {
                    this.log.info((Object)("msg is " + msg));
                }
                this.out_stream.reset();
                ObjectOutputStream out = new ObjectOutputStream(this.out_stream);
                msg.writeExternal(out);
                out.flush();
                byte[] buf = this.out_stream.toByteArray();
                ObjectMessage jmsMessage = this.session.createObjectMessage();
                jmsMessage.setObject((Serializable)buf);
                jmsMessage.setStringProperty(GROUP_NAME_PROPERTY, this.group_addr);
                if (msg.getSrc() instanceof JMSAddress) {
                    jmsMessage.setStringProperty(SRC_PROPERTY, msg.getSrc().toString());
                }
                if (msg.getDest() instanceof JMSAddress) {
                    jmsMessage.setStringProperty(DEST_PROPERTY, msg.getDest().toString());
                }
                this.publisher.publish((javax.jms.Message)jmsMessage);
            }
            catch (JMSException ex) {
                if (this.log.isErrorEnabled()) {
                    this.log.error((Object)("JMSException : " + ex.toString()));
                }
            }
            catch (IOException ioex) {
                if (!this.log.isErrorEnabled()) break block9;
                this.log.error((Object)("IOException : " + ioex.toString()));
            }
        }
    }

    public void start() throws Exception {
        if (this.initCtxFactory != null && this.providerUrl != null) {
            Hashtable<String, String> env = new Hashtable<String, String>();
            env.put("java.naming.factory.initial", this.initCtxFactory);
            env.put("java.naming.provider.url", this.providerUrl);
            this.ctx = new InitialContext(env);
        } else {
            this.ctx = new InitialContext();
        }
        this.connectionFactory = (TopicConnectionFactory)this.ctx.lookup(this.cfName);
        if (this.connectionFactory == null) {
            throw new IllegalArgumentException("Topic connection factory cannot be found in JNDI.");
        }
        this.topic = (Topic)this.ctx.lookup(this.topicName);
        if (this.topic == null) {
            throw new IllegalArgumentException("Topic cannot be found in JNDI.");
        }
        this.connection = this.connectionFactory.createTopicConnection();
        boolean addressAssigned = false;
        while (!addressAssigned) {
            try {
                this.connection.setClientID(this.generateLocalAddress());
                addressAssigned = true;
            }
            catch (IllegalStateException e) {
                addressAssigned = true;
            }
            catch (InvalidClientIDException invalidClientIDException) {}
        }
        this.local_addr = new JMSAddress(this.connection.getClientID(), false);
        this.mcast_addr = new JMSAddress(this.topicName, true);
        this.session = this.connection.createTopicSession(false, 1);
        this.publisher = this.session.createPublisher(this.topic);
        this.publisher.setTimeToLive(this.timeToLive);
        this.subscriber = this.session.createSubscriber(this.topic);
        this.subscriber.setMessageListener((MessageListener)this);
        this.connection.start();
        this.passUp(new Event(8, this.local_addr));
    }

    public void stop() {
        block3: {
            if (this.log.isInfoEnabled()) {
                this.log.info((Object)"finishing JMS transport layer.");
            }
            try {
                this.connection.stop();
                this.subscriber.setMessageListener(null);
                this.session.close();
                this.connection.close();
            }
            catch (Throwable ex) {
                if (!this.log.isErrorEnabled()) break block3;
                this.log.error((Object)("exception is " + ex));
            }
        }
    }

    protected String generateLocalAddress() throws UnknownHostException {
        String hostName = InetAddress.getLocalHost().getHostName();
        int rndPort = RND.nextInt(65535);
        return hostName + ':' + rndPort;
    }

    public static class JMSAddress
    implements Address {
        private String address;
        private boolean isMCast;

        public JMSAddress() {
        }

        JMSAddress(String address, boolean isMCast) {
            this.address = address;
            this.isMCast = isMCast;
        }

        JMSAddress(String str) {
            if (str.startsWith("#")) {
                this.address = str.substring(1);
                this.isMCast = false;
            } else {
                this.address = str;
                this.isMCast = true;
            }
        }

        public String getAddress() {
            return this.address;
        }

        public void setAddress(String address) {
            this.address = address;
        }

        public boolean isMulticastAddress() {
            return this.isMCast;
        }

        public int size() {
            return 22;
        }

        protected Object clone() throws CloneNotSupportedException {
            return new JMSAddress(this.address, this.isMCast);
        }

        public int compareTo(Object o) throws ClassCastException {
            if (!(o instanceof JMSAddress)) {
                throw new ClassCastException("Cannot compare different classes.");
            }
            JMSAddress that = (JMSAddress)o;
            if (that.isMCast != this.isMCast) {
                throw new ClassCastException("Addresses are different: one is multicast, and one is not");
            }
            return this.address.compareTo(that.address);
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (!(obj instanceof JMSAddress)) {
                return false;
            }
            JMSAddress that = (JMSAddress)obj;
            if (this.isMCast) {
                return this.isMCast == that.isMCast;
            }
            if (this.address == null || that.address == null) {
                return false;
            }
            return this.address.equals(that.address) && this.isMCast == that.isMCast;
        }

        public int hashCode() {
            return this.toString().hashCode();
        }

        public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
            this.address = (String)in.readObject();
            this.isMCast = in.readBoolean();
        }

        public String toString() {
            return !this.isMCast ? '#' + this.address : this.address;
        }

        public void writeExternal(ObjectOutput out) throws IOException {
            out.writeObject(this.address);
            out.writeBoolean(this.isMCast);
        }

        public void writeTo(DataOutputStream outstream) throws IOException {
            outstream.writeUTF(this.address);
            outstream.writeBoolean(this.isMCast);
        }

        public void readFrom(DataInputStream instream) throws IOException, IllegalAccessException, InstantiationException {
            this.address = instream.readUTF();
            this.isMCast = instream.readBoolean();
        }
    }
}

