/*
 * Decompiled with CFR 0.152.
 */
package com.sas.storage.iquery;

import com.sas.iquery.IQueryServicesException;
import com.sas.iquery.dataretrieval.DataRetrievalException;
import com.sas.iquery.dataretrieval.QueryConnector;
import com.sas.iquery.execution2.ExecutionException;
import com.sas.iquery.execution2.ResultSetInterface;
import com.sas.iquery.metadata.MetadataException;
import com.sas.iquery.metadata.StructureOfData;
import com.sas.iquery.metadata.business.BriefInformationMap;
import com.sas.iquery.metadata.business.BusinessItem;
import com.sas.iquery.metadata.business.BusinessModel;
import com.sas.iquery.metadata.business.DataItem;
import com.sas.iquery.metadata.business.DataItemActionType;
import com.sas.iquery.metadata.business.DataItemReference;
import com.sas.iquery.metadata.business.DataSelection;
import com.sas.iquery.metadata.business.DataSelectionFactory;
import com.sas.iquery.metadata.business.DataSourceCube;
import com.sas.iquery.metadata.business.Prompt;
import com.sas.iquery.metadata.business.Role;
import com.sas.iquery.util.BusinessQueryOLAPUtil;
import com.sas.prompts.definitions.TextDefinition;
import com.sas.prompts.valueprovider.dynamic.iq.IQIdentityValueProvider;
import com.sas.services.ServiceException;
import com.sas.services.information.MetadataServerInterface;
import com.sas.services.information.OMIRepositoryInterface;
import com.sas.services.information.RepositoryInterface;
import com.sas.services.information.ServerInterface;
import com.sas.services.information.metadata.MetadataInterface;
import com.sas.storage.iquery.BusinessQueryToOLAPDataSetAdapter;
import com.sas.storage.iquery.InformationMapMetaData;
import com.sas.storage.olap.AxisInterface;
import com.sas.storage.olap.Filter;
import com.sas.storage.olap.LevelInterface;
import com.sas.storage.olap.OLAPDataSetInterface;
import com.sas.storage.olap.OLAPException;
import com.sas.storage.olap.TupleElementInterface;
import com.sas.storage.olap.TupleInterface;
import com.sas.storage.olap.sasmdx.OLAPDataSet;
import com.sas.storage.valueprovider.ValueProviderInterface;
import com.sas.util.UserInfoInterface;
import com.sas.util.ValidateArg;
import com.sas.util.log.CommonLoggerInterface;
import com.sas.util.log.LoggerFactoryInterface;
import com.sas.util.log.LoggerRepository2;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;

public class IQUeryUtil {
    private static Map mapMetaDataCache = null;
    private static CommonLoggerInterface log = null;
    private static final int GET_VALUES_NAME_COL = 0;
    private static final int GET_VALUES_VALUE_COL = 2;
    private static final int GET_VALUES_NULL_COL = 3;
    private static final String GET_VALUES_NULL_FALSE = "0";

    private IQUeryUtil() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static OLAPDataSetInterface getLegendMembers(DataItem dataItem) throws MetadataException, ExecutionException, DataRetrievalException, OLAPException {
        OLAPDataSetInterface olapDataSet = null;
        DataSelection dataSelection = null;
        try {
            BusinessModel businessModel = dataItem.getBusinessModel();
            dataSelection = DataSelectionFactory.newDataSelection((BusinessModel)businessModel);
            DataItemReference dataItemRef = dataSelection.newDataItemReference(dataItem);
            dataItemRef.setSteps(dataItem.getSteps());
            if (IQUeryUtil.isTimeDimension(businessModel, dataItem)) {
                if (dataItemRef.isActionSupported(DataItemActionType.SORT_ASCENDING)) {
                    dataItemRef.setSortDirection(DataItemActionType.SORT_ASCENDING);
                }
            } else if (dataItemRef.isActionSupported(DataItemActionType.SORT_NONE)) {
                dataItemRef.setSortDirection(DataItemActionType.SORT_NONE);
            }
            dataSelection.addResultItem((DataItem)dataItemRef, Role.COLUMN);
            dataSelection.addBusinessItem((BusinessItem)dataItemRef);
            ArrayList<DataSelection> selectionList = new ArrayList<DataSelection>();
            selectionList.add(dataSelection);
            QueryConnector connector = new QueryConnector();
            Map results = connector.retrieveQueryResultMap(selectionList);
            ResultSetInterface iqResultSet = (ResultSetInterface)results.get(dataSelection.getID());
            olapDataSet = (OLAPDataSetInterface)iqResultSet.getResultSet();
        }
        finally {
            if (dataSelection != null) {
                dataSelection.dispose();
            }
        }
        return olapDataSet;
    }

    public static boolean isTimeDimension(BusinessModel businessModel, DataItem dataItem) throws OLAPException {
        return BusinessQueryToOLAPDataSetAdapter.isTimeDimension(businessModel, dataItem);
    }

    public static int getDimensionType(BusinessModel businessModel, DataItem dataItem) throws OLAPException {
        return BusinessQueryToOLAPDataSetAdapter.getDimensionType(businessModel, dataItem);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static LevelInterface[] getLevels(DataItem dataItem) {
        LevelInterface[] levels = null;
        com.sas.storage.olap.MetadataInterface metadata = null;
        if (dataItem != null) {
            try {
                BusinessModel businessModel = dataItem.getBusinessModel();
                List sources = businessModel.getObjects(1, DataSourceCube.class);
                if (!sources.isEmpty()) {
                    DataSourceCube dataSource = (DataSourceCube)sources.get(0);
                    String cubeName = dataSource.getCube().getCubeName();
                    metadata = BusinessQueryOLAPUtil.getMetadataInterface((Object)businessModel);
                    if (metadata != null) {
                        String hierarchyName = BusinessQueryOLAPUtil.getHierarchyName((BusinessModel)businessModel, (DataItem)dataItem);
                        Filter filter = new Filter();
                        filter.setCubeName(cubeName);
                        filter.setUniqueHierarchyName(hierarchyName);
                        try {
                            levels = metadata.getLevels(filter);
                        }
                        catch (OLAPException oLAPException) {
                            // empty catch block
                        }
                    }
                }
            }
            catch (MetadataException metadataException) {
            }
            catch (IQueryServicesException iQueryServicesException) {
            }
            finally {
                if (metadata != null) {
                    BusinessQueryOLAPUtil.releaseMetadataInterface(metadata);
                }
            }
        }
        return levels;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static InformationMapMetaData getInfoMapMetaData(String entityKey, long modifyTime, RepositoryInterface repos) {
        if (entityKey == null) {
            return null;
        }
        InformationMapMetaData metaData = null;
        String cacheKey = entityKey + modifyTime;
        try {
            Map map = mapMetaDataCache;
            synchronized (map) {
                metaData = (InformationMapMetaData)mapMetaDataCache.get(cacheKey);
                if (metaData != null) {
                    return metaData;
                }
                if (repos == null) {
                    return null;
                }
                MetadataInterface reposItem = repos.fetch(entityKey);
                if (!(reposItem instanceof BriefInformationMap)) {
                    return null;
                }
                StructureOfData structure = ((BriefInformationMap)reposItem).getStructure();
                if (structure == null) {
                    return null;
                }
                metaData = new InformationMapMetaData();
                metaData.setOLAP(structure.isOLAP());
                metaData.setRelational(structure.isRelational());
                mapMetaDataCache.put(cacheKey, metaData);
                IQUeryUtil.enforceCacheMaxSize(mapMetaDataCache, 500, 100);
            }
        }
        catch (ServiceException se) {
            IQUeryUtil.getLog().error(se.getMessage(), (Throwable)se);
        }
        catch (RemoteException re) {
            IQUeryUtil.getLog().error(re.getMessage(), (Throwable)re);
        }
        return metaData;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static InformationMapMetaData getInfoMapMetaData(String entityKey, long modifyTime, ServerInterface server) {
        if (entityKey == null) {
            return null;
        }
        InformationMapMetaData metaData = null;
        String cacheKey = entityKey + modifyTime;
        try {
            Map map = mapMetaDataCache;
            synchronized (map) {
                metaData = (InformationMapMetaData)mapMetaDataCache.get(cacheKey);
                if (metaData != null) {
                    return metaData;
                }
                if (server == null) {
                    return null;
                }
                MetadataInterface reposItem = server.fetch(entityKey);
                if (!(reposItem instanceof BriefInformationMap)) {
                    return null;
                }
                StructureOfData structure = ((BriefInformationMap)reposItem).getStructure();
                if (structure == null) {
                    return null;
                }
                metaData = new InformationMapMetaData();
                metaData.setOLAP(structure.isOLAP());
                metaData.setRelational(structure.isRelational());
                mapMetaDataCache.put(cacheKey, metaData);
                IQUeryUtil.enforceCacheMaxSize(mapMetaDataCache, 500, 100);
            }
        }
        catch (ServiceException se) {
            IQUeryUtil.getLog().error(se.getMessage(), (Throwable)se);
        }
        catch (RemoteException re) {
            IQUeryUtil.getLog().error(re.getMessage(), (Throwable)re);
        }
        return metaData;
    }

    private static void enforceCacheMaxSize(Map cache, int max, int numToRemove) {
        int size = cache.size();
        if (size < max) {
            return;
        }
        int count = 0;
        Iterator iterator = mapMetaDataCache.keySet().iterator();
        while (iterator.hasNext()) {
            iterator.next();
            iterator.remove();
            if (++count < numToRemove) continue;
            break;
        }
    }

    private static CommonLoggerInterface getLog() {
        if (log == null) {
            log = LoggerRepository2.getLogger((String)IQUeryUtil.class.getName(), null);
        }
        return log;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getFirstLastMemberUniqueNameViaMDX(boolean isFirstWanted, String cubeName, String uniqueLevelName, Object connection) {
        String firstLastMemberUniqueName = null;
        StringBuffer query = null;
        if (cubeName != null && !cubeName.trim().equals("") && uniqueLevelName != null && !uniqueLevelName.trim().equals("") && connection != null) {
            query = new StringBuffer("SELECT ");
            if (isFirstWanted) {
                query.append("OPENINGPERIOD(");
            } else {
                query.append("CLOSINGPERIOD(");
            }
            query.append(uniqueLevelName).append(") ON COLUMNS FROM ").append("[").append(cubeName).append("]");
        }
        OLAPDataSet olapDataSet = null;
        try {
            TupleElementInterface[] tupleElements;
            olapDataSet = new OLAPDataSet(connection, query.toString());
            AxisInterface columnAxis = olapDataSet.getResultSetMetadata().getAxes(0, 1)[0];
            TupleInterface[] tempTuples = columnAxis.getTuples(0, -1);
            if (tempTuples.length > 0 && (tupleElements = tempTuples[0].getElements(0, -1)).length > 0) {
                firstLastMemberUniqueName = tupleElements[0].getName();
            }
        }
        catch (OLAPException e) {
            IQUeryUtil.getLog().error(e.getMessage(), (Throwable)e);
        }
        finally {
            if (olapDataSet != null) {
                try {
                    olapDataSet.close();
                }
                catch (OLAPException e) {
                    IQUeryUtil.getLog().error(e.getMessage(), (Throwable)e);
                }
            }
        }
        return firstLastMemberUniqueName;
    }

    public static final String[][] getIdentityDrivenPropertyNames(OMIRepositoryInterface repository) throws ServiceException, RemoteException {
        return repository.getAuthorizations("getIdentityDrivenPropertyNames", "", "", "");
    }

    public static final Map getIdentityDrivenPropertyValues(OMIRepositoryInterface repository, LoggerFactoryInterface factory) throws ServiceException, RemoteException {
        ValidateArg.notNull((Object)repository, (String)"repository");
        CommonLoggerInterface logger = LoggerRepository2.getLogger((String)IQUeryUtil.class.getName(), (LoggerFactoryInterface)factory);
        String[][] namesInfo = IQUeryUtil.getIdentityDrivenPropertyNames(repository);
        String commaDelimitedNames = "";
        for (int propRow = 0; propRow < namesInfo.length; ++propRow) {
            if (commaDelimitedNames.length() > 0) {
                commaDelimitedNames = commaDelimitedNames + ",";
            }
            commaDelimitedNames = commaDelimitedNames + namesInfo[propRow][0];
            commaDelimitedNames = commaDelimitedNames.trim();
        }
        logger.debug("getIdentityDrivenPropertyValues() The comma-delimited names are:");
        logger.debug(commaDelimitedNames);
        Map propsMap = IQUeryUtil.getValues(repository, commaDelimitedNames);
        logger.debug("Authorizations returned from metadata:", Integer.toString(propsMap.size()));
        return propsMap;
    }

    public static final String getIdentityDrivenPropertyValue(OMIRepositoryInterface repository, LoggerFactoryInterface factory, String name) throws ServiceException, RemoteException {
        ValidateArg.notNull((Object)repository, (String)"repository");
        CommonLoggerInterface logger = LoggerRepository2.getLogger((String)IQUeryUtil.class.getName(), (LoggerFactoryInterface)factory);
        logger.debug("getIdentityDrivenPropertyValue()- name is:", name);
        Map propsMap = IQUeryUtil.getValues(repository, name);
        if (propsMap.containsKey(name)) {
            logger.debug("Found a value for the name, although it might be null.");
        }
        return (String)propsMap.get(name);
    }

    private static Map getValues(OMIRepositoryInterface repository, String names) throws ServiceException, RemoteException {
        String[][] valuesInfo = repository.getAuthorizations("getIdentityDrivenPropertyValues", "", names, "");
        HashMap<String, String> propsMap = new HashMap<String, String>();
        for (int propRow = 0; propRow < valuesInfo.length; ++propRow) {
            String iddPropVal = "";
            if (valuesInfo[propRow][3].equalsIgnoreCase(GET_VALUES_NULL_FALSE)) {
                iddPropVal = valuesInfo[propRow][2];
            }
            propsMap.put(valuesInfo[propRow][0], iddPropVal);
        }
        return propsMap;
    }

    public static List getIdentityDrivenPrompts(OMIRepositoryInterface repository, LoggerFactoryInterface factory) throws ServiceException, RemoteException {
        String[][] outInfo = IQUeryUtil.getIdentityDrivenPropertyNames(repository);
        ArrayList<TextDefinition> list = new ArrayList<TextDefinition>();
        CommonLoggerInterface logger = LoggerRepository2.getLogger((String)IQUeryUtil.class.getName(), (LoggerFactoryInterface)factory);
        logger.debug("getIdentityDrivenPrompts() for list of size:", Integer.toString(outInfo.length));
        for (int propRow = 0; propRow < outInfo.length; ++propRow) {
            String name = outInfo[propRow][0];
            logger.debug("create identity prompt for name:", name);
            TextDefinition def = new TextDefinition();
            def.setPromptLabel(name, Locale.getDefault());
            def.setPromptName(name);
            def.setPromptDescription(outInfo[propRow][1], Locale.getDefault());
            def.setFixed(true);
            def.setHidden(true);
            def.addUserInfo("IDENTITYDRIVEN", " ");
            IQIdentityValueProvider vp = new IQIdentityValueProvider();
            vp.initialize(repository, name);
            def.setValueProvider((ValueProviderInterface)vp);
            list.add(def);
        }
        return list;
    }

    public static final String[][] getIdentityDrivenPropertyNames(MetadataServerInterface server) throws ServiceException, RemoteException {
        return server.getAuthorizations("getIdentityDrivenPropertyNames", "", "", "");
    }

    public static final Map getIdentityDrivenPropertyValues(MetadataServerInterface server, LoggerFactoryInterface factory) throws ServiceException, RemoteException {
        ValidateArg.notNull((Object)server, (String)"server");
        CommonLoggerInterface logger = LoggerRepository2.getLogger((String)IQUeryUtil.class.getName(), (LoggerFactoryInterface)factory);
        String[][] namesInfo = IQUeryUtil.getIdentityDrivenPropertyNames(server);
        String commaDelimitedNames = "";
        for (int propRow = 0; propRow < namesInfo.length; ++propRow) {
            if (commaDelimitedNames.length() > 0) {
                commaDelimitedNames = commaDelimitedNames + ",";
            }
            commaDelimitedNames = commaDelimitedNames + namesInfo[propRow][0];
            commaDelimitedNames = commaDelimitedNames.trim();
        }
        logger.debug("getIdentityDrivenPropertyValues() The comma-delimited names are:");
        logger.debug(commaDelimitedNames);
        Map propsMap = IQUeryUtil.getValues(server, commaDelimitedNames);
        logger.debug("Authorizations returned from metadata:", Integer.toString(propsMap.size()));
        return propsMap;
    }

    public static final String getIdentityDrivenPropertyValue(MetadataServerInterface server, LoggerFactoryInterface factory, String name) throws ServiceException, RemoteException {
        ValidateArg.notNull((Object)server, (String)"server");
        CommonLoggerInterface logger = LoggerRepository2.getLogger((String)IQUeryUtil.class.getName(), (LoggerFactoryInterface)factory);
        logger.debug("getIdentityDrivenPropertyValue()- name is:", name);
        Map propsMap = IQUeryUtil.getValues(server, name);
        String value = (String)propsMap.get(name);
        if (logger.isDebugEnabled() && null != value) {
            logger.debug("Found a non-null value for the name.");
        }
        return value;
    }

    public static final List getIdentityGroups(MetadataServerInterface server, LoggerFactoryInterface factory) throws ServiceException, RemoteException {
        ValidateArg.notNull((Object)server, (String)"server");
        CommonLoggerInterface logger = LoggerRepository2.getLogger((String)IQUeryUtil.class.getName(), (LoggerFactoryInterface)factory);
        String[][] valuesInfo = server.getAuthorizations("getIdentityDrivenPropertyValues", "", "SAS.IdentityGroups", "");
        ArrayList<String> list = new ArrayList<String>();
        for (int propRow = 0; propRow < valuesInfo.length; ++propRow) {
            String iddPropVal = null;
            if (valuesInfo[propRow][3].equalsIgnoreCase(GET_VALUES_NULL_FALSE)) {
                iddPropVal = valuesInfo[propRow][2];
            }
            list.add(iddPropVal);
        }
        if (logger.isDebugEnabled()) {
            logger.debug("getIdentityGroups() returning a list sized:", Integer.toString(list.size()));
        }
        return list;
    }

    private static Map getValues(MetadataServerInterface server, String names) throws ServiceException, RemoteException {
        String[][] valuesInfo = server.getAuthorizations("getIdentityDrivenPropertyValues", "", names, "");
        HashMap<String, String> propsMap = new HashMap<String, String>();
        for (int propRow = 0; propRow < valuesInfo.length; ++propRow) {
            String iddPropVal = "";
            if (valuesInfo[propRow][3].equalsIgnoreCase(GET_VALUES_NULL_FALSE)) {
                iddPropVal = valuesInfo[propRow][2];
            }
            propsMap.put(valuesInfo[propRow][0], iddPropVal);
        }
        return propsMap;
    }

    public static List getIdentityDrivenPrompts(MetadataServerInterface server, LoggerFactoryInterface factory) throws ServiceException, RemoteException {
        String[][] outInfo = IQUeryUtil.getIdentityDrivenPropertyNames(server);
        ArrayList<TextDefinition> list = new ArrayList<TextDefinition>();
        CommonLoggerInterface logger = LoggerRepository2.getLogger((String)IQUeryUtil.class.getName(), (LoggerFactoryInterface)factory);
        logger.debug("getIdentityDrivenPrompts() for list of size:", Integer.toString(outInfo.length));
        for (int propRow = 0; propRow < outInfo.length; ++propRow) {
            String name = outInfo[propRow][0];
            logger.debug("create identity prompt for name:", name);
            TextDefinition def = new TextDefinition();
            def.setPromptLabel(name, Locale.getDefault());
            def.setPromptName(name);
            def.setPromptDescription(outInfo[propRow][1], Locale.getDefault());
            def.setFixed(true);
            def.setHidden(true);
            def.addUserInfo("IDENTITYDRIVEN", " ");
            IQIdentityValueProvider vp = new IQIdentityValueProvider();
            HashMap<String, Object> options = new HashMap<String, Object>();
            options.put("SERVER", server);
            options.put("NAME", name);
            vp.initialize(options);
            def.setValueProvider((ValueProviderInterface)vp);
            if ("SAS.IdentityGroups".equals(name)) {
                def.setMaximumValueCount(Integer.MAX_VALUE);
            }
            list.add(def);
        }
        return list;
    }

    public static boolean isSystemIdentityPrompt(Prompt prompt) {
        UserInfoInterface userInfo;
        boolean isSystemIdentityPrompt = false;
        if (prompt != null && prompt.getPromptDefinition() != null && (userInfo = prompt.getPromptDefinition().getUserInfo()) != null && userInfo.contains("IDENTITYDRIVEN")) {
            isSystemIdentityPrompt = true;
        }
        return isSystemIdentityPrompt;
    }

    static {
        mapMetaDataCache = Collections.synchronizedMap(new LinkedHashMap(1000, 0.75f, true));
    }
}

