/*
 * Decompiled with CFR 0.152.
 */
package com.sas.storage.iquery;

import com.sas.beans.ExtendedBeanInfo;
import com.sas.iquery.execution2.ResultSetInterface;
import com.sas.iquery.metadata.MetadataException;
import com.sas.iquery.metadata.business.BusinessItem;
import com.sas.iquery.metadata.business.BusinessModel;
import com.sas.iquery.metadata.business.BusinessQuery;
import com.sas.iquery.metadata.business.DataItem;
import com.sas.iquery.metadata.business.DataItemReference;
import com.sas.iquery.metadata.business.DataSelection;
import com.sas.iquery.metadata.business.DataSelectionFactory;
import com.sas.iquery.metadata.business.FilterItem;
import com.sas.iquery.metadata.business.Role;
import com.sas.iquery.metadata.expr.ComparisonOperator;
import com.sas.iquery.metadata.expr.CompoundConditionalExpression;
import com.sas.iquery.metadata.expr.ConditionalRelationType;
import com.sas.iquery.metadata.expr.ConstantExpression;
import com.sas.iquery.metadata.expr.ExpressionInterface;
import com.sas.iquery.metadata.expr.relational.SimpleConditionalExpression_Comparison;
import com.sas.storage.iquery.BusinessQueryAdapter;
import com.sas.storage.iquery.RB;
import com.sas.storage.jdbc.JDBCAdapter;
import com.sas.storage.jdbc.JDBCToTreeModelAdapter;
import com.sas.swing.models.IndexedMutableTreeNode;
import com.sas.util.Util;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.EventListener;
import java.util.EventObject;
import java.util.List;
import java.util.Map;
import javax.swing.event.EventListenerList;
import javax.swing.event.TreeModelEvent;
import javax.swing.event.TreeModelListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;

public class BusinessQueryToTreeModelAdapter
extends BusinessQueryAdapter
implements TreeModel,
TreeModelListener {
    public static final String RB_KEY = "BusinessQueryToTreeModelAdapter.";
    protected EventListenerList listenerList = new EventListenerList();
    protected JDBCToTreeModelAdapter delegateAdapter;
    protected int initialLevelsRead = 1;
    protected FilterItem filter;
    protected DataItem indexDataItem;
    protected DataItem levelDataItem;
    protected DataItem textDataItem;
    protected BusinessQuery businessQueryOriginal;

    public BusinessQueryToTreeModelAdapter() {
        this(null);
    }

    public BusinessQueryToTreeModelAdapter(BusinessQuery businessQueryModel) {
        super(businessQueryModel);
    }

    @Override
    protected void init() {
        if (this.initialized) {
            return;
        }
        if (this.businessQueryModel == null) {
            throw new IllegalStateException(RB.getStringResource("BusinessQueryAdapter.", "modelNull.ex.txt"));
        }
        if (this.levelDataItem == null || this.indexDataItem == null) {
            throw new IllegalStateException(RB.getStringResource(RB_KEY, "dataItemsNotSet.ex.txt"));
        }
        if (this.initialLevelsRead > 0) {
            this.businessQueryOriginal = this.businessQueryModel;
            try {
                this.businessQueryModel = DataSelectionFactory.newDataSelection((BusinessModel)this.businessQueryOriginal.getBusinessModel());
                List resultItems = this.businessQueryOriginal.getResultItems();
                int size = resultItems.size();
                for (int i = 0; i < size; ++i) {
                    BusinessItem di = (BusinessItem)resultItems.get(i);
                    if (!(di instanceof DataItem)) continue;
                    DataItemReference dataItemRef = this.businessQueryModel.getBusinessModel().newDataItemReference((DataItem)di);
                    this.businessQueryModel.getBusinessModel().addBusinessItem((BusinessItem)dataItemRef);
                    this.businessQueryModel.addResultItem((DataItem)dataItemRef, Role.COLUMN);
                }
                BusinessModel map = this.businessQueryOriginal.getBusinessModel();
                this.filter = this.businessQueryModel.getBusinessModel().newFilterItem();
                this.businessQueryModel.getBusinessModel().addBusinessItem((BusinessItem)this.filter);
                List filters = this.businessQueryOriginal.getFilters();
                filters.add(this.filter);
                this.businessQueryModel.setFilters(filters);
                SimpleConditionalExpression_Comparison expression = this.createConditionalExpression((ExpressionInterface)this.getLevelDataItem(), ComparisonOperator.COMPARE_LE, this.initialLevelsRead);
                this.filter.setExpression((ExpressionInterface)expression);
            }
            catch (MetadataException e) {
                IllegalStateException ise = new IllegalStateException(e.getMessage());
                ise.initCause(e);
                throw ise;
            }
        }
        super.init();
    }

    @Override
    protected JDBCAdapter createDelegateAdapter(ResultSet resultSet) {
        block6: {
            if (this.delegateAdapter != null) {
                this.delegateAdapter.removeTreeModelListener((TreeModelListener)this);
            }
            try {
                this.delegateAdapter = new JDBCToTreeModelAdapter(resultSet);
                this.delegateAdapter.addTreeModelListener((TreeModelListener)this);
                this.delegateAdapter.setInitialLevelsRead(this.initialLevelsRead);
                ResultSetMetaData metadata = resultSet.getMetaData();
                List resultList = this.businessQueryOriginal != null ? this.businessQueryOriginal.getResultItems() : this.businessQueryModel.getResultItems();
                int index = resultList.indexOf(this.levelDataItem);
                if (index == -1) {
                    throw new IllegalStateException(RB.getStringResource(RB_KEY, "invalidLevelDataItem.ex.txt"));
                }
                this.delegateAdapter.setLevelColumnName(metadata.getColumnName(index + 1));
                index = resultList.indexOf(this.indexDataItem);
                if (index == -1) {
                    throw new IllegalStateException(RB.getStringResource(RB_KEY, "invalidIndexDataItem.ex.txt"));
                }
                this.delegateAdapter.setIndexColumnName(metadata.getColumnName(index + 1));
                if (this.textDataItem == null) break block6;
                index = resultList.indexOf(this.textDataItem);
                if (index != -1) {
                    this.delegateAdapter.setTextColumnName(metadata.getColumnName(index + 1));
                    break block6;
                }
                throw new IllegalStateException(RB.getStringResource(RB_KEY, "invalidTextDataItem.ex.txt"));
            }
            catch (SQLException sqle) {
                IllegalStateException ise = new IllegalStateException(sqle.getMessage());
                ise.initCause(sqle);
                throw ise;
            }
        }
        return this.delegateAdapter;
    }

    @Override
    public BusinessQuery getModel() {
        if (this.businessQueryOriginal != null) {
            return this.businessQueryOriginal;
        }
        return this.businessQueryModel;
    }

    @Override
    public void addTreeModelListener(TreeModelListener l) {
        this.listenerList.add(TreeModelListener.class, l);
    }

    @Override
    public void removeTreeModelListener(TreeModelListener l) {
        this.listenerList.remove(TreeModelListener.class, l);
    }

    public int getInitialLevelsRead() {
        return this.initialLevelsRead;
    }

    public void setInitialLevelsRead(int initialLevelsRead) {
        int oldInitialLevelsRead = this.getInitialLevelsRead();
        if (oldInitialLevelsRead != initialLevelsRead) {
            this.initialLevelsRead = initialLevelsRead;
            this.initialized = false;
            this.spcs.firePropertyChange("initialLevelsRead", oldInitialLevelsRead, initialLevelsRead);
        }
    }

    public DataItem getLevelDataItem() {
        return this.levelDataItem;
    }

    public void setLevelDataItem(DataItem levelDataItem) {
        DataItem oldLevelDataItem = this.getLevelDataItem();
        if (Util.unequal((Object)oldLevelDataItem, (Object)levelDataItem)) {
            this.levelDataItem = levelDataItem;
            this.initialized = false;
            this.spcs.firePropertyChange("levelDataItem", oldLevelDataItem, levelDataItem);
        }
    }

    public DataItem getIndexDataItem() {
        return this.indexDataItem;
    }

    public void setIndexDataItem(DataItem indexDataItem) {
        DataItem oldIndexDataItem = this.getIndexDataItem();
        if (Util.unequal((Object)oldIndexDataItem, (Object)indexDataItem)) {
            this.indexDataItem = indexDataItem;
            this.initialized = false;
            this.spcs.firePropertyChange("indexDataItem", oldIndexDataItem, indexDataItem);
        }
    }

    public DataItem getTextDataItem() {
        return this.textDataItem;
    }

    public void setTextDataItem(DataItem textDataItem) {
        DataItem oldTextDataItem = this.getTextDataItem();
        if (Util.unequal((Object)oldTextDataItem, (Object)textDataItem)) {
            this.textDataItem = textDataItem;
            this.initialized = false;
            this.spcs.firePropertyChange("textDataItem", oldTextDataItem, textDataItem);
        }
    }

    @Override
    public Object getChild(Object parent, int index) {
        if (this.designTime) {
            return null;
        }
        this.init();
        this.addChildren(parent);
        return this.delegateAdapter.getChild(parent, index);
    }

    @Override
    public boolean isLeaf(Object node) {
        BusinessQuery model = this.getModel();
        if (model != null) {
            int size = model.getResultItems().size();
            if (!this.designTime && size > 0) {
                this.init();
                this.addChildren(node);
                return this.delegateAdapter.isLeaf(node);
            }
        }
        return true;
    }

    @Override
    public int getChildCount(Object parent) {
        BusinessQuery model = this.getModel();
        if (model != null) {
            int size = model.getResultItems().size();
            if (!this.designTime && size > 0) {
                this.init();
                this.addChildren(parent);
                return this.delegateAdapter.getChildCount(parent);
            }
        }
        return 0;
    }

    @Override
    public void valueForPathChanged(TreePath path, Object newValue) {
        this.init();
        this.delegateAdapter.valueForPathChanged(path, newValue);
    }

    @Override
    public int getIndexOfChild(Object parent, Object child) {
        this.init();
        this.addChildren(parent);
        return this.delegateAdapter.getIndexOfChild(parent, child);
    }

    @Override
    public Object getRoot() {
        BusinessQuery model = this.getModel();
        if (model != null) {
            int size = model.getResultItems().size();
            if (!this.designTime && size > 0) {
                this.init();
                return this.delegateAdapter.getRoot();
            }
        }
        return new DefaultMutableTreeNode(null, false);
    }

    protected void addChildren(Object parentNode) {
        if (this.initialLevelsRead > 0 && parentNode instanceof IndexedMutableTreeNode && !((IndexedMutableTreeNode)parentNode).isChildrenRead()) {
            try {
                if (((IndexedMutableTreeNode)parentNode).getNextRelativeIndex() == ((IndexedMutableTreeNode)parentNode).getIndex() + 1) {
                    ((IndexedMutableTreeNode)parentNode).setChildrenRead(true);
                    return;
                }
                int level = ((IndexedMutableTreeNode)parentNode).getLevel() + 1;
                int index = ((IndexedMutableTreeNode)parentNode).getIndex();
                SimpleConditionalExpression_Comparison levelCondition = this.createConditionalExpression((ExpressionInterface)this.getLevelDataItem(), ComparisonOperator.COMPARE_EQ, level + 1);
                SimpleConditionalExpression_Comparison greaterIndexCondition = this.createConditionalExpression((ExpressionInterface)this.getIndexDataItem(), ComparisonOperator.COMPARE_GT, index);
                CompoundConditionalExpression compoundCondition1 = new CompoundConditionalExpression();
                compoundCondition1.setLeftExpression((ExpressionInterface)levelCondition);
                compoundCondition1.setRelationType(ConditionalRelationType.AND);
                compoundCondition1.setRightExpression((ExpressionInterface)greaterIndexCondition);
                int parentsNextRelativeIndex = ((IndexedMutableTreeNode)parentNode).getNextRelativeIndex();
                if (parentsNextRelativeIndex != 0) {
                    SimpleConditionalExpression_Comparison indexCondition = this.createConditionalExpression((ExpressionInterface)this.getIndexDataItem(), ComparisonOperator.COMPARE_LT, parentsNextRelativeIndex);
                    CompoundConditionalExpression compoundCondition2 = new CompoundConditionalExpression();
                    compoundCondition2.setLeftExpression((ExpressionInterface)compoundCondition1);
                    compoundCondition2.setRelationType(ConditionalRelationType.AND);
                    compoundCondition2.setRightExpression((ExpressionInterface)indexCondition);
                    this.filter.setExpression((ExpressionInterface)compoundCondition2);
                } else {
                    this.filter.setExpression((ExpressionInterface)compoundCondition1);
                }
                ArrayList<BusinessQuery> selectionList = new ArrayList<BusinessQuery>();
                selectionList.add(this.businessQueryModel);
                Map results = this.connector.retrieveQueryResultMap(selectionList);
                ResultSetInterface iqResultSet = (ResultSetInterface)results.get(this.businessQueryModel.getID());
                Object obj = iqResultSet.getResultSet();
                ResultSet resultSet = (ResultSet)iqResultSet.getResultSet();
                this.delegateAdapter.addChildren(parentNode, resultSet);
            }
            catch (Exception e) {
                IllegalStateException ise = new IllegalStateException(e.getMessage());
                ise.initCause(e);
                throw ise;
            }
        }
    }

    protected SimpleConditionalExpression_Comparison createConditionalExpression(ExpressionInterface leftExpression, ComparisonOperator operator, int constantValue) {
        SimpleConditionalExpression_Comparison expression = new SimpleConditionalExpression_Comparison();
        expression.setLeftExpression(leftExpression);
        expression.setComparisonOperator(operator);
        ConstantExpression constantExpression = new ConstantExpression();
        constantExpression.setExpressionType(2);
        constantExpression.setValue(Integer.toString(constantValue));
        expression.setRightExpression((ExpressionInterface)constantExpression);
        return expression;
    }

    public static ExtendedBeanInfo getExtendedBeanInfo() {
        String[][][] propertyMetadata = new String[][][]{{{"Name", "model"}, {"Property editor class", "com.sas.beans.editors._InstanceEditor"}}, {{"Name", "resultSetRequeryUsed"}, {"Expert", "true"}}, {{"Name", "root"}, {"Expert", "true"}}};
        ExtendedBeanInfo ebi = new ExtendedBeanInfo();
        ebi.propertyMetadata = propertyMetadata;
        return ebi;
    }

    public void fireModelEvent(EventObject event) {
        if (event instanceof TreeModelEvent) {
            EventListener[] listeners = this.listenerList.getListeners(TreeModelListener.class);
            int n = listeners.length;
            for (int i = 0; i < n; ++i) {
                ((TreeModelListener)listeners[i]).treeStructureChanged((TreeModelEvent)event);
            }
        }
    }

    @Override
    public void treeStructureChanged(TreeModelEvent e) {
        TreeModelEvent event = new TreeModelEvent((Object)this, e.getPath());
        this.fireModelEvent(event);
    }

    @Override
    public void treeNodesChanged(TreeModelEvent e) {
        this.treeStructureChanged(e);
    }

    @Override
    public void treeNodesInserted(TreeModelEvent e) {
        this.treeStructureChanged(e);
    }

    @Override
    public void treeNodesRemoved(TreeModelEvent e) {
        this.treeStructureChanged(e);
    }

    @Override
    public void fireModelEvent() {
        if (this.designTime) {
            return;
        }
        if (this.delegateAdapter != null && this.delegateAdapter.getIndexColumnName() != null && this.delegateAdapter.getLevelColumnName() != null && this.delegateAdapter.getTextColumnName() != null) {
            this.fireModelEvent(new TreeModelEvent((Object)this, new Object[]{this.delegateAdapter.getRoot()}));
        }
    }

    protected void finalize() throws Throwable {
        try {
            BusinessModel parentModel;
            if (this.businessQueryOriginal != null && this.businessQueryModel != null && (parentModel = ((DataSelection)this.businessQueryModel).getParentBusinessModel()) != null) {
                parentModel.removeChild((BusinessModel)((DataSelection)this.businessQueryModel));
            }
        }
        finally {
            super.finalize();
        }
    }
}

