/*
 * Decompiled with CFR 0.152.
 */
package com.sas.storage.iquery;

import com.sas.MissingValues;
import com.sas.beans.ExtendedBeanInfo;
import com.sas.iquery.dataretrieval.OfflineResultSetConfiguration;
import com.sas.iquery.dataretrieval.QueryConnectorInterface;
import com.sas.iquery.dataretrieval.RetrievalPolicy;
import com.sas.iquery.intelligentquery.IntelligentQueryException;
import com.sas.iquery.intelligentquery.QueryConnectionInterface;
import com.sas.iquery.metadata.MetadataException;
import com.sas.iquery.metadata.business.BusinessModel;
import com.sas.iquery.metadata.business.BusinessQuery;
import com.sas.iquery.metadata.business.BusinessQueryActionType;
import com.sas.iquery.metadata.business.DataItem;
import com.sas.iquery.metadata.business.DataItemActionType;
import com.sas.iquery.metadata.business.Role;
import com.sas.iquery.metadata.business.SelectedItem;
import com.sas.iquery.metadata.business.StructureOfDataItem;
import com.sas.storage.iquery.BusinessQueryAdapter;
import com.sas.storage.iquery.BusinessQueryAdapterUtil;
import com.sas.storage.iquery.RB;
import com.sas.storage.jdbc.JDBCAdapter;
import com.sas.storage.jdbc.JDBCToTableModelAdapter;
import com.sas.storage.jdbc.RawSASNumericValueProvider;
import com.sas.swing.event.SwingTableModelEvent;
import com.sas.swing.visuals.tableview.TableColumnUniqueIDInterface;
import com.sas.table.ColumnAlignmentInterface;
import com.sas.table.FormattedInterface;
import com.sas.table.MoveColumnInterface;
import com.sas.table.SortException;
import com.sas.table.SortableInterface;
import com.sas.table.StaticColumnInfoInterface;
import com.sas.table.TableException;
import com.sas.table.TrueRowCountCalculatedInterface;
import com.sas.util.Util;
import com.sas.util.log.LoggerRepository2;
import com.sas.util.transforms.ObjectToStringTransform;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.EventListener;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.swing.event.EventListenerList;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.TableModel;

public class BusinessQueryToTableModelAdapter
extends BusinessQueryAdapter
implements TableModel,
TableModelListener,
TrueRowCountCalculatedInterface,
SortableInterface,
FormattedInterface,
StaticColumnInfoInterface,
MoveColumnInterface,
PropertyChangeListener,
ColumnAlignmentInterface,
TableColumnUniqueIDInterface,
RawSASNumericValueProvider {
    public static final String RB_KEY = "BusinessQueryToTableModelAdapter.";
    protected EventListenerList listenerList = new EventListenerList();
    protected JDBCToTableModelAdapter delegateAdapter;
    protected int rowCount;
    protected String columnInfoUsed;
    protected int readAheadAmount;
    protected boolean trueRowCountCalculated;
    protected boolean sortAllowed;
    protected boolean predefinedSortsReturned;
    protected boolean formattedDataUsed;
    protected Locale formatLocale;
    protected ObjectToStringTransform objectToStringTransform;
    private List labelChangeEventList;
    private boolean useDualResultSets;
    public static final String LABEL = "LABEL";
    private List sortedDataItemList;
    private String[] sortedColumns;
    private int[] sortDirections;
    private boolean ignoreTableModelEvents;
    private boolean storeTableModelEvents;
    private List storedTableEvents;
    private Map modelDataItems;
    private boolean retrievingFormattedDualResultSetData;
    private boolean retrievingUnformattedDualResultSetData;
    public static final boolean DEFAULT_POLICY_ON_USING_DUAL_RESULT_SETS = true;

    public BusinessQueryToTableModelAdapter() {
        this(null);
    }

    public BusinessQueryToTableModelAdapter(BusinessQuery businessQueryModel) {
        this(businessQueryModel, null);
    }

    public BusinessQueryToTableModelAdapter(BusinessQuery businessQueryModel, QueryConnectionInterface queryConnector) {
        super(businessQueryModel, queryConnector);
        this.useDualResultSets = true;
        this.initFields();
        this.setupDualFormatResultSet();
    }

    public BusinessQueryToTableModelAdapter(BusinessQuery businessQueryModel, QueryConnectorInterface queryConnector, RetrievalPolicy retrievalPolicy) {
        this(businessQueryModel, queryConnector, retrievalPolicy, true);
    }

    public BusinessQueryToTableModelAdapter(BusinessQuery businessQueryModel, QueryConnectorInterface queryConnector, RetrievalPolicy retrievalPolicy, boolean useDualResultSets) {
        super(businessQueryModel, queryConnector, retrievalPolicy);
        OfflineResultSetConfiguration offlineConfig;
        this.useDualResultSets = useDualResultSets;
        this.initFields();
        this.setupDualFormatResultSet();
        if (retrievalPolicy != null && (offlineConfig = retrievalPolicy.getOfflineResultSetConfiguration()) != null && offlineConfig.isOfflineResultSetsEnabled()) {
            this.trueRowCountCalculated = false;
            this.readAheadAmount = offlineConfig.getMemoryBlockSize();
        }
    }

    private void setupDualFormatResultSet() {
        if (this.getBusinessQuery() != null && this.useDualResultSets) {
            List resultItems = this.getBusinessQuery().getSelectedItems();
            for (SelectedItem selectedItem : resultItems) {
                DataItem dataItem = selectedItem.getItem();
                if (dataItem == null || dataItem.getStructure() == null || !dataItem.getStructure().equals(StructureOfDataItem.STRUCTURE_COLUMN) || selectedItem.getFormatType() == 1) continue;
                selectedItem.setFormatType(1);
            }
        }
    }

    private void initFields() {
        this.columnInfoUsed = LABEL;
        this.sortedDataItemList = new ArrayList();
        this.modelDataItems = new HashMap();
        this.sortAllowed = true;
        this.sortedColumns = new String[0];
        this.sortDirections = new int[0];
        this.readAheadAmount = 1000;
        this.formattedDataUsed = true;
        this.ignoreTableModelEvents = false;
        this.storeTableModelEvents = false;
        this.storedTableEvents = new ArrayList(2);
        this.labelChangeEventList = new ArrayList();
        this.formatLocale = Locale.getDefault();
        this.objectToStringTransform = ObjectToStringTransform.defaultInstance;
    }

    @Override
    protected JDBCAdapter createDelegateAdapter(ResultSet resulSet) {
        if (this.delegateAdapter != null) {
            this.delegateAdapter.removeTableModelListener((TableModelListener)this);
        }
        this.delegateAdapter = new JDBCToTableModelAdapter(resulSet){

            protected Object retrieveValueAt(int col, ResultSet result) throws SQLException {
                if (BusinessQueryToTableModelAdapter.this.retrievingFormattedDualResultSetData) {
                    String value = result.getString(col);
                    List resultItems = BusinessQueryToTableModelAdapter.this.getVisibleResultItems(BusinessQueryToTableModelAdapter.this.getBusinessQuery());
                    DataItem di = (DataItem)resultItems.get(col - 1);
                    boolean isFormattingForced = di.isFormattingForced();
                    if (result.wasNull() && (!isFormattingForced || value == null)) {
                        int colType = this.meta.getColumnType(col);
                        if (colType == 1 || colType == 12) {
                            return "";
                        }
                        if (value != null) {
                            return value;
                        }
                        return ObjectToStringTransform.defaultInstance.transform((Object)MissingValues.Dot);
                    }
                    if (value != null && this.isTrimUsed()) {
                        return value.trim();
                    }
                    return value;
                }
                if (BusinessQueryToTableModelAdapter.this.retrievingUnformattedDualResultSetData) {
                    Object value = result.getObject(col);
                    if (result.wasNull()) {
                        return MissingValues.Dot;
                    }
                    return value;
                }
                return super.retrieveValueAt(col, result);
            }
        };
        this.delegateAdapter.setReadAheadAmount(this.readAheadAmount);
        this.delegateAdapter.setFormattedDataUsed(this.formattedDataUsed);
        this.delegateAdapter.setColumnInfoUsed(this.columnInfoUsed);
        this.delegateAdapter.setTrueRowCountCalculated(this.trueRowCountCalculated);
        this.delegateAdapter.setFormatLocale(this.formatLocale);
        this.delegateAdapter.addTableModelListener((TableModelListener)this);
        return this.delegateAdapter;
    }

    @Override
    public void setValueAt(Object value, int row, int column) {
        this.init();
        this.delegateAdapter.setValueAt(value, row, column);
    }

    @Override
    public String getColumnName(int index) {
        if (this.designTime) {
            BusinessQuery model = this.getModel();
            String name = null;
            if (model != null) {
                name = ((DataItem)this.getVisibleResultItems(model).get(index)).getLabel();
            }
            return name;
        }
        this.init();
        return this.delegateAdapter.getColumnName(index);
    }

    @Override
    public int getColumnCount() {
        BusinessQuery model = this.getModel();
        if (model != null) {
            int size = this.getVisibleResultItems(model).size();
            if (!this.designTime && size > 0) {
                this.init();
                return this.delegateAdapter.getColumnCount();
            }
        }
        return 0;
    }

    public Class getColumnClass(int col) {
        this.init();
        return this.delegateAdapter.getColumnClass(col);
    }

    public Class getUnformattedColumnClass(int col) {
        this.init();
        return this.delegateAdapter.getUnformattedColumnClass(col);
    }

    public int getColumnAlignment(int columnIndex) {
        int exprType;
        DataItem di = this.getDataItem(columnIndex);
        if (di != null && ((exprType = di.getExpressionTypeIgnoringFormattingForced()) == 4 || exprType == 2 || exprType == 5 || exprType == 6)) {
            return 4;
        }
        return 2;
    }

    @Override
    public int getRowCount() {
        BusinessQuery model = this.getModel();
        if (model != null) {
            int size = this.getVisibleResultItems(model).size();
            if (!this.designTime && size > 0) {
                this.init();
                return this.delegateAdapter.getRowCount();
            }
        }
        return 0;
    }

    @Override
    public Object getValueAt(int row, int col) {
        this.init();
        if (this.isFormattedDataUsed()) {
            return this.getFormattedValueAt(row, col);
        }
        if (this.isDualResultSetsAvailable() || !this.isFormattedDataReturned()) {
            return this.getUnformattedValueAt(row, col);
        }
        return this.delegateAdapter.getValueAt(row, col);
    }

    @Override
    public boolean isCellEditable(int row, int col) {
        this.init();
        return this.delegateAdapter.isCellEditable(row, col);
    }

    public String getColumnInfoUsed() {
        return this.columnInfoUsed;
    }

    public void setColumnInfoUsed(String info) {
        String oldInfo = this.getColumnInfoUsed();
        if (!oldInfo.equalsIgnoreCase(info)) {
            this.columnInfoUsed = info;
            if (this.initialized) {
                this.delegateAdapter.setColumnInfoUsed(info);
                this.fireModelEvent();
            }
            this.spcs.firePropertyChange("columnInfoUsed", oldInfo, info);
        }
    }

    public Object getColumnInfo(int index, String columnInfoName) throws TableException {
        return this.delegateAdapter.getColumnInfo(index, columnInfoName);
    }

    public String[] getColumnInfoNames() throws TableException {
        return this.delegateAdapter.getColumnInfoNames();
    }

    public void setTrueRowCountCalculated(boolean trueRowCountCalculated) {
        boolean oldValue = this.isTrueRowCountCalculated();
        if (oldValue != trueRowCountCalculated) {
            this.trueRowCountCalculated = trueRowCountCalculated;
            if (!this.designTime) {
                this.init();
                this.delegateAdapter.setTrueRowCountCalculated(trueRowCountCalculated);
            }
            this.spcs.firePropertyChange("trueRowCountCalculated", trueRowCountCalculated ? Boolean.FALSE : Boolean.TRUE, trueRowCountCalculated ? Boolean.TRUE : Boolean.FALSE);
        }
    }

    public boolean isTrueRowCountCalculated() {
        return this.trueRowCountCalculated;
    }

    public void setReadAheadAmount(int readAheadAmount) {
        int oldReadAheadAmount = this.getReadAheadAmount();
        if (oldReadAheadAmount != readAheadAmount) {
            if (!this.designTime) {
                this.init();
                this.delegateAdapter.setReadAheadAmount(readAheadAmount);
            }
            this.spcs.firePropertyChange("readAheadAmount", oldReadAheadAmount, readAheadAmount);
        }
    }

    public int getReadAheadAmount() {
        return this.readAheadAmount;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sort(String[] columnNames, int[] direction) throws SortException {
        block14: {
            try {
                int i;
                this.ignoreTableModelEvents = true;
                if (!this.isSortAllowed()) {
                    throw new IllegalStateException(RB.getStringResource(RB_KEY, "sortNotAllowed.ex.txt"));
                }
                if (columnNames.length != direction.length) {
                    throw new SortException();
                }
                for (i = 0; i < direction.length - 1; ++i) {
                    if (direction[i] == 0 || direction[i] == 1) continue;
                    throw new SortException();
                }
                if (columnNames.length > 0) {
                    this.clearSort();
                    this.sortedColumns = new String[columnNames.length];
                    System.arraycopy(columnNames, 0, this.sortedColumns, 0, columnNames.length);
                    this.sortDirections = new int[direction.length];
                    System.arraycopy(direction, 0, this.sortDirections, 0, direction.length);
                    for (i = 0; i < columnNames.length; ++i) {
                        String columnName = columnNames[i];
                        if (columnName == null || columnName.length() <= 0) continue;
                        DataItemActionType sortDirection = direction[i] == 0 ? DataItemActionType.SORT_ASCENDING : DataItemActionType.SORT_DESCENDING;
                        DataItem dataItem = this.getDataItem(columnName);
                        if (dataItem == null) continue;
                        try {
                            dataItem.setSortDirection(sortDirection);
                        }
                        catch (MetadataException metadataException) {
                            // empty catch block
                        }
                        this.sortedDataItemList.add(dataItem);
                    }
                    if (this.sortedDataItemList.isEmpty()) break block14;
                    try {
                        this.businessQueryModel.setSortOrderPrecedence(this.sortedDataItemList);
                    }
                    catch (MetadataException i2) {
                        // empty catch block
                    }
                    int oldRowCount = this.getRowCount();
                    this.initialized = false;
                    this.init();
                    int newRowCount = this.getRowCount();
                    if (newRowCount < oldRowCount) {
                        this.fireModelEvent(new TableModelEvent(this, newRowCount, oldRowCount - 1, -1, -1));
                    }
                    this.fireModelEvent(new TableModelEvent(this, 0, newRowCount - 1));
                    break block14;
                }
                if (!this.sortedDataItemList.isEmpty()) {
                    this.clearSort();
                    this.sortedColumns = new String[0];
                    this.sortDirections = new int[0];
                    this.initialized = false;
                    this.init();
                    this.fireModelEvent(new TableModelEvent(this, 0, this.getRowCount() - 1));
                }
            }
            finally {
                this.ignoreTableModelEvents = false;
            }
        }
    }

    private void initializeSortedColumns() {
        this.sortedDataItemList.clear();
        BusinessQuery model = this.getModel();
        if (model != null) {
            List sortList = model.getEffectiveSortOrderPrecedence();
            int sortSize = sortList.size();
            ArrayList<String> sortedColumnsList = new ArrayList<String>();
            ArrayList<Integer> sortDirectionsList = new ArrayList<Integer>();
            for (int i = 0; i < sortSize; ++i) {
                DataItem di = (DataItem)sortList.get(i);
                DataItemActionType at = di.getSortDirection();
                if (at == DataItemActionType.SORT_ASCENDING) {
                    sortDirectionsList.add(new Integer(0));
                    sortedColumnsList.add(di.getResultSetID());
                    this.sortedDataItemList.add(di);
                    continue;
                }
                if (at != DataItemActionType.SORT_DESCENDING) continue;
                sortDirectionsList.add(new Integer(1));
                sortedColumnsList.add(di.getResultSetID());
                this.sortedDataItemList.add(di);
            }
            int size = sortDirectionsList.size();
            this.sortedColumns = new String[size];
            this.sortDirections = new int[size];
            for (int i = 0; i < size; ++i) {
                this.sortDirections[i] = (Integer)sortDirectionsList.get(i);
                this.sortedColumns[i] = (String)sortedColumnsList.get(i);
            }
        } else {
            this.sortedColumns = new String[0];
            this.sortDirections = new int[0];
        }
    }

    public boolean isColumnSortable(String columnName) {
        DataItem di = this.getDataItem(columnName);
        return this.isSortAllowed() && di != null && di.isActionSupported(DataItemActionType.SORT_ASCENDING) && di.isActionSupported(DataItemActionType.SORT_DESCENDING);
    }

    public boolean isSortAllowed() {
        return this.sortAllowed;
    }

    public void setSortAllowed(boolean sortAllowed) {
        if (this.sortAllowed == sortAllowed) {
            return;
        }
        this.sortAllowed = sortAllowed;
        this.spcs.firePropertyChange("sortAllowed", sortAllowed ? Boolean.FALSE : Boolean.TRUE, sortAllowed ? Boolean.TRUE : Boolean.FALSE);
    }

    public String[] getSortedColumns() {
        if (this.isPredefinedSortsReturned()) {
            this.initializeSortedColumns();
        }
        return this.sortedColumns;
    }

    public int[] getSortedDirections() {
        if (this.isPredefinedSortsReturned()) {
            this.initializeSortedColumns();
        }
        return this.sortDirections;
    }

    private void clearSort() {
        if (!this.sortedDataItemList.isEmpty()) {
            Iterator listIter = this.sortedDataItemList.iterator();
            try {
                while (listIter.hasNext()) {
                    DataItem dataItem = (DataItem)listIter.next();
                    dataItem.setSortDirection(DataItemActionType.SORT_NONE);
                }
                this.businessQueryModel.setSortOrderPrecedence(new ArrayList());
            }
            catch (MetadataException metadataException) {
                // empty catch block
            }
            this.sortedDataItemList.clear();
        }
    }

    public DataItem getDataItem(int columnIndex) {
        try {
            return this.getDataItem((String)this.getColumnInfo(columnIndex + 1, "NAME"));
        }
        catch (TableException e) {
            LoggerRepository2.getLogger((String)this.getClass().getName(), null).error(e.getMessage(), (Throwable)e);
            return null;
        }
    }

    private DataItem getDataItem(String columnName) {
        DataItem dataItem = null;
        dataItem = (DataItem)this.modelDataItems.get(columnName);
        if (dataItem != null) {
            return dataItem;
        }
        BusinessModel businessModel = this.businessQueryModel.getBusinessModel();
        List dataItems = businessModel != null ? businessModel.getObjects(1, DataItem.class) : this.getVisibleResultItems(this.businessQueryModel);
        for (int j = 0; j < dataItems.size(); ++j) {
            DataItem currItem = (DataItem)dataItems.get(j);
            if (currItem == null || !currItem.getResultSetID().equals(columnName)) continue;
            dataItem = currItem;
            break;
        }
        this.modelDataItems.put(columnName, dataItem);
        return dataItem;
    }

    public boolean isAccurateRowCountAvailable() {
        this.init();
        return this.delegateAdapter.isAccurateRowCountAvailable();
    }

    public static ExtendedBeanInfo getExtendedBeanInfo() {
        String[][][] propertyMetadata = new String[][][]{{{"Name", "model"}, {"Property editor class", "com.sas.beans.editors._InstanceEditor"}}, {{"Name", "columnClass"}, {"Hidden", "true"}}, {{"Name", "columnCount"}, {"Expert", "true"}}, {{"Name", "columnName"}, {"Hidden", "true"}}, {{"Name", "rowCount"}, {"Expert", "true"}}};
        ExtendedBeanInfo ebi = new ExtendedBeanInfo();
        ebi.propertyMetadata = propertyMetadata;
        return ebi;
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if (evt.getPropertyName().equals("label changed")) {
            this.labelChangeEventList.add(evt);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void refreshBusinessQuery(BusinessQuery businessQuery) throws IntelligentQueryException {
        BusinessQueryAdapterUtil.cleanRelationalQuery(businessQuery);
        if (!this.initialized) {
            this.setModel(businessQuery);
            this.init();
            this.fireModelEvent();
            return;
        }
        int colCount = this.getColumnCount();
        int rowCount = this.getRowCount();
        DataItem[] dataItems = new DataItem[colCount];
        for (int i = 0; i < colCount; ++i) {
            dataItems[i] = this.getDataItem(i);
        }
        try {
            this.isRefreshingBusinessQuery = true;
            this.setModel(businessQuery);
            this.modelDataItems.clear();
            this.initialized = false;
            this.init();
            this.ignoreTableModelEvents = true;
            int newColCount = this.getColumnCount();
            int sortedDataItemListSize = this.sortedDataItemList.size();
            if (sortedDataItemListSize > 0) {
                ArrayList<String> newSortedColumns = new ArrayList<String>();
                ArrayList<DataItem> newSortedDataItems = new ArrayList<DataItem>();
                ArrayList<Integer> newSortDirections = new ArrayList<Integer>();
                for (int j = 0; j < sortedDataItemListSize; ++j) {
                    boolean found = false;
                    DataItem sortedDataItem = (DataItem)this.sortedDataItemList.get(j);
                    if (businessQuery.getResultItemRole(sortedDataItem) == Role.BACKGROUND) {
                        found = true;
                    } else {
                        for (int k = 0; k < newColCount; ++k) {
                            DataItem di = this.getDataItem(k);
                            if (!Util.equal((Object)sortedDataItem.getResultSetID(), (Object)di.getResultSetID())) continue;
                            found = true;
                            break;
                        }
                    }
                    if (found) {
                        if (sortedDataItem.getSortDirection() == DataItemActionType.SORT_NONE) continue;
                        newSortedColumns.add(this.sortedColumns[j]);
                        newSortDirections.add(new Integer(this.sortDirections[j]));
                        newSortedDataItems.add(sortedDataItem);
                        continue;
                    }
                    List sortOrder = businessQuery.getSortOrderPrecedence();
                    sortOrder.remove(sortedDataItem);
                    businessQuery.setSortOrderPrecedence(sortOrder);
                    sortedDataItem.setSortDirection(DataItemActionType.SORT_NONE);
                }
                if (this.sortedDataItemList.size() != newSortedDataItems.size()) {
                    this.sortedDataItemList = newSortedDataItems;
                    int sortedColumnsSize = newSortedColumns.size();
                    this.sortedColumns = new String[sortedColumnsSize];
                    for (int i = 0; i < sortedColumnsSize; ++i) {
                        this.sortedColumns[i] = (String)newSortedColumns.get(i);
                    }
                    int sortDirectionsSize = newSortDirections.size();
                    this.sortDirections = new int[sortDirectionsSize];
                    for (int i = 0; i < sortDirectionsSize; ++i) {
                        this.sortDirections[i] = (Integer)newSortDirections.get(i);
                    }
                    this.fireModelEvent();
                    return;
                }
            }
            if (colCount == newColCount) {
                for (int i = 0; i < newColCount; ++i) {
                    DataItem di = this.getDataItem(i);
                    if (di != null && Util.equal((Object)dataItems[i].getResultSetID(), (Object)di.getResultSetID())) continue;
                    this.fireModelEvent();
                    return;
                }
                if (!this.labelChangeEventList.isEmpty()) {
                    List items = this.getVisibleResultItems(this.getModel());
                    int size = items.size();
                    block15: for (PropertyChangeEvent labelChangeEvent : this.labelChangeEventList) {
                        DataItem source = (DataItem)labelChangeEvent.getSource();
                        for (int i = 0; i < size; ++i) {
                            DataItem di = (DataItem)items.get(i);
                            if (di != source) continue;
                            this.fireModelEvent((EventObject)new SwingTableModelEvent((TableModel)this, -2, -2, i, 17, (String)labelChangeEvent.getOldValue(), (String)labelChangeEvent.getNewValue()));
                            continue block15;
                        }
                    }
                    this.initialized = false;
                    this.init();
                    return;
                }
                int newRowCount = this.getRowCount();
                if (rowCount == newRowCount) {
                    this.fireModelEvent(new TableModelEvent(this, 0, newRowCount - 1));
                } else {
                    if (rowCount > newRowCount) {
                        this.fireModelEvent(new TableModelEvent(this, newRowCount, rowCount - 1, -1, -1));
                    } else {
                        this.fireModelEvent(new TableModelEvent(this, rowCount, newRowCount - 1, -1, 1));
                    }
                    this.fireModelEvent(new TableModelEvent(this, 0, newRowCount - 1));
                }
                return;
            }
            this.fireModelEvent();
        }
        catch (Exception ex) {
            this.fireModelEvent();
        }
        finally {
            this.isRefreshingBusinessQuery = false;
            this.ignoreTableModelEvents = false;
            this.labelChangeEventList.clear();
        }
    }

    private List getVisibleResultItems(BusinessQuery model) {
        List resultItems = new ArrayList();
        if (model != null) {
            try {
                resultItems = model.getResultItems(Role.COLUMN);
            }
            catch (MetadataException e) {
                LoggerRepository2.getLogger((String)this.getClass().getName(), null).error(e.getMessage(), (Throwable)e);
            }
        }
        return resultItems;
    }

    @Override
    public void setModel(BusinessQuery businessQuery) {
        BusinessQuery oldModel = this.getModel();
        if (oldModel != businessQuery) {
            this.modelDataItems.clear();
            if (this.isPredefinedSortsReturned()) {
                this.initializeSortedColumns();
            } else {
                this.sortedDataItemList.clear();
                this.sortedColumns = new String[0];
                this.sortDirections = new int[0];
            }
        }
        if (oldModel != null) {
            List oldDataItems = this.getVisibleResultItems(oldModel);
            for (DataItem dItem : oldDataItems) {
                dItem.removeListener((PropertyChangeListener)this);
            }
        }
        if (businessQuery != null) {
            List dataItems = this.getVisibleResultItems(businessQuery);
            for (DataItem dItem : dataItems) {
                dItem.addListener((PropertyChangeListener)this);
            }
        }
        super.setModel(businessQuery);
        this.setupDualFormatResultSet();
    }

    public void fireModelEvent(EventObject event) {
        if (event instanceof TableModelEvent) {
            EventListener[] listeners = this.listenerList.getListeners(TableModelListener.class);
            int n = listeners.length;
            for (int i = 0; i < n; ++i) {
                ((TableModelListener)listeners[i]).tableChanged((TableModelEvent)event);
            }
        }
    }

    @Override
    public void fireModelEvent() {
        this.fireModelEvent(new TableModelEvent(this, -1));
    }

    @Override
    public void addTableModelListener(TableModelListener l) {
        this.listenerList.add(TableModelListener.class, l);
    }

    @Override
    public void removeTableModelListener(TableModelListener l) {
        this.listenerList.remove(TableModelListener.class, l);
    }

    @Override
    public void tableChanged(TableModelEvent e) {
        if (!this.ignoreTableModelEvents) {
            TableModelEvent event = new TableModelEvent(this, e.getFirstRow(), e.getLastRow(), e.getColumn(), e.getType());
            if (this.storeTableModelEvents) {
                this.storedTableEvents.add(event);
            } else {
                this.fireModelEvent(event);
            }
        }
    }

    private void fireStoredTableEvents() {
        List eventList = (List)((ArrayList)this.storedTableEvents).clone();
        this.storedTableEvents.clear();
        Iterator iter = eventList.iterator();
        while (iter.hasNext()) {
            TableModelEvent event = (TableModelEvent)iter.next();
            iter.remove();
            this.fireModelEvent(event);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getFormattedValueAt(int rowIndex, int columnIndex) {
        this.init();
        try {
            Object value = null;
            if (this.isDualResultSetsAvailable()) {
                try {
                    this.retrievingFormattedDualResultSetData = true;
                    value = this.delegateAdapter.getValueAt(rowIndex, columnIndex);
                }
                finally {
                    this.retrievingFormattedDualResultSetData = false;
                }
            } else if (this.isFormattedDataReturned()) {
                if (this.isFormattedDataUsed()) {
                    this.storeTableModelEvents = true;
                    try {
                        this.delegateAdapter.setFormattedDataUsed(false);
                        value = this.delegateAdapter.getValueAt(rowIndex, columnIndex);
                    }
                    finally {
                        this.delegateAdapter.setFormattedDataUsed(this.formattedDataUsed);
                    }
                } else {
                    value = this.delegateAdapter.getValueAt(rowIndex, columnIndex);
                }
            } else {
                value = this.delegateAdapter.getFormattedValueAt(rowIndex, columnIndex);
            }
            if (value == null) {
                String string = "";
                return string;
            }
            String string = (String)this.objectToStringTransform.transform(value);
            return string;
        }
        finally {
            if (this.storeTableModelEvents) {
                this.storeTableModelEvents = false;
                this.fireStoredTableEvents();
            }
        }
    }

    @Override
    public boolean isFormattedDataReturned() {
        if (this.isDualResultSetsAvailable()) {
            return true;
        }
        return super.isFormattedDataReturned();
    }

    public String getFormat(int columnIndex) {
        this.init();
        return this.delegateAdapter.getFormat(columnIndex);
    }

    public void setFormattedDataUsed(boolean useFormattedData) {
        if (useFormattedData != this.formattedDataUsed) {
            boolean old = this.formattedDataUsed;
            this.formattedDataUsed = useFormattedData;
            if (this.initialized) {
                this.delegateAdapter.setFormattedDataUsed(this.formattedDataUsed);
            }
            this.spcs.firePropertyChange("formattedDataUsed", old ? Boolean.TRUE : Boolean.FALSE, old ? Boolean.FALSE : Boolean.TRUE);
        }
    }

    public boolean isFormattedDataUsed() {
        return this.formattedDataUsed;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object getUnformattedValueAt(int rowIndex, int columnIndex) {
        this.init();
        try {
            Object object;
            boolean isDualResultSetsAvailable = this.isDualResultSetsAvailable();
            if (this.isFormattedDataReturned() && !isDualResultSetsAvailable) {
                throw new IllegalStateException(RB.getStringResource(RB_KEY, "getUnformattedData.ex.txt"));
            }
            if (isDualResultSetsAvailable) {
                this.retrievingUnformattedDualResultSetData = true;
            }
            if (!this.isFormattedDataUsed()) {
                Object object2 = this.delegateAdapter.getValueAt(rowIndex, columnIndex);
                return object2;
            }
            this.storeTableModelEvents = true;
            try {
                Object value;
                this.delegateAdapter.setFormattedDataUsed(false);
                object = value = this.delegateAdapter.getValueAt(rowIndex, columnIndex);
            }
            catch (Throwable throwable) {
                this.delegateAdapter.setFormattedDataUsed(this.formattedDataUsed);
                throw throwable;
            }
            this.delegateAdapter.setFormattedDataUsed(this.formattedDataUsed);
            return object;
        }
        finally {
            if (this.storeTableModelEvents) {
                this.storeTableModelEvents = false;
                this.fireStoredTableEvents();
            }
            this.retrievingUnformattedDualResultSetData = false;
        }
    }

    public void setFormatLocale(Locale locale) {
        if (this.formatLocale != locale) {
            Locale oldFormatLocale = this.formatLocale;
            this.formatLocale = locale == null ? Locale.getDefault() : locale;
            this.objectToStringTransform = new ObjectToStringTransform(locale);
            if (this.initialized) {
                this.delegateAdapter.setFormatLocale(this.formatLocale);
            }
            this.spcs.firePropertyChange("formatLocale", oldFormatLocale, this.formatLocale);
        }
    }

    public Locale getFormatLocale() {
        return this.formatLocale;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void moveColumn(int columnIndex, int newIndex) {
        try {
            this.ignoreTableModelEvents = true;
            if (columnIndex != newIndex) {
                try {
                    BusinessQuery businessQuery = this.getModel();
                    List list = this.getVisibleResultItems(businessQuery);
                    if (columnIndex < 0 || columnIndex >= list.size() || newIndex < 0 || newIndex >= list.size()) {
                        throw new IllegalArgumentException(RB.getStringResource(RB_KEY, "invalidColumnIndex.txt"));
                    }
                    DataItem dataItem = (DataItem)list.get(columnIndex);
                    Role role = businessQuery.getResultItemRole(dataItem);
                    businessQuery.removeResultItem(dataItem);
                    businessQuery.insertResultItemsAt(dataItem, role, newIndex);
                    this.initialized = false;
                    this.init();
                    this.fireModelEvent((EventObject)new SwingTableModelEvent((TableModel)this, -2, -2, columnIndex, 44, newIndex));
                    this.getRowCount();
                }
                catch (Exception e) {
                    LoggerRepository2.getLogger((String)this.getClass().getName(), null).error(e.getMessage(), (Throwable)e);
                }
            }
        }
        finally {
            this.ignoreTableModelEvents = false;
        }
    }

    public boolean isColumnMoveAllowed(int columnIndex, int newIndex) {
        BusinessQuery businessQuery = this.getModel();
        return businessQuery != null && businessQuery.isActionSupported(BusinessQueryActionType.RESULT_ITEM) && columnIndex >= 0 && columnIndex < this.getColumnCount() && newIndex >= 0 && newIndex < this.getColumnCount();
    }

    public void setPredefinedSortsReturned(boolean predefinedSortsReturned) {
        if (this.predefinedSortsReturned != predefinedSortsReturned) {
            this.predefinedSortsReturned = predefinedSortsReturned;
            if (this.predefinedSortsReturned) {
                this.initializeSortedColumns();
            }
            this.spcs.firePropertyChange("predefinedSortsReturned", this.predefinedSortsReturned ? Boolean.FALSE : Boolean.TRUE, this.predefinedSortsReturned ? Boolean.TRUE : Boolean.FALSE);
        }
    }

    public boolean isPredefinedSortsReturned() {
        return this.predefinedSortsReturned;
    }

    private boolean isDualResultSetsAvailable() {
        if (this.useDualResultSets) {
            return true;
        }
        boolean dualRSAvailable = false;
        if (this.getBusinessQuery() != null) {
            List resultItems = this.getBusinessQuery().getSelectedItems();
            for (SelectedItem selectedItem : resultItems) {
                DataItem dataItem = selectedItem.getItem();
                if (dataItem == null || dataItem.getStructure() == null || !dataItem.getStructure().equals(StructureOfDataItem.STRUCTURE_COLUMN) || selectedItem.getFormatType() != 1) continue;
                dualRSAvailable = true;
                break;
            }
        }
        return dualRSAvailable;
    }

    public Object getColumnUniqueID(int columnIndex) {
        DataItem di = this.getDataItem(columnIndex);
        if (di != null) {
            return di.getResultSetID();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Double getRawSASNumericValue(int rowIndex, int columnIndex) {
        this.init();
        Double value = new Double(Double.NaN);
        if (this.delegateAdapter instanceof RawSASNumericValueProvider) {
            JDBCToTableModelAdapter rawSASNumericValueProvider = this.delegateAdapter;
            try {
                Double d;
                boolean isDualResultSetsAvailable = this.isDualResultSetsAvailable();
                if (this.isFormattedDataReturned() && !isDualResultSetsAvailable) {
                    throw new IllegalStateException(RB.getStringResource(RB_KEY, "getUnformattedData.ex.txt"));
                }
                if (isDualResultSetsAvailable) {
                    this.retrievingUnformattedDualResultSetData = true;
                }
                if (!this.isFormattedDataUsed()) {
                    Double d2 = rawSASNumericValueProvider.getRawSASNumericValue(rowIndex, columnIndex);
                    return d2;
                }
                this.storeTableModelEvents = true;
                try {
                    this.delegateAdapter.setFormattedDataUsed(false);
                    d = rawSASNumericValueProvider.getRawSASNumericValue(rowIndex, columnIndex);
                }
                catch (Throwable throwable) {
                    this.delegateAdapter.setFormattedDataUsed(this.formattedDataUsed);
                    throw throwable;
                }
                this.delegateAdapter.setFormattedDataUsed(this.formattedDataUsed);
                return d;
            }
            finally {
                if (this.storeTableModelEvents) {
                    this.storeTableModelEvents = false;
                    this.fireStoredTableEvents();
                }
                this.retrievingUnformattedDualResultSetData = false;
            }
        }
        return value;
    }
}

