/*
 * Decompiled with CFR 0.152.
 */
package com.sas.storage.iquery;

import com.sas.beans.ExtendedBeanInfo;
import com.sas.beans.PropertyChangeSource;
import com.sas.beans.Util;
import com.sas.collection.ContentsChangedEvent;
import com.sas.collection.ContentsChangedListener;
import com.sas.collection.ContentsChangedListenerList;
import com.sas.collection.ContentsChangedSource;
import com.sas.iquery.IQueryServicesException;
import com.sas.iquery.dataretrieval.DataRetrievalException;
import com.sas.iquery.dataretrieval.QueryConnector;
import com.sas.iquery.dataretrieval.QueryConnectorInterface;
import com.sas.iquery.execution2.ExecutionException;
import com.sas.iquery.intelligentquery.BusinessQueryProviderInterface;
import com.sas.iquery.intelligentquery.IntelligentQueryException;
import com.sas.iquery.intelligentquery.QueryConnectionInterface;
import com.sas.iquery.metadata.MetadataException;
import com.sas.iquery.metadata.business.BusinessModel;
import com.sas.iquery.metadata.business.BusinessModelResource;
import com.sas.iquery.metadata.business.BusinessQuery;
import com.sas.iquery.metadata.business.BusinessQueryTotalModeType;
import com.sas.iquery.metadata.business.DataItem;
import com.sas.iquery.metadata.business.DataSourceCube;
import com.sas.iquery.metadata.business.Role;
import com.sas.iquery.metadata.business.StructureOfDataItem;
import com.sas.iquery.metadata.expr.ExpressionInterface;
import com.sas.iquery.metadata.expr.ResourceAwareStringExpression;
import com.sas.iquery.metadata.physical.OlapItem;
import com.sas.iquery.metadata.physical.oma.OMACalculatedMeasure;
import com.sas.iquery.util.BusinessQueryOLAPUtil;
import com.sas.storage.iquery.BusinessQueryAdapterUtil;
import com.sas.storage.iquery.RB;
import com.sas.storage.olap.AxisInterface;
import com.sas.storage.olap.DimensionInterface;
import com.sas.storage.olap.Filter;
import com.sas.storage.olap.LevelInterface;
import com.sas.storage.olap.MeasureInterface;
import com.sas.storage.olap.MemberInterface;
import com.sas.storage.olap.MetadataInterface;
import com.sas.storage.olap.OLAPDataSetInterface;
import com.sas.storage.olap.OLAPException;
import com.sas.storage.olap.PerformanceTuning;
import com.sas.storage.olap.ResultSetInterface;
import com.sas.storage.olap.ResultSetMetadataInterface;
import com.sas.storage.olap.TupleElementInterface;
import com.sas.storage.olap.TupleInterface;
import com.sas.storage.olap.embedded.Axis;
import com.sas.storage.olap.embedded.OLAPDataSet;
import com.sas.storage.olap.embedded.ResultSet;
import com.sas.storage.olap.embedded.ResultSetMetadata;
import com.sas.storage.olap.embedded.Tuple;
import com.sas.storage.olap.embedded.TupleElement;
import com.sas.swing.models.ViewDefaultModel;
import com.sas.util.Strings;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Vector;
import javax.swing.event.SwingPropertyChangeSupport;

public class BusinessQueryToOLAPDataSetAdapter
implements OLAPDataSetInterface,
ContentsChangedSource,
ViewDefaultModel,
PropertyChangeSource,
PropertyChangeListener,
BusinessQueryProviderInterface {
    public static final String RB_KEY = "BusinessQueryToOLAPDataSetAdapter.";
    public static final int TUPLE_ELEMENT = 1;
    public static final int MEMBER_NAME = 2;
    public static final int LEVEL_NAME = 3;
    private SwingPropertyChangeSupport spcs;
    protected boolean designTime = Util.isDesignTime();
    protected boolean defaultModelAttached;
    protected BusinessQuery businessQueryModel;
    protected OLAPDataSetInterface delegateModel;
    protected boolean initialized;
    protected com.sas.iquery.execution2.ResultSetInterface iqResultSet;
    protected QueryConnectionInterface connector;
    private ContentsChangedListenerList allContentsChangedListeners;

    public static ExtendedBeanInfo getExtendedBeanInfo() {
        String[][][] propertyMetadata = new String[][][]{{{"Name", "model"}, {"Property editor class", "com.sas.beans.editors._InstanceEditor"}}};
        ExtendedBeanInfo ebi = new ExtendedBeanInfo();
        ebi.defaultInputPropertyName = "model";
        ebi.defaultOutputPropertyName = "model";
        ebi.propertyMetadata = propertyMetadata;
        return ebi;
    }

    public BusinessQueryToOLAPDataSetAdapter() {
        this(null, null);
    }

    public BusinessQueryToOLAPDataSetAdapter(BusinessQuery businessQueryModel) {
        this(businessQueryModel, null);
    }

    public BusinessQueryToOLAPDataSetAdapter(BusinessQuery businessQueryModel, QueryConnectionInterface queryConnector) {
        this.spcs = new SwingPropertyChangeSupport(this);
        this.connector = queryConnector == null ? new QueryConnector() : queryConnector;
        this.initialized = false;
        if (businessQueryModel == null) {
            this.createDefaultDelegateModel();
            this.setDefaultModelAttached(true);
        } else {
            this.setModel(businessQueryModel);
        }
    }

    public BusinessQuery getModel() {
        return this.businessQueryModel;
    }

    public void setModel(BusinessQuery businessQuery) {
        BusinessQuery oldModel = this.businessQueryModel;
        if (oldModel != businessQuery) {
            if (this.designTime && oldModel != null) {
                oldModel.removeListener((PropertyChangeListener)this);
            }
            this.businessQueryModel = businessQuery;
            if (this.designTime && this.businessQueryModel != null) {
                this.businessQueryModel.addListener((PropertyChangeListener)this);
            }
            if (businessQuery == null) {
                this.createDefaultDelegateModel();
                this.setDefaultModelAttached(true);
            } else {
                this.initialized = false;
                this.init();
                this.setDefaultModelAttached(false);
            }
            this.fireContentsChanged();
            this.firePropertyChange("model", oldModel, businessQuery);
        }
    }

    public boolean isDefaultModelAttached() {
        return this.defaultModelAttached;
    }

    protected void setDefaultModelAttached(boolean defaultModelUsed) {
        if (defaultModelUsed != this.defaultModelAttached) {
            this.defaultModelAttached = defaultModelUsed;
        }
    }

    public void addContentsChangedListener(ContentsChangedListener listener) {
        if (this.allContentsChangedListeners == null) {
            this.allContentsChangedListeners = new ContentsChangedListenerList();
        }
        this.allContentsChangedListeners.add(listener);
    }

    public void removeContentsChangedListener(ContentsChangedListener listener) {
        if (this.allContentsChangedListeners != null) {
            this.allContentsChangedListeners.remove(listener);
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent e) {
        if (e.getSource() == this.businessQueryModel) {
            this.initialized = false;
            this.init();
            this.fireContentsChanged();
        }
    }

    protected void fireContentsChanged(ContentsChangedEvent event) {
        if (this.allContentsChangedListeners != null && this.allContentsChangedListeners.count() > 0) {
            for (ContentsChangedListener listener : this.allContentsChangedListeners.getListeners()) {
                listener.contentsChanged(event);
            }
        }
    }

    protected synchronized void fireContentsChanged() {
        ContentsChangedEvent contentsChangedEvent = new ContentsChangedEvent((Object)this);
        this.fireContentsChanged(contentsChangedEvent);
    }

    private void createDefaultDelegateModel() {
        try {
            Tuple tuple1 = new Tuple(new TupleElementInterface[]{new TupleElement("Column A"), new TupleElement("a")});
            Tuple tuple2 = new Tuple(new TupleElementInterface[]{new TupleElement("Column A"), new TupleElement("b")});
            Tuple tuple3 = new Tuple(new TupleElementInterface[]{new TupleElement("Column B"), new TupleElement("c")});
            Tuple tuple4 = new Tuple(new TupleElementInterface[]{new TupleElement("Column B"), new TupleElement("d")});
            Tuple tuple5 = new Tuple(new TupleElementInterface[]{new TupleElement("Row A"), new TupleElement("a")});
            Tuple tuple6 = new Tuple(new TupleElementInterface[]{new TupleElement("Row A"), new TupleElement("b")});
            Tuple tuple7 = new Tuple(new TupleElementInterface[]{new TupleElement("Row B"), new TupleElement("c")});
            Tuple tuple8 = new Tuple(new TupleElementInterface[]{new TupleElement("Row B"), new TupleElement("d")});
            Tuple tuple9 = new Tuple(new TupleElementInterface[]{new TupleElement("Row C"), new TupleElement("e")});
            Tuple tuple10 = new Tuple(new TupleElementInterface[]{new TupleElement("Row C"), new TupleElement("f")});
            Axis columnAxis = new Axis(0, null, new TupleInterface[]{tuple1, tuple2, tuple3, tuple4});
            Axis rowAxis = new Axis(1, null, new TupleInterface[]{tuple5, tuple6, tuple7, tuple8, tuple9, tuple10});
            AxisInterface[] axes = new AxisInterface[]{columnAxis, rowAxis};
            ResultSetMetadata resultSetMetadata = new ResultSetMetadata(axes);
            ResultSet resultSet = new ResultSet();
            resultSet.setResultSetMetadata((ResultSetMetadataInterface)resultSetMetadata);
            this.delegateModel = new OLAPDataSet((ResultSetInterface)resultSet);
            this.defaultModelAttached = true;
            this.initialized = true;
        }
        catch (OLAPException oLAPException) {
            // empty catch block
        }
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.spcs.addPropertyChangeListener(listener);
    }

    public void addPropertyChangeListener(String propertyName, PropertyChangeListener listener) {
        this.spcs.addPropertyChangeListener(propertyName, listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.spcs.removePropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(String propertyName, PropertyChangeListener listener) {
        this.spcs.removePropertyChangeListener(propertyName, listener);
    }

    protected void firePropertyChange(PropertyChangeEvent event) {
        this.spcs.firePropertyChange(event);
    }

    protected void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
        this.firePropertyChange(new PropertyChangeEvent(this, propertyName, oldValue, newValue));
    }

    public String getCubeName() throws OLAPException {
        this.init();
        return this.delegateModel.getCubeName();
    }

    public int getContextType() throws OLAPException {
        this.init();
        return this.delegateModel.getContextType();
    }

    public void setContextType(int contextType) throws OLAPException {
        this.init();
        int old = this.delegateModel.getContextType();
        if (old != contextType) {
            this.delegateModel.setContextType(contextType);
            this.firePropertyChange("contextType", new Integer(old), new Integer(contextType));
        }
    }

    public Object getConnection() throws OLAPException {
        this.init();
        return this.delegateModel.getConnection();
    }

    public void setConnection(Object connection) throws OLAPException {
        this.init();
        Object old = this.delegateModel.getConnection();
        if (old != connection) {
            this.delegateModel.setConnection(connection);
            this.firePropertyChange("connection", old, connection);
        }
    }

    public void executeQuery(String queryStatement) throws OLAPException {
        this.init();
        this.delegateModel.executeQuery(queryStatement);
    }

    public void executeQuery() throws OLAPException {
        this.init();
        this.delegateModel.executeQuery();
    }

    public void setQueryStatement(String queryStatement) throws OLAPException {
        this.init();
        String old = this.delegateModel.getQueryStatement();
        if (old != queryStatement) {
            this.delegateModel.setQueryStatement(queryStatement);
            this.firePropertyChange("queryStatement", old, queryStatement);
        }
    }

    public Locale getLocale() throws OLAPException {
        this.init();
        return this.delegateModel.getLocale();
    }

    public void setLocale(Locale locale) throws OLAPException {
        this.init();
        this.delegateModel.setLocale(locale);
    }

    public void setReadOnly(boolean readOnly) throws OLAPException {
        this.init();
        boolean old = this.delegateModel.isReadOnly();
        if (old != readOnly) {
            this.delegateModel.setReadOnly(readOnly);
            this.firePropertyChange("readOnly", old ? Boolean.TRUE : Boolean.FALSE, readOnly ? Boolean.TRUE : Boolean.FALSE);
        }
    }

    public ResultSetMetadataInterface getResultSetMetadata() throws OLAPException {
        this.init();
        return this.delegateModel.getResultSetMetadata();
    }

    public String getQueryStatement() throws OLAPException {
        this.init();
        return this.delegateModel.getQueryStatement();
    }

    public boolean isReadOnly() throws OLAPException {
        this.init();
        return this.delegateModel.isReadOnly();
    }

    public Object[] getCells(long startCell, long endCell) throws OLAPException {
        this.init();
        return this.delegateModel.getCells(startCell, endCell);
    }

    public String[] getFormattedCells(long startCell, long endCell) throws OLAPException {
        this.init();
        return this.delegateModel.getFormattedCells(startCell, endCell);
    }

    public long getCellCount() throws OLAPException {
        this.init();
        return this.delegateModel.getCellCount();
    }

    public void setCells(long startCell, long endCell, Object[] cellValues) throws OLAPException {
        this.init();
        this.delegateModel.setCells(startCell, endCell, cellValues);
    }

    public void setFormattedCells(long startCell, long endCell, String[] cellValues) throws OLAPException {
        this.init();
        this.delegateModel.setFormattedCells(startCell, endCell, cellValues);
    }

    public void close() throws OLAPException {
        try {
            if (this.iqResultSet != null && this.connector instanceof QueryConnectorInterface) {
                ((QueryConnectorInterface)this.connector).closeResult(this.iqResultSet);
            }
            this.initialized = false;
        }
        catch (DataRetrievalException de) {
            throw new OLAPException((Throwable)de);
        }
        if (this.delegateModel != null) {
            this.delegateModel.close();
        }
    }

    public PerformanceTuning getPerformanceTuning() throws OLAPException {
        this.init();
        return this.delegateModel.getPerformanceTuning();
    }

    public void setPerformanceTuning(PerformanceTuning performanceTuning) throws OLAPException {
        this.init();
        this.delegateModel.setPerformanceTuning(performanceTuning);
    }

    public MetadataInterface getDatabaseMetadata() throws OLAPException {
        this.init();
        return this.delegateModel.getDatabaseMetadata();
    }

    public BusinessQuery getBusinessQuery() {
        this.init();
        return this.getModel();
    }

    public void refreshBusinessQuery(BusinessQuery businessQuery) throws IntelligentQueryException {
        BusinessQueryAdapterUtil.cleanOLAPQuery(businessQuery);
        if (this.businessQueryModel != businessQuery) {
            this.setModel(businessQuery);
        } else {
            this.initialized = false;
            this.init();
            this.fireContentsChanged();
        }
    }

    public com.sas.iquery.execution2.ResultSetInterface getResultSetInterface() {
        this.init();
        return this.iqResultSet;
    }

    public static boolean isTimeDimension(BusinessModel businessModel, DataItem dataItem) throws OLAPException {
        MetadataInterface metadata = null;
        try {
            metadata = BusinessQueryOLAPUtil.getMetadataInterface((Object)businessModel);
            int dimType = BusinessQueryToOLAPDataSetAdapter.getDimensionTypeForMetadata(metadata, businessModel, dataItem);
            boolean bl = dimType == 1;
            return bl;
        }
        catch (IQueryServicesException ie) {
            throw new OLAPException((Throwable)ie, ie.getMessage());
        }
        finally {
            if (metadata != null) {
                BusinessQueryOLAPUtil.releaseMetadataInterface((MetadataInterface)metadata);
            }
        }
    }

    public static boolean isTimeDimension(BusinessQuery businessQuery, DataItem dataItem) throws OLAPException {
        MetadataInterface metadata = null;
        try {
            metadata = BusinessQueryOLAPUtil.getMetadataInterface((Object)businessQuery);
            int dimType = BusinessQueryToOLAPDataSetAdapter.getDimensionTypeForMetadata(metadata, businessQuery.getBusinessModel(), dataItem);
            boolean bl = dimType == 1;
            return bl;
        }
        catch (IQueryServicesException ie) {
            throw new OLAPException((Throwable)ie, ie.getMessage());
        }
        finally {
            if (metadata != null) {
                BusinessQueryOLAPUtil.releaseMetadataInterface((MetadataInterface)metadata);
            }
        }
    }

    private static int getDimensionTypeForMetadata(MetadataInterface metadata, BusinessModel businessModel, DataItem dataItem) throws OLAPException {
        int type = 4;
        try {
            List sources = businessModel.getObjects(1, DataSourceCube.class);
            if (!sources.isEmpty()) {
                DataSourceCube dataSource = (DataSourceCube)sources.get(0);
                String cubeName = dataSource.getCube().getCubeName();
                if (metadata != null) {
                    ExpressionInterface obj = dataItem.getExpression();
                    String dimensionName = BusinessQueryOLAPUtil.getDimensionName((BusinessModel)businessModel, (DataItem)dataItem);
                    Filter filter = new Filter();
                    filter.setCubeName(cubeName);
                    filter.setDimensionName(dimensionName);
                    DimensionInterface dim = metadata.getDimension(filter);
                    if (dim != null) {
                        type = dim.getType();
                    }
                }
            }
        }
        catch (MetadataException metadataException) {
            // empty catch block
        }
        return type;
    }

    public static int getDimensionType(BusinessModel businessModel, DataItem dataItem) throws OLAPException {
        MetadataInterface metadata = null;
        try {
            metadata = BusinessQueryOLAPUtil.getMetadataInterface((Object)businessModel);
            int n = BusinessQueryToOLAPDataSetAdapter.getDimensionTypeForMetadata(metadata, businessModel, dataItem);
            return n;
        }
        catch (IQueryServicesException ie) {
            throw new OLAPException((Throwable)ie, ie.getMessage());
        }
        finally {
            if (metadata != null) {
                BusinessQueryOLAPUtil.releaseMetadataInterface((MetadataInterface)metadata);
            }
        }
    }

    public static String getFormat(BusinessQuery businessQuery, TupleElementInterface tupleElement) throws OLAPException {
        MetadataInterface metadata = null;
        try {
            DataItem di = BusinessQueryToOLAPDataSetAdapter.findDataItem(businessQuery, null, tupleElement, 1);
            if (di != null && BusinessQueryOLAPUtil.isInMeasureDimension((BusinessModel)businessQuery.getBusinessModel(), (DataItem)di)) {
                String format = di.getFormat();
                if (format == null || format.length() == 0) {
                    BusinessModelResource bmaResource;
                    ResourceAwareStringExpression resourceExp;
                    List resources;
                    Iterator it;
                    ExpressionInterface obj = di.getExpression();
                    if (obj instanceof OMACalculatedMeasure) {
                        OMACalculatedMeasure om = (OMACalculatedMeasure)obj;
                        BusinessModel businessModel = businessQuery.getBusinessModel();
                        List sources = businessModel.getObjects(1, DataSourceCube.class);
                        if (!sources.isEmpty()) {
                            DataSourceCube dataSource = (DataSourceCube)sources.get(0);
                            String cubeName = dataSource.getCube().getCubeName();
                            metadata = BusinessQueryOLAPUtil.getMetadataInterface((Object)businessQuery);
                            if (metadata != null) {
                                Filter filter = new Filter();
                                filter.setCubeName(cubeName);
                                filter.setUniqueMeasureName(om.getMeasureUniqueName());
                                MeasureInterface m = metadata.getMeasure(filter);
                                format = m.getFormat();
                            }
                        }
                    } else if (obj instanceof ResourceAwareStringExpression && (it = (resources = (resourceExp = (ResourceAwareStringExpression)obj).getResources(BusinessModelResource.class, 65535)).iterator()).hasNext() && (bmaResource = (BusinessModelResource)it.next()) instanceof DataItem) {
                        format = ((DataItem)bmaResource).getFormat();
                    }
                }
                String string = format;
                return string;
            }
        }
        catch (MetadataException me) {
            throw new OLAPException((Throwable)me, me.getMessage());
        }
        catch (IQueryServicesException me) {
            throw new OLAPException((Throwable)me, me.getMessage());
        }
        finally {
            if (metadata != null) {
                BusinessQueryOLAPUtil.releaseMetadataInterface(metadata);
            }
        }
        return null;
    }

    public static DataItem findDataItem(BusinessQuery businessQuery, OLAPDataSetInterface physicalModel, Object uniqueIdentifier, int type) throws OLAPException {
        int size;
        DataItem dataItem = null;
        if (businessQuery != null && (size = businessQuery.getResultItems().size()) > 0) {
            String dimensionName = null;
            String[] levelNames = null;
            String levelName = null;
            boolean foundAxis = false;
            MetadataInterface metadata = null;
            String cubeName = null;
            MemberInterface[] member = null;
            LevelInterface[] level = null;
            DimensionInterface[] dimension = null;
            switch (type) {
                case 1: {
                    TupleElementInterface tupleElement = (TupleElementInterface)uniqueIdentifier;
                    if (tupleElement.getSpan() == 0) {
                        return null;
                    }
                    int axisNumber = tupleElement.getTuple().getAxis().getAxisNumber();
                    String[] dimensionNames = tupleElement.getTuple().getAxis().getDimensionNames();
                    TupleElementInterface[] tupleElements = tupleElement.getTuple().getElements(0, tupleElement.getTupleElementIndex());
                    int relativeIndex = 0;
                    for (int i = 0; i < tupleElements.length; ++i) {
                        relativeIndex += tupleElements[i].getSpan();
                    }
                    dimensionName = dimensionNames[relativeIndex];
                    dataItem = BusinessQueryToOLAPDataSetAdapter.findDataItemInternal(businessQuery, axisNumber, dimensionName, tupleElement.getName(), tupleElement.getLabel());
                    break;
                }
                case 2: {
                    if (physicalModel == null) {
                        throw new IllegalArgumentException(RB.getStringResource(RB_KEY, "physicalModelNull.ex.txt"));
                    }
                    metadata = physicalModel.getDatabaseMetadata();
                    cubeName = physicalModel.getCubeName();
                    Filter filter = new Filter();
                    filter.setCubeName(cubeName);
                    filter.setUniqueMemberName((String)uniqueIdentifier);
                    member = null;
                    try {
                        member = metadata.getMembers(filter, 0, 1);
                        filter = member[0].getFilter();
                        levelName = filter.getUniqueLevelName();
                    }
                    catch (OLAPException ex) {
                        dimensionName = null;
                        levelName = null;
                    }
                    dataItem = null;
                    if (levelName == null) break;
                    ResultSetMetadataInterface resultSetMetadata = physicalModel.getResultSetMetadata();
                    AxisInterface[] axis = resultSetMetadata.getAxes(0, -1);
                    for (int i = 0; i < axis.length; ++i) {
                        levelNames = axis[i].getUniqueLevelNames();
                        for (int j = 0; j < levelNames.length; ++j) {
                            if (!levelNames[j].equalsIgnoreCase(levelName)) continue;
                            foundAxis = true;
                            String[] dimensionNames = axis[i].getDimensionNames();
                            dimensionName = dimensionNames[j];
                            dataItem = BusinessQueryToOLAPDataSetAdapter.findDataItemInternal(businessQuery, axis[i].getAxisNumber(), dimensionName, filter.getUniqueMemberName(), filter.getMemberLabel());
                            break;
                        }
                        if (dataItem != null) break;
                    }
                    if (dataItem != null || foundAxis) break;
                    String uniqueDimensionName = filter.getUniqueDimensionName();
                    cubeName = filter.getCubeName();
                    filter = new Filter();
                    filter.setCubeName(cubeName);
                    filter.setUniqueDimensionName(uniqueDimensionName);
                    dimension = metadata.getDimensions(filter);
                    if (dimension.length <= 0) break;
                    dataItem = BusinessQueryToOLAPDataSetAdapter.findDataItemInternal(businessQuery, -789, dimension[0].getName(), filter.getUniqueMemberName(), filter.getMemberLabel());
                    break;
                }
                case 3: {
                    levelName = (String)uniqueIdentifier;
                    levelNames = null;
                    ResultSetMetadataInterface resultSetMetadata = physicalModel.getResultSetMetadata();
                    AxisInterface[] axis = resultSetMetadata.getAxes(0, -1);
                    dataItem = null;
                    for (int i = 0; i < axis.length; ++i) {
                        levelNames = axis[i].getUniqueLevelNames();
                        for (int j = 0; j < levelNames.length; ++j) {
                            if (!levelNames[j].equalsIgnoreCase(levelName)) continue;
                            foundAxis = true;
                            String[] dimensionNames = axis[i].getDimensionNames();
                            dimensionName = dimensionNames[j];
                            dataItem = BusinessQueryToOLAPDataSetAdapter.findDataItemInternal(businessQuery, axis[i].getAxisNumber(), dimensionName, null, null);
                            break;
                        }
                        if (dataItem != null) break;
                    }
                    if (dataItem != null || foundAxis || physicalModel == null) break;
                    metadata = physicalModel.getDatabaseMetadata();
                    Filter filter = new Filter();
                    filter.setCubeName(physicalModel.getCubeName());
                    filter.setUniqueLevelName((String)uniqueIdentifier);
                    level = null;
                    try {
                        level = metadata.getLevels(filter);
                        filter = level[0].getFilter();
                        String uniqueDimensionName = filter.getUniqueDimensionName();
                        filter = new Filter();
                        filter.setCubeName(physicalModel.getCubeName());
                        filter.setUniqueDimensionName(uniqueDimensionName);
                        dimension = metadata.getDimensions(filter);
                        if (dimension.length > 0) {
                            dataItem = BusinessQueryToOLAPDataSetAdapter.findDataItemInternal(businessQuery, -789, dimension[0].getName(), filter.getUniqueMemberName(), filter.getMemberLabel());
                        }
                    }
                    catch (OLAPException ex) {
                        dimensionName = null;
                    }
                    if (dimensionName == null) break;
                    dataItem = BusinessQueryToOLAPDataSetAdapter.findDataItemInternal(businessQuery, -789, dimensionName, null, null);
                    break;
                }
            }
        }
        return dataItem;
    }

    protected void buildOLAPDataSet(BusinessQuery businessQueryModel) {
        block23: {
            try {
                if (this.designTime) {
                    Axis rowAxis = new Axis(1);
                    Axis columnAxis = new Axis(0);
                    Axis slicerAxis = new Axis(-1);
                    AxisInterface[] axes = new AxisInterface[]{columnAxis, rowAxis, slicerAxis};
                    HashMap rowTable = new HashMap();
                    HashMap columnTable = new HashMap();
                    HashMap backgroundTable = new HashMap();
                    int rowMax = 0;
                    int colMax = 0;
                    int backMax = 0;
                    try {
                        List items = businessQueryModel.getResultItems();
                        int count = items.size();
                        for (int i = 0; i < count; ++i) {
                            Vector dataItems;
                            DataItem dataItem = (DataItem)items.get(i);
                            Role role = businessQueryModel.getResultItemRole(dataItem);
                            String dimensionName = BusinessQueryOLAPUtil.getDimensionName((BusinessModel)businessQueryModel.getBusinessModel(), (DataItem)dataItem);
                            int size = 0;
                            if (role == Role.ROW) {
                                if (!rowTable.containsKey(dimensionName)) {
                                    rowTable.put(dimensionName, new Vector());
                                }
                                dataItems = (Vector)rowTable.get(dimensionName);
                                dataItems.add(dataItem.getLabel());
                                size = dataItems.size();
                                if (rowMax == 0) {
                                    rowMax = 1;
                                }
                                if (size <= 1) continue;
                                rowMax = rowMax / (size - 1) * size;
                                continue;
                            }
                            if (role == Role.COLUMN) {
                                if (!columnTable.containsKey(dimensionName)) {
                                    columnTable.put(dimensionName, new Vector());
                                }
                                dataItems = (Vector)columnTable.get(dimensionName);
                                dataItems.add(dataItem.getLabel());
                                size = dataItems.size();
                                if (colMax == 0) {
                                    colMax = 1;
                                }
                                if (size <= 1) continue;
                                colMax = colMax / (size - 1) * size;
                                continue;
                            }
                            if (role != Role.BACKGROUND) continue;
                            if (!backgroundTable.containsKey(dimensionName)) {
                                backgroundTable.put(dimensionName, new Vector());
                            }
                            dataItems = (Vector)backgroundTable.get(dimensionName);
                            dataItems.add(dataItem.getLabel());
                            size = dataItems.size();
                            if (backMax == 0) {
                                backMax = 1;
                            }
                            if (size <= 1) continue;
                            backMax = backMax / (size - 1) * size;
                        }
                    }
                    catch (MetadataException items) {
                        // empty catch block
                    }
                    this.createAxis(rowAxis, rowTable.entrySet().toArray(), rowMax);
                    this.createAxis(columnAxis, columnTable.entrySet().toArray(), colMax);
                    this.createAxis(slicerAxis, backgroundTable.entrySet().toArray(), backMax);
                    ResultSetMetadata resultSetMetadata = new ResultSetMetadata(axes);
                    ResultSet resultSet = new ResultSet();
                    Object[] entries = backgroundTable.entrySet().toArray();
                    ArrayList<StringBuffer> cells = new ArrayList<StringBuffer>();
                    StringBuffer cell = new StringBuffer();
                    for (int i = 0; i < entries.length; ++i) {
                        Vector items = (Vector)((Map.Entry)entries[i]).getValue();
                        int size2 = items.size();
                        for (int j = 0; j < size2; ++j) {
                            cell.append("<" + ((String)items.get(j)).trim() + ">");
                        }
                    }
                    int rowTupCount = rowAxis.getTupleCount();
                    int colTupCount = columnAxis.getTupleCount();
                    int crossProduct = rowTupCount * colTupCount;
                    for (int i = 0; i < crossProduct; ++i) {
                        cells.add(cell);
                    }
                    resultSet.setResultSetMetadata((ResultSetMetadataInterface)resultSetMetadata);
                    resultSet.setCells(0L, -1L, cells.toArray());
                    this.delegateModel = new OLAPDataSet((ResultSetInterface)resultSet);
                    break block23;
                }
                String modelID = businessQueryModel.getID();
                if (modelID == null) {
                    throw new IllegalStateException(RB.getStringResource(RB_KEY, "modelIDNull.ex.txt"));
                }
                ArrayList<BusinessQuery> selectionList = new ArrayList<BusinessQuery>();
                selectionList.add(businessQueryModel);
                Map results = this.connector.retrieveQueryResultMap(selectionList);
                com.sas.iquery.execution2.ResultSetInterface previqResultSet = this.iqResultSet;
                this.iqResultSet = (com.sas.iquery.execution2.ResultSetInterface)results.get(modelID);
                Object resultSet = this.iqResultSet.getResultSet();
                if (resultSet instanceof OLAPDataSetInterface) {
                    String totalLabel;
                    this.delegateModel = (OLAPDataSetInterface)resultSet;
                    if (this.delegateModel instanceof com.sas.storage.olap.sasmdx.OLAPDataSet && (totalLabel = this.getTotalLabel(businessQueryModel)) != null && totalLabel.length() > 0) {
                        ((com.sas.storage.olap.sasmdx.OLAPDataSet)this.delegateModel).setTotalLabel(totalLabel);
                    }
                }
                if (previqResultSet != null && this.connector instanceof QueryConnectorInterface) {
                    ((QueryConnectorInterface)this.connector).closeResult(previqResultSet);
                }
                this.initialized = true;
            }
            catch (IntelligentQueryException ex) {
                this.initialized = false;
                IllegalStateException ise = new IllegalStateException(ex.getMessage());
                ise.initCause(ex);
                throw ise;
            }
            catch (ExecutionException ex) {
                this.initialized = false;
                IllegalStateException ise = new IllegalStateException(ex.getMessage());
                ise.initCause(ex);
                throw ise;
            }
            catch (OLAPException ex) {
                this.initialized = false;
                IllegalStateException ise = new IllegalStateException(ex.getMessage());
                ise.initCause(ex);
                throw ise;
            }
        }
    }

    private String getTotalLabel(BusinessQuery businessQueryModel) {
        String totalLabel = null;
        if (businessQueryModel.getTotalMode() == BusinessQueryTotalModeType.VISUAL_VALUES) {
            String rowTotalType = businessQueryModel.getTotalType(Role.ROW);
            String colTotalType = businessQueryModel.getTotalType(Role.COLUMN);
            if (rowTotalType == BusinessQuery.ALLTOTAL || colTotalType == BusinessQuery.ALLTOTAL) {
                totalLabel = businessQueryModel.getTotalLabel(Role.ROW, BusinessQuery.ALLTOTAL);
            } else if (rowTotalType == BusinessQuery.GRANDTOTAL) {
                totalLabel = businessQueryModel.getTotalLabel(Role.ROW, BusinessQuery.GRANDTOTAL);
            } else if (colTotalType == BusinessQuery.GRANDTOTAL) {
                totalLabel = businessQueryModel.getTotalLabel(Role.COLUMN, BusinessQuery.GRANDTOTAL);
            } else if (rowTotalType == BusinessQuery.AXISTOTAL) {
                totalLabel = businessQueryModel.getTotalLabel(Role.ROW, BusinessQuery.AXISTOTAL);
            } else if (colTotalType == BusinessQuery.AXISTOTAL) {
                totalLabel = businessQueryModel.getTotalLabel(Role.COLUMN, BusinessQuery.AXISTOTAL);
            }
        }
        return totalLabel;
    }

    private void createAxis(Axis axis, Object[] entries, int max) {
        int newMax = max;
        String[][] dataItems = new String[max][entries.length];
        for (int j = 0; j < entries.length; ++j) {
            Vector items = (Vector)((Map.Entry)entries[j]).getValue();
            int size = items.size();
            int num = newMax / size;
            for (int i = 0; i < max; ++i) {
                int z;
                for (z = i / num; z >= size; z -= size) {
                }
                dataItems[i][j] = (String)items.get(z);
            }
            newMax = num;
        }
        try {
            for (int i = 0; i < dataItems.length; ++i) {
                Tuple tuple = new Tuple();
                for (int j = 0; j < dataItems[i].length; ++j) {
                    TupleElement element = new TupleElement(dataItems[i][j]);
                    tuple.addElement((TupleElementInterface)element);
                }
                axis.addTuple((TupleInterface)tuple);
            }
        }
        catch (OLAPException oLAPException) {
            // empty catch block
        }
    }

    private static DataItem findDataItemInternal(BusinessQuery businessQuery, int axisNumber, String dimensionName, String elementName, String elementLabel) throws OLAPException {
        DataItem dataItem2 = null;
        try {
            ExpressionInterface expression;
            List dataItems = null;
            switch (axisNumber) {
                case 1: {
                    dataItems = businessQuery.getResultItems(Role.ROW);
                    break;
                }
                case 0: {
                    dataItems = businessQuery.getResultItems(Role.COLUMN);
                    break;
                }
                case 2: {
                    dataItems = businessQuery.getResultItems(Role.PAGE);
                    break;
                }
                case -1: {
                    dataItems = businessQuery.getResultItems(Role.BACKGROUND);
                    break;
                }
                default: {
                    dataItems = businessQuery.getResultItems();
                }
            }
            if (dataItems == null) {
                return dataItem2;
            }
            Iterator iterator = dataItems.iterator();
            ArrayList<DataItem> calculatedItems = new ArrayList<DataItem>();
            boolean found = false;
            while (iterator.hasNext()) {
                dataItem2 = (DataItem)iterator.next();
                if (dataItem2.isCalculatedItem()) {
                    calculatedItems.add(dataItem2);
                    continue;
                }
                if (dimensionName != null && !dimensionName.equalsIgnoreCase(BusinessQueryOLAPUtil.getDimensionName((BusinessModel)businessQuery.getBusinessModel(), (DataItem)dataItem2))) continue;
                expression = dataItem2.getExpression();
                if (dataItem2.getStructure() == StructureOfDataItem.STRUCTURE_MEASURE) {
                    if (elementName == null) {
                        found = true;
                        break;
                    }
                    if (expression instanceof OlapItem && elementName != null && !elementName.equalsIgnoreCase(((OlapItem)expression).getUniqueName()) && !Strings.equal((String)dataItem2.getLabel(), (String)elementLabel, (boolean)true, (boolean)false) || !(expression instanceof OlapItem) && !dataItem2.getLabel().equals(elementLabel)) continue;
                }
                found = true;
                break;
            }
            if (!found) {
                for (DataItem dataItem2 : calculatedItems) {
                    if (dimensionName != null && !dimensionName.equalsIgnoreCase(BusinessQueryOLAPUtil.getDimensionName((BusinessModel)businessQuery.getBusinessModel(), (DataItem)dataItem2))) continue;
                    expression = dataItem2.getExpression();
                    if (dataItem2.getStructure() == StructureOfDataItem.STRUCTURE_MEASURE) {
                        if (elementName == null) {
                            found = true;
                            break;
                        }
                        if (expression instanceof OlapItem && elementName != null && !elementName.equalsIgnoreCase(((OlapItem)expression).getUniqueName()) || !(expression instanceof OlapItem) && !dataItem2.getLabel().equals(elementLabel)) continue;
                    }
                    found = true;
                    break;
                }
            }
            if (!found) {
                dataItem2 = null;
            }
        }
        catch (MetadataException ex) {
            throw new OLAPException((Throwable)ex);
        }
        return dataItem2;
    }

    protected void init() {
        if (this.initialized) {
            return;
        }
        if (this.businessQueryModel == null && this.delegateModel == null) {
            throw new IllegalStateException(RB.getStringResource(RB_KEY, "modelNull.ex.txt"));
        }
        if (this.businessQueryModel != null) {
            this.buildOLAPDataSet(this.businessQueryModel);
        }
        this.initialized = true;
    }
}

