/*
 * Decompiled with CFR 0.152.
 */
package com.sas.storage.iquery;

import com.sas.beans.ExtendedBeanInfo;
import com.sas.iquery.metadata.business.BusinessQuery;
import com.sas.storage.iquery.BusinessQueryAdapter;
import com.sas.storage.jdbc.JDBCAdapter;
import com.sas.storage.jdbc.JDBCToListModelAdapter;
import java.sql.ResultSet;
import java.util.EventListener;
import java.util.EventObject;
import javax.swing.ListModel;
import javax.swing.event.EventListenerList;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;

public class BusinessQueryToListModelAdapter
extends BusinessQueryAdapter
implements ListModel,
ListDataListener {
    protected EventListenerList listenerList = new EventListenerList();
    protected JDBCToListModelAdapter delegateAdapter;
    protected String templateText;

    public BusinessQueryToListModelAdapter() {
        this(null);
    }

    public BusinessQueryToListModelAdapter(BusinessQuery businessQueryModel) {
        super(businessQueryModel);
    }

    @Override
    protected JDBCAdapter createDelegateAdapter(ResultSet resulSet) {
        if (this.delegateAdapter != null) {
            this.delegateAdapter.removeListDataListener((ListDataListener)this);
        }
        this.delegateAdapter = new JDBCToListModelAdapter(resulSet);
        this.delegateAdapter.addListDataListener((ListDataListener)this);
        return this.delegateAdapter;
    }

    @Override
    public void addListDataListener(ListDataListener l) {
        this.listenerList.add(ListDataListener.class, l);
    }

    @Override
    public void removeListDataListener(ListDataListener l) {
        this.listenerList.add(ListDataListener.class, l);
    }

    @Override
    public int getSize() {
        BusinessQuery model = this.getModel();
        if (model != null) {
            int size = model.getResultItems().size();
            if (!this.designTime && size > 0) {
                this.init();
                return this.delegateAdapter.getSize();
            }
        }
        return 0;
    }

    public Object getElementAt(int index) {
        this.init();
        return this.delegateAdapter.getElementAt(index);
    }

    public String getTemplateText() {
        return this.templateText;
    }

    public void setTemplateText(String templateText) {
        String oldTemplateText = this.getTemplateText();
        if (oldTemplateText == null || !oldTemplateText.equals(templateText)) {
            this.templateText = templateText;
            if (!this.designTime) {
                this.init();
                this.delegateAdapter.setTemplateText(templateText);
            }
            this.spcs.firePropertyChange("templateText", oldTemplateText, templateText);
        }
    }

    public static ExtendedBeanInfo getExtendedBeanInfo() {
        String[][][] propertyMetadata = new String[][][]{{{"Name", "model"}, {"Property editor class", "com.sas.beans.editors._InstanceEditor"}}, {{"Name", "elementAt"}, {"Hidden", "true"}}, {{"Name", "resultSetRequeryUsed"}, {"Expert", "true"}}, {{"Name", "size"}, {"Expert", "true"}}};
        ExtendedBeanInfo ebi = new ExtendedBeanInfo();
        ebi.propertyMetadata = propertyMetadata;
        return ebi;
    }

    public void fireModelEvent(EventObject event) {
        if (event instanceof ListDataEvent) {
            EventListener[] listeners = this.listenerList.getListeners(ListDataListener.class);
            int n = listeners.length;
            for (int i = 0; i < n; ++i) {
                if (((ListDataEvent)event).getType() == 0) {
                    ((ListDataListener)listeners[i]).contentsChanged((ListDataEvent)event);
                    continue;
                }
                if (((ListDataEvent)event).getType() == 1) {
                    ((ListDataListener)listeners[i]).intervalAdded((ListDataEvent)event);
                    continue;
                }
                if (((ListDataEvent)event).getType() != 2) continue;
                ((ListDataListener)listeners[i]).intervalRemoved((ListDataEvent)event);
            }
        }
    }

    @Override
    public void fireModelEvent() {
        if (this.designTime) {
            return;
        }
        int lastRow = this.getSize() - 1;
        this.fireModelEvent(new ListDataEvent(this, 0, 0, lastRow));
    }

    @Override
    public void contentsChanged(ListDataEvent e) {
        ListDataEvent event = new ListDataEvent(this, e.getType(), e.getIndex0(), e.getIndex1());
        this.fireModelEvent(event);
    }

    @Override
    public void intervalRemoved(ListDataEvent e) {
        this.contentsChanged(e);
    }

    @Override
    public void intervalAdded(ListDataEvent e) {
        this.contentsChanged(e);
    }
}

