/*
 * Decompiled with CFR 0.152.
 */
package com.sas.storage.iquery;

import com.sas.iquery.intelligentquery.IntelligentQueryException;
import com.sas.iquery.metadata.MetadataException;
import com.sas.iquery.metadata.business.BusinessModel;
import com.sas.iquery.metadata.business.BusinessQuery;
import com.sas.iquery.metadata.business.DataItem;
import com.sas.iquery.metadata.business.DataSourceCube;
import com.sas.iquery.metadata.business.FilterItem;
import com.sas.iquery.metadata.business.Role;
import com.sas.iquery.metadata.business.step.olap.BusinessQueryDataBasedFilter;
import com.sas.iquery.metadata.business.step.olap.BusinessQueryRankFilter;
import com.sas.iquery.metadata.expr.FractionOfTotalExpression;
import com.sas.iquery.metadata.expr.olap.TimeExpressionMeasure;
import com.sas.iquery.util.BusinessQueryOLAPUtil;
import com.sas.storage.olap.DimensionInterface;
import com.sas.storage.olap.Filter;
import com.sas.storage.olap.MetadataInterface;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public abstract class BusinessQueryAdapterUtil {
    public static void cleanRelationalQuery(BusinessQuery query) throws IntelligentQueryException {
        try {
            BusinessQueryAdapterUtil.cleanPercentOfTotals(query);
            BusinessQueryAdapterUtil.cleanQueryFilters(query);
        }
        catch (MetadataException e) {
            throw new IntelligentQueryException((Throwable)e, e.getMessage());
        }
    }

    public static void cleanOLAPQuery(BusinessQuery query) throws IntelligentQueryException {
        try {
            BusinessQueryAdapterUtil.cleanPercentOfTotals(query);
            BusinessQueryAdapterUtil.cleanQuerySortsByRole(query, Role.COLUMN);
            BusinessQueryAdapterUtil.cleanQuerySortsByRole(query, Role.ROW);
            BusinessQueryAdapterUtil.cleanQueryFilterAndRank(query, Role.COLUMN);
            BusinessQueryAdapterUtil.cleanQueryFilterAndRank(query, Role.ROW);
            BusinessQueryAdapterUtil.cleanCalculatedMeasures(query);
        }
        catch (MetadataException e) {
            throw new IntelligentQueryException((Throwable)e, e.getMessage());
        }
    }

    public static void cleanPercentOfTotals(BusinessQuery query) throws MetadataException {
        List items = query.getResultItems();
        for (Object item : items) {
            DataItem di;
            if (!(item instanceof DataItem) || !((di = (DataItem)item).getExpression() instanceof FractionOfTotalExpression)) continue;
            FractionOfTotalExpression pot = (FractionOfTotalExpression)di.getExpression();
            try {
                if ((pot.getNumerator() == null || query.getResultItemRole(pot.getNumerator()) != null) && (pot.getDenominator() == null || query.getResultItemRole(pot.getDenominator()) != null)) continue;
                query.removeResultItem(di);
            }
            catch (Exception e) {
                query.removeResultItem(di);
            }
        }
    }

    public static void cleanQueryFilters(BusinessQuery query) throws MetadataException {
        List filters = query.getEffectiveFilters();
        Iterator filterIterator = filters.iterator();
        while (filterIterator.hasNext()) {
            FilterItem filter = (FilterItem)filterIterator.next();
            if (filter.isUsableInQuery()) continue;
            filterIterator.remove();
        }
        if (query.getEffectiveFilters().size() != filters.size()) {
            query.setFilters(filters);
        }
    }

    public static void cleanQuerySortsByRole(BusinessQuery query, Role role) throws MetadataException {
        List sorts = query.getSortCriteria(role);
        Iterator sortIterator = sorts.iterator();
        while (sortIterator.hasNext()) {
            Object sort = sortIterator.next();
            if (!(sort instanceof DataItem)) continue;
            DataItem dataItem = (DataItem)sort;
            if (!dataItem.isUsableInQuery()) {
                sortIterator.remove();
            }
            if (query.getSortCriteria(role).size() == sorts.size()) continue;
            query.setSortCriteria(sorts, role);
        }
    }

    public static void cleanQueryFilterAndRank(BusinessQuery query, Role role) throws MetadataException {
        List steps = query.getSteps(role);
        Iterator stepIterator = steps.iterator();
        block4: while (stepIterator.hasNext()) {
            DataItem di;
            List qualifiers;
            Object step = stepIterator.next();
            if (step instanceof BusinessQueryRankFilter) {
                BusinessQueryRankFilter rankFilter = (BusinessQueryRankFilter)step;
                qualifiers = rankFilter.getRankQualifiers();
                for (Object item : qualifiers) {
                    if (!(item instanceof DataItem)) continue;
                    di = (DataItem)item;
                    try {
                        if (query.getResultItemRole(di) != null) continue block4;
                        stepIterator.remove();
                    }
                    catch (Exception e) {
                        stepIterator.remove();
                    }
                    continue block4;
                }
                continue;
            }
            if (!(step instanceof BusinessQueryDataBasedFilter)) continue;
            BusinessQueryDataBasedFilter filter = (BusinessQueryDataBasedFilter)step;
            qualifiers = filter.getLeftExpression();
            for (Object item : qualifiers) {
                if (!(item instanceof DataItem)) continue;
                di = (DataItem)item;
                try {
                    if (query.getResultItemRole(di) != null) continue block4;
                    stepIterator.remove();
                }
                catch (Exception e) {
                    stepIterator.remove();
                }
                continue block4;
            }
        }
        if (query.getSteps(role).size() != steps.size()) {
            query.setSteps(steps, role);
        }
    }

    public static void cleanCalculatedMeasures(BusinessQuery query) throws MetadataException {
        List items = query.getResultItems();
        ArrayList<DataItem> calcItems = new ArrayList<DataItem>(3);
        if (!BusinessQueryAdapterUtil.isTimeDimensionInQuery(query)) {
            for (Object item : items) {
                if (!(item instanceof DataItem) || !(((DataItem)item).getExpression() instanceof TimeExpressionMeasure)) continue;
                calcItems.add((DataItem)item);
            }
        }
        if (!calcItems.isEmpty()) {
            query.removeResultItems(calcItems);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean isTimeDimensionInQuery(BusinessQuery bq) {
        MetadataInterface metadata = null;
        try {
            metadata = BusinessQueryOLAPUtil.getMetadataInterface((Object)bq);
            List items = bq.getResultItems();
            for (Object item : items) {
                if (!(item instanceof DataItem)) continue;
                int type = 4;
                BusinessModel model = bq.getBusinessModel();
                DataItem dataItem = (DataItem)item;
                List sources = model.getObjects(1, DataSourceCube.class);
                if (!sources.isEmpty()) {
                    DataSourceCube dataSource = (DataSourceCube)sources.get(0);
                    String cubeName = dataSource.getCube().getCubeName();
                    if (metadata != null) {
                        String dimensionName = BusinessQueryOLAPUtil.getDimensionName((BusinessModel)model, (DataItem)dataItem);
                        Filter filter = new Filter();
                        filter.setCubeName(cubeName);
                        filter.setDimensionName(dimensionName);
                        DimensionInterface dim = metadata.getDimension(filter);
                        if (dim != null) {
                            type = dim.getType();
                        }
                    }
                }
                if (type != 1) continue;
                boolean bl = true;
                return bl;
            }
        }
        catch (Exception exception) {
        }
        finally {
            if (metadata != null) {
                BusinessQueryOLAPUtil.releaseMetadataInterface((MetadataInterface)metadata);
            }
        }
        return false;
    }
}

