/*
 * Decompiled with CFR 0.152.
 */
package com.sas.prompts.valueprovider.dynamic.workspace;

import com.sas.datatypes.DataTypeInterface;
import com.sas.prompts.DynamicListSearchInterface;
import com.sas.prompts.DynamicPromptValueContextInterface;
import com.sas.prompts.DynamicValueProviderInterface;
import com.sas.prompts.InvalidPromptValueException;
import com.sas.prompts.PromptValueNotFoundException;
import com.sas.prompts.PromptValuesInterface;
import com.sas.prompts.PromptViewInterface;
import com.sas.prompts.util.iquery.PromptIQueryUtil;
import com.sas.prompts.valueprovider.dynamic.workspace.PromptColumnValueProvider;
import com.sas.prompts.valueprovider.dynamic.workspace.RB;
import com.sas.storage.simplesqlmodel.ColumnInfo;
import com.sas.storage.simplesqlmodel.Expression;
import com.sas.storage.simplesqlmodel.OperandInterface;
import com.sas.storage.valueprovider.SearchCriteria;
import com.sas.storage.valueprovider.ValueProviderException;
import com.sas.storage.valueprovider.ValueProviderInterface;
import com.sas.storage.valueprovider.ValueType;
import com.sas.storage.vr.dto.DataSource;
import com.sas.storage.vr.dto.DynamicValueRetrieverConfiguration;
import com.sas.storage.vr.dto.QueryItem;
import com.sas.storage.vr.dto.QueryItemSearchCriteria;
import com.sas.storage.vr.dto.QueryProperty;
import com.sas.storage.vr.dto.Search;
import com.sas.storage.vr.dto.SearchOperatorEnum;
import com.sas.storage.vr.dto.ValueDataTypeEnum;
import com.sas.storage.vr.dto.ValueRetrieverConfiguration;
import com.sas.svcs.formvr.client.ValueRetrieverExceptionHolder;
import com.sas.svcs.formvr.client.ValueRetrieverServiceInterface;
import com.sas.svcs.formvr.client.types.GetValuesAsListParameters;
import com.sas.util.ValidateArg;
import com.sas.util.ValueItem;
import com.sas.util.anno.NotNull;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public final class PromptColumnVPtoVRConverter
implements ValueProviderInterface,
DynamicValueProviderInterface,
DynamicListSearchInterface {
    private static Logger logger = LogManager.getLogger(PromptColumnVPtoVRConverter.class);
    private PromptColumnValueProvider delegate = null;
    private ValueRetrieverServiceInterface valueRetrieverProxy;

    public PromptColumnVPtoVRConverter(@NotNull ValueRetrieverServiceInterface proxy, @NotNull PromptColumnValueProvider valueProvider) {
        ValidateArg.notNull((Object)proxy, (String)"proxy");
        ValidateArg.notNull((Object)((Object)valueProvider), (String)"valueProvider");
        this.valueRetrieverProxy = proxy;
        this.delegate = valueProvider;
    }

    private PromptColumnVPtoVRConverter() {
    }

    public DataTypeInterface getDataType(DynamicPromptValueContextInterface dynamicValuesContext) throws ValueProviderException {
        return this.delegate.getDataType();
    }

    public Collection getDependentPrompts(Locale locale, DynamicPromptValueContextInterface dynamicValuesContext) throws ValueProviderException {
        return this.delegate.getDependentPrompts(locale, dynamicValuesContext);
    }

    public Object getValues(Locale locale, DynamicPromptValueContextInterface dynamicPromptValueContext, ValueType returnType) throws ValueProviderException {
        if (returnType == ValueType.TREE) {
            throw new ValueProviderException(RB.getStringResource("RelationalDataItemValueProvider.UnsupportedMethodError.log"));
        }
        try {
            return this.getValuesAsList(locale, null, dynamicPromptValueContext, 0, -1);
        }
        catch (ValueRetrieverExceptionHolder e) {
            logger.error(e.getMessage(), (Throwable)e);
            throw PromptIQueryUtil.convertedValueProviderException(e);
        }
    }

    public Object getValues(Locale locale, DynamicPromptValueContextInterface dynamicPromptValueContext, ValueType returnType, int index, int count) throws ValueProviderException {
        if (returnType == ValueType.TREE) {
            throw new ValueProviderException(RB.getStringResource("RelationalDataItemValueProvider.UnsupportedMethodError.log"));
        }
        try {
            return this.getValuesAsList(locale, null, dynamicPromptValueContext, index, count);
        }
        catch (ValueRetrieverExceptionHolder e) {
            logger.error(e.getMessage(), (Throwable)e);
            throw PromptIQueryUtil.convertedValueProviderException(e);
        }
    }

    public Object getValues(Locale locale, PromptViewInterface promptView, DynamicPromptValueContextInterface dynamicPromptValueContext, ValueType returnType) throws ValueProviderException {
        if (returnType == ValueType.TREE) {
            throw new ValueProviderException(RB.getStringResource("RelationalDataItemValueProvider.UnsupportedMethodError.log"));
        }
        try {
            return this.getValuesAsList(locale, promptView, dynamicPromptValueContext, 0, -1);
        }
        catch (ValueRetrieverExceptionHolder e) {
            logger.error(e.getMessage(), (Throwable)e);
            throw PromptIQueryUtil.convertedValueProviderException(e);
        }
    }

    public Object getValues(Locale locale, PromptViewInterface promptView, DynamicPromptValueContextInterface dynamicPromptValueContext, ValueType returnType, int index, int count) throws ValueProviderException {
        if (returnType == ValueType.TREE) {
            throw new ValueProviderException(RB.getStringResource("RelationalDataItemValueProvider.UnsupportedMethodError.log"));
        }
        try {
            return this.getValuesAsList(locale, promptView, dynamicPromptValueContext, index, count);
        }
        catch (ValueRetrieverExceptionHolder e) {
            throw PromptIQueryUtil.convertedValueProviderException(e);
        }
    }

    private List<ValueItem> getValuesAsList(Locale locale, PromptViewInterface promptView, DynamicPromptValueContextInterface dynamicPromptValueContext, int index, int count) throws ValueProviderException, ValueRetrieverExceptionHolder {
        if (null != this.delegate.getWhereClause()) {
            return this.getSearchValuesAsList(locale, promptView, dynamicPromptValueContext, null, index, count);
        }
        DynamicValueRetrieverConfiguration vrc = this.convertValueProviderToValueRetrieverConfiguration(false);
        vrc.setDynamicSource(true);
        GetValuesAsListParameters parameters = new GetValuesAsListParameters();
        parameters.setCount(count);
        parameters.setIndex(index);
        parameters.setLocale(locale.toString());
        parameters.setValueRetrieverConfiguration((ValueRetrieverConfiguration)vrc);
        if (logger.isDebugEnabled()) {
            logger.debug("getValuesAsList(), calling same method on valueRetrieverProxy");
            logger.debug(PromptIQueryUtil.prettyPrintGetValuesAsListParameters(parameters));
        }
        List result = this.valueRetrieverProxy.getValuesAsList(parameters);
        logger.debug("got value column with row data of size:" + result.size());
        return PromptIQueryUtil.convertResults(result);
    }

    private List<ValueItem> getSearchValuesAsList(Locale locale, PromptViewInterface promptView, DynamicPromptValueContextInterface dynamicPromptValueContext, SearchCriteria searchCriterion, int index, int count) throws ValueProviderException, ValueRetrieverExceptionHolder {
        boolean is4Search = true;
        if (searchCriterion == null) {
            is4Search = false;
        }
        DynamicValueRetrieverConfiguration vrc = this.convertValueProviderToValueRetrieverConfiguration(is4Search);
        vrc.setDynamicSource(true);
        GetValuesAsListParameters parameters = new GetValuesAsListParameters();
        parameters.setCount(count);
        parameters.setIndex(index);
        parameters.setLocale(locale.toString());
        parameters.setValueRetrieverConfiguration((ValueRetrieverConfiguration)vrc);
        Search search = new Search();
        search.setOperator(SearchOperatorEnum.AND_OPERATOR);
        vrc.setSearch(search);
        if (null != searchCriterion) {
            logger.debug("getSearchValuesAsList(), processsing searchCriterion");
            QueryItemSearchCriteria qisc = PromptIQueryUtil.newQueryItemSearchCriteria(searchCriterion, vrc.getQueryItems());
            search.getSearchCriteriaList().add(qisc);
        }
        if (null != this.delegate.getWhereClause()) {
            logger.debug("getSearchValuesAsList(), processsing Where clause");
            PromptValuesInterface promptValues = null;
            try {
                promptValues = this.delegate.populateDefinitionValueMap(promptView, dynamicPromptValueContext);
            }
            catch (InvalidPromptValueException e) {
                logger.error(e.getMessage(), (Throwable)e);
                throw new ValueProviderException(e.getMessage());
            }
            if (promptValues == null) {
                return Collections.emptyList();
            }
            OperandInterface operand = this.delegate.getWhereClause().getCondition();
            if (operand instanceof Expression) {
                try {
                    List<QueryItemSearchCriteria> list = PromptIQueryUtil.getSearchCriteriaForExpression((Expression)operand, ((QueryItem)vrc.getQueryItems().get(0)).getDataSource(), promptValues, locale);
                    search.getSearchCriteriaList().addAll(list);
                }
                catch (PromptValueNotFoundException e) {
                    logger.error(e.getMessage(), (Throwable)e);
                    throw new ValueProviderException(e.getMessage());
                }
            }
        }
        if (logger.isDebugEnabled()) {
            logger.debug("getSearchValuesAsList(), calling same method on valueRetrieverProxy");
            logger.debug(PromptIQueryUtil.prettyPrintGetMultiSearchValuesAsListParameters(parameters));
        }
        List result = this.valueRetrieverProxy.getValuesAsList(parameters);
        logger.debug("got value column with row data of size:" + result.size());
        return PromptIQueryUtil.convertResults(result);
    }

    public DataTypeInterface getDataType() throws ValueProviderException {
        return this.delegate.getDataType();
    }

    public Object getValues(Locale locale) throws ValueProviderException {
        try {
            return this.getValuesAsList(locale, null, null, 0, -1);
        }
        catch (ValueRetrieverExceptionHolder e) {
            logger.error(e.getMessage(), (Throwable)e);
            throw PromptIQueryUtil.convertedValueProviderException(e);
        }
    }

    public Object getValues(Locale locale, int index, int count) throws ValueProviderException {
        try {
            return this.getValuesAsList(locale, null, null, index, count);
        }
        catch (ValueRetrieverExceptionHolder e) {
            logger.error(e.getMessage(), (Throwable)e);
            throw PromptIQueryUtil.convertedValueProviderException(e);
        }
    }

    public Object getValues(Locale locale, ValueType returnType) throws ValueProviderException {
        if (returnType == ValueType.TREE) {
            throw new ValueProviderException(RB.getStringResource("RelationalDataItemValueProvider.UnsupportedMethodError.log"));
        }
        try {
            return this.getValuesAsList(locale, null, null, 0, -1);
        }
        catch (ValueRetrieverExceptionHolder e) {
            logger.error(e.getMessage(), (Throwable)e);
            throw new ValueProviderException(e.getMessage());
        }
    }

    public Object getValues(Locale locale, ValueType returnType, int index, int count) throws ValueProviderException {
        if (returnType == ValueType.TREE) {
            throw new ValueProviderException(RB.getStringResource("RelationalDataItemValueProvider.UnsupportedMethodError.log"));
        }
        try {
            return this.getValuesAsList(locale, null, null, index, count);
        }
        catch (ValueRetrieverExceptionHolder e) {
            logger.error(e.getMessage(), (Throwable)e);
            throw PromptIQueryUtil.convertedValueProviderException(e);
        }
    }

    public boolean isValueDisplayed() {
        return this.delegate.isValueDisplayed();
    }

    public Object getValues(Locale locale, DynamicPromptValueContextInterface dynamicPromptValueContext, SearchCriteria searchCriterion) throws ValueProviderException {
        try {
            return this.getSearchValuesAsList(locale, null, dynamicPromptValueContext, searchCriterion, 0, -1);
        }
        catch (ValueRetrieverExceptionHolder e) {
            logger.error(e.getMessage(), (Throwable)e);
            throw PromptIQueryUtil.convertedValueProviderException(e);
        }
    }

    public Object getValues(Locale locale, DynamicPromptValueContextInterface dynamicPromptValueContext, SearchCriteria searchCriterion, int index, int count) throws ValueProviderException {
        try {
            return this.getSearchValuesAsList(locale, null, dynamicPromptValueContext, searchCriterion, index, count);
        }
        catch (ValueRetrieverExceptionHolder e) {
            logger.error(e.getMessage(), (Throwable)e);
            throw PromptIQueryUtil.convertedValueProviderException(e);
        }
    }

    public Object getValues(Locale locale, PromptViewInterface promptView, DynamicPromptValueContextInterface dynamicPromptValueContext, SearchCriteria searchCriterion, int index, int count) throws ValueProviderException {
        try {
            return this.getSearchValuesAsList(locale, promptView, dynamicPromptValueContext, searchCriterion, index, count);
        }
        catch (ValueRetrieverExceptionHolder e) {
            logger.error(e.getMessage(), (Throwable)e);
            throw PromptIQueryUtil.convertedValueProviderException(e);
        }
    }

    public boolean isSearchable(Locale locale, DynamicPromptValueContextInterface dynamicPromptValueContext) throws ValueProviderException {
        return this.delegate.isFormatLabels();
    }

    public Object clone() throws CloneNotSupportedException {
        try {
            PromptColumnVPtoVRConverter obj = (PromptColumnVPtoVRConverter)super.clone();
            obj.delegate = (PromptColumnValueProvider)((Object)this.delegate.clone());
            obj.valueRetrieverProxy = this.valueRetrieverProxy;
            return obj;
        }
        catch (CloneNotSupportedException e) {
            logger.error(e.getMessage(), (Throwable)e);
            return null;
        }
    }

    private DynamicValueRetrieverConfiguration convertValueProviderToValueRetrieverConfiguration(boolean is4Search) {
        DynamicValueRetrieverConfiguration valueRetrieverConfiguration = new DynamicValueRetrieverConfiguration();
        valueRetrieverConfiguration.setDynamicSource(true);
        List<QueryItem> queryItems = this.getQueryItemsForVP(is4Search);
        valueRetrieverConfiguration.getQueryItems().addAll(queryItems);
        QueryProperty queryProperty = new QueryProperty();
        queryProperty.setName("distinct");
        queryProperty.setValue(Boolean.toString(this.delegate.isDistinct()));
        valueRetrieverConfiguration.getQueryProperties().add(queryProperty);
        QueryProperty property = new QueryProperty();
        property.setName("DISPLAY_VALUE");
        property.setValue(Boolean.toString(this.delegate.isValueDisplayed()));
        valueRetrieverConfiguration.getQueryProperties().add(property);
        return valueRetrieverConfiguration;
    }

    private List<QueryItem> getQueryItemsForVP(boolean is4Search) {
        ColumnInfo vci;
        logger.debug("getQueryItemsForVP() start ");
        ArrayList<QueryItem> queryItems = new ArrayList<QueryItem>();
        ColumnInfo lci = this.delegate.getLabelColumn();
        boolean isFormattedLabels = this.delegate.isFormatLabels();
        DataSource dataSource = new DataSource();
        dataSource.setDataSourceLocation(this.delegate.getTableUrl());
        dataSource.setDataSourceType(1L);
        if (null != lci) {
            logger.debug("Label column is: " + lci.getName());
            QueryItem qi = new QueryItem();
            qi.setDataSource(dataSource);
            qi.setUniqueName(lci.getName());
            qi.setLabel(lci.getName());
            qi.setTrimValues(true);
            qi.setFormattedValues(isFormattedLabels);
            if (is4Search) {
                qi.setDataType(ValueDataTypeEnum.STRING);
            }
            if (this.delegate.isFormatLabels()) {
                String format = PromptColumnVPtoVRConverter.getFormatForColumn(lci);
                qi.setFormat(format);
            }
            qi.setSortDirection(lci.getSortOrder());
            queryItems.add(qi);
        }
        if (null == (vci = this.delegate.getValueColumn())) {
            throw new IllegalStateException("The ValueProvider does not contain a value column.");
        }
        logger.debug("Value column is: " + vci.getName());
        boolean isFormattedValues = this.delegate.isFormatValues();
        QueryItem qiv = new QueryItem();
        qiv.setDataSource(dataSource);
        qiv.setUniqueName(vci.getName());
        qiv.setLabel(vci.getName());
        qiv.setFormattedValues(isFormattedValues);
        if (is4Search) {
            if (isFormattedValues) {
                qiv.setDataType(ValueDataTypeEnum.STRING);
            }
            if (this.delegate.getUseValueAsLabel()) {
                qiv.setDataType(ValueDataTypeEnum.STRING);
            }
        }
        if (this.delegate.isFormatValues()) {
            String format = PromptColumnVPtoVRConverter.getFormatForColumn(vci);
            qiv.setFormat(format);
        }
        qiv.setTrimValues(false);
        qiv.setSortDirection(vci.getSortOrder());
        queryItems.add(qiv);
        logger.debug("getQueryItemsForVP() returns: " + Integer.valueOf(queryItems.size()));
        return queryItems;
    }

    private static String getFormatForColumn(ColumnInfo col) {
        String format = col.getFormat().trim();
        int index = format.indexOf(ColumnInfo.DEFAULT_FORMAT);
        if (index >= 0) {
            format = format.length() > ColumnInfo.DEFAULT_FORMAT.length() ? format.substring(ColumnInfo.DEFAULT_FORMAT.length() + 1, format.length()).trim() : null;
        }
        return format;
    }
}

